package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetProviderStatus invokes the cloudcallcenter.GetProviderStatus API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getproviderstatus.html
func (client *Client) GetProviderStatus(request *GetProviderStatusRequest) (response *GetProviderStatusResponse, err error) {
	response = CreateGetProviderStatusResponse()
	err = client.DoAction(request, response)
	return
}

// GetProviderStatusWithChan invokes the cloudcallcenter.GetProviderStatus API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getproviderstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetProviderStatusWithChan(request *GetProviderStatusRequest) (<-chan *GetProviderStatusResponse, <-chan error) {
	responseChan := make(chan *GetProviderStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetProviderStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetProviderStatusWithCallback invokes the cloudcallcenter.GetProviderStatus API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getproviderstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetProviderStatusWithCallback(request *GetProviderStatusRequest, callback func(response *GetProviderStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetProviderStatusResponse
		var err error
		defer close(result)
		response, err = client.GetProviderStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetProviderStatusRequest is the request struct for api GetProviderStatus
type GetProviderStatusRequest struct {
	*requests.RpcRequest
}

// GetProviderStatusResponse is the response struct for api GetProviderStatus
type GetProviderStatusResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	ProviderId     string `json:"ProviderId" xml:"ProviderId"`
	Status         string `json:"Status" xml:"Status"`
	OrderId        string `json:"OrderId" xml:"OrderId"`
	ReviewComment  string `json:"ReviewComment" xml:"ReviewComment"`
}

// CreateGetProviderStatusRequest creates a request to invoke GetProviderStatus API
func CreateGetProviderStatusRequest() (request *GetProviderStatusRequest) {
	request = &GetProviderStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "GetProviderStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateGetProviderStatusResponse creates a response to parse from GetProviderStatus response
func CreateGetProviderStatusResponse() (response *GetProviderStatusResponse) {
	response = &GetProviderStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
