package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTrafficMarkingPolicies invokes the cbn.ListTrafficMarkingPolicies API synchronously
func (client *Client) ListTrafficMarkingPolicies(request *ListTrafficMarkingPoliciesRequest) (response *ListTrafficMarkingPoliciesResponse, err error) {
	response = CreateListTrafficMarkingPoliciesResponse()
	err = client.DoAction(request, response)
	return
}

// ListTrafficMarkingPoliciesWithChan invokes the cbn.ListTrafficMarkingPolicies API asynchronously
func (client *Client) ListTrafficMarkingPoliciesWithChan(request *ListTrafficMarkingPoliciesRequest) (<-chan *ListTrafficMarkingPoliciesResponse, <-chan error) {
	responseChan := make(chan *ListTrafficMarkingPoliciesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTrafficMarkingPolicies(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTrafficMarkingPoliciesWithCallback invokes the cbn.ListTrafficMarkingPolicies API asynchronously
func (client *Client) ListTrafficMarkingPoliciesWithCallback(request *ListTrafficMarkingPoliciesRequest, callback func(response *ListTrafficMarkingPoliciesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTrafficMarkingPoliciesResponse
		var err error
		defer close(result)
		response, err = client.ListTrafficMarkingPolicies(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTrafficMarkingPoliciesRequest is the request struct for api ListTrafficMarkingPolicies
type ListTrafficMarkingPoliciesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId                 requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TrafficMarkingPolicyDescription string           `position:"Query" name:"TrafficMarkingPolicyDescription"`
	TrafficMarkingPolicyId          string           `position:"Query" name:"TrafficMarkingPolicyId"`
	NextToken                       string           `position:"Query" name:"NextToken"`
	TrafficMarkingPolicyName        string           `position:"Query" name:"TrafficMarkingPolicyName"`
	ResourceOwnerAccount            string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount                    string           `position:"Query" name:"OwnerAccount"`
	OwnerId                         requests.Integer `position:"Query" name:"OwnerId"`
	TransitRouterId                 string           `position:"Query" name:"TransitRouterId"`
	MaxResults                      requests.Integer `position:"Query" name:"MaxResults"`
}

// ListTrafficMarkingPoliciesResponse is the response struct for api ListTrafficMarkingPolicies
type ListTrafficMarkingPoliciesResponse struct {
	*responses.BaseResponse
	NextToken              string                 `json:"NextToken" xml:"NextToken"`
	RequestId              string                 `json:"RequestId" xml:"RequestId"`
	TotalCount             int                    `json:"TotalCount" xml:"TotalCount"`
	MaxResults             int                    `json:"MaxResults" xml:"MaxResults"`
	TrafficMarkingPolicies []TrafficMarkingPolicy `json:"TrafficMarkingPolicies" xml:"TrafficMarkingPolicies"`
}

// CreateListTrafficMarkingPoliciesRequest creates a request to invoke ListTrafficMarkingPolicies API
func CreateListTrafficMarkingPoliciesRequest() (request *ListTrafficMarkingPoliciesRequest) {
	request = &ListTrafficMarkingPoliciesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "ListTrafficMarkingPolicies", "", "")
	request.Method = requests.POST
	return
}

// CreateListTrafficMarkingPoliciesResponse creates a response to parse from ListTrafficMarkingPolicies response
func CreateListTrafficMarkingPoliciesResponse() (response *ListTrafficMarkingPoliciesResponse) {
	response = &ListTrafficMarkingPoliciesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
