package cassandra

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PurgeCluster invokes the cassandra.PurgeCluster API synchronously
func (client *Client) PurgeCluster(request *PurgeClusterRequest) (response *PurgeClusterResponse, err error) {
	response = CreatePurgeClusterResponse()
	err = client.DoAction(request, response)
	return
}

// PurgeClusterWithChan invokes the cassandra.PurgeCluster API asynchronously
func (client *Client) PurgeClusterWithChan(request *PurgeClusterRequest) (<-chan *PurgeClusterResponse, <-chan error) {
	responseChan := make(chan *PurgeClusterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PurgeCluster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PurgeClusterWithCallback invokes the cassandra.PurgeCluster API asynchronously
func (client *Client) PurgeClusterWithCallback(request *PurgeClusterRequest, callback func(response *PurgeClusterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PurgeClusterResponse
		var err error
		defer close(result)
		response, err = client.PurgeCluster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PurgeClusterRequest is the request struct for api PurgeCluster
type PurgeClusterRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
}

// PurgeClusterResponse is the response struct for api PurgeCluster
type PurgeClusterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreatePurgeClusterRequest creates a request to invoke PurgeCluster API
func CreatePurgeClusterRequest() (request *PurgeClusterRequest) {
	request = &PurgeClusterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cassandra", "2019-01-01", "PurgeCluster", "Cassandra", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePurgeClusterResponse creates a response to parse from PurgeCluster response
func CreatePurgeClusterResponse() (response *PurgeClusterResponse) {
	response = &PurgeClusterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
