package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteJoinRule invokes the aegis.DeleteJoinRule API synchronously
// api document: https://help.aliyun.com/api/aegis/deletejoinrule.html
func (client *Client) DeleteJoinRule(request *DeleteJoinRuleRequest) (response *DeleteJoinRuleResponse, err error) {
	response = CreateDeleteJoinRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteJoinRuleWithChan invokes the aegis.DeleteJoinRule API asynchronously
// api document: https://help.aliyun.com/api/aegis/deletejoinrule.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteJoinRuleWithChan(request *DeleteJoinRuleRequest) (<-chan *DeleteJoinRuleResponse, <-chan error) {
	responseChan := make(chan *DeleteJoinRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteJoinRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteJoinRuleWithCallback invokes the aegis.DeleteJoinRule API asynchronously
// api document: https://help.aliyun.com/api/aegis/deletejoinrule.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteJoinRuleWithCallback(request *DeleteJoinRuleRequest, callback func(response *DeleteJoinRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteJoinRuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteJoinRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteJoinRuleRequest is the request struct for api DeleteJoinRule
type DeleteJoinRuleRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Ids      string `position:"Query" name:"Ids"`
}

// DeleteJoinRuleResponse is the response struct for api DeleteJoinRule
type DeleteJoinRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteJoinRuleRequest creates a request to invoke DeleteJoinRule API
func CreateDeleteJoinRuleRequest() (request *DeleteJoinRuleRequest) {
	request = &DeleteJoinRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DeleteJoinRule", "vipaegis", "openAPI")
	return
}

// CreateDeleteJoinRuleResponse creates a response to parse from DeleteJoinRule response
func CreateDeleteJoinRuleResponse() (response *DeleteJoinRuleResponse) {
	response = &DeleteJoinRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
