package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTableDetail invokes the adb.DescribeTableDetail API synchronously
func (client *Client) DescribeTableDetail(request *DescribeTableDetailRequest) (response *DescribeTableDetailResponse, err error) {
	response = CreateDescribeTableDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTableDetailWithChan invokes the adb.DescribeTableDetail API asynchronously
func (client *Client) DescribeTableDetailWithChan(request *DescribeTableDetailRequest) (<-chan *DescribeTableDetailResponse, <-chan error) {
	responseChan := make(chan *DescribeTableDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTableDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTableDetailWithCallback invokes the adb.DescribeTableDetail API asynchronously
func (client *Client) DescribeTableDetailWithCallback(request *DescribeTableDetailRequest, callback func(response *DescribeTableDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTableDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribeTableDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTableDetailRequest is the request struct for api DescribeTableDetail
type DescribeTableDetailRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TableName            string           `position:"Query" name:"TableName"`
	SchemaName           string           `position:"Query" name:"SchemaName"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeTableDetailResponse is the response struct for api DescribeTableDetail
type DescribeTableDetailResponse struct {
	*responses.BaseResponse
	RequestId string                     `json:"RequestId" xml:"RequestId"`
	AvgSize   int64                      `json:"AvgSize" xml:"AvgSize"`
	Items     ItemsInDescribeTableDetail `json:"Items" xml:"Items"`
}

// CreateDescribeTableDetailRequest creates a request to invoke DescribeTableDetail API
func CreateDescribeTableDetailRequest() (request *DescribeTableDetailRequest) {
	request = &DescribeTableDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "DescribeTableDetail", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeTableDetailResponse creates a response to parse from DescribeTableDetail response
func CreateDescribeTableDetailResponse() (response *DescribeTableDetailResponse) {
	response = &DescribeTableDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
