package windowsesuapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/windowsesu/2019-09-16-preview/windowsesu"
	"github.com/Azure/go-autorest/autorest"
)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result windowsesu.OperationListPage, err error)
	ListComplete(ctx context.Context) (result windowsesu.OperationListIterator, err error)
}

var _ OperationsClientAPI = (*windowsesu.OperationsClient)(nil)

// MultipleActivationKeysClientAPI contains the set of methods on the MultipleActivationKeysClient type.
type MultipleActivationKeysClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, multipleActivationKeyName string, multipleActivationKey windowsesu.MultipleActivationKey) (result windowsesu.MultipleActivationKeysCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, multipleActivationKeyName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, multipleActivationKeyName string) (result windowsesu.MultipleActivationKey, err error)
	List(ctx context.Context) (result windowsesu.MultipleActivationKeyListPage, err error)
	ListComplete(ctx context.Context) (result windowsesu.MultipleActivationKeyListIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result windowsesu.MultipleActivationKeyListPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result windowsesu.MultipleActivationKeyListIterator, err error)
	Update(ctx context.Context, resourceGroupName string, multipleActivationKeyName string, multipleActivationKey windowsesu.MultipleActivationKeyUpdate) (result windowsesu.MultipleActivationKey, err error)
}

var _ MultipleActivationKeysClientAPI = (*windowsesu.MultipleActivationKeysClient)(nil)
