// Package newssearch implements the Azure ARM Newssearch service API version 1.0.
//
// The News Search API lets you send a search query to Bing and get back a list of news that are relevant to the search
// query. This section provides technical details about the query parameters and headers that you use to request news
// and the JSON response objects that contain them. For examples that show how to make requests, see [Searching the web
// for news](https://docs.microsoft.com/en-us/azure/cognitive-services/bing-news-search/search-the-web).
package newssearch

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
)

const (
	// DefaultEndpoint is the default value for endpoint
	DefaultEndpoint = "https://api.cognitive.microsoft.com"
)

// BaseClient is the base client for Newssearch.
type BaseClient struct {
	autorest.Client
	Endpoint string
}

// New creates an instance of the BaseClient client.
func New() BaseClient {
	return NewWithoutDefaults(DefaultEndpoint)
}

// NewWithoutDefaults creates an instance of the BaseClient client.
func NewWithoutDefaults(endpoint string) BaseClient {
	return BaseClient{
		Client:   autorest.NewClientWithUserAgent(UserAgent()),
		Endpoint: endpoint,
	}
}
