/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ac.ant.tasks;

import com.adobe.ac.ant.tasks.FlexUnitLauncher;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class FlexUnitTask
extends Task {
    private static final String END_OF_TEST_RUN = "<endOfTestRun/>";
    private static final String END_OF_TEST_SUITE = "</testsuite>";
    private static final String END_OF_TEST_ACK = "<endOfTestRunAck/>";
    private static final char NULL_BYTE = '\u0000';
    private static final String FILENAME_PREFIX = "TEST-";
    private static final String FILENAME_EXTENSION = ".xml";
    private static final String POLICY_FILE_REQUEST = "<policy-file-request/>";
    static final String DOMAIN_POLICY = "<cross-domain-policy><allow-access-from domain=\"*\" to-ports=\"{0}\" /></cross-domain-policy>";
    private boolean failures = false;
    private boolean complete;
    private String lastFailureMessage;
    private boolean verbose = true;
    private int port = 1024;
    private int socketTimeout = 60000;
    private boolean failOnTestFailure = true;
    private String failureProperty = "flexunit.failed";
    private String swf;
    private File reportDir;

    public void setPort(int n) {
        this.port = n;
    }

    public void setTimeout(int n) {
        this.socketTimeout = n;
    }

    public void setSWF(String string) {
        this.swf = string;
    }

    public void setToDir(String string) {
        this.reportDir = new File(string);
    }

    public void setHaltonfailure(boolean bl) {
        this.failOnTestFailure = bl;
    }

    public void setFailureproperty(String string) {
        this.failureProperty = string;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void execute() throws BuildException {
        if (this.swf == null || this.swf.length() == 0) {
            throw new BuildException("You must specify the 'swf' property.");
        }
        if (this.reportDir == null) {
            this.reportDir = this.getProject().resolveFile(".");
        }
        this.reportDir.mkdirs();
        this.receiveFlexUnitResults();
        FlexUnitLauncher flexUnitLauncher = new FlexUnitLauncher();
        try {
            flexUnitLauncher.runTests(this.swf);
        }
        catch (Exception exception) {
            throw new BuildException("Error launching the test runner.", (Throwable)exception);
        }
        while (!this.complete) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                throw new BuildException((Throwable)interruptedException);
            }
        }
        this.handleFailures();
    }

    private void receiveFlexUnitResults() {
        Thread thread = new Thread(){
            private ServerSocket serverSocket = null;
            private Socket clientSocket = null;
            private InputStream in = null;
            private OutputStream out = null;

            public void run() {
                try {
                    this.openServerSocket();
                    this.openClientSocket();
                    StringBuffer stringBuffer = new StringBuffer();
                    int n = -1;
                    while ((n = this.in.read()) != -1) {
                        char c = (char)n;
                        if (c == '\u0000') {
                            String string = stringBuffer.toString();
                            stringBuffer = new StringBuffer();
                            if (string.equals(FlexUnitTask.POLICY_FILE_REQUEST)) {
                                this.sendPolicyFile();
                                this.closeClientSocket();
                                this.openClientSocket();
                                continue;
                            }
                            if (string.endsWith(FlexUnitTask.END_OF_TEST_SUITE)) {
                                this.saveTestReport(string);
                                continue;
                            }
                            if (!string.equals(FlexUnitTask.END_OF_TEST_RUN)) continue;
                            this.sendAcknowledgement();
                            continue;
                        }
                        stringBuffer.append(c);
                    }
                }
                catch (BuildException buildException) {
                    try {
                        this.sendAcknowledgement();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    FlexUnitTask.this.lastFailureMessage = buildException.getMessage();
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    throw new BuildException("timeout waiting for flexunit report", (Throwable)socketTimeoutException);
                }
                catch (IOException iOException) {
                    throw new BuildException("error receiving report from flexunit", (Throwable)iOException);
                }
                finally {
                    FlexUnitTask.this.complete = true;
                    this.closeClientSocket();
                    this.closeServerSocket();
                }
            }

            private void sendPolicyFile() throws IOException {
                this.out.write(MessageFormat.format(FlexUnitTask.DOMAIN_POLICY, Integer.toString(FlexUnitTask.this.port)).getBytes());
                this.out.write(0);
                if (FlexUnitTask.this.verbose) {
                    FlexUnitTask.this.log("sent policy file");
                }
            }

            private void saveTestReport(String string) {
                FlexUnitTask.this.writeTestReport(string);
                if (FlexUnitTask.this.verbose) {
                    FlexUnitTask.this.log("end of test");
                }
            }

            private void sendAcknowledgement() throws IOException {
                this.out.write(FlexUnitTask.END_OF_TEST_ACK.getBytes());
                this.out.write(0);
                if (FlexUnitTask.this.verbose) {
                    FlexUnitTask.this.log("end of test run");
                }
            }

            private void openServerSocket() throws IOException {
                this.serverSocket = new ServerSocket(FlexUnitTask.this.port);
                this.serverSocket.setSoTimeout(FlexUnitTask.this.socketTimeout);
                if (FlexUnitTask.this.verbose) {
                    FlexUnitTask.this.log("opened server socket");
                }
            }

            private void closeServerSocket() {
                if (this.serverSocket != null) {
                    try {
                        this.serverSocket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }

            private void openClientSocket() throws IOException {
                this.clientSocket = this.serverSocket.accept();
                if (FlexUnitTask.this.verbose) {
                    FlexUnitTask.this.log("accepting data from client");
                }
                this.in = this.clientSocket.getInputStream();
                this.out = this.clientSocket.getOutputStream();
            }

            private void closeClientSocket() {
                if (this.out != null) {
                    try {
                        this.out.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (this.in != null) {
                    try {
                        this.in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (this.clientSocket != null) {
                    try {
                        this.clientSocket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
        thread.start();
    }

    private void writeTestReport(String string) {
        try {
            Document document = DocumentHelper.parseText(string);
            Element element = document.getRootElement();
            String string2 = element.valueOf("@name");
            int n = Integer.parseInt(element.valueOf("@failures"));
            if (this.verbose) {
                this.log("Running " + string2);
            }
            if (this.verbose) {
                this.log(this.formatLogReport(element));
            }
            File file = new File(this.reportDir, FILENAME_PREFIX + string2 + FILENAME_EXTENSION);
            OutputFormat outputFormat = OutputFormat.createPrettyPrint();
            XMLWriter xMLWriter = new XMLWriter(new FileOutputStream(file), outputFormat);
            xMLWriter.write(document);
            xMLWriter.close();
            if (n > 0) {
                this.failures = true;
                if (this.verbose) {
                    this.log("flexunit test " + string2 + " failed.");
                }
                if (this.failOnTestFailure) {
                    throw new BuildException("flexunit test " + string2 + " failed.");
                }
            }
        }
        catch (BuildException buildException) {
            throw buildException;
        }
        catch (Exception exception) {
            throw new BuildException("error writing report to disk", (Throwable)exception);
        }
    }

    private String formatLogReport(Element element) {
        int n = Integer.parseInt(element.valueOf("@failures"));
        int n2 = Integer.parseInt(element.valueOf("@errors"));
        int n3 = Integer.parseInt(element.valueOf("@tests"));
        int n4 = Integer.parseInt(element.valueOf("@time"));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Tests run: ");
        stringBuffer.append(n3);
        stringBuffer.append(", Failures: ");
        stringBuffer.append(n);
        stringBuffer.append(", Errors: ");
        stringBuffer.append(n2);
        stringBuffer.append(", Time Elapsed: ");
        stringBuffer.append(n4);
        stringBuffer.append(" sec");
        return stringBuffer.toString();
    }

    private void handleFailures() {
        if (this.failures) {
            this.getProject().setNewProperty(this.failureProperty, "true");
            if (this.failOnTestFailure) {
                throw new BuildException(this.lastFailureMessage);
            }
        }
    }

    public void log(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        FlexUnitTask flexUnitTask = new FlexUnitTask();
        flexUnitTask.setTimeout(0);
        flexUnitTask.setSWF("C:/dev/swat/projects/ac_emea/FlexUnitExample/bin/AntTestRunner.swf");
        flexUnitTask.setToDir("reports");
        flexUnitTask.execute();
    }
}

