
    static const char* C()
    {
        return "[\\p{Cc}\\p{Cf}\\p{Co}\\p{Cs}]";
    }

    static const char* L()
    {
        return "[\\p{Ll}\\p{Lm}\\p{Lo}\\p{Lt}\\p{Lu}]";
    }

    static const char* LC()
    {
        return "[\\p{Ll}\\p{Lt}\\p{Lu}]";
    }

    static const char* M()
    {
        return "[\\p{Mc}\\p{Me}\\p{Mn}]";
    }

    static const char* N()
    {
        return "[\\p{Nd}\\p{Nl}\\p{No}]";
    }

    static const char* P()
    {
        return "[\\p{Pc}\\p{Pd}\\p{Pe}\\p{Pf}\\p{Pi}\\p{Po}\\p{Ps}]";
    }

    static const char* S()
    {
        return "[\\p{Sc}\\p{Sk}\\p{Sm}\\p{So}]";
    }

    static const char* Z()
    {
        return "[\\p{Zl}\\p{Zp}\\p{Zs}]";
    }

    static const char *Cc()
    {
        return "[\\x0-\\x1f\\x7f-\\x9f]";
    }

    static const char *Cf()
    {
        return "[\\xad\\x600-\\x605\\x61c\\x6dd\\x70f\\x890\\x891\\x8e2\\x180e"
            "\\x200b-\\x200f\\x202a-\\x202e\\x2060-\\x2064\\x2066-\\x206f"
            "\\xfeff\\xfff9-\\xfffb\\x110bd\\x110cd\\x13430-\\x13438"
            "\\x1bca0-\\x1bca3\\x1d173-\\x1d17a\\xe0001\\xe0020-\\xe007f]";
    }

    static const char *Co()
    {
        return "[\\xe000\\xf8ff\\xf0000\\xffffd\\x100000\\x10fffd]";
    }

    static const char *Cs()
    {
        return "[\\xd800\\xdb7f\\xdb80\\xdbff\\xdc00\\xdfff]";
    }

    static const char *Ll()
    {
        return "[\\x61-\\x7a\\xb5\\xdf-\\xf6\\xf8-\\xff\\x101\\x103\\x105\\x107"
            "\\x109\\x10b\\x10d\\x10f\\x111\\x113\\x115\\x117\\x119\\x11b\\x11d"
            "\\x11f\\x121\\x123\\x125\\x127\\x129\\x12b\\x12d\\x12f\\x131\\x133"
            "\\x135\\x137\\x138\\x13a\\x13c\\x13e\\x140\\x142\\x144\\x146"
            "\\x148\\x149\\x14b\\x14d\\x14f\\x151\\x153\\x155\\x157\\x159\\x15b"
            "\\x15d\\x15f\\x161\\x163\\x165\\x167\\x169\\x16b\\x16d\\x16f\\x171"
            "\\x173\\x175\\x177\\x17a\\x17c\\x17e-\\x180\\x183\\x185\\x188"
            "\\x18c\\x18d\\x192\\x195\\x199-\\x19b\\x19e\\x1a1\\x1a3\\x1a5"
            "\\x1a8\\x1aa\\x1ab\\x1ad\\x1b0\\x1b4\\x1b6\\x1b9\\x1ba"
            "\\x1bd-\\x1bf\\x1c6\\x1c9\\x1cc\\x1ce\\x1d0\\x1d2\\x1d4\\x1d6"
            "\\x1d8\\x1da\\x1dc\\x1dd\\x1df\\x1e1\\x1e3\\x1e5\\x1e7\\x1e9\\x1eb"
            "\\x1ed\\x1ef\\x1f0\\x1f3\\x1f5\\x1f9\\x1fb\\x1fd\\x1ff\\x201\\x203"
            "\\x205\\x207\\x209\\x20b\\x20d\\x20f\\x211\\x213\\x215\\x217\\x219"
            "\\x21b\\x21d\\x21f\\x221\\x223\\x225\\x227\\x229\\x22b\\x22d\\x22f"
            "\\x231\\x233-\\x239\\x23c\\x23f\\x240\\x242\\x247\\x249\\x24b"
            "\\x24d\\x24f-\\x293\\x295-\\x2af\\x371\\x373\\x377\\x37b-\\x37d"
            "\\x390\\x3ac-\\x3ce\\x3d0\\x3d1\\x3d5-\\x3d7\\x3d9\\x3db\\x3dd"
            "\\x3df\\x3e1\\x3e3\\x3e5\\x3e7\\x3e9\\x3eb\\x3ed\\x3ef-\\x3f3"
            "\\x3f5\\x3f8\\x3fb\\x3fc\\x430-\\x45f\\x461\\x463\\x465\\x467"
            "\\x469\\x46b\\x46d\\x46f\\x471\\x473\\x475\\x477\\x479\\x47b\\x47d"
            "\\x47f\\x481\\x48b\\x48d\\x48f\\x491\\x493\\x495\\x497\\x499\\x49b"
            "\\x49d\\x49f\\x4a1\\x4a3\\x4a5\\x4a7\\x4a9\\x4ab\\x4ad\\x4af\\x4b1"
            "\\x4b3\\x4b5\\x4b7\\x4b9\\x4bb\\x4bd\\x4bf\\x4c2\\x4c4\\x4c6\\x4c8"
            "\\x4ca\\x4cc\\x4ce\\x4cf\\x4d1\\x4d3\\x4d5\\x4d7\\x4d9\\x4db\\x4dd"
            "\\x4df\\x4e1\\x4e3\\x4e5\\x4e7\\x4e9\\x4eb\\x4ed\\x4ef\\x4f1\\x4f3"
            "\\x4f5\\x4f7\\x4f9\\x4fb\\x4fd\\x4ff\\x501\\x503\\x505\\x507\\x509"
            "\\x50b\\x50d\\x50f\\x511\\x513\\x515\\x517\\x519\\x51b\\x51d\\x51f"
            "\\x521\\x523\\x525\\x527\\x529\\x52b\\x52d\\x52f\\x560-\\x588"
            "\\x10d0-\\x10fa\\x10fd-\\x10ff\\x13f8-\\x13fd\\x1c80-\\x1c88"
            "\\x1d00-\\x1d2b\\x1d6b-\\x1d77\\x1d79-\\x1d9a\\x1e01\\x1e03\\x1e05"
            "\\x1e07\\x1e09\\x1e0b\\x1e0d\\x1e0f\\x1e11\\x1e13\\x1e15\\x1e17"
            "\\x1e19\\x1e1b\\x1e1d\\x1e1f\\x1e21\\x1e23\\x1e25\\x1e27\\x1e29"
            "\\x1e2b\\x1e2d\\x1e2f\\x1e31\\x1e33\\x1e35\\x1e37\\x1e39\\x1e3b"
            "\\x1e3d\\x1e3f\\x1e41\\x1e43\\x1e45\\x1e47\\x1e49\\x1e4b\\x1e4d"
            "\\x1e4f\\x1e51\\x1e53\\x1e55\\x1e57\\x1e59\\x1e5b\\x1e5d\\x1e5f"
            "\\x1e61\\x1e63\\x1e65\\x1e67\\x1e69\\x1e6b\\x1e6d\\x1e6f\\x1e71"
            "\\x1e73\\x1e75\\x1e77\\x1e79\\x1e7b\\x1e7d\\x1e7f\\x1e81\\x1e83"
            "\\x1e85\\x1e87\\x1e89\\x1e8b\\x1e8d\\x1e8f\\x1e91\\x1e93"
            "\\x1e95-\\x1e9d\\x1e9f\\x1ea1\\x1ea3\\x1ea5\\x1ea7\\x1ea9\\x1eab"
            "\\x1ead\\x1eaf\\x1eb1\\x1eb3\\x1eb5\\x1eb7\\x1eb9\\x1ebb\\x1ebd"
            "\\x1ebf\\x1ec1\\x1ec3\\x1ec5\\x1ec7\\x1ec9\\x1ecb\\x1ecd\\x1ecf"
            "\\x1ed1\\x1ed3\\x1ed5\\x1ed7\\x1ed9\\x1edb\\x1edd\\x1edf\\x1ee1"
            "\\x1ee3\\x1ee5\\x1ee7\\x1ee9\\x1eeb\\x1eed\\x1eef\\x1ef1\\x1ef3"
            "\\x1ef5\\x1ef7\\x1ef9\\x1efb\\x1efd\\x1eff-\\x1f07\\x1f10-\\x1f15"
            "\\x1f20-\\x1f27\\x1f30-\\x1f37\\x1f40-\\x1f45\\x1f50-\\x1f57"
            "\\x1f60-\\x1f67\\x1f70-\\x1f7d\\x1f80-\\x1f87\\x1f90-\\x1f97"
            "\\x1fa0-\\x1fa7\\x1fb0-\\x1fb4\\x1fb6\\x1fb7\\x1fbe"
            "\\x1fc2-\\x1fc4\\x1fc6\\x1fc7\\x1fd0-\\x1fd3\\x1fd6\\x1fd7"
            "\\x1fe0-\\x1fe7\\x1ff2-\\x1ff4\\x1ff6\\x1ff7\\x210a\\x210e\\x210f"
            "\\x2113\\x212f\\x2134\\x2139\\x213c\\x213d\\x2146-\\x2149\\x214e"
            "\\x2184\\x2c30-\\x2c5f\\x2c61\\x2c65\\x2c66\\x2c68\\x2c6a\\x2c6c"
            "\\x2c71\\x2c73\\x2c74\\x2c76-\\x2c7b\\x2c81\\x2c83\\x2c85\\x2c87"
            "\\x2c89\\x2c8b\\x2c8d\\x2c8f\\x2c91\\x2c93\\x2c95\\x2c97\\x2c99"
            "\\x2c9b\\x2c9d\\x2c9f\\x2ca1\\x2ca3\\x2ca5\\x2ca7\\x2ca9\\x2cab"
            "\\x2cad\\x2caf\\x2cb1\\x2cb3\\x2cb5\\x2cb7\\x2cb9\\x2cbb\\x2cbd"
            "\\x2cbf\\x2cc1\\x2cc3\\x2cc5\\x2cc7\\x2cc9\\x2ccb\\x2ccd\\x2ccf"
            "\\x2cd1\\x2cd3\\x2cd5\\x2cd7\\x2cd9\\x2cdb\\x2cdd\\x2cdf\\x2ce1"
            "\\x2ce3\\x2ce4\\x2cec\\x2cee\\x2cf3\\x2d00-\\x2d25\\x2d27\\x2d2d"
            "\\xa641\\xa643\\xa645\\xa647\\xa649\\xa64b\\xa64d\\xa64f\\xa651"
            "\\xa653\\xa655\\xa657\\xa659\\xa65b\\xa65d\\xa65f\\xa661\\xa663"
            "\\xa665\\xa667\\xa669\\xa66b\\xa66d\\xa681\\xa683\\xa685\\xa687"
            "\\xa689\\xa68b\\xa68d\\xa68f\\xa691\\xa693\\xa695\\xa697\\xa699"
            "\\xa69b\\xa723\\xa725\\xa727\\xa729\\xa72b\\xa72d\\xa72f-\\xa731"
            "\\xa733\\xa735\\xa737\\xa739\\xa73b\\xa73d\\xa73f\\xa741\\xa743"
            "\\xa745\\xa747\\xa749\\xa74b\\xa74d\\xa74f\\xa751\\xa753\\xa755"
            "\\xa757\\xa759\\xa75b\\xa75d\\xa75f\\xa761\\xa763\\xa765\\xa767"
            "\\xa769\\xa76b\\xa76d\\xa76f\\xa771-\\xa778\\xa77a\\xa77c\\xa77f"
            "\\xa781\\xa783\\xa785\\xa787\\xa78c\\xa78e\\xa791\\xa793-\\xa795"
            "\\xa797\\xa799\\xa79b\\xa79d\\xa79f\\xa7a1\\xa7a3\\xa7a5\\xa7a7"
            "\\xa7a9\\xa7af\\xa7b5\\xa7b7\\xa7b9\\xa7bb\\xa7bd\\xa7bf\\xa7c1"
            "\\xa7c3\\xa7c8\\xa7ca\\xa7d1\\xa7d3\\xa7d5\\xa7d7\\xa7d9\\xa7f6"
            "\\xa7fa\\xab30-\\xab5a\\xab60-\\xab68\\xab70-\\xabbf"
            "\\xfb00-\\xfb06\\xfb13-\\xfb17\\xff41-\\xff5a\\x10428-\\x1044f"
            "\\x104d8-\\x104fb\\x10597-\\x105a1\\x105a3-\\x105b1"
            "\\x105b3-\\x105b9\\x105bb\\x105bc\\x10cc0-\\x10cf2"
            "\\x118c0-\\x118df\\x16e60-\\x16e7f\\x1d41a-\\x1d433"
            "\\x1d44e-\\x1d454\\x1d456-\\x1d467\\x1d482-\\x1d49b"
            "\\x1d4b6-\\x1d4b9\\x1d4bb\\x1d4bd-\\x1d4c3\\x1d4c5-\\x1d4cf"
            "\\x1d4ea-\\x1d503\\x1d51e-\\x1d537\\x1d552-\\x1d56b"
            "\\x1d586-\\x1d59f\\x1d5ba-\\x1d5d3\\x1d5ee-\\x1d607"
            "\\x1d622-\\x1d63b\\x1d656-\\x1d66f\\x1d68a-\\x1d6a5"
            "\\x1d6c2-\\x1d6da\\x1d6dc-\\x1d6e1\\x1d6fc-\\x1d714"
            "\\x1d716-\\x1d71b\\x1d736-\\x1d74e\\x1d750-\\x1d755"
            "\\x1d770-\\x1d788\\x1d78a-\\x1d78f\\x1d7aa-\\x1d7c2"
            "\\x1d7c4-\\x1d7c9\\x1d7cb\\x1df00-\\x1df09\\x1df0b-\\x1df1e"
            "\\x1e922-\\x1e943]";
    }

    static const char *Lm()
    {
        return "[\\x2b0-\\x2c1\\x2c6-\\x2d1\\x2e0-\\x2e4\\x2ec\\x2ee\\x374"
            "\\x37a\\x559\\x640\\x6e5\\x6e6\\x7f4\\x7f5\\x7fa\\x81a\\x824\\x828"
            "\\x8c9\\x971\\xe46\\xec6\\x10fc\\x17d7\\x1843\\x1aa7"
            "\\x1c78-\\x1c7d\\x1d2c-\\x1d6a\\x1d78\\x1d9b-\\x1dbf\\x2071\\x207f"
            "\\x2090-\\x209c\\x2c7c\\x2c7d\\x2d6f\\x2e2f\\x3005\\x3031-\\x3035"
            "\\x303b\\x309d\\x309e\\x30fc-\\x30fe\\xa015\\xa4f8-\\xa4fd\\xa60c"
            "\\xa67f\\xa69c\\xa69d\\xa717-\\xa71f\\xa770\\xa788\\xa7f2-\\xa7f4"
            "\\xa7f8\\xa7f9\\xa9cf\\xa9e6\\xaa70\\xaadd\\xaaf3\\xaaf4"
            "\\xab5c-\\xab5f\\xab69\\xff70\\xff9e\\xff9f\\x10780-\\x10785"
            "\\x10787-\\x107b0\\x107b2-\\x107ba\\x16b40-\\x16b43"
            "\\x16f93-\\x16f9f\\x16fe0\\x16fe1\\x16fe3\\x1aff0-\\x1aff3"
            "\\x1aff5-\\x1affb\\x1affd\\x1affe\\x1e137-\\x1e13d\\x1e94b]";
    }

    static const char *Lo()
    {
        return "[\\xaa\\xba\\x1bb\\x1c0-\\x1c3\\x294\\x5d0-\\x5ea\\x5ef-\\x5f2"
            "\\x620-\\x63f\\x641-\\x64a\\x66e\\x66f\\x671-\\x6d3\\x6d5"
            "\\x6ee\\x6ef\\x6fa-\\x6fc\\x6ff\\x710\\x712-\\x72f\\x74d-\\x7a5"
            "\\x7b1\\x7ca-\\x7ea\\x800-\\x815\\x840-\\x858\\x860-\\x86a"
            "\\x870-\\x887\\x889-\\x88e\\x8a0-\\x8c8\\x904-\\x939\\x93d\\x950"
            "\\x958-\\x961\\x972-\\x980\\x985-\\x98c\\x98f\\x990\\x993-\\x9a8"
            "\\x9aa-\\x9b0\\x9b2\\x9b6-\\x9b9\\x9bd\\x9ce\\x9dc\\x9dd"
            "\\x9df-\\x9e1\\x9f0\\x9f1\\x9fc\\xa05-\\xa0a\\xa0f\\xa10"
            "\\xa13-\\xa28\\xa2a-\\xa30\\xa32\\xa33\\xa35\\xa36\\xa38\\xa39"
            "\\xa59-\\xa5c\\xa5e\\xa72-\\xa74\\xa85-\\xa8d\\xa8f-\\xa91"
            "\\xa93-\\xaa8\\xaaa-\\xab0\\xab2\\xab3\\xab5-\\xab9\\xabd\\xad0"
            "\\xae0\\xae1\\xaf9\\xb05-\\xb0c\\xb0f\\xb10\\xb13-\\xb28"
            "\\xb2a-\\xb30\\xb32\\xb33\\xb35-\\xb39\\xb3d\\xb5c\\xb5d"
            "\\xb5f-\\xb61\\xb71\\xb83\\xb85-\\xb8a\\xb8e-\\xb90\\xb92-\\xb95"
            "\\xb99\\xb9a\\xb9c\\xb9e\\xb9f\\xba3\\xba4\\xba8-\\xbaa"
            "\\xbae-\\xbb9\\xbd0\\xc05-\\xc0c\\xc0e-\\xc10\\xc12-\\xc28"
            "\\xc2a-\\xc39\\xc3d\\xc58-\\xc5a\\xc5d\\xc60\\xc61\\xc80"
            "\\xc85-\\xc8c\\xc8e-\\xc90\\xc92-\\xca8\\xcaa-\\xcb3\\xcb5-\\xcb9"
            "\\xcbd\\xcdd\\xcde\\xce0\\xce1\\xcf1\\xcf2\\xd04-\\xd0c"
            "\\xd0e-\\xd10\\xd12-\\xd3a\\xd3d\\xd4e\\xd54-\\xd56\\xd5f-\\xd61"
            "\\xd7a-\\xd7f\\xd85-\\xd96\\xd9a-\\xdb1\\xdb3-\\xdbb\\xdbd"
            "\\xdc0-\\xdc6\\xe01-\\xe30\\xe32\\xe33\\xe40-\\xe45\\xe81\\xe82"
            "\\xe84\\xe86-\\xe8a\\xe8c-\\xea3\\xea5\\xea7-\\xeb0\\xeb2\\xeb3"
            "\\xebd\\xec0-\\xec4\\xedc-\\xedf\\xf00\\xf40-\\xf47\\xf49-\\xf6c"
            "\\xf88-\\xf8c\\x1000-\\x102a\\x103f\\x1050-\\x1055\\x105a-\\x105d"
            "\\x1061\\x1065\\x1066\\x106e-\\x1070\\x1075-\\x1081\\x108e"
            "\\x1100-\\x1248\\x124a-\\x124d\\x1250-\\x1256\\x1258"
            "\\x125a-\\x125d\\x1260-\\x1288\\x128a-\\x128d\\x1290-\\x12b0"
            "\\x12b2-\\x12b5\\x12b8-\\x12be\\x12c0\\x12c2-\\x12c5"
            "\\x12c8-\\x12d6\\x12d8-\\x1310\\x1312-\\x1315\\x1318-\\x135a"
            "\\x1380-\\x138f\\x1401-\\x166c\\x166f-\\x167f\\x1681-\\x169a"
            "\\x16a0-\\x16ea\\x16f1-\\x16f8\\x1700-\\x1711\\x171f-\\x1731"
            "\\x1740-\\x1751\\x1760-\\x176c\\x176e-\\x1770\\x1780-\\x17b3"
            "\\x17dc\\x1820-\\x1842\\x1844-\\x1878\\x1880-\\x1884"
            "\\x1887-\\x18a8\\x18aa\\x18b0-\\x18f5\\x1900-\\x191e"
            "\\x1950-\\x196d\\x1970-\\x1974\\x1980-\\x19ab\\x19b0-\\x19c9"
            "\\x1a00-\\x1a16\\x1a20-\\x1a54\\x1b05-\\x1b33\\x1b45-\\x1b4c"
            "\\x1b83-\\x1ba0\\x1bae\\x1baf\\x1bba-\\x1be5\\x1c00-\\x1c23"
            "\\x1c4d-\\x1c4f\\x1c5a-\\x1c77\\x1ce9-\\x1cec\\x1cee-\\x1cf3"
            "\\x1cf5\\x1cf6\\x1cfa\\x2135-\\x2138\\x2d30-\\x2d67"
            "\\x2d80-\\x2d96\\x2da0-\\x2da6\\x2da8-\\x2dae\\x2db0-\\x2db6"
            "\\x2db8-\\x2dbe\\x2dc0-\\x2dc6\\x2dc8-\\x2dce\\x2dd0-\\x2dd6"
            "\\x2dd8-\\x2dde\\x3006\\x303c\\x3041-\\x3096\\x309f"
            "\\x30a1-\\x30fa\\x30ff\\x3105-\\x312f\\x3131-\\x318e"
            "\\x31a0-\\x31bf\\x31f0-\\x31ff\\x3400\\x4dbf\\x4e00"
            "\\x9fff-\\xa014\\xa016-\\xa48c\\xa4d0-\\xa4f7\\xa500-\\xa60b"
            "\\xa610-\\xa61f\\xa62a\\xa62b\\xa66e\\xa6a0-\\xa6e5\\xa78f\\xa7f7"
            "\\xa7fb-\\xa801\\xa803-\\xa805\\xa807-\\xa80a\\xa80c-\\xa822"
            "\\xa840-\\xa873\\xa882-\\xa8b3\\xa8f2-\\xa8f7\\xa8fb\\xa8fd\\xa8fe"
            "\\xa90a-\\xa925\\xa930-\\xa946\\xa960-\\xa97c\\xa984-\\xa9b2"
            "\\xa9e0-\\xa9e4\\xa9e7-\\xa9ef\\xa9fa-\\xa9fe\\xaa00-\\xaa28"
            "\\xaa40-\\xaa42\\xaa44-\\xaa4b\\xaa60-\\xaa6f\\xaa71-\\xaa76"
            "\\xaa7a\\xaa7e-\\xaaaf\\xaab1\\xaab5\\xaab6\\xaab9-\\xaabd\\xaac0"
            "\\xaac2\\xaadb\\xaadc\\xaae0-\\xaaea\\xaaf2\\xab01-\\xab06"
            "\\xab09-\\xab0e\\xab11-\\xab16\\xab20-\\xab26\\xab28-\\xab2e"
            "\\xabc0-\\xabe2\\xac00\\xd7a3\\xd7b0-\\xd7c6\\xd7cb-\\xd7fb"
            "\\xf900-\\xfa6d\\xfa70-\\xfad9\\xfb1d\\xfb1f-\\xfb28"
            "\\xfb2a-\\xfb36\\xfb38-\\xfb3c\\xfb3e\\xfb40\\xfb41\\xfb43\\xfb44"
            "\\xfb46-\\xfbb1\\xfbd3-\\xfd3d\\xfd50-\\xfd8f\\xfd92-\\xfdc7"
            "\\xfdf0-\\xfdfb\\xfe70-\\xfe74\\xfe76-\\xfefc\\xff66-\\xff6f"
            "\\xff71-\\xff9d\\xffa0-\\xffbe\\xffc2-\\xffc7\\xffca-\\xffcf"
            "\\xffd2-\\xffd7\\xffda-\\xffdc\\x10000-\\x1000b\\x1000d-\\x10026"
            "\\x10028-\\x1003a\\x1003c\\x1003d\\x1003f-\\x1004d"
            "\\x10050-\\x1005d\\x10080-\\x100fa\\x10280-\\x1029c"
            "\\x102a0-\\x102d0\\x10300-\\x1031f\\x1032d-\\x10340"
            "\\x10342-\\x10349\\x10350-\\x10375\\x10380-\\x1039d"
            "\\x103a0-\\x103c3\\x103c8-\\x103cf\\x10450-\\x1049d"
            "\\x10500-\\x10527\\x10530-\\x10563\\x10600-\\x10736"
            "\\x10740-\\x10755\\x10760-\\x10767\\x10800-\\x10805\\x10808"
            "\\x1080a-\\x10835\\x10837\\x10838\\x1083c\\x1083f-\\x10855"
            "\\x10860-\\x10876\\x10880-\\x1089e\\x108e0-\\x108f2"
            "\\x108f4\\x108f5\\x10900-\\x10915\\x10920-\\x10939"
            "\\x10980-\\x109b7\\x109be\\x109bf\\x10a00\\x10a10-\\x10a13"
            "\\x10a15-\\x10a17\\x10a19-\\x10a35\\x10a60-\\x10a7c"
            "\\x10a80-\\x10a9c\\x10ac0-\\x10ac7\\x10ac9-\\x10ae4"
            "\\x10b00-\\x10b35\\x10b40-\\x10b55\\x10b60-\\x10b72"
            "\\x10b80-\\x10b91\\x10c00-\\x10c48\\x10d00-\\x10d23"
            "\\x10e80-\\x10ea9\\x10eb0\\x10eb1\\x10f00-\\x10f1c\\x10f27"
            "\\x10f30-\\x10f45\\x10f70-\\x10f81\\x10fb0-\\x10fc4"
            "\\x10fe0-\\x10ff6\\x11003-\\x11037\\x11071\\x11072\\x11075"
            "\\x11083-\\x110af\\x110d0-\\x110e8\\x11103-\\x11126\\x11144"
            "\\x11147\\x11150-\\x11172\\x11176\\x11183-\\x111b2"
            "\\x111c1-\\x111c4\\x111da\\x111dc\\x11200-\\x11211"
            "\\x11213-\\x1122b\\x11280-\\x11286\\x11288\\x1128a-\\x1128d"
            "\\x1128f-\\x1129d\\x1129f-\\x112a8\\x112b0-\\x112de"
            "\\x11305-\\x1130c\\x1130f\\x11310\\x11313-\\x11328"
            "\\x1132a-\\x11330\\x11332\\x11333\\x11335-\\x11339\\x1133d\\x11350"
            "\\x1135d-\\x11361\\x11400-\\x11434\\x11447-\\x1144a"
            "\\x1145f-\\x11461\\x11480-\\x114af\\x114c4\\x114c5\\x114c7"
            "\\x11580-\\x115ae\\x115d8-\\x115db\\x11600-\\x1162f\\x11644"
            "\\x11680-\\x116aa\\x116b8\\x11700-\\x1171a\\x11740-\\x11746"
            "\\x11800-\\x1182b\\x118ff-\\x11906\\x11909\\x1190c-\\x11913"
            "\\x11915\\x11916\\x11918-\\x1192f\\x1193f\\x11941"
            "\\x119a0-\\x119a7\\x119aa-\\x119d0\\x119e1\\x119e3\\x11a00"
            "\\x11a0b-\\x11a32\\x11a3a\\x11a50\\x11a5c-\\x11a89\\x11a9d"
            "\\x11ab0-\\x11af8\\x11c00-\\x11c08\\x11c0a-\\x11c2e\\x11c40"
            "\\x11c72-\\x11c8f\\x11d00-\\x11d06\\x11d08\\x11d09"
            "\\x11d0b-\\x11d30\\x11d46\\x11d60-\\x11d65\\x11d67\\x11d68"
            "\\x11d6a-\\x11d89\\x11d98\\x11ee0-\\x11ef2\\x11fb0"
            "\\x12000-\\x12399\\x12480-\\x12543\\x12f90-\\x12ff2"
            "\\x13000-\\x1342e\\x14400-\\x14646\\x16800-\\x16a38"
            "\\x16a40-\\x16a5e\\x16a70-\\x16abe\\x16ad0-\\x16aed"
            "\\x16b00-\\x16b2f\\x16b63-\\x16b77\\x16b7d-\\x16b8f"
            "\\x16f00-\\x16f4a\\x16f50\\x17000\\x187f7\\x18800-\\x18cd5\\x18d00"
            "\\x18d08\\x1b000-\\x1b122\\x1b150-\\x1b152\\x1b164-\\x1b167"
            "\\x1b170-\\x1b2fb\\x1bc00-\\x1bc6a\\x1bc70-\\x1bc7c"
            "\\x1bc80-\\x1bc88\\x1bc90-\\x1bc99\\x1df0a\\x1e100-\\x1e12c"
            "\\x1e14e\\x1e290-\\x1e2ad\\x1e2c0-\\x1e2eb\\x1e7e0-\\x1e7e6"
            "\\x1e7e8-\\x1e7eb\\x1e7ed\\x1e7ee\\x1e7f0-\\x1e7fe"
            "\\x1e800-\\x1e8c4\\x1ee00-\\x1ee03\\x1ee05-\\x1ee1f"
            "\\x1ee21\\x1ee22\\x1ee24\\x1ee27\\x1ee29-\\x1ee32"
            "\\x1ee34-\\x1ee37\\x1ee39\\x1ee3b\\x1ee42\\x1ee47\\x1ee49\\x1ee4b"
            "\\x1ee4d-\\x1ee4f\\x1ee51\\x1ee52\\x1ee54\\x1ee57\\x1ee59\\x1ee5b"
            "\\x1ee5d\\x1ee5f\\x1ee61\\x1ee62\\x1ee64\\x1ee67-\\x1ee6a"
            "\\x1ee6c-\\x1ee72\\x1ee74-\\x1ee77\\x1ee79-\\x1ee7c\\x1ee7e"
            "\\x1ee80-\\x1ee89\\x1ee8b-\\x1ee9b\\x1eea1-\\x1eea3"
            "\\x1eea5-\\x1eea9\\x1eeab-\\x1eebb\\x20000\\x2a6df\\x2a700\\x2b738"
            "\\x2b740\\x2b81d\\x2b820\\x2cea1\\x2ceb0\\x2ebe0\\x2f800-\\x2fa1d"
            "\\x30000\\x3134a]";
    }

    static const char *Lt()
    {
        return "[\\x1c5\\x1c8\\x1cb\\x1f2\\x1f88-\\x1f8f\\x1f98-\\x1f9f"
            "\\x1fa8-\\x1faf\\x1fbc\\x1fcc\\x1ffc]";
    }

    static const char *Lu()
    {
        return "[\\x41-\\x5a\\xc0-\\xd6\\xd8-\\xde\\x100\\x102\\x104\\x106"
            "\\x108\\x10a\\x10c\\x10e\\x110\\x112\\x114\\x116\\x118\\x11a\\x11c"
            "\\x11e\\x120\\x122\\x124\\x126\\x128\\x12a\\x12c\\x12e\\x130\\x132"
            "\\x134\\x136\\x139\\x13b\\x13d\\x13f\\x141\\x143\\x145\\x147\\x14a"
            "\\x14c\\x14e\\x150\\x152\\x154\\x156\\x158\\x15a\\x15c\\x15e\\x160"
            "\\x162\\x164\\x166\\x168\\x16a\\x16c\\x16e\\x170\\x172\\x174\\x176"
            "\\x178\\x179\\x17b\\x17d\\x181\\x182\\x184\\x186\\x187"
            "\\x189-\\x18b\\x18e-\\x191\\x193\\x194\\x196-\\x198\\x19c\\x19d"
            "\\x19f\\x1a0\\x1a2\\x1a4\\x1a6\\x1a7\\x1a9\\x1ac\\x1ae\\x1af"
            "\\x1b1-\\x1b3\\x1b5\\x1b7\\x1b8\\x1bc\\x1c4\\x1c7\\x1ca\\x1cd"
            "\\x1cf\\x1d1\\x1d3\\x1d5\\x1d7\\x1d9\\x1db\\x1de\\x1e0\\x1e2\\x1e4"
            "\\x1e6\\x1e8\\x1ea\\x1ec\\x1ee\\x1f1\\x1f4\\x1f6-\\x1f8\\x1fa"
            "\\x1fc\\x1fe\\x200\\x202\\x204\\x206\\x208\\x20a\\x20c\\x20e\\x210"
            "\\x212\\x214\\x216\\x218\\x21a\\x21c\\x21e\\x220\\x222\\x224\\x226"
            "\\x228\\x22a\\x22c\\x22e\\x230\\x232\\x23a\\x23b\\x23d\\x23e\\x241"
            "\\x243-\\x246\\x248\\x24a\\x24c\\x24e\\x370\\x372\\x376\\x37f"
            "\\x386\\x388-\\x38a\\x38c\\x38e\\x38f\\x391-\\x3a1\\x3a3-\\x3ab"
            "\\x3cf\\x3d2-\\x3d4\\x3d8\\x3da\\x3dc\\x3de\\x3e0\\x3e2\\x3e4"
            "\\x3e6\\x3e8\\x3ea\\x3ec\\x3ee\\x3f4\\x3f7\\x3f9\\x3fa"
            "\\x3fd-\\x42f\\x460\\x462\\x464\\x466\\x468\\x46a\\x46c\\x46e"
            "\\x470\\x472\\x474\\x476\\x478\\x47a\\x47c\\x47e\\x480\\x48a\\x48c"
            "\\x48e\\x490\\x492\\x494\\x496\\x498\\x49a\\x49c\\x49e\\x4a0\\x4a2"
            "\\x4a4\\x4a6\\x4a8\\x4aa\\x4ac\\x4ae\\x4b0\\x4b2\\x4b4\\x4b6\\x4b8"
            "\\x4ba\\x4bc\\x4be\\x4c0\\x4c1\\x4c3\\x4c5\\x4c7\\x4c9\\x4cb\\x4cd"
            "\\x4d0\\x4d2\\x4d4\\x4d6\\x4d8\\x4da\\x4dc\\x4de\\x4e0\\x4e2\\x4e4"
            "\\x4e6\\x4e8\\x4ea\\x4ec\\x4ee\\x4f0\\x4f2\\x4f4\\x4f6\\x4f8\\x4fa"
            "\\x4fc\\x4fe\\x500\\x502\\x504\\x506\\x508\\x50a\\x50c\\x50e\\x510"
            "\\x512\\x514\\x516\\x518\\x51a\\x51c\\x51e\\x520\\x522\\x524\\x526"
            "\\x528\\x52a\\x52c\\x52e\\x531-\\x556\\x10a0-\\x10c5\\x10c7\\x10cd"
            "\\x13a0-\\x13f5\\x1c90-\\x1cba\\x1cbd-\\x1cbf\\x1e00\\x1e02\\x1e04"
            "\\x1e06\\x1e08\\x1e0a\\x1e0c\\x1e0e\\x1e10\\x1e12\\x1e14\\x1e16"
            "\\x1e18\\x1e1a\\x1e1c\\x1e1e\\x1e20\\x1e22\\x1e24\\x1e26\\x1e28"
            "\\x1e2a\\x1e2c\\x1e2e\\x1e30\\x1e32\\x1e34\\x1e36\\x1e38\\x1e3a"
            "\\x1e3c\\x1e3e\\x1e40\\x1e42\\x1e44\\x1e46\\x1e48\\x1e4a\\x1e4c"
            "\\x1e4e\\x1e50\\x1e52\\x1e54\\x1e56\\x1e58\\x1e5a\\x1e5c\\x1e5e"
            "\\x1e60\\x1e62\\x1e64\\x1e66\\x1e68\\x1e6a\\x1e6c\\x1e6e\\x1e70"
            "\\x1e72\\x1e74\\x1e76\\x1e78\\x1e7a\\x1e7c\\x1e7e\\x1e80\\x1e82"
            "\\x1e84\\x1e86\\x1e88\\x1e8a\\x1e8c\\x1e8e\\x1e90\\x1e92\\x1e94"
            "\\x1e9e\\x1ea0\\x1ea2\\x1ea4\\x1ea6\\x1ea8\\x1eaa\\x1eac\\x1eae"
            "\\x1eb0\\x1eb2\\x1eb4\\x1eb6\\x1eb8\\x1eba\\x1ebc\\x1ebe\\x1ec0"
            "\\x1ec2\\x1ec4\\x1ec6\\x1ec8\\x1eca\\x1ecc\\x1ece\\x1ed0\\x1ed2"
            "\\x1ed4\\x1ed6\\x1ed8\\x1eda\\x1edc\\x1ede\\x1ee0\\x1ee2\\x1ee4"
            "\\x1ee6\\x1ee8\\x1eea\\x1eec\\x1eee\\x1ef0\\x1ef2\\x1ef4\\x1ef6"
            "\\x1ef8\\x1efa\\x1efc\\x1efe\\x1f08-\\x1f0f\\x1f18-\\x1f1d"
            "\\x1f28-\\x1f2f\\x1f38-\\x1f3f\\x1f48-\\x1f4d\\x1f59\\x1f5b\\x1f5d"
            "\\x1f5f\\x1f68-\\x1f6f\\x1fb8-\\x1fbb\\x1fc8-\\x1fcb"
            "\\x1fd8-\\x1fdb\\x1fe8-\\x1fec\\x1ff8-\\x1ffb\\x2102\\x2107"
            "\\x210b-\\x210d\\x2110-\\x2112\\x2115\\x2119-\\x211d\\x2124\\x2126"
            "\\x2128\\x212a-\\x212d\\x2130-\\x2133\\x213e\\x213f\\x2145\\x2183"
            "\\x2c00-\\x2c2f\\x2c60\\x2c62-\\x2c64\\x2c67\\x2c69\\x2c6b"
            "\\x2c6d-\\x2c70\\x2c72\\x2c75\\x2c7e-\\x2c80\\x2c82\\x2c84\\x2c86"
            "\\x2c88\\x2c8a\\x2c8c\\x2c8e\\x2c90\\x2c92\\x2c94\\x2c96\\x2c98"
            "\\x2c9a\\x2c9c\\x2c9e\\x2ca0\\x2ca2\\x2ca4\\x2ca6\\x2ca8\\x2caa"
            "\\x2cac\\x2cae\\x2cb0\\x2cb2\\x2cb4\\x2cb6\\x2cb8\\x2cba\\x2cbc"
            "\\x2cbe\\x2cc0\\x2cc2\\x2cc4\\x2cc6\\x2cc8\\x2cca\\x2ccc\\x2cce"
            "\\x2cd0\\x2cd2\\x2cd4\\x2cd6\\x2cd8\\x2cda\\x2cdc\\x2cde\\x2ce0"
            "\\x2ce2\\x2ceb\\x2ced\\x2cf2\\xa640\\xa642\\xa644\\xa646\\xa648"
            "\\xa64a\\xa64c\\xa64e\\xa650\\xa652\\xa654\\xa656\\xa658\\xa65a"
            "\\xa65c\\xa65e\\xa660\\xa662\\xa664\\xa666\\xa668\\xa66a\\xa66c"
            "\\xa680\\xa682\\xa684\\xa686\\xa688\\xa68a\\xa68c\\xa68e\\xa690"
            "\\xa692\\xa694\\xa696\\xa698\\xa69a\\xa722\\xa724\\xa726\\xa728"
            "\\xa72a\\xa72c\\xa72e\\xa732\\xa734\\xa736\\xa738\\xa73a\\xa73c"
            "\\xa73e\\xa740\\xa742\\xa744\\xa746\\xa748\\xa74a\\xa74c\\xa74e"
            "\\xa750\\xa752\\xa754\\xa756\\xa758\\xa75a\\xa75c\\xa75e\\xa760"
            "\\xa762\\xa764\\xa766\\xa768\\xa76a\\xa76c\\xa76e\\xa779\\xa77b"
            "\\xa77d\\xa77e\\xa780\\xa782\\xa784\\xa786\\xa78b\\xa78d\\xa790"
            "\\xa792\\xa796\\xa798\\xa79a\\xa79c\\xa79e\\xa7a0\\xa7a2\\xa7a4"
            "\\xa7a6\\xa7a8\\xa7aa-\\xa7ae\\xa7b0-\\xa7b4\\xa7b6\\xa7b8\\xa7ba"
            "\\xa7bc\\xa7be\\xa7c0\\xa7c2\\xa7c4-\\xa7c7\\xa7c9\\xa7d0\\xa7d6"
            "\\xa7d8\\xa7f5\\xff21-\\xff3a\\x10400-\\x10427\\x104b0-\\x104d3"
            "\\x10570-\\x1057a\\x1057c-\\x1058a\\x1058c-\\x10592"
            "\\x10594\\x10595\\x10c80-\\x10cb2\\x118a0-\\x118bf"
            "\\x16e40-\\x16e5f\\x1d400-\\x1d419\\x1d434-\\x1d44d"
            "\\x1d468-\\x1d481\\x1d49c\\x1d49e\\x1d49f\\x1d4a2\\x1d4a5\\x1d4a6"
            "\\x1d4a9-\\x1d4ac\\x1d4ae-\\x1d4b5\\x1d4d0-\\x1d4e9"
            "\\x1d504\\x1d505\\x1d507-\\x1d50a\\x1d50d-\\x1d514"
            "\\x1d516-\\x1d51c\\x1d538\\x1d539\\x1d53b-\\x1d53e"
            "\\x1d540-\\x1d544\\x1d546\\x1d54a-\\x1d550\\x1d56c-\\x1d585"
            "\\x1d5a0-\\x1d5b9\\x1d5d4-\\x1d5ed\\x1d608-\\x1d621"
            "\\x1d63c-\\x1d655\\x1d670-\\x1d689\\x1d6a8-\\x1d6c0"
            "\\x1d6e2-\\x1d6fa\\x1d71c-\\x1d734\\x1d756-\\x1d76e"
            "\\x1d790-\\x1d7a8\\x1d7ca\\x1e900-\\x1e921]";
    }

    static const char *Mc()
    {
        return "[\\x903\\x93b\\x93e-\\x940\\x949-\\x94c\\x94e\\x94f\\x982\\x983"
            "\\x9be-\\x9c0\\x9c7\\x9c8\\x9cb\\x9cc\\x9d7\\xa03\\xa3e-\\xa40"
            "\\xa83\\xabe-\\xac0\\xac9\\xacb\\xacc\\xb02\\xb03\\xb3e\\xb40"
            "\\xb47\\xb48\\xb4b\\xb4c\\xb57\\xbbe\\xbbf\\xbc1\\xbc2"
            "\\xbc6-\\xbc8\\xbca-\\xbcc\\xbd7\\xc01-\\xc03\\xc41-\\xc44"
            "\\xc82\\xc83\\xcbe\\xcc0-\\xcc4\\xcc7\\xcc8\\xcca\\xccb"
            "\\xcd5\\xcd6\\xd02\\xd03\\xd3e-\\xd40\\xd46-\\xd48\\xd4a-\\xd4c"
            "\\xd57\\xd82\\xd83\\xdcf-\\xdd1\\xdd8-\\xddf\\xdf2\\xdf3"
            "\\xf3e\\xf3f\\xf7f\\x102b\\x102c\\x1031\\x1038\\x103b\\x103c"
            "\\x1056\\x1057\\x1062-\\x1064\\x1067-\\x106d\\x1083\\x1084"
            "\\x1087-\\x108c\\x108f\\x109a-\\x109c\\x1715\\x17b6"
            "\\x17be-\\x17c5\\x17c7\\x17c8\\x1923-\\x1926\\x1929-\\x192b"
            "\\x1930\\x1931\\x1933-\\x1938\\x1a19\\x1a1a\\x1a55\\x1a57\\x1a61"
            "\\x1a63\\x1a64\\x1a6d-\\x1a72\\x1b04\\x1b35\\x1b3b\\x1b3d-\\x1b41"
            "\\x1b43\\x1b44\\x1b82\\x1ba1\\x1ba6\\x1ba7\\x1baa\\x1be7"
            "\\x1bea-\\x1bec\\x1bee\\x1bf2\\x1bf3\\x1c24-\\x1c2b\\x1c34\\x1c35"
            "\\x1ce1\\x1cf7\\x302e\\x302f\\xa823\\xa824\\xa827\\xa880\\xa881"
            "\\xa8b4-\\xa8c3\\xa952\\xa953\\xa983\\xa9b4\\xa9b5\\xa9ba\\xa9bb"
            "\\xa9be-\\xa9c0\\xaa2f\\xaa30\\xaa33\\xaa34\\xaa4d\\xaa7b\\xaa7d"
            "\\xaaeb\\xaaee\\xaaef\\xaaf5\\xabe3\\xabe4\\xabe6\\xabe7"
            "\\xabe9\\xabea\\xabec\\x11000\\x11002\\x11082\\x110b0-\\x110b2"
            "\\x110b7\\x110b8\\x1112c\\x11145\\x11146\\x11182\\x111b3-\\x111b5"
            "\\x111bf\\x111c0\\x111ce\\x1122c-\\x1122e\\x11232\\x11233\\x11235"
            "\\x112e0-\\x112e2\\x11302\\x11303\\x1133e\\x1133f"
            "\\x11341-\\x11344\\x11347\\x11348\\x1134b-\\x1134d\\x11357"
            "\\x11362\\x11363\\x11435-\\x11437\\x11440\\x11441\\x11445"
            "\\x114b0-\\x114b2\\x114b9\\x114bb-\\x114be\\x114c1"
            "\\x115af-\\x115b1\\x115b8-\\x115bb\\x115be\\x11630-\\x11632"
            "\\x1163b\\x1163c\\x1163e\\x116ac\\x116ae\\x116af\\x116b6"
            "\\x11720\\x11721\\x11726\\x1182c-\\x1182e\\x11838"
            "\\x11930-\\x11935\\x11937\\x11938\\x1193d\\x11940\\x11942"
            "\\x119d1-\\x119d3\\x119dc-\\x119df\\x119e4\\x11a39\\x11a57\\x11a58"
            "\\x11a97\\x11c2f\\x11c3e\\x11ca9\\x11cb1\\x11cb4\\x11d8a-\\x11d8e"
            "\\x11d93\\x11d94\\x11d96\\x11ef5\\x11ef6\\x16f51-\\x16f87"
            "\\x16ff0\\x16ff1\\x1d165\\x1d166\\x1d16d-\\x1d172]";
    }

    static const char *Me()
    {
        return "[\\x488\\x489\\x1abe\\x20dd-\\x20e0\\x20e2-\\x20e4"
            "\\xa670-\\xa672]";
    }

    static const char *Mn()
    {
        return "[\\x300-\\x36f\\x483-\\x487\\x591-\\x5bd\\x5bf\\x5c1\\x5c2"
            "\\x5c4\\x5c5\\x5c7\\x610-\\x61a\\x64b-\\x65f\\x670\\x6d6-\\x6dc"
            "\\x6df-\\x6e4\\x6e7\\x6e8\\x6ea-\\x6ed\\x711\\x730-\\x74a"
            "\\x7a6-\\x7b0\\x7eb-\\x7f3\\x7fd\\x816-\\x819\\x81b-\\x823"
            "\\x825-\\x827\\x829-\\x82d\\x859-\\x85b\\x898-\\x89f\\x8ca-\\x8e1"
            "\\x8e3-\\x902\\x93a\\x93c\\x941-\\x948\\x94d\\x951-\\x957"
            "\\x962\\x963\\x981\\x9bc\\x9c1-\\x9c4\\x9cd\\x9e2\\x9e3\\x9fe"
            "\\xa01\\xa02\\xa3c\\xa41\\xa42\\xa47\\xa48\\xa4b-\\xa4d\\xa51"
            "\\xa70\\xa71\\xa75\\xa81\\xa82\\xabc\\xac1-\\xac5\\xac7\\xac8"
            "\\xacd\\xae2\\xae3\\xafa-\\xaff\\xb01\\xb3c\\xb3f\\xb41-\\xb44"
            "\\xb4d\\xb55\\xb56\\xb62\\xb63\\xb82\\xbc0\\xbcd\\xc00\\xc04\\xc3c"
            "\\xc3e-\\xc40\\xc46-\\xc48\\xc4a-\\xc4d\\xc55\\xc56\\xc62\\xc63"
            "\\xc81\\xcbc\\xcbf\\xcc6\\xccc\\xccd\\xce2\\xce3\\xd00\\xd01"
            "\\xd3b\\xd3c\\xd41-\\xd44\\xd4d\\xd62\\xd63\\xd81\\xdca"
            "\\xdd2-\\xdd4\\xdd6\\xe31\\xe34-\\xe3a\\xe47-\\xe4e\\xeb1"
            "\\xeb4-\\xebc\\xec8-\\xecd\\xf18\\xf19\\xf35\\xf37\\xf39"
            "\\xf71-\\xf7e\\xf80-\\xf84\\xf86\\xf87\\xf8d-\\xf97\\xf99-\\xfbc"
            "\\xfc6\\x102d-\\x1030\\x1032-\\x1037\\x1039\\x103a\\x103d\\x103e"
            "\\x1058\\x1059\\x105e-\\x1060\\x1071-\\x1074\\x1082\\x1085\\x1086"
            "\\x108d\\x109d\\x135d-\\x135f\\x1712-\\x1714\\x1732-\\x1734"
            "\\x1752\\x1753\\x1772\\x1773\\x17b4\\x17b5\\x17b7-\\x17bd\\x17c6"
            "\\x17c9-\\x17d3\\x17dd\\x180b-\\x180d\\x180f\\x1885\\x1886\\x18a9"
            "\\x1920-\\x1922\\x1927\\x1928\\x1932\\x1939-\\x193b\\x1a17\\x1a18"
            "\\x1a1b\\x1a56\\x1a58-\\x1a5e\\x1a60\\x1a62\\x1a65-\\x1a6c"
            "\\x1a73-\\x1a7c\\x1a7f\\x1ab0-\\x1abd\\x1abf-\\x1ace"
            "\\x1b00-\\x1b03\\x1b34\\x1b36-\\x1b3a\\x1b3c\\x1b42"
            "\\x1b6b-\\x1b73\\x1b80\\x1b81\\x1ba2-\\x1ba5\\x1ba8\\x1ba9"
            "\\x1bab-\\x1bad\\x1be6\\x1be8\\x1be9\\x1bed\\x1bef-\\x1bf1"
            "\\x1c2c-\\x1c33\\x1c36\\x1c37\\x1cd0-\\x1cd2\\x1cd4-\\x1ce0"
            "\\x1ce2-\\x1ce8\\x1ced\\x1cf4\\x1cf8\\x1cf9\\x1dc0-\\x1dff"
            "\\x20d0-\\x20dc\\x20e1\\x20e5-\\x20f0\\x2cef-\\x2cf1\\x2d7f"
            "\\x2de0-\\x2dff\\x302a-\\x302d\\x3099\\x309a\\xa66f"
            "\\xa674-\\xa67d\\xa69e\\xa69f\\xa6f0\\xa6f1\\xa802\\xa806\\xa80b"
            "\\xa825\\xa826\\xa82c\\xa8c4\\xa8c5\\xa8e0-\\xa8f1\\xa8ff"
            "\\xa926-\\xa92d\\xa947-\\xa951\\xa980-\\xa982\\xa9b3"
            "\\xa9b6-\\xa9b9\\xa9bc\\xa9bd\\xa9e5\\xaa29-\\xaa2e\\xaa31\\xaa32"
            "\\xaa35\\xaa36\\xaa43\\xaa4c\\xaa7c\\xaab0\\xaab2-\\xaab4"
            "\\xaab7\\xaab8\\xaabe\\xaabf\\xaac1\\xaaec\\xaaed\\xaaf6\\xabe5"
            "\\xabe8\\xabed\\xfb1e\\xfe00-\\xfe0f\\xfe20-\\xfe2f\\x101fd"
            "\\x102e0\\x10376-\\x1037a\\x10a01-\\x10a03\\x10a05\\x10a06"
            "\\x10a0c-\\x10a0f\\x10a38-\\x10a3a\\x10a3f\\x10ae5\\x10ae6"
            "\\x10d24-\\x10d27\\x10eab\\x10eac\\x10f46-\\x10f50"
            "\\x10f82-\\x10f85\\x11001\\x11038-\\x11046\\x11070\\x11073\\x11074"
            "\\x1107f-\\x11081\\x110b3-\\x110b6\\x110b9\\x110ba\\x110c2"
            "\\x11100-\\x11102\\x11127-\\x1112b\\x1112d-\\x11134\\x11173"
            "\\x11180\\x11181\\x111b6-\\x111be\\x111c9-\\x111cc\\x111cf"
            "\\x1122f-\\x11231\\x11234\\x11236\\x11237\\x1123e\\x112df"
            "\\x112e3-\\x112ea\\x11300\\x11301\\x1133b\\x1133c\\x11340"
            "\\x11366-\\x1136c\\x11370-\\x11374\\x11438-\\x1143f"
            "\\x11442-\\x11444\\x11446\\x1145e\\x114b3-\\x114b8\\x114ba"
            "\\x114bf\\x114c0\\x114c2\\x114c3\\x115b2-\\x115b5\\x115bc\\x115bd"
            "\\x115bf\\x115c0\\x115dc\\x115dd\\x11633-\\x1163a\\x1163d"
            "\\x1163f\\x11640\\x116ab\\x116ad\\x116b0-\\x116b5\\x116b7"
            "\\x1171d-\\x1171f\\x11722-\\x11725\\x11727-\\x1172b"
            "\\x1182f-\\x11837\\x11839\\x1183a\\x1193b\\x1193c\\x1193e\\x11943"
            "\\x119d4-\\x119d7\\x119da\\x119db\\x119e0\\x11a01-\\x11a0a"
            "\\x11a33-\\x11a38\\x11a3b-\\x11a3e\\x11a47\\x11a51-\\x11a56"
            "\\x11a59-\\x11a5b\\x11a8a-\\x11a96\\x11a98\\x11a99"
            "\\x11c30-\\x11c36\\x11c38-\\x11c3d\\x11c3f\\x11c92-\\x11ca7"
            "\\x11caa-\\x11cb0\\x11cb2\\x11cb3\\x11cb5\\x11cb6"
            "\\x11d31-\\x11d36\\x11d3a\\x11d3c\\x11d3d\\x11d3f-\\x11d45\\x11d47"
            "\\x11d90\\x11d91\\x11d95\\x11d97\\x11ef3\\x11ef4\\x16af0-\\x16af4"
            "\\x16b30-\\x16b36\\x16f4f\\x16f8f-\\x16f92\\x16fe4\\x1bc9d\\x1bc9e"
            "\\x1cf00-\\x1cf2d\\x1cf30-\\x1cf46\\x1d167-\\x1d169"
            "\\x1d17b-\\x1d182\\x1d185-\\x1d18b\\x1d1aa-\\x1d1ad"
            "\\x1d242-\\x1d244\\x1da00-\\x1da36\\x1da3b-\\x1da6c\\x1da75"
            "\\x1da84\\x1da9b-\\x1da9f\\x1daa1-\\x1daaf\\x1e000-\\x1e006"
            "\\x1e008-\\x1e018\\x1e01b-\\x1e021\\x1e023\\x1e024"
            "\\x1e026-\\x1e02a\\x1e130-\\x1e136\\x1e2ae\\x1e2ec-\\x1e2ef"
            "\\x1e8d0-\\x1e8d6\\x1e944-\\x1e94a\\xe0100-\\xe01ef]";
    }

    static const char *Nd()
    {
        return "[\\x30-\\x39\\x660-\\x669\\x6f0-\\x6f9\\x7c0-\\x7c9"
            "\\x966-\\x96f\\x9e6-\\x9ef\\xa66-\\xa6f\\xae6-\\xaef\\xb66-\\xb6f"
            "\\xbe6-\\xbef\\xc66-\\xc6f\\xce6-\\xcef\\xd66-\\xd6f\\xde6-\\xdef"
            "\\xe50-\\xe59\\xed0-\\xed9\\xf20-\\xf29\\x1040-\\x1049"
            "\\x1090-\\x1099\\x17e0-\\x17e9\\x1810-\\x1819\\x1946-\\x194f"
            "\\x19d0-\\x19d9\\x1a80-\\x1a89\\x1a90-\\x1a99\\x1b50-\\x1b59"
            "\\x1bb0-\\x1bb9\\x1c40-\\x1c49\\x1c50-\\x1c59\\xa620-\\xa629"
            "\\xa8d0-\\xa8d9\\xa900-\\xa909\\xa9d0-\\xa9d9\\xa9f0-\\xa9f9"
            "\\xaa50-\\xaa59\\xabf0-\\xabf9\\xff10-\\xff19\\x104a0-\\x104a9"
            "\\x10d30-\\x10d39\\x11066-\\x1106f\\x110f0-\\x110f9"
            "\\x11136-\\x1113f\\x111d0-\\x111d9\\x112f0-\\x112f9"
            "\\x11450-\\x11459\\x114d0-\\x114d9\\x11650-\\x11659"
            "\\x116c0-\\x116c9\\x11730-\\x11739\\x118e0-\\x118e9"
            "\\x11950-\\x11959\\x11c50-\\x11c59\\x11d50-\\x11d59"
            "\\x11da0-\\x11da9\\x16a60-\\x16a69\\x16ac0-\\x16ac9"
            "\\x16b50-\\x16b59\\x1d7ce-\\x1d7ff\\x1e140-\\x1e149"
            "\\x1e2f0-\\x1e2f9\\x1e950-\\x1e959\\x1fbf0-\\x1fbf9]";
    }

    static const char *Nl()
    {
        return "[\\x16ee-\\x16f0\\x2160-\\x2182\\x2185-\\x2188\\x3007"
            "\\x3021-\\x3029\\x3038-\\x303a\\xa6e6-\\xa6ef\\x10140-\\x10174"
            "\\x10341\\x1034a\\x103d1-\\x103d5\\x12400-\\x1246e]";
    }

    static const char *No()
    {
        return "[\\xb2\\xb3\\xb9\\xbc-\\xbe\\x9f4-\\x9f9\\xb72-\\xb77"
            "\\xbf0-\\xbf2\\xc78-\\xc7e\\xd58-\\xd5e\\xd70-\\xd78\\xf2a-\\xf33"
            "\\x1369-\\x137c\\x17f0-\\x17f9\\x19da\\x2070\\x2074-\\x2079"
            "\\x2080-\\x2089\\x2150-\\x215f\\x2189\\x2460-\\x249b"
            "\\x24ea-\\x24ff\\x2776-\\x2793\\x2cfd\\x3192-\\x3195"
            "\\x3220-\\x3229\\x3248-\\x324f\\x3251-\\x325f\\x3280-\\x3289"
            "\\x32b1-\\x32bf\\xa830-\\xa835\\x10107-\\x10133\\x10175-\\x10178"
            "\\x1018a\\x1018b\\x102e1-\\x102fb\\x10320-\\x10323"
            "\\x10858-\\x1085f\\x10879-\\x1087f\\x108a7-\\x108af"
            "\\x108fb-\\x108ff\\x10916-\\x1091b\\x109bc\\x109bd"
            "\\x109c0-\\x109cf\\x109d2-\\x109ff\\x10a40-\\x10a48"
            "\\x10a7d\\x10a7e\\x10a9d-\\x10a9f\\x10aeb-\\x10aef"
            "\\x10b58-\\x10b5f\\x10b78-\\x10b7f\\x10ba9-\\x10baf"
            "\\x10cfa-\\x10cff\\x10e60-\\x10e7e\\x10f1d-\\x10f26"
            "\\x10f51-\\x10f54\\x10fc5-\\x10fcb\\x11052-\\x11065"
            "\\x111e1-\\x111f4\\x1173a\\x1173b\\x118ea-\\x118f2"
            "\\x11c5a-\\x11c6c\\x11fc0-\\x11fd4\\x16b5b-\\x16b61"
            "\\x16e80-\\x16e96\\x1d2e0-\\x1d2f3\\x1d360-\\x1d378"
            "\\x1e8c7-\\x1e8cf\\x1ec71-\\x1ecab\\x1ecad-\\x1ecaf"
            "\\x1ecb1-\\x1ecb4\\x1ed01-\\x1ed2d\\x1ed2f-\\x1ed3d"
            "\\x1f100-\\x1f10c]";
    }

    static const char *Pc()
    {
        return "[\\x5f\\x203f\\x2040\\x2054\\xfe33\\xfe34\\xfe4d-\\xfe4f"
            "\\xff3f]";
    }

    static const char *Pd()
    {
        return "[\\x2d\\x58a\\x5be\\x1400\\x1806\\x2010-\\x2015\\x2e17\\x2e1a"
            "\\x2e3a\\x2e3b\\x2e40\\x2e5d\\x301c\\x3030\\x30a0\\xfe31\\xfe32"
            "\\xfe58\\xfe63\\xff0d\\x10ead]";
    }

    static const char *Pe()
    {
        return "[\\x29\\x5d\\x7d\\xf3b\\xf3d\\x169c\\x2046\\x207e\\x208e\\x2309"
            "\\x230b\\x232a\\x2769\\x276b\\x276d\\x276f\\x2771\\x2773\\x2775"
            "\\x27c6\\x27e7\\x27e9\\x27eb\\x27ed\\x27ef\\x2984\\x2986\\x2988"
            "\\x298a\\x298c\\x298e\\x2990\\x2992\\x2994\\x2996\\x2998\\x29d9"
            "\\x29db\\x29fd\\x2e23\\x2e25\\x2e27\\x2e29\\x2e56\\x2e58\\x2e5a"
            "\\x2e5c\\x3009\\x300b\\x300d\\x300f\\x3011\\x3015\\x3017\\x3019"
            "\\x301b\\x301e\\x301f\\xfd3e\\xfe18\\xfe36\\xfe38\\xfe3a\\xfe3c"
            "\\xfe3e\\xfe40\\xfe42\\xfe44\\xfe48\\xfe5a\\xfe5c\\xfe5e\\xff09"
            "\\xff3d\\xff5d\\xff60\\xff63]";
    }

    static const char *Pf()
    {
        return "[\\xbb\\x2019\\x201d\\x203a\\x2e03\\x2e05\\x2e0a\\x2e0d\\x2e1d"
            "\\x2e21]";
    }

    static const char *Pi()
    {
        return "[\\xab\\x2018\\x201b\\x201c\\x201f\\x2039\\x2e02\\x2e04\\x2e09"
            "\\x2e0c\\x2e1c\\x2e20]";
    }

    static const char *Po()
    {
        return "[\\x21-\\x23\\x25-\\x27\\x2a\\x2c\\x2e\\x2f\\x3a\\x3b\\x3f\\x40"
            "\\x5c\\xa1\\xa7\\xb6\\xb7\\xbf\\x37e\\x387\\x55a-\\x55f\\x589"
            "\\x5c0\\x5c3\\x5c6\\x5f3\\x5f4\\x609\\x60a\\x60c\\x60d\\x61b"
            "\\x61d-\\x61f\\x66a-\\x66d\\x6d4\\x700-\\x70d\\x7f7-\\x7f9"
            "\\x830-\\x83e\\x85e\\x964\\x965\\x970\\x9fd\\xa76\\xaf0\\xc77"
            "\\xc84\\xdf4\\xe4f\\xe5a\\xe5b\\xf04-\\xf12\\xf14\\xf85"
            "\\xfd0-\\xfd4\\xfd9\\xfda\\x104a-\\x104f\\x10fb\\x1360-\\x1368"
            "\\x166e\\x16eb-\\x16ed\\x1735\\x1736\\x17d4-\\x17d6"
            "\\x17d8-\\x17da\\x1800-\\x1805\\x1807-\\x180a\\x1944\\x1945"
            "\\x1a1e\\x1a1f\\x1aa0-\\x1aa6\\x1aa8-\\x1aad\\x1b5a-\\x1b60"
            "\\x1b7d\\x1b7e\\x1bfc-\\x1bff\\x1c3b-\\x1c3f\\x1c7e\\x1c7f"
            "\\x1cc0-\\x1cc7\\x1cd3\\x2016\\x2017\\x2020-\\x2027"
            "\\x2030-\\x2038\\x203b-\\x203e\\x2041-\\x2043\\x2047-\\x2051"
            "\\x2053\\x2055-\\x205e\\x2cf9-\\x2cfc\\x2cfe\\x2cff\\x2d70"
            "\\x2e00\\x2e01\\x2e06-\\x2e08\\x2e0b\\x2e0e-\\x2e16\\x2e18\\x2e19"
            "\\x2e1b\\x2e1e\\x2e1f\\x2e2a-\\x2e2e\\x2e30-\\x2e39"
            "\\x2e3c-\\x2e3f\\x2e41\\x2e43-\\x2e4f\\x2e52-\\x2e54"
            "\\x3001-\\x3003\\x303d\\x30fb\\xa4fe\\xa4ff\\xa60d-\\xa60f\\xa673"
            "\\xa67e\\xa6f2-\\xa6f7\\xa874-\\xa877\\xa8ce\\xa8cf"
            "\\xa8f8-\\xa8fa\\xa8fc\\xa92e\\xa92f\\xa95f\\xa9c1-\\xa9cd"
            "\\xa9de\\xa9df\\xaa5c-\\xaa5f\\xaade\\xaadf\\xaaf0\\xaaf1\\xabeb"
            "\\xfe10-\\xfe16\\xfe19\\xfe30\\xfe45\\xfe46\\xfe49-\\xfe4c"
            "\\xfe50-\\xfe52\\xfe54-\\xfe57\\xfe5f-\\xfe61\\xfe68\\xfe6a\\xfe6b"
            "\\xff01-\\xff03\\xff05-\\xff07\\xff0a\\xff0c\\xff0e\\xff0f"
            "\\xff1a\\xff1b\\xff1f\\xff20\\xff3c\\xff61\\xff64\\xff65"
            "\\x10100-\\x10102\\x1039f\\x103d0\\x1056f\\x10857\\x1091f\\x1093f"
            "\\x10a50-\\x10a58\\x10a7f\\x10af0-\\x10af6\\x10b39-\\x10b3f"
            "\\x10b99-\\x10b9c\\x10f55-\\x10f59\\x10f86-\\x10f89"
            "\\x11047-\\x1104d\\x110bb\\x110bc\\x110be-\\x110c1"
            "\\x11140-\\x11143\\x11174\\x11175\\x111c5-\\x111c8\\x111cd\\x111db"
            "\\x111dd-\\x111df\\x11238-\\x1123d\\x112a9\\x1144b-\\x1144f"
            "\\x1145a\\x1145b\\x1145d\\x114c6\\x115c1-\\x115d7"
            "\\x11641-\\x11643\\x11660-\\x1166c\\x116b9\\x1173c-\\x1173e"
            "\\x1183b\\x11944-\\x11946\\x119e2\\x11a3f-\\x11a46"
            "\\x11a9a-\\x11a9c\\x11a9e-\\x11aa2\\x11c41-\\x11c45"
            "\\x11c70\\x11c71\\x11ef7\\x11ef8\\x11fff\\x12470-\\x12474"
            "\\x16a6e\\x16a6f\\x16af5\\x16b37-\\x16b3b\\x16b44"
            "\\x16e97-\\x16e9a\\x16fe2\\x1bc9f\\x1da87-\\x1da8b"
            "\\x1e95e\\x1e95f]";
    }

    static const char *Ps()
    {
        return "[\\x28\\x5b\\x7b\\xf3a\\xf3c\\x169b\\x201a\\x201e\\x2045\\x207d"
            "\\x208d\\x2308\\x230a\\x2329\\x2768\\x276a\\x276c\\x276e\\x2770"
            "\\x2772\\x2774\\x27c5\\x27e6\\x27e8\\x27ea\\x27ec\\x27ee\\x2983"
            "\\x2985\\x2987\\x2989\\x298b\\x298d\\x298f\\x2991\\x2993\\x2995"
            "\\x2997\\x29d8\\x29da\\x29fc\\x2e22\\x2e24\\x2e26\\x2e28\\x2e42"
            "\\x2e55\\x2e57\\x2e59\\x2e5b\\x3008\\x300a\\x300c\\x300e\\x3010"
            "\\x3014\\x3016\\x3018\\x301a\\x301d\\xfd3f\\xfe17\\xfe35\\xfe37"
            "\\xfe39\\xfe3b\\xfe3d\\xfe3f\\xfe41\\xfe43\\xfe47\\xfe59\\xfe5b"
            "\\xfe5d\\xff08\\xff3b\\xff5b\\xff5f\\xff62]";
    }

    static const char *Sc()
    {
        return "[\\x24\\xa2-\\xa5\\x58f\\x60b\\x7fe\\x7ff\\x9f2\\x9f3\\x9fb"
            "\\xaf1\\xbf9\\xe3f\\x17db\\x20a0-\\x20c0\\xa838\\xfdfc\\xfe69"
            "\\xff04\\xffe0\\xffe1\\xffe5\\xffe6\\x11fdd-\\x11fe0\\x1e2ff"
            "\\x1ecb0]";
    }

    static const char *Sk()
    {
        return "[\\x5e\\x60\\xa8\\xaf\\xb4\\xb8\\x2c2-\\x2c5\\x2d2-\\x2df"
            "\\x2e5-\\x2eb\\x2ed\\x2ef-\\x2ff\\x375\\x384\\x385\\x888\\x1fbd"
            "\\x1fbf-\\x1fc1\\x1fcd-\\x1fcf\\x1fdd-\\x1fdf\\x1fed-\\x1fef"
            "\\x1ffd\\x1ffe\\x309b\\x309c\\xa700-\\xa716\\xa720\\xa721"
            "\\xa789\\xa78a\\xab5b\\xab6a\\xab6b\\xfbb2-\\xfbc2\\xff3e\\xff40"
            "\\xffe3\\x1f3fb-\\x1f3ff]";
    }

    static const char *Sm()
    {
        return "[\\x2b\\x3c-\\x3e\\x7c\\x7e\\xac\\xb1\\xd7\\xf7\\x3f6"
            "\\x606-\\x608\\x2044\\x2052\\x207a-\\x207c\\x208a-\\x208c\\x2118"
            "\\x2140-\\x2144\\x214b\\x2190-\\x2194\\x219a\\x219b\\x21a0\\x21a3"
            "\\x21a6\\x21ae\\x21ce\\x21cf\\x21d2\\x21d4\\x21f4-\\x22ff"
            "\\x2320\\x2321\\x237c\\x239b-\\x23b3\\x23dc-\\x23e1\\x25b7\\x25c1"
            "\\x25f8-\\x25ff\\x266f\\x27c0-\\x27c4\\x27c7-\\x27e5"
            "\\x27f0-\\x27ff\\x2900-\\x2982\\x2999-\\x29d7\\x29dc-\\x29fb"
            "\\x29fe-\\x2aff\\x2b30-\\x2b44\\x2b47-\\x2b4c\\xfb29\\xfe62"
            "\\xfe64-\\xfe66\\xff0b\\xff1c-\\xff1e\\xff5c\\xff5e\\xffe2"
            "\\xffe9-\\xffec\\x1d6c1\\x1d6db\\x1d6fb\\x1d715\\x1d735\\x1d74f"
            "\\x1d76f\\x1d789\\x1d7a9\\x1d7c3\\x1eef0\\x1eef1]";
    }

    static const char *So()
    {
        return "[\\xa6\\xa9\\xae\\xb0\\x482\\x58d\\x58e\\x60e\\x60f\\x6de\\x6e9"
            "\\x6fd\\x6fe\\x7f6\\x9fa\\xb70\\xbf3-\\xbf8\\xbfa\\xc7f\\xd4f"
            "\\xd79\\xf01-\\xf03\\xf13\\xf15-\\xf17\\xf1a-\\xf1f\\xf34\\xf36"
            "\\xf38\\xfbe-\\xfc5\\xfc7-\\xfcc\\xfce\\xfcf\\xfd5-\\xfd8"
            "\\x109e\\x109f\\x1390-\\x1399\\x166d\\x1940\\x19de-\\x19ff"
            "\\x1b61-\\x1b6a\\x1b74-\\x1b7c\\x2100\\x2101\\x2103-\\x2106"
            "\\x2108\\x2109\\x2114\\x2116\\x2117\\x211e-\\x2123\\x2125\\x2127"
            "\\x2129\\x212e\\x213a\\x213b\\x214a\\x214c\\x214d\\x214f"
            "\\x218a\\x218b\\x2195-\\x2199\\x219c-\\x219f\\x21a1\\x21a2"
            "\\x21a4\\x21a5\\x21a7-\\x21ad\\x21af-\\x21cd\\x21d0\\x21d1\\x21d3"
            "\\x21d5-\\x21f3\\x2300-\\x2307\\x230c-\\x231f\\x2322-\\x2328"
            "\\x232b-\\x237b\\x237d-\\x239a\\x23b4-\\x23db\\x23e2-\\x2426"
            "\\x2440-\\x244a\\x249c-\\x24e9\\x2500-\\x25b6\\x25b8-\\x25c0"
            "\\x25c2-\\x25f7\\x2600-\\x266e\\x2670-\\x2767\\x2794-\\x27bf"
            "\\x2800-\\x28ff\\x2b00-\\x2b2f\\x2b45\\x2b46\\x2b4d-\\x2b73"
            "\\x2b76-\\x2b95\\x2b97-\\x2bff\\x2ce5-\\x2cea\\x2e50\\x2e51"
            "\\x2e80-\\x2e99\\x2e9b-\\x2ef3\\x2f00-\\x2fd5\\x2ff0-\\x2ffb"
            "\\x3004\\x3012\\x3013\\x3020\\x3036\\x3037\\x303e\\x303f"
            "\\x3190\\x3191\\x3196-\\x319f\\x31c0-\\x31e3\\x3200-\\x321e"
            "\\x322a-\\x3247\\x3250\\x3260-\\x327f\\x328a-\\x32b0"
            "\\x32c0-\\x33ff\\x4dc0-\\x4dff\\xa490-\\xa4c6\\xa828-\\xa82b"
            "\\xa836\\xa837\\xa839\\xaa77-\\xaa79\\xfd40-\\xfd4f\\xfdcf"
            "\\xfdfd-\\xfdff\\xffe4\\xffe8\\xffed\\xffee\\xfffc\\xfffd"
            "\\x10137-\\x1013f\\x10179-\\x10189\\x1018c-\\x1018e"
            "\\x10190-\\x1019c\\x101a0\\x101d0-\\x101fc\\x10877\\x10878\\x10ac8"
            "\\x1173f\\x11fd5-\\x11fdc\\x11fe1-\\x11ff1\\x16b3c-\\x16b3f"
            "\\x16b45\\x1bc9c\\x1cf50-\\x1cfc3\\x1d000-\\x1d0f5"
            "\\x1d100-\\x1d126\\x1d129-\\x1d164\\x1d16a-\\x1d16c"
            "\\x1d183\\x1d184\\x1d18c-\\x1d1a9\\x1d1ae-\\x1d1ea"
            "\\x1d200-\\x1d241\\x1d245\\x1d300-\\x1d356\\x1d800-\\x1d9ff"
            "\\x1da37-\\x1da3a\\x1da6d-\\x1da74\\x1da76-\\x1da83"
            "\\x1da85\\x1da86\\x1e14f\\x1ecac\\x1ed2e\\x1f000-\\x1f02b"
            "\\x1f030-\\x1f093\\x1f0a0-\\x1f0ae\\x1f0b1-\\x1f0bf"
            "\\x1f0c1-\\x1f0cf\\x1f0d1-\\x1f0f5\\x1f10d-\\x1f1ad"
            "\\x1f1e6-\\x1f202\\x1f210-\\x1f23b\\x1f240-\\x1f248"
            "\\x1f250\\x1f251\\x1f260-\\x1f265\\x1f300-\\x1f3fa"
            "\\x1f400-\\x1f6d7\\x1f6dd-\\x1f6ec\\x1f6f0-\\x1f6fc"
            "\\x1f700-\\x1f773\\x1f780-\\x1f7d8\\x1f7e0-\\x1f7eb\\x1f7f0"
            "\\x1f800-\\x1f80b\\x1f810-\\x1f847\\x1f850-\\x1f859"
            "\\x1f860-\\x1f887\\x1f890-\\x1f8ad\\x1f8b0\\x1f8b1"
            "\\x1f900-\\x1fa53\\x1fa60-\\x1fa6d\\x1fa70-\\x1fa74"
            "\\x1fa78-\\x1fa7c\\x1fa80-\\x1fa86\\x1fa90-\\x1faac"
            "\\x1fab0-\\x1faba\\x1fac0-\\x1fac5\\x1fad0-\\x1fad9"
            "\\x1fae0-\\x1fae7\\x1faf0-\\x1faf6\\x1fb00-\\x1fb92"
            "\\x1fb94-\\x1fbca]";
    }

    static const char *Zl()
    {
        return "[\\x2028]";
    }

    static const char *Zp()
    {
        return "[\\x2029]";
    }

    static const char *Zs()
    {
        return "[\\x20\\xa0\\x1680\\x2000-\\x200a\\x202f\\x205f\\x3000]";
    }
