#--------------------------------------------------------
# Script 4:  md4.sh - build the raidtab
bootpart=2
rootpart=3
swappart=4
if [ -d /dev/scsi/host0 ]
then
deva=/dev/scsi/host1/bus0/target0/lun0/part
devb=/dev/scsi/host1/bus0/target1/lun0/part
devm=/dev/md/
else
deva=/dev/sda
devb=/dev/sdb
devm=/dev/md
fi
rtabfile=/etc/raidtab
cat - <<%%% >$rtabfile
# raidtab 
# md0 is the root array
raiddev         ${devm}0
raid-level      1
nr-raid-disks   2
chunk-size      32
nr-spare-disks  0
persistent-superblock   1
device          ${devb}${rootpart}
raid-disk       0
device          ${deva}${rootpart}
failed-disk     1
 
# md1 is the /boot array
raiddev         ${devm}1
raid-level      1
nr-raid-disks   2 
chunk-size      32
nr-spare-disks  0
persistent-superblock   1
device          ${devb}${bootpart}
raid-disk       0
device          ${deva}${bootpart}
failed-disk     1
 
# md2 is the swap array
raiddev         ${devm}2
raid-level      1
nr-raid-disks   2
chunk-size      32
nr-spare-disks  0
persistent-superblock   1
device          ${devb}${swappart}
raid-disk       0
device          ${deva}${swappart}
failed-disk     1  
# raidtab end
%%%
# end script 4
#--------------------------------------------------------
