#--------------------------------------------------------
# Script 3 - partition /dev/sdb
if [ -d /dev/scsi/host0 ]
then
deva=/dev/scsi/host1/bus0/target0/lun0/disc
devb=/dev/scsi/host1/bus0/target1/lun0/disc
else
deva=/dev/sda
devb=/dev/sdb
fi
tmpf=/tmp/fdisk.in
tmps1=/tmp/sda.sfdisk
tmpr=/tmp/raid.sfdisk
echo "Repartitioning $devb ..."
# wipe any existing partitions on sdb
dd if=/dev/zero of=$devb bs=512 count=1
cat /proc/mdstat | grep md0
if [ $? -eq 0 ]
then
   echo "Reboot to stop pre-existing raid, then do md3.sh again."
   exit 1
fi
# save partition info from sda
sfdisk -d $deva  >$tmps1
# set the selected partition types to fd (Linux raid)
sed -e 's/Id=83/Id=fd/' -e 's/Id=82/Id=fd/' $tmps1 >$tmpr
# write partition info to sdb
sfdisk --force --no-reread $devb <$tmpr
# end script 3
#--------------------------------------------------------
