//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/config/bootstrap/v3/bootstrap.proto

package bootstrapv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on Bootstrap with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Bootstrap) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Bootstrap with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in BootstrapMultiError, or nil
// if none found.
func (m *Bootstrap) ValidateAll() error {
	return m.validate(true)
}

func (m *Bootstrap) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetNode()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "Node",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "Node",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetNode()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BootstrapValidationError{
				field:  "Node",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetStaticResources()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "StaticResources",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "StaticResources",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetStaticResources()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BootstrapValidationError{
				field:  "StaticResources",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetDynamicResources()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "DynamicResources",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "DynamicResources",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDynamicResources()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BootstrapValidationError{
				field:  "DynamicResources",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetClusterManager()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "ClusterManager",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "ClusterManager",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetClusterManager()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BootstrapValidationError{
				field:  "ClusterManager",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetHdsConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "HdsConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "HdsConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetHdsConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BootstrapValidationError{
				field:  "HdsConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for FlagsPath

	for idx, item := range m.GetStatsSinks() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, BootstrapValidationError{
						field:  fmt.Sprintf("StatsSinks[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, BootstrapValidationError{
						field:  fmt.Sprintf("StatsSinks[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return BootstrapValidationError{
					field:  fmt.Sprintf("StatsSinks[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetDeferredStatOptions()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "DeferredStatOptions",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "DeferredStatOptions",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDeferredStatOptions()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BootstrapValidationError{
				field:  "DeferredStatOptions",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetStatsConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "StatsConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "StatsConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetStatsConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BootstrapValidationError{
				field:  "StatsConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if d := m.GetStatsFlushInterval(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = BootstrapValidationError{
				field:  "StatsFlushInterval",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			lt := time.Duration(300*time.Second + 0*time.Nanosecond)
			gte := time.Duration(0*time.Second + 1000000*time.Nanosecond)

			if dur < gte || dur >= lt {
				err := BootstrapValidationError{
					field:  "StatsFlushInterval",
					reason: "value must be inside range [1ms, 5m0s)",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if all {
		switch v := interface{}(m.GetWatchdog()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "Watchdog",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "Watchdog",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetWatchdog()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BootstrapValidationError{
				field:  "Watchdog",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetWatchdogs()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "Watchdogs",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "Watchdogs",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetWatchdogs()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BootstrapValidationError{
				field:  "Watchdogs",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetTracing()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "Tracing",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "Tracing",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTracing()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BootstrapValidationError{
				field:  "Tracing",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetLayeredRuntime()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "LayeredRuntime",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "LayeredRuntime",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetLayeredRuntime()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BootstrapValidationError{
				field:  "LayeredRuntime",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetAdmin()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "Admin",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "Admin",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAdmin()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BootstrapValidationError{
				field:  "Admin",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetOverloadManager()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "OverloadManager",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "OverloadManager",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetOverloadManager()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BootstrapValidationError{
				field:  "OverloadManager",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for EnableDispatcherStats

	// no validation rules for HeaderPrefix

	if all {
		switch v := interface{}(m.GetStatsServerVersionOverride()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "StatsServerVersionOverride",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "StatsServerVersionOverride",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetStatsServerVersionOverride()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BootstrapValidationError{
				field:  "StatsServerVersionOverride",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for UseTcpForDnsLookups

	if all {
		switch v := interface{}(m.GetDnsResolutionConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "DnsResolutionConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "DnsResolutionConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDnsResolutionConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BootstrapValidationError{
				field:  "DnsResolutionConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetTypedDnsResolverConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "TypedDnsResolverConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "TypedDnsResolverConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTypedDnsResolverConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BootstrapValidationError{
				field:  "TypedDnsResolverConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetBootstrapExtensions() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, BootstrapValidationError{
						field:  fmt.Sprintf("BootstrapExtensions[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, BootstrapValidationError{
						field:  fmt.Sprintf("BootstrapExtensions[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return BootstrapValidationError{
					field:  fmt.Sprintf("BootstrapExtensions[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetFatalActions() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, BootstrapValidationError{
						field:  fmt.Sprintf("FatalActions[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, BootstrapValidationError{
						field:  fmt.Sprintf("FatalActions[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return BootstrapValidationError{
					field:  fmt.Sprintf("FatalActions[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetConfigSources() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, BootstrapValidationError{
						field:  fmt.Sprintf("ConfigSources[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, BootstrapValidationError{
						field:  fmt.Sprintf("ConfigSources[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return BootstrapValidationError{
					field:  fmt.Sprintf("ConfigSources[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetDefaultConfigSource()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "DefaultConfigSource",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "DefaultConfigSource",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDefaultConfigSource()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BootstrapValidationError{
				field:  "DefaultConfigSource",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for DefaultSocketInterface

	{
		sorted_keys := make([]string, len(m.GetCertificateProviderInstances()))
		i := 0
		for key := range m.GetCertificateProviderInstances() {
			sorted_keys[i] = key
			i++
		}
		sort.Slice(sorted_keys, func(i, j int) bool { return sorted_keys[i] < sorted_keys[j] })
		for _, key := range sorted_keys {
			val := m.GetCertificateProviderInstances()[key]
			_ = val

			// no validation rules for CertificateProviderInstances[key]

			if all {
				switch v := interface{}(val).(type) {
				case interface{ ValidateAll() error }:
					if err := v.ValidateAll(); err != nil {
						errors = append(errors, BootstrapValidationError{
							field:  fmt.Sprintf("CertificateProviderInstances[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				case interface{ Validate() error }:
					if err := v.Validate(); err != nil {
						errors = append(errors, BootstrapValidationError{
							field:  fmt.Sprintf("CertificateProviderInstances[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				}
			} else if v, ok := interface{}(val).(interface{ Validate() error }); ok {
				if err := v.Validate(); err != nil {
					return BootstrapValidationError{
						field:  fmt.Sprintf("CertificateProviderInstances[%v]", key),
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		}
	}

	for idx, item := range m.GetInlineHeaders() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, BootstrapValidationError{
						field:  fmt.Sprintf("InlineHeaders[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, BootstrapValidationError{
						field:  fmt.Sprintf("InlineHeaders[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return BootstrapValidationError{
					field:  fmt.Sprintf("InlineHeaders[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	// no validation rules for PerfTracingFilePath

	if all {
		switch v := interface{}(m.GetDefaultRegexEngine()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "DefaultRegexEngine",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "DefaultRegexEngine",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDefaultRegexEngine()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BootstrapValidationError{
				field:  "DefaultRegexEngine",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetXdsDelegateExtension()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "XdsDelegateExtension",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "XdsDelegateExtension",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetXdsDelegateExtension()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BootstrapValidationError{
				field:  "XdsDelegateExtension",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetXdsConfigTrackerExtension()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "XdsConfigTrackerExtension",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "XdsConfigTrackerExtension",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetXdsConfigTrackerExtension()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BootstrapValidationError{
				field:  "XdsConfigTrackerExtension",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetListenerManager()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "ListenerManager",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "ListenerManager",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetListenerManager()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BootstrapValidationError{
				field:  "ListenerManager",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetApplicationLogConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "ApplicationLogConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "ApplicationLogConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetApplicationLogConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BootstrapValidationError{
				field:  "ApplicationLogConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetGrpcAsyncClientManagerConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "GrpcAsyncClientManagerConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "GrpcAsyncClientManagerConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetGrpcAsyncClientManagerConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BootstrapValidationError{
				field:  "GrpcAsyncClientManagerConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetMemoryAllocatorManager()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "MemoryAllocatorManager",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, BootstrapValidationError{
					field:  "MemoryAllocatorManager",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMemoryAllocatorManager()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BootstrapValidationError{
				field:  "MemoryAllocatorManager",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	switch v := m.StatsFlush.(type) {
	case *Bootstrap_StatsFlushOnAdmin:
		if v == nil {
			err := BootstrapValidationError{
				field:  "StatsFlush",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if m.GetStatsFlushOnAdmin() != true {
			err := BootstrapValidationError{
				field:  "StatsFlushOnAdmin",
				reason: "value must equal true",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return BootstrapMultiError(errors)
	}

	return nil
}

// BootstrapMultiError is an error wrapping multiple validation errors returned
// by Bootstrap.ValidateAll() if the designated constraints aren't met.
type BootstrapMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m BootstrapMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m BootstrapMultiError) AllErrors() []error { return m }

// BootstrapValidationError is the validation error returned by
// Bootstrap.Validate if the designated constraints aren't met.
type BootstrapValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BootstrapValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BootstrapValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BootstrapValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BootstrapValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BootstrapValidationError) ErrorName() string { return "BootstrapValidationError" }

// Error satisfies the builtin error interface
func (e BootstrapValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBootstrap.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BootstrapValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BootstrapValidationError{}

// Validate checks the field values on Admin with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Admin) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Admin with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in AdminMultiError, or nil if none found.
func (m *Admin) ValidateAll() error {
	return m.validate(true)
}

func (m *Admin) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetAccessLog() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, AdminValidationError{
						field:  fmt.Sprintf("AccessLog[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, AdminValidationError{
						field:  fmt.Sprintf("AccessLog[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return AdminValidationError{
					field:  fmt.Sprintf("AccessLog[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	// no validation rules for AccessLogPath

	// no validation rules for ProfilePath

	if all {
		switch v := interface{}(m.GetAddress()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AdminValidationError{
					field:  "Address",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AdminValidationError{
					field:  "Address",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAddress()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AdminValidationError{
				field:  "Address",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetSocketOptions() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, AdminValidationError{
						field:  fmt.Sprintf("SocketOptions[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, AdminValidationError{
						field:  fmt.Sprintf("SocketOptions[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return AdminValidationError{
					field:  fmt.Sprintf("SocketOptions[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	// no validation rules for IgnoreGlobalConnLimit

	if len(errors) > 0 {
		return AdminMultiError(errors)
	}

	return nil
}

// AdminMultiError is an error wrapping multiple validation errors returned by
// Admin.ValidateAll() if the designated constraints aren't met.
type AdminMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AdminMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AdminMultiError) AllErrors() []error { return m }

// AdminValidationError is the validation error returned by Admin.Validate if
// the designated constraints aren't met.
type AdminValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AdminValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AdminValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AdminValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AdminValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AdminValidationError) ErrorName() string { return "AdminValidationError" }

// Error satisfies the builtin error interface
func (e AdminValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAdmin.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AdminValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AdminValidationError{}

// Validate checks the field values on ClusterManager with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *ClusterManager) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ClusterManager with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ClusterManagerMultiError,
// or nil if none found.
func (m *ClusterManager) ValidateAll() error {
	return m.validate(true)
}

func (m *ClusterManager) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for LocalClusterName

	if all {
		switch v := interface{}(m.GetOutlierDetection()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ClusterManagerValidationError{
					field:  "OutlierDetection",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ClusterManagerValidationError{
					field:  "OutlierDetection",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetOutlierDetection()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterManagerValidationError{
				field:  "OutlierDetection",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetUpstreamBindConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ClusterManagerValidationError{
					field:  "UpstreamBindConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ClusterManagerValidationError{
					field:  "UpstreamBindConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetUpstreamBindConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterManagerValidationError{
				field:  "UpstreamBindConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetLoadStatsConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ClusterManagerValidationError{
					field:  "LoadStatsConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ClusterManagerValidationError{
					field:  "LoadStatsConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetLoadStatsConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterManagerValidationError{
				field:  "LoadStatsConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for EnableDeferredClusterCreation

	if len(errors) > 0 {
		return ClusterManagerMultiError(errors)
	}

	return nil
}

// ClusterManagerMultiError is an error wrapping multiple validation errors
// returned by ClusterManager.ValidateAll() if the designated constraints
// aren't met.
type ClusterManagerMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ClusterManagerMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ClusterManagerMultiError) AllErrors() []error { return m }

// ClusterManagerValidationError is the validation error returned by
// ClusterManager.Validate if the designated constraints aren't met.
type ClusterManagerValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ClusterManagerValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ClusterManagerValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ClusterManagerValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ClusterManagerValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ClusterManagerValidationError) ErrorName() string { return "ClusterManagerValidationError" }

// Error satisfies the builtin error interface
func (e ClusterManagerValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sClusterManager.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ClusterManagerValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ClusterManagerValidationError{}

// Validate checks the field values on Watchdogs with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Watchdogs) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Watchdogs with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in WatchdogsMultiError, or nil
// if none found.
func (m *Watchdogs) ValidateAll() error {
	return m.validate(true)
}

func (m *Watchdogs) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetMainThreadWatchdog()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, WatchdogsValidationError{
					field:  "MainThreadWatchdog",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, WatchdogsValidationError{
					field:  "MainThreadWatchdog",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMainThreadWatchdog()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return WatchdogsValidationError{
				field:  "MainThreadWatchdog",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetWorkerWatchdog()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, WatchdogsValidationError{
					field:  "WorkerWatchdog",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, WatchdogsValidationError{
					field:  "WorkerWatchdog",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetWorkerWatchdog()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return WatchdogsValidationError{
				field:  "WorkerWatchdog",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return WatchdogsMultiError(errors)
	}

	return nil
}

// WatchdogsMultiError is an error wrapping multiple validation errors returned
// by Watchdogs.ValidateAll() if the designated constraints aren't met.
type WatchdogsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m WatchdogsMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m WatchdogsMultiError) AllErrors() []error { return m }

// WatchdogsValidationError is the validation error returned by
// Watchdogs.Validate if the designated constraints aren't met.
type WatchdogsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e WatchdogsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e WatchdogsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e WatchdogsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e WatchdogsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e WatchdogsValidationError) ErrorName() string { return "WatchdogsValidationError" }

// Error satisfies the builtin error interface
func (e WatchdogsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sWatchdogs.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = WatchdogsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = WatchdogsValidationError{}

// Validate checks the field values on Watchdog with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Watchdog) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Watchdog with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in WatchdogMultiError, or nil
// if none found.
func (m *Watchdog) ValidateAll() error {
	return m.validate(true)
}

func (m *Watchdog) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetActions() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, WatchdogValidationError{
						field:  fmt.Sprintf("Actions[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, WatchdogValidationError{
						field:  fmt.Sprintf("Actions[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return WatchdogValidationError{
					field:  fmt.Sprintf("Actions[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetMissTimeout()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, WatchdogValidationError{
					field:  "MissTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, WatchdogValidationError{
					field:  "MissTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMissTimeout()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return WatchdogValidationError{
				field:  "MissTimeout",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetMegamissTimeout()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, WatchdogValidationError{
					field:  "MegamissTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, WatchdogValidationError{
					field:  "MegamissTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMegamissTimeout()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return WatchdogValidationError{
				field:  "MegamissTimeout",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetKillTimeout()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, WatchdogValidationError{
					field:  "KillTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, WatchdogValidationError{
					field:  "KillTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetKillTimeout()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return WatchdogValidationError{
				field:  "KillTimeout",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if d := m.GetMaxKillTimeoutJitter(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = WatchdogValidationError{
				field:  "MaxKillTimeoutJitter",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gte := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur < gte {
				err := WatchdogValidationError{
					field:  "MaxKillTimeoutJitter",
					reason: "value must be greater than or equal to 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if all {
		switch v := interface{}(m.GetMultikillTimeout()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, WatchdogValidationError{
					field:  "MultikillTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, WatchdogValidationError{
					field:  "MultikillTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMultikillTimeout()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return WatchdogValidationError{
				field:  "MultikillTimeout",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetMultikillThreshold()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, WatchdogValidationError{
					field:  "MultikillThreshold",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, WatchdogValidationError{
					field:  "MultikillThreshold",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMultikillThreshold()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return WatchdogValidationError{
				field:  "MultikillThreshold",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return WatchdogMultiError(errors)
	}

	return nil
}

// WatchdogMultiError is an error wrapping multiple validation errors returned
// by Watchdog.ValidateAll() if the designated constraints aren't met.
type WatchdogMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m WatchdogMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m WatchdogMultiError) AllErrors() []error { return m }

// WatchdogValidationError is the validation error returned by
// Watchdog.Validate if the designated constraints aren't met.
type WatchdogValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e WatchdogValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e WatchdogValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e WatchdogValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e WatchdogValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e WatchdogValidationError) ErrorName() string { return "WatchdogValidationError" }

// Error satisfies the builtin error interface
func (e WatchdogValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sWatchdog.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = WatchdogValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = WatchdogValidationError{}

// Validate checks the field values on FatalAction with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *FatalAction) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on FatalAction with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in FatalActionMultiError, or
// nil if none found.
func (m *FatalAction) ValidateAll() error {
	return m.validate(true)
}

func (m *FatalAction) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, FatalActionValidationError{
					field:  "Config",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, FatalActionValidationError{
					field:  "Config",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return FatalActionValidationError{
				field:  "Config",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return FatalActionMultiError(errors)
	}

	return nil
}

// FatalActionMultiError is an error wrapping multiple validation errors
// returned by FatalAction.ValidateAll() if the designated constraints aren't met.
type FatalActionMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m FatalActionMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m FatalActionMultiError) AllErrors() []error { return m }

// FatalActionValidationError is the validation error returned by
// FatalAction.Validate if the designated constraints aren't met.
type FatalActionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e FatalActionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e FatalActionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e FatalActionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e FatalActionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e FatalActionValidationError) ErrorName() string { return "FatalActionValidationError" }

// Error satisfies the builtin error interface
func (e FatalActionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sFatalAction.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = FatalActionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = FatalActionValidationError{}

// Validate checks the field values on Runtime with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Runtime) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Runtime with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in RuntimeMultiError, or nil if none found.
func (m *Runtime) ValidateAll() error {
	return m.validate(true)
}

func (m *Runtime) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for SymlinkRoot

	// no validation rules for Subdirectory

	// no validation rules for OverrideSubdirectory

	if all {
		switch v := interface{}(m.GetBase()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RuntimeValidationError{
					field:  "Base",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RuntimeValidationError{
					field:  "Base",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetBase()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RuntimeValidationError{
				field:  "Base",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return RuntimeMultiError(errors)
	}

	return nil
}

// RuntimeMultiError is an error wrapping multiple validation errors returned
// by Runtime.ValidateAll() if the designated constraints aren't met.
type RuntimeMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RuntimeMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RuntimeMultiError) AllErrors() []error { return m }

// RuntimeValidationError is the validation error returned by Runtime.Validate
// if the designated constraints aren't met.
type RuntimeValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RuntimeValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RuntimeValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RuntimeValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RuntimeValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RuntimeValidationError) ErrorName() string { return "RuntimeValidationError" }

// Error satisfies the builtin error interface
func (e RuntimeValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRuntime.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RuntimeValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RuntimeValidationError{}

// Validate checks the field values on RuntimeLayer with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *RuntimeLayer) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RuntimeLayer with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in RuntimeLayerMultiError, or
// nil if none found.
func (m *RuntimeLayer) ValidateAll() error {
	return m.validate(true)
}

func (m *RuntimeLayer) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetName()) < 1 {
		err := RuntimeLayerValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	oneofLayerSpecifierPresent := false
	switch v := m.LayerSpecifier.(type) {
	case *RuntimeLayer_StaticLayer:
		if v == nil {
			err := RuntimeLayerValidationError{
				field:  "LayerSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofLayerSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetStaticLayer()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RuntimeLayerValidationError{
						field:  "StaticLayer",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RuntimeLayerValidationError{
						field:  "StaticLayer",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetStaticLayer()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RuntimeLayerValidationError{
					field:  "StaticLayer",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RuntimeLayer_DiskLayer_:
		if v == nil {
			err := RuntimeLayerValidationError{
				field:  "LayerSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofLayerSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetDiskLayer()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RuntimeLayerValidationError{
						field:  "DiskLayer",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RuntimeLayerValidationError{
						field:  "DiskLayer",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetDiskLayer()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RuntimeLayerValidationError{
					field:  "DiskLayer",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RuntimeLayer_AdminLayer_:
		if v == nil {
			err := RuntimeLayerValidationError{
				field:  "LayerSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofLayerSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetAdminLayer()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RuntimeLayerValidationError{
						field:  "AdminLayer",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RuntimeLayerValidationError{
						field:  "AdminLayer",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetAdminLayer()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RuntimeLayerValidationError{
					field:  "AdminLayer",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RuntimeLayer_RtdsLayer_:
		if v == nil {
			err := RuntimeLayerValidationError{
				field:  "LayerSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofLayerSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetRtdsLayer()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RuntimeLayerValidationError{
						field:  "RtdsLayer",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RuntimeLayerValidationError{
						field:  "RtdsLayer",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetRtdsLayer()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RuntimeLayerValidationError{
					field:  "RtdsLayer",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofLayerSpecifierPresent {
		err := RuntimeLayerValidationError{
			field:  "LayerSpecifier",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return RuntimeLayerMultiError(errors)
	}

	return nil
}

// RuntimeLayerMultiError is an error wrapping multiple validation errors
// returned by RuntimeLayer.ValidateAll() if the designated constraints aren't met.
type RuntimeLayerMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RuntimeLayerMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RuntimeLayerMultiError) AllErrors() []error { return m }

// RuntimeLayerValidationError is the validation error returned by
// RuntimeLayer.Validate if the designated constraints aren't met.
type RuntimeLayerValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RuntimeLayerValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RuntimeLayerValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RuntimeLayerValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RuntimeLayerValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RuntimeLayerValidationError) ErrorName() string { return "RuntimeLayerValidationError" }

// Error satisfies the builtin error interface
func (e RuntimeLayerValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRuntimeLayer.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RuntimeLayerValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RuntimeLayerValidationError{}

// Validate checks the field values on LayeredRuntime with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *LayeredRuntime) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on LayeredRuntime with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in LayeredRuntimeMultiError,
// or nil if none found.
func (m *LayeredRuntime) ValidateAll() error {
	return m.validate(true)
}

func (m *LayeredRuntime) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetLayers() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, LayeredRuntimeValidationError{
						field:  fmt.Sprintf("Layers[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, LayeredRuntimeValidationError{
						field:  fmt.Sprintf("Layers[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return LayeredRuntimeValidationError{
					field:  fmt.Sprintf("Layers[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return LayeredRuntimeMultiError(errors)
	}

	return nil
}

// LayeredRuntimeMultiError is an error wrapping multiple validation errors
// returned by LayeredRuntime.ValidateAll() if the designated constraints
// aren't met.
type LayeredRuntimeMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m LayeredRuntimeMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m LayeredRuntimeMultiError) AllErrors() []error { return m }

// LayeredRuntimeValidationError is the validation error returned by
// LayeredRuntime.Validate if the designated constraints aren't met.
type LayeredRuntimeValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e LayeredRuntimeValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e LayeredRuntimeValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e LayeredRuntimeValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e LayeredRuntimeValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e LayeredRuntimeValidationError) ErrorName() string { return "LayeredRuntimeValidationError" }

// Error satisfies the builtin error interface
func (e LayeredRuntimeValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sLayeredRuntime.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = LayeredRuntimeValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = LayeredRuntimeValidationError{}

// Validate checks the field values on CustomInlineHeader with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *CustomInlineHeader) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on CustomInlineHeader with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// CustomInlineHeaderMultiError, or nil if none found.
func (m *CustomInlineHeader) ValidateAll() error {
	return m.validate(true)
}

func (m *CustomInlineHeader) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetInlineHeaderName()) < 1 {
		err := CustomInlineHeaderValidationError{
			field:  "InlineHeaderName",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_CustomInlineHeader_InlineHeaderName_Pattern.MatchString(m.GetInlineHeaderName()) {
		err := CustomInlineHeaderValidationError{
			field:  "InlineHeaderName",
			reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if _, ok := CustomInlineHeader_InlineHeaderType_name[int32(m.GetInlineHeaderType())]; !ok {
		err := CustomInlineHeaderValidationError{
			field:  "InlineHeaderType",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return CustomInlineHeaderMultiError(errors)
	}

	return nil
}

// CustomInlineHeaderMultiError is an error wrapping multiple validation errors
// returned by CustomInlineHeader.ValidateAll() if the designated constraints
// aren't met.
type CustomInlineHeaderMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m CustomInlineHeaderMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m CustomInlineHeaderMultiError) AllErrors() []error { return m }

// CustomInlineHeaderValidationError is the validation error returned by
// CustomInlineHeader.Validate if the designated constraints aren't met.
type CustomInlineHeaderValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CustomInlineHeaderValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CustomInlineHeaderValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CustomInlineHeaderValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CustomInlineHeaderValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CustomInlineHeaderValidationError) ErrorName() string {
	return "CustomInlineHeaderValidationError"
}

// Error satisfies the builtin error interface
func (e CustomInlineHeaderValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCustomInlineHeader.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CustomInlineHeaderValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CustomInlineHeaderValidationError{}

var _CustomInlineHeader_InlineHeaderName_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

// Validate checks the field values on MemoryAllocatorManager with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *MemoryAllocatorManager) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on MemoryAllocatorManager with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// MemoryAllocatorManagerMultiError, or nil if none found.
func (m *MemoryAllocatorManager) ValidateAll() error {
	return m.validate(true)
}

func (m *MemoryAllocatorManager) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for BytesToRelease

	if all {
		switch v := interface{}(m.GetMemoryReleaseInterval()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, MemoryAllocatorManagerValidationError{
					field:  "MemoryReleaseInterval",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, MemoryAllocatorManagerValidationError{
					field:  "MemoryReleaseInterval",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMemoryReleaseInterval()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return MemoryAllocatorManagerValidationError{
				field:  "MemoryReleaseInterval",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return MemoryAllocatorManagerMultiError(errors)
	}

	return nil
}

// MemoryAllocatorManagerMultiError is an error wrapping multiple validation
// errors returned by MemoryAllocatorManager.ValidateAll() if the designated
// constraints aren't met.
type MemoryAllocatorManagerMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m MemoryAllocatorManagerMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m MemoryAllocatorManagerMultiError) AllErrors() []error { return m }

// MemoryAllocatorManagerValidationError is the validation error returned by
// MemoryAllocatorManager.Validate if the designated constraints aren't met.
type MemoryAllocatorManagerValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e MemoryAllocatorManagerValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e MemoryAllocatorManagerValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e MemoryAllocatorManagerValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e MemoryAllocatorManagerValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e MemoryAllocatorManagerValidationError) ErrorName() string {
	return "MemoryAllocatorManagerValidationError"
}

// Error satisfies the builtin error interface
func (e MemoryAllocatorManagerValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sMemoryAllocatorManager.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = MemoryAllocatorManagerValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = MemoryAllocatorManagerValidationError{}

// Validate checks the field values on Bootstrap_StaticResources with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *Bootstrap_StaticResources) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Bootstrap_StaticResources with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// Bootstrap_StaticResourcesMultiError, or nil if none found.
func (m *Bootstrap_StaticResources) ValidateAll() error {
	return m.validate(true)
}

func (m *Bootstrap_StaticResources) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetListeners() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, Bootstrap_StaticResourcesValidationError{
						field:  fmt.Sprintf("Listeners[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, Bootstrap_StaticResourcesValidationError{
						field:  fmt.Sprintf("Listeners[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return Bootstrap_StaticResourcesValidationError{
					field:  fmt.Sprintf("Listeners[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetClusters() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, Bootstrap_StaticResourcesValidationError{
						field:  fmt.Sprintf("Clusters[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, Bootstrap_StaticResourcesValidationError{
						field:  fmt.Sprintf("Clusters[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return Bootstrap_StaticResourcesValidationError{
					field:  fmt.Sprintf("Clusters[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetSecrets() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, Bootstrap_StaticResourcesValidationError{
						field:  fmt.Sprintf("Secrets[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, Bootstrap_StaticResourcesValidationError{
						field:  fmt.Sprintf("Secrets[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return Bootstrap_StaticResourcesValidationError{
					field:  fmt.Sprintf("Secrets[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return Bootstrap_StaticResourcesMultiError(errors)
	}

	return nil
}

// Bootstrap_StaticResourcesMultiError is an error wrapping multiple validation
// errors returned by Bootstrap_StaticResources.ValidateAll() if the
// designated constraints aren't met.
type Bootstrap_StaticResourcesMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Bootstrap_StaticResourcesMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Bootstrap_StaticResourcesMultiError) AllErrors() []error { return m }

// Bootstrap_StaticResourcesValidationError is the validation error returned by
// Bootstrap_StaticResources.Validate if the designated constraints aren't met.
type Bootstrap_StaticResourcesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Bootstrap_StaticResourcesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Bootstrap_StaticResourcesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Bootstrap_StaticResourcesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Bootstrap_StaticResourcesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Bootstrap_StaticResourcesValidationError) ErrorName() string {
	return "Bootstrap_StaticResourcesValidationError"
}

// Error satisfies the builtin error interface
func (e Bootstrap_StaticResourcesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBootstrap_StaticResources.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Bootstrap_StaticResourcesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Bootstrap_StaticResourcesValidationError{}

// Validate checks the field values on Bootstrap_DynamicResources with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *Bootstrap_DynamicResources) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Bootstrap_DynamicResources with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// Bootstrap_DynamicResourcesMultiError, or nil if none found.
func (m *Bootstrap_DynamicResources) ValidateAll() error {
	return m.validate(true)
}

func (m *Bootstrap_DynamicResources) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetLdsConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, Bootstrap_DynamicResourcesValidationError{
					field:  "LdsConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, Bootstrap_DynamicResourcesValidationError{
					field:  "LdsConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetLdsConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Bootstrap_DynamicResourcesValidationError{
				field:  "LdsConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for LdsResourcesLocator

	if all {
		switch v := interface{}(m.GetCdsConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, Bootstrap_DynamicResourcesValidationError{
					field:  "CdsConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, Bootstrap_DynamicResourcesValidationError{
					field:  "CdsConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetCdsConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Bootstrap_DynamicResourcesValidationError{
				field:  "CdsConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for CdsResourcesLocator

	if all {
		switch v := interface{}(m.GetAdsConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, Bootstrap_DynamicResourcesValidationError{
					field:  "AdsConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, Bootstrap_DynamicResourcesValidationError{
					field:  "AdsConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAdsConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Bootstrap_DynamicResourcesValidationError{
				field:  "AdsConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return Bootstrap_DynamicResourcesMultiError(errors)
	}

	return nil
}

// Bootstrap_DynamicResourcesMultiError is an error wrapping multiple
// validation errors returned by Bootstrap_DynamicResources.ValidateAll() if
// the designated constraints aren't met.
type Bootstrap_DynamicResourcesMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Bootstrap_DynamicResourcesMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Bootstrap_DynamicResourcesMultiError) AllErrors() []error { return m }

// Bootstrap_DynamicResourcesValidationError is the validation error returned
// by Bootstrap_DynamicResources.Validate if the designated constraints aren't met.
type Bootstrap_DynamicResourcesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Bootstrap_DynamicResourcesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Bootstrap_DynamicResourcesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Bootstrap_DynamicResourcesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Bootstrap_DynamicResourcesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Bootstrap_DynamicResourcesValidationError) ErrorName() string {
	return "Bootstrap_DynamicResourcesValidationError"
}

// Error satisfies the builtin error interface
func (e Bootstrap_DynamicResourcesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBootstrap_DynamicResources.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Bootstrap_DynamicResourcesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Bootstrap_DynamicResourcesValidationError{}

// Validate checks the field values on Bootstrap_ApplicationLogConfig with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *Bootstrap_ApplicationLogConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Bootstrap_ApplicationLogConfig with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// Bootstrap_ApplicationLogConfigMultiError, or nil if none found.
func (m *Bootstrap_ApplicationLogConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *Bootstrap_ApplicationLogConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetLogFormat()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, Bootstrap_ApplicationLogConfigValidationError{
					field:  "LogFormat",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, Bootstrap_ApplicationLogConfigValidationError{
					field:  "LogFormat",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetLogFormat()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Bootstrap_ApplicationLogConfigValidationError{
				field:  "LogFormat",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return Bootstrap_ApplicationLogConfigMultiError(errors)
	}

	return nil
}

// Bootstrap_ApplicationLogConfigMultiError is an error wrapping multiple
// validation errors returned by Bootstrap_ApplicationLogConfig.ValidateAll()
// if the designated constraints aren't met.
type Bootstrap_ApplicationLogConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Bootstrap_ApplicationLogConfigMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Bootstrap_ApplicationLogConfigMultiError) AllErrors() []error { return m }

// Bootstrap_ApplicationLogConfigValidationError is the validation error
// returned by Bootstrap_ApplicationLogConfig.Validate if the designated
// constraints aren't met.
type Bootstrap_ApplicationLogConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Bootstrap_ApplicationLogConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Bootstrap_ApplicationLogConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Bootstrap_ApplicationLogConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Bootstrap_ApplicationLogConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Bootstrap_ApplicationLogConfigValidationError) ErrorName() string {
	return "Bootstrap_ApplicationLogConfigValidationError"
}

// Error satisfies the builtin error interface
func (e Bootstrap_ApplicationLogConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBootstrap_ApplicationLogConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Bootstrap_ApplicationLogConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Bootstrap_ApplicationLogConfigValidationError{}

// Validate checks the field values on Bootstrap_DeferredStatOptions with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *Bootstrap_DeferredStatOptions) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Bootstrap_DeferredStatOptions with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// Bootstrap_DeferredStatOptionsMultiError, or nil if none found.
func (m *Bootstrap_DeferredStatOptions) ValidateAll() error {
	return m.validate(true)
}

func (m *Bootstrap_DeferredStatOptions) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for EnableDeferredCreationStats

	if len(errors) > 0 {
		return Bootstrap_DeferredStatOptionsMultiError(errors)
	}

	return nil
}

// Bootstrap_DeferredStatOptionsMultiError is an error wrapping multiple
// validation errors returned by Bootstrap_DeferredStatOptions.ValidateAll()
// if the designated constraints aren't met.
type Bootstrap_DeferredStatOptionsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Bootstrap_DeferredStatOptionsMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Bootstrap_DeferredStatOptionsMultiError) AllErrors() []error { return m }

// Bootstrap_DeferredStatOptionsValidationError is the validation error
// returned by Bootstrap_DeferredStatOptions.Validate if the designated
// constraints aren't met.
type Bootstrap_DeferredStatOptionsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Bootstrap_DeferredStatOptionsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Bootstrap_DeferredStatOptionsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Bootstrap_DeferredStatOptionsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Bootstrap_DeferredStatOptionsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Bootstrap_DeferredStatOptionsValidationError) ErrorName() string {
	return "Bootstrap_DeferredStatOptionsValidationError"
}

// Error satisfies the builtin error interface
func (e Bootstrap_DeferredStatOptionsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBootstrap_DeferredStatOptions.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Bootstrap_DeferredStatOptionsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Bootstrap_DeferredStatOptionsValidationError{}

// Validate checks the field values on Bootstrap_GrpcAsyncClientManagerConfig
// with the rules defined in the proto definition for this message. If any
// rules are violated, the first error encountered is returned, or nil if
// there are no violations.
func (m *Bootstrap_GrpcAsyncClientManagerConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// Bootstrap_GrpcAsyncClientManagerConfig with the rules defined in the proto
// definition for this message. If any rules are violated, the result is a
// list of violation errors wrapped in
// Bootstrap_GrpcAsyncClientManagerConfigMultiError, or nil if none found.
func (m *Bootstrap_GrpcAsyncClientManagerConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *Bootstrap_GrpcAsyncClientManagerConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if d := m.GetMaxCachedEntryIdleDuration(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = Bootstrap_GrpcAsyncClientManagerConfigValidationError{
				field:  "MaxCachedEntryIdleDuration",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gte := time.Duration(5*time.Second + 0*time.Nanosecond)

			if dur < gte {
				err := Bootstrap_GrpcAsyncClientManagerConfigValidationError{
					field:  "MaxCachedEntryIdleDuration",
					reason: "value must be greater than or equal to 5s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if len(errors) > 0 {
		return Bootstrap_GrpcAsyncClientManagerConfigMultiError(errors)
	}

	return nil
}

// Bootstrap_GrpcAsyncClientManagerConfigMultiError is an error wrapping
// multiple validation errors returned by
// Bootstrap_GrpcAsyncClientManagerConfig.ValidateAll() if the designated
// constraints aren't met.
type Bootstrap_GrpcAsyncClientManagerConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Bootstrap_GrpcAsyncClientManagerConfigMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Bootstrap_GrpcAsyncClientManagerConfigMultiError) AllErrors() []error { return m }

// Bootstrap_GrpcAsyncClientManagerConfigValidationError is the validation
// error returned by Bootstrap_GrpcAsyncClientManagerConfig.Validate if the
// designated constraints aren't met.
type Bootstrap_GrpcAsyncClientManagerConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Bootstrap_GrpcAsyncClientManagerConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Bootstrap_GrpcAsyncClientManagerConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Bootstrap_GrpcAsyncClientManagerConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Bootstrap_GrpcAsyncClientManagerConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Bootstrap_GrpcAsyncClientManagerConfigValidationError) ErrorName() string {
	return "Bootstrap_GrpcAsyncClientManagerConfigValidationError"
}

// Error satisfies the builtin error interface
func (e Bootstrap_GrpcAsyncClientManagerConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBootstrap_GrpcAsyncClientManagerConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Bootstrap_GrpcAsyncClientManagerConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Bootstrap_GrpcAsyncClientManagerConfigValidationError{}

// Validate checks the field values on Bootstrap_ApplicationLogConfig_LogFormat
// with the rules defined in the proto definition for this message. If any
// rules are violated, the first error encountered is returned, or nil if
// there are no violations.
func (m *Bootstrap_ApplicationLogConfig_LogFormat) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// Bootstrap_ApplicationLogConfig_LogFormat with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in
// Bootstrap_ApplicationLogConfig_LogFormatMultiError, or nil if none found.
func (m *Bootstrap_ApplicationLogConfig_LogFormat) ValidateAll() error {
	return m.validate(true)
}

func (m *Bootstrap_ApplicationLogConfig_LogFormat) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	oneofLogFormatPresent := false
	switch v := m.LogFormat.(type) {
	case *Bootstrap_ApplicationLogConfig_LogFormat_JsonFormat:
		if v == nil {
			err := Bootstrap_ApplicationLogConfig_LogFormatValidationError{
				field:  "LogFormat",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofLogFormatPresent = true

		if all {
			switch v := interface{}(m.GetJsonFormat()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, Bootstrap_ApplicationLogConfig_LogFormatValidationError{
						field:  "JsonFormat",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, Bootstrap_ApplicationLogConfig_LogFormatValidationError{
						field:  "JsonFormat",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetJsonFormat()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return Bootstrap_ApplicationLogConfig_LogFormatValidationError{
					field:  "JsonFormat",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Bootstrap_ApplicationLogConfig_LogFormat_TextFormat:
		if v == nil {
			err := Bootstrap_ApplicationLogConfig_LogFormatValidationError{
				field:  "LogFormat",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofLogFormatPresent = true
		// no validation rules for TextFormat
	default:
		_ = v // ensures v is used
	}
	if !oneofLogFormatPresent {
		err := Bootstrap_ApplicationLogConfig_LogFormatValidationError{
			field:  "LogFormat",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return Bootstrap_ApplicationLogConfig_LogFormatMultiError(errors)
	}

	return nil
}

// Bootstrap_ApplicationLogConfig_LogFormatMultiError is an error wrapping
// multiple validation errors returned by
// Bootstrap_ApplicationLogConfig_LogFormat.ValidateAll() if the designated
// constraints aren't met.
type Bootstrap_ApplicationLogConfig_LogFormatMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Bootstrap_ApplicationLogConfig_LogFormatMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Bootstrap_ApplicationLogConfig_LogFormatMultiError) AllErrors() []error { return m }

// Bootstrap_ApplicationLogConfig_LogFormatValidationError is the validation
// error returned by Bootstrap_ApplicationLogConfig_LogFormat.Validate if the
// designated constraints aren't met.
type Bootstrap_ApplicationLogConfig_LogFormatValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Bootstrap_ApplicationLogConfig_LogFormatValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Bootstrap_ApplicationLogConfig_LogFormatValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Bootstrap_ApplicationLogConfig_LogFormatValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Bootstrap_ApplicationLogConfig_LogFormatValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Bootstrap_ApplicationLogConfig_LogFormatValidationError) ErrorName() string {
	return "Bootstrap_ApplicationLogConfig_LogFormatValidationError"
}

// Error satisfies the builtin error interface
func (e Bootstrap_ApplicationLogConfig_LogFormatValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBootstrap_ApplicationLogConfig_LogFormat.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Bootstrap_ApplicationLogConfig_LogFormatValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Bootstrap_ApplicationLogConfig_LogFormatValidationError{}

// Validate checks the field values on ClusterManager_OutlierDetection with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ClusterManager_OutlierDetection) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ClusterManager_OutlierDetection with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// ClusterManager_OutlierDetectionMultiError, or nil if none found.
func (m *ClusterManager_OutlierDetection) ValidateAll() error {
	return m.validate(true)
}

func (m *ClusterManager_OutlierDetection) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for EventLogPath

	if all {
		switch v := interface{}(m.GetEventService()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ClusterManager_OutlierDetectionValidationError{
					field:  "EventService",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ClusterManager_OutlierDetectionValidationError{
					field:  "EventService",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetEventService()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterManager_OutlierDetectionValidationError{
				field:  "EventService",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return ClusterManager_OutlierDetectionMultiError(errors)
	}

	return nil
}

// ClusterManager_OutlierDetectionMultiError is an error wrapping multiple
// validation errors returned by ClusterManager_OutlierDetection.ValidateAll()
// if the designated constraints aren't met.
type ClusterManager_OutlierDetectionMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ClusterManager_OutlierDetectionMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ClusterManager_OutlierDetectionMultiError) AllErrors() []error { return m }

// ClusterManager_OutlierDetectionValidationError is the validation error
// returned by ClusterManager_OutlierDetection.Validate if the designated
// constraints aren't met.
type ClusterManager_OutlierDetectionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ClusterManager_OutlierDetectionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ClusterManager_OutlierDetectionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ClusterManager_OutlierDetectionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ClusterManager_OutlierDetectionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ClusterManager_OutlierDetectionValidationError) ErrorName() string {
	return "ClusterManager_OutlierDetectionValidationError"
}

// Error satisfies the builtin error interface
func (e ClusterManager_OutlierDetectionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sClusterManager_OutlierDetection.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ClusterManager_OutlierDetectionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ClusterManager_OutlierDetectionValidationError{}

// Validate checks the field values on Watchdog_WatchdogAction with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *Watchdog_WatchdogAction) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Watchdog_WatchdogAction with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// Watchdog_WatchdogActionMultiError, or nil if none found.
func (m *Watchdog_WatchdogAction) ValidateAll() error {
	return m.validate(true)
}

func (m *Watchdog_WatchdogAction) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, Watchdog_WatchdogActionValidationError{
					field:  "Config",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, Watchdog_WatchdogActionValidationError{
					field:  "Config",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Watchdog_WatchdogActionValidationError{
				field:  "Config",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if _, ok := Watchdog_WatchdogAction_WatchdogEvent_name[int32(m.GetEvent())]; !ok {
		err := Watchdog_WatchdogActionValidationError{
			field:  "Event",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return Watchdog_WatchdogActionMultiError(errors)
	}

	return nil
}

// Watchdog_WatchdogActionMultiError is an error wrapping multiple validation
// errors returned by Watchdog_WatchdogAction.ValidateAll() if the designated
// constraints aren't met.
type Watchdog_WatchdogActionMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Watchdog_WatchdogActionMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Watchdog_WatchdogActionMultiError) AllErrors() []error { return m }

// Watchdog_WatchdogActionValidationError is the validation error returned by
// Watchdog_WatchdogAction.Validate if the designated constraints aren't met.
type Watchdog_WatchdogActionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Watchdog_WatchdogActionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Watchdog_WatchdogActionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Watchdog_WatchdogActionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Watchdog_WatchdogActionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Watchdog_WatchdogActionValidationError) ErrorName() string {
	return "Watchdog_WatchdogActionValidationError"
}

// Error satisfies the builtin error interface
func (e Watchdog_WatchdogActionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sWatchdog_WatchdogAction.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Watchdog_WatchdogActionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Watchdog_WatchdogActionValidationError{}

// Validate checks the field values on RuntimeLayer_DiskLayer with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RuntimeLayer_DiskLayer) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RuntimeLayer_DiskLayer with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RuntimeLayer_DiskLayerMultiError, or nil if none found.
func (m *RuntimeLayer_DiskLayer) ValidateAll() error {
	return m.validate(true)
}

func (m *RuntimeLayer_DiskLayer) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for SymlinkRoot

	// no validation rules for Subdirectory

	// no validation rules for AppendServiceCluster

	if len(errors) > 0 {
		return RuntimeLayer_DiskLayerMultiError(errors)
	}

	return nil
}

// RuntimeLayer_DiskLayerMultiError is an error wrapping multiple validation
// errors returned by RuntimeLayer_DiskLayer.ValidateAll() if the designated
// constraints aren't met.
type RuntimeLayer_DiskLayerMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RuntimeLayer_DiskLayerMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RuntimeLayer_DiskLayerMultiError) AllErrors() []error { return m }

// RuntimeLayer_DiskLayerValidationError is the validation error returned by
// RuntimeLayer_DiskLayer.Validate if the designated constraints aren't met.
type RuntimeLayer_DiskLayerValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RuntimeLayer_DiskLayerValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RuntimeLayer_DiskLayerValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RuntimeLayer_DiskLayerValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RuntimeLayer_DiskLayerValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RuntimeLayer_DiskLayerValidationError) ErrorName() string {
	return "RuntimeLayer_DiskLayerValidationError"
}

// Error satisfies the builtin error interface
func (e RuntimeLayer_DiskLayerValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRuntimeLayer_DiskLayer.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RuntimeLayer_DiskLayerValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RuntimeLayer_DiskLayerValidationError{}

// Validate checks the field values on RuntimeLayer_AdminLayer with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RuntimeLayer_AdminLayer) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RuntimeLayer_AdminLayer with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RuntimeLayer_AdminLayerMultiError, or nil if none found.
func (m *RuntimeLayer_AdminLayer) ValidateAll() error {
	return m.validate(true)
}

func (m *RuntimeLayer_AdminLayer) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return RuntimeLayer_AdminLayerMultiError(errors)
	}

	return nil
}

// RuntimeLayer_AdminLayerMultiError is an error wrapping multiple validation
// errors returned by RuntimeLayer_AdminLayer.ValidateAll() if the designated
// constraints aren't met.
type RuntimeLayer_AdminLayerMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RuntimeLayer_AdminLayerMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RuntimeLayer_AdminLayerMultiError) AllErrors() []error { return m }

// RuntimeLayer_AdminLayerValidationError is the validation error returned by
// RuntimeLayer_AdminLayer.Validate if the designated constraints aren't met.
type RuntimeLayer_AdminLayerValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RuntimeLayer_AdminLayerValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RuntimeLayer_AdminLayerValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RuntimeLayer_AdminLayerValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RuntimeLayer_AdminLayerValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RuntimeLayer_AdminLayerValidationError) ErrorName() string {
	return "RuntimeLayer_AdminLayerValidationError"
}

// Error satisfies the builtin error interface
func (e RuntimeLayer_AdminLayerValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRuntimeLayer_AdminLayer.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RuntimeLayer_AdminLayerValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RuntimeLayer_AdminLayerValidationError{}

// Validate checks the field values on RuntimeLayer_RtdsLayer with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RuntimeLayer_RtdsLayer) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RuntimeLayer_RtdsLayer with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RuntimeLayer_RtdsLayerMultiError, or nil if none found.
func (m *RuntimeLayer_RtdsLayer) ValidateAll() error {
	return m.validate(true)
}

func (m *RuntimeLayer_RtdsLayer) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Name

	if all {
		switch v := interface{}(m.GetRtdsConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RuntimeLayer_RtdsLayerValidationError{
					field:  "RtdsConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RuntimeLayer_RtdsLayerValidationError{
					field:  "RtdsConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRtdsConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RuntimeLayer_RtdsLayerValidationError{
				field:  "RtdsConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return RuntimeLayer_RtdsLayerMultiError(errors)
	}

	return nil
}

// RuntimeLayer_RtdsLayerMultiError is an error wrapping multiple validation
// errors returned by RuntimeLayer_RtdsLayer.ValidateAll() if the designated
// constraints aren't met.
type RuntimeLayer_RtdsLayerMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RuntimeLayer_RtdsLayerMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RuntimeLayer_RtdsLayerMultiError) AllErrors() []error { return m }

// RuntimeLayer_RtdsLayerValidationError is the validation error returned by
// RuntimeLayer_RtdsLayer.Validate if the designated constraints aren't met.
type RuntimeLayer_RtdsLayerValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RuntimeLayer_RtdsLayerValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RuntimeLayer_RtdsLayerValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RuntimeLayer_RtdsLayerValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RuntimeLayer_RtdsLayerValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RuntimeLayer_RtdsLayerValidationError) ErrorName() string {
	return "RuntimeLayer_RtdsLayerValidationError"
}

// Error satisfies the builtin error interface
func (e RuntimeLayer_RtdsLayerValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRuntimeLayer_RtdsLayer.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RuntimeLayer_RtdsLayerValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RuntimeLayer_RtdsLayerValidationError{}
