// Copyright 2018, OpenCensus Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.17.3
// source: opencensus/proto/agent/common/v1/common.proto

// NOTE: This proto is experimental and is subject to change at this point.
// Please do not use it at the moment.

package v1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type LibraryInfo_Language int32

const (
	LibraryInfo_LANGUAGE_UNSPECIFIED LibraryInfo_Language = 0
	LibraryInfo_CPP                  LibraryInfo_Language = 1
	LibraryInfo_C_SHARP              LibraryInfo_Language = 2
	LibraryInfo_ERLANG               LibraryInfo_Language = 3
	LibraryInfo_GO_LANG              LibraryInfo_Language = 4
	LibraryInfo_JAVA                 LibraryInfo_Language = 5
	LibraryInfo_NODE_JS              LibraryInfo_Language = 6
	LibraryInfo_PHP                  LibraryInfo_Language = 7
	LibraryInfo_PYTHON               LibraryInfo_Language = 8
	LibraryInfo_RUBY                 LibraryInfo_Language = 9
	LibraryInfo_WEB_JS               LibraryInfo_Language = 10
)

// Enum value maps for LibraryInfo_Language.
var (
	LibraryInfo_Language_name = map[int32]string{
		0:  "LANGUAGE_UNSPECIFIED",
		1:  "CPP",
		2:  "C_SHARP",
		3:  "ERLANG",
		4:  "GO_LANG",
		5:  "JAVA",
		6:  "NODE_JS",
		7:  "PHP",
		8:  "PYTHON",
		9:  "RUBY",
		10: "WEB_JS",
	}
	LibraryInfo_Language_value = map[string]int32{
		"LANGUAGE_UNSPECIFIED": 0,
		"CPP":                  1,
		"C_SHARP":              2,
		"ERLANG":               3,
		"GO_LANG":              4,
		"JAVA":                 5,
		"NODE_JS":              6,
		"PHP":                  7,
		"PYTHON":               8,
		"RUBY":                 9,
		"WEB_JS":               10,
	}
)

func (x LibraryInfo_Language) Enum() *LibraryInfo_Language {
	p := new(LibraryInfo_Language)
	*p = x
	return p
}

func (x LibraryInfo_Language) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LibraryInfo_Language) Descriptor() protoreflect.EnumDescriptor {
	return file_opencensus_proto_agent_common_v1_common_proto_enumTypes[0].Descriptor()
}

func (LibraryInfo_Language) Type() protoreflect.EnumType {
	return &file_opencensus_proto_agent_common_v1_common_proto_enumTypes[0]
}

func (x LibraryInfo_Language) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LibraryInfo_Language.Descriptor instead.
func (LibraryInfo_Language) EnumDescriptor() ([]byte, []int) {
	return file_opencensus_proto_agent_common_v1_common_proto_rawDescGZIP(), []int{2, 0}
}

// Identifier metadata of the Node that produces the span or tracing data.
// Note, this is not the metadata about the Node or service that is described by associated spans.
// In the future we plan to extend the identifier proto definition to support
// additional information (e.g cloud id, etc.)
type Node struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier that uniquely identifies a process within a VM/container.
	Identifier *ProcessIdentifier `protobuf:"bytes,1,opt,name=identifier,proto3" json:"identifier,omitempty"`
	// Information on the OpenCensus Library that initiates the stream.
	LibraryInfo *LibraryInfo `protobuf:"bytes,2,opt,name=library_info,json=libraryInfo,proto3" json:"library_info,omitempty"`
	// Additional information on service.
	ServiceInfo *ServiceInfo `protobuf:"bytes,3,opt,name=service_info,json=serviceInfo,proto3" json:"service_info,omitempty"`
	// Additional attributes.
	Attributes map[string]string `protobuf:"bytes,4,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Node) Reset() {
	*x = Node{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_agent_common_v1_common_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Node) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Node) ProtoMessage() {}

func (x *Node) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_agent_common_v1_common_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Node.ProtoReflect.Descriptor instead.
func (*Node) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_agent_common_v1_common_proto_rawDescGZIP(), []int{0}
}

func (x *Node) GetIdentifier() *ProcessIdentifier {
	if x != nil {
		return x.Identifier
	}
	return nil
}

func (x *Node) GetLibraryInfo() *LibraryInfo {
	if x != nil {
		return x.LibraryInfo
	}
	return nil
}

func (x *Node) GetServiceInfo() *ServiceInfo {
	if x != nil {
		return x.ServiceInfo
	}
	return nil
}

func (x *Node) GetAttributes() map[string]string {
	if x != nil {
		return x.Attributes
	}
	return nil
}

// Identifier that uniquely identifies a process within a VM/container.
type ProcessIdentifier struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The host name. Usually refers to the machine/container name.
	// For example: os.Hostname() in Go, socket.gethostname() in Python.
	HostName string `protobuf:"bytes,1,opt,name=host_name,json=hostName,proto3" json:"host_name,omitempty"`
	// Process id.
	Pid uint32 `protobuf:"varint,2,opt,name=pid,proto3" json:"pid,omitempty"`
	// Start time of this ProcessIdentifier. Represented in epoch time.
	StartTimestamp *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=start_timestamp,json=startTimestamp,proto3" json:"start_timestamp,omitempty"`
}

func (x *ProcessIdentifier) Reset() {
	*x = ProcessIdentifier{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_agent_common_v1_common_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProcessIdentifier) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessIdentifier) ProtoMessage() {}

func (x *ProcessIdentifier) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_agent_common_v1_common_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessIdentifier.ProtoReflect.Descriptor instead.
func (*ProcessIdentifier) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_agent_common_v1_common_proto_rawDescGZIP(), []int{1}
}

func (x *ProcessIdentifier) GetHostName() string {
	if x != nil {
		return x.HostName
	}
	return ""
}

func (x *ProcessIdentifier) GetPid() uint32 {
	if x != nil {
		return x.Pid
	}
	return 0
}

func (x *ProcessIdentifier) GetStartTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTimestamp
	}
	return nil
}

// Information on OpenCensus Library.
type LibraryInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Language of OpenCensus Library.
	Language LibraryInfo_Language `protobuf:"varint,1,opt,name=language,proto3,enum=opencensus.proto.agent.common.v1.LibraryInfo_Language" json:"language,omitempty"`
	// Version of Agent exporter of Library.
	ExporterVersion string `protobuf:"bytes,2,opt,name=exporter_version,json=exporterVersion,proto3" json:"exporter_version,omitempty"`
	// Version of OpenCensus Library.
	CoreLibraryVersion string `protobuf:"bytes,3,opt,name=core_library_version,json=coreLibraryVersion,proto3" json:"core_library_version,omitempty"`
}

func (x *LibraryInfo) Reset() {
	*x = LibraryInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_agent_common_v1_common_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LibraryInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LibraryInfo) ProtoMessage() {}

func (x *LibraryInfo) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_agent_common_v1_common_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LibraryInfo.ProtoReflect.Descriptor instead.
func (*LibraryInfo) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_agent_common_v1_common_proto_rawDescGZIP(), []int{2}
}

func (x *LibraryInfo) GetLanguage() LibraryInfo_Language {
	if x != nil {
		return x.Language
	}
	return LibraryInfo_LANGUAGE_UNSPECIFIED
}

func (x *LibraryInfo) GetExporterVersion() string {
	if x != nil {
		return x.ExporterVersion
	}
	return ""
}

func (x *LibraryInfo) GetCoreLibraryVersion() string {
	if x != nil {
		return x.CoreLibraryVersion
	}
	return ""
}

// Additional service information.
type ServiceInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the service.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ServiceInfo) Reset() {
	*x = ServiceInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_agent_common_v1_common_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceInfo) ProtoMessage() {}

func (x *ServiceInfo) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_agent_common_v1_common_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceInfo.ProtoReflect.Descriptor instead.
func (*ServiceInfo) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_agent_common_v1_common_proto_rawDescGZIP(), []int{3}
}

func (x *ServiceInfo) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_opencensus_proto_agent_common_v1_common_proto protoreflect.FileDescriptor

var file_opencensus_proto_agent_common_v1_common_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f,
	0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x20, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x96, 0x03, 0x0a, 0x04, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x53, 0x0a, 0x0a, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x69, 0x65, 0x72, 0x52, 0x0a, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x12, 0x50, 0x0a, 0x0c, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x5f, 0x69, 0x6e, 0x66, 0x6f,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e,
	0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72,
	0x79, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0b, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x50, 0x0a, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63,
	0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x56, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63,
	0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65,
	0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x1a, 0x3d, 0x0a, 0x0f,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x87, 0x01, 0x0a, 0x11,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65,
	0x72, 0x12, 0x1b, 0x0a, 0x09, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x10,
	0x0a, 0x03, 0x70, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x03, 0x70, 0x69, 0x64,
	0x12, 0x43, 0x0a, 0x0f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x22, 0xd6, 0x02, 0x0a, 0x0b, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72,
	0x79, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x52, 0x0a, 0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65,
	0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61,
	0x72, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x52,
	0x08, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x65, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x72, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x0a, 0x14, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x6c, 0x69, 0x62,
	0x72, 0x61, 0x72, 0x79, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x12, 0x63, 0x6f, 0x72, 0x65, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x95, 0x01, 0x0a, 0x08, 0x4c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x12, 0x18, 0x0a, 0x14, 0x4c, 0x41, 0x4e, 0x47, 0x55, 0x41, 0x47, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a,
	0x03, 0x43, 0x50, 0x50, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x5f, 0x53, 0x48, 0x41, 0x52,
	0x50, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x45, 0x52, 0x4c, 0x41, 0x4e, 0x47, 0x10, 0x03, 0x12,
	0x0b, 0x0a, 0x07, 0x47, 0x4f, 0x5f, 0x4c, 0x41, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x08, 0x0a, 0x04,
	0x4a, 0x41, 0x56, 0x41, 0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07, 0x4e, 0x4f, 0x44, 0x45, 0x5f, 0x4a,
	0x53, 0x10, 0x06, 0x12, 0x07, 0x0a, 0x03, 0x50, 0x48, 0x50, 0x10, 0x07, 0x12, 0x0a, 0x0a, 0x06,
	0x50, 0x59, 0x54, 0x48, 0x4f, 0x4e, 0x10, 0x08, 0x12, 0x08, 0x0a, 0x04, 0x52, 0x55, 0x42, 0x59,
	0x10, 0x09, 0x12, 0x0a, 0x0a, 0x06, 0x57, 0x45, 0x42, 0x5f, 0x4a, 0x53, 0x10, 0x0a, 0x22, 0x21,
	0x0a, 0x0b, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x42, 0xa6, 0x01, 0x0a, 0x23, 0x69, 0x6f, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e,
	0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x42, 0x0b, 0x43, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x49, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2d, 0x69, 0x6e, 0x73, 0x74,
	0x72, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x6f, 0x70, 0x65, 0x6e,
	0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2d, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x65, 0x6e,
	0x2d, 0x67, 0x6f, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2f, 0x76, 0x31, 0xea, 0x02, 0x24, 0x4f, 0x70, 0x65, 0x6e, 0x43, 0x65, 0x6e, 0x73, 0x75, 0x73,
	0x3a, 0x3a, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x3a, 0x3a, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x3a, 0x3a,
	0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_opencensus_proto_agent_common_v1_common_proto_rawDescOnce sync.Once
	file_opencensus_proto_agent_common_v1_common_proto_rawDescData = file_opencensus_proto_agent_common_v1_common_proto_rawDesc
)

func file_opencensus_proto_agent_common_v1_common_proto_rawDescGZIP() []byte {
	file_opencensus_proto_agent_common_v1_common_proto_rawDescOnce.Do(func() {
		file_opencensus_proto_agent_common_v1_common_proto_rawDescData = protoimpl.X.CompressGZIP(file_opencensus_proto_agent_common_v1_common_proto_rawDescData)
	})
	return file_opencensus_proto_agent_common_v1_common_proto_rawDescData
}

var file_opencensus_proto_agent_common_v1_common_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_opencensus_proto_agent_common_v1_common_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_opencensus_proto_agent_common_v1_common_proto_goTypes = []interface{}{
	(LibraryInfo_Language)(0),     // 0: opencensus.proto.agent.common.v1.LibraryInfo.Language
	(*Node)(nil),                  // 1: opencensus.proto.agent.common.v1.Node
	(*ProcessIdentifier)(nil),     // 2: opencensus.proto.agent.common.v1.ProcessIdentifier
	(*LibraryInfo)(nil),           // 3: opencensus.proto.agent.common.v1.LibraryInfo
	(*ServiceInfo)(nil),           // 4: opencensus.proto.agent.common.v1.ServiceInfo
	nil,                           // 5: opencensus.proto.agent.common.v1.Node.AttributesEntry
	(*timestamppb.Timestamp)(nil), // 6: google.protobuf.Timestamp
}
var file_opencensus_proto_agent_common_v1_common_proto_depIdxs = []int32{
	2, // 0: opencensus.proto.agent.common.v1.Node.identifier:type_name -> opencensus.proto.agent.common.v1.ProcessIdentifier
	3, // 1: opencensus.proto.agent.common.v1.Node.library_info:type_name -> opencensus.proto.agent.common.v1.LibraryInfo
	4, // 2: opencensus.proto.agent.common.v1.Node.service_info:type_name -> opencensus.proto.agent.common.v1.ServiceInfo
	5, // 3: opencensus.proto.agent.common.v1.Node.attributes:type_name -> opencensus.proto.agent.common.v1.Node.AttributesEntry
	6, // 4: opencensus.proto.agent.common.v1.ProcessIdentifier.start_timestamp:type_name -> google.protobuf.Timestamp
	0, // 5: opencensus.proto.agent.common.v1.LibraryInfo.language:type_name -> opencensus.proto.agent.common.v1.LibraryInfo.Language
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_opencensus_proto_agent_common_v1_common_proto_init() }
func file_opencensus_proto_agent_common_v1_common_proto_init() {
	if File_opencensus_proto_agent_common_v1_common_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_opencensus_proto_agent_common_v1_common_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Node); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opencensus_proto_agent_common_v1_common_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProcessIdentifier); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opencensus_proto_agent_common_v1_common_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LibraryInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opencensus_proto_agent_common_v1_common_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_opencensus_proto_agent_common_v1_common_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_opencensus_proto_agent_common_v1_common_proto_goTypes,
		DependencyIndexes: file_opencensus_proto_agent_common_v1_common_proto_depIdxs,
		EnumInfos:         file_opencensus_proto_agent_common_v1_common_proto_enumTypes,
		MessageInfos:      file_opencensus_proto_agent_common_v1_common_proto_msgTypes,
	}.Build()
	File_opencensus_proto_agent_common_v1_common_proto = out.File
	file_opencensus_proto_agent_common_v1_common_proto_rawDesc = nil
	file_opencensus_proto_agent_common_v1_common_proto_goTypes = nil
	file_opencensus_proto_agent_common_v1_common_proto_depIdxs = nil
}
