/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui;

import java.util.EventObject;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.internal.p2.ui.ProvisioningOperationRunner;
import org.eclipse.equinox.internal.p2.ui.RepositoryOperationBeginningEvent;
import org.eclipse.equinox.internal.p2.ui.RepositoryOperationEndingEvent;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.SynchronousProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.repository.RepositoryEvent;
import org.eclipse.equinox.p2.engine.IProfileEvent;

public abstract class ProvUIProvisioningListener
implements SynchronousProvisioningListener {
    public static final int PROV_EVENT_METADATA_REPOSITORY = 1;
    public static final int PROV_EVENT_IU = 2;
    public static final int PROV_EVENT_PROFILE = 4;
    public static final int PROV_EVENT_ARTIFACT_REPOSITORY = 8;
    int eventTypes = 0;
    String name;
    private final ProvisioningOperationRunner runner;

    public ProvUIProvisioningListener(String name, int eventTypes, ProvisioningOperationRunner runner) {
        this.name = name;
        this.eventTypes = eventTypes;
        this.runner = runner;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void notify(EventObject o) {
        if (o instanceof RepositoryOperationBeginningEvent) {
            if (!Tracing.DEBUG_EVENTS_CLIENT) return;
            Tracing.debug((String)("Batch Eventing:  Ignore Following Events. " + this.getReceiverString()));
            return;
        }
        if (o instanceof RepositoryOperationEndingEvent) {
            RepositoryOperationEndingEvent event = (RepositoryOperationEndingEvent)o;
            if (Tracing.DEBUG_EVENTS_CLIENT) {
                Tracing.debug((String)("Batch Eventing:  Batch Ended. " + this.getReceiverString()));
            }
            if (this.runner.eventBatchCount > 0) {
                RepositoryEvent innerEvent = event.getEvent();
                if (innerEvent == null) return;
                this.handleRepositoryEvent(innerEvent);
                return;
            }
            if (Tracing.DEBUG_EVENTS_CLIENT) {
                Tracing.debug((String)("Batch Eventing Complete." + this.getReceiverString()));
            }
            if (event.getEvent() == null && event.update()) {
                if (Tracing.DEBUG_EVENTS_CLIENT) {
                    Tracing.debug((String)("Refreshing After Batch." + this.getReceiverString()));
                }
                this.refreshAll();
                return;
            }
            if (!event.update()) {
                if (!Tracing.DEBUG_EVENTS_CLIENT) return;
                Tracing.debug((String)"No Refresh on Batch Complete.");
                return;
            }
            if (Tracing.DEBUG_EVENTS_CLIENT) {
                Tracing.debug((String)("Dispatching Last Event in Batch." + this.getReceiverString()));
            }
            this.notify((EventObject)event.getEvent());
            return;
        }
        if (this.runner.eventBatchCount > 0) {
            if (!Tracing.DEBUG_EVENTS_CLIENT) return;
            Tracing.debug((String)(this.name + " Ignoring: " + o.toString()));
            return;
        }
        if (o instanceof IProfileEvent) {
            IProfileEvent event = (IProfileEvent)o;
            if ((this.eventTypes & 2) == 2 || (this.eventTypes & 4) == 4) {
                if (Tracing.DEBUG_EVENTS_CLIENT) {
                    Tracing.debug((String)(o.toString() + this.getReceiverString()));
                }
                if (event.getReason() == 2) {
                    this.profileChanged(event.getProfileId());
                    return;
                }
                if (event.getReason() == 0) {
                    this.profileAdded(event.getProfileId());
                    return;
                }
                if (event.getReason() != 1) return;
                this.profileRemoved(event.getProfileId());
                return;
            }
        }
        if (!(o instanceof RepositoryEvent)) return;
        if (Tracing.DEBUG_EVENTS_CLIENT) {
            Tracing.debug((String)(o.toString() + this.getReceiverString()));
        }
        this.handleRepositoryEvent((RepositoryEvent)o);
    }

    private String getReceiverString() {
        return " --  <" + this.name + "> ";
    }

    private void handleRepositoryEvent(RepositoryEvent event) {
        if (event.getRepositoryType() == 0 && (this.eventTypes & 1) == 1 || event.getRepositoryType() == 1 && (this.eventTypes & 8) == 8) {
            if (event.getKind() == 0 && event.isRepositoryEnabled()) {
                this.repositoryAdded(event);
            } else if (event.getKind() == 1 && event.isRepositoryEnabled()) {
                this.repositoryRemoved(event);
            } else if (event.getKind() == 4) {
                this.repositoryDiscovered(event);
            } else if (event.getKind() == 2) {
                this.repositoryChanged(event);
            } else if (event.getKind() == 8) {
                this.repositoryEnablement(event);
            }
        }
    }

    protected void repositoryAdded(RepositoryEvent event) {
    }

    protected void repositoryRemoved(RepositoryEvent event) {
    }

    protected void repositoryDiscovered(RepositoryEvent event) {
    }

    protected void repositoryChanged(RepositoryEvent event) {
    }

    protected void repositoryEnablement(RepositoryEvent event) {
        if (event.isRepositoryEnabled()) {
            this.repositoryAdded(event);
        } else {
            this.repositoryRemoved(event);
        }
    }

    protected void profileChanged(String profileId) {
    }

    protected void profileAdded(String profileId) {
    }

    protected void profileRemoved(String profileId) {
    }

    protected void refreshAll() {
    }

    public int getEventTypes() {
        return this.eventTypes;
    }
}

