###############################################################################
#
# Tests for XlsxWriter.
#
# SPDX-License-Identifier: BSD-2-Clause
#
# Copyright (c) 2013-2025, John McNamara, jmcnamara@cpan.org
#

from xlsxwriter.workbook import Workbook

from ..excel_comparison_test import ExcelComparisonTest


class TestCompareXLSXFiles(ExcelComparisonTest):
    """
    Test file created by XlsxWriter against a file created by Excel.

    """

    def setUp(self):

        self.set_filename("quote_name06.xlsx")

    def test_create_file(self):
        """Test the creation of a simple XlsxWriter file."""

        workbook = Workbook(self.got_filename)

        sheet_name = "Sheet-1"

        worksheet = workbook.add_worksheet(sheet_name)
        chart = workbook.add_chart({"type": "column"})

        chart.axis_ids = [62284544, 83429248]

        data = [
            [1, 2, 3, 4, 5],
            [2, 4, 6, 8, 10],
            [3, 6, 9, 12, 15],
        ]

        worksheet.write_column("A1", data[0])
        worksheet.write_column("B1", data[1])
        worksheet.write_column("C1", data[2])

        worksheet.repeat_rows(0, 1)
        worksheet.set_portrait()
        worksheet.vertical_dpi = 200

        chart.add_series({"values": [sheet_name, 0, 0, 4, 0]})
        chart.add_series({"values": [sheet_name, 0, 1, 4, 1]})
        chart.add_series({"values": [sheet_name, 0, 2, 4, 2]})

        worksheet.insert_chart("E9", chart)

        workbook.close()

        self.assertExcelEqual()
