/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* This file was automatically generated by getCTKnownLogs.py. */

#ifndef CTKnownLogs_h
#define CTKnownLogs_h

#include "CTLog.h"
#include "prtime.h"

#include <stddef.h>

static const PRTime kCTExpirationTime = INT64_C(1756120883000000);

namespace mozilla::ct {

enum class CTLogState {
  Admissible,  // Qualified, Usable, or ReadOnly
  Retired,
};

struct CTLogInfo {
  // See bug 1338873 about making these fields const.
  const char* name;
  CTLogState state;
  uint64_t timestamp;
  // Index within kCTLogOperatorList.
  size_t operatorIndex;
  const char* key;
  size_t keyLength;
};

struct CTLogOperatorInfo {
  // See bug 1338873 about making these fields const.
  const char* name;
  mozilla::ct::CTLogOperatorId id;
};

const CTLogInfo kCTLogList[] = {
    {"Google 'Argon2025h1' log", CTLogState::Admissible,
     1701000000000,  // 2023-11-26T12:00:00Z
     0,              // operated by Google
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x20\x82\xa1\xf9\x67\x68\xa8\xe4\xdb"
     "\x94\x98\xe2\xe1\x68\x87\xe4\x09\x6d\x20\x35\x33\x38\x3c\xaf\x14\xaa\xd7"
     "\x08\x18\xf0\xfd\x16\x9b\xd3\xff\x7c\x27\x82\xd4\x87\xb7\x4e\x24\x46\x3b"
     "\xfb\xae\xbe\xc8\x23\x52\x20\x2b\xaa\x44\x05\xfe\x54\xf9\xd5\xf1\x1d\x45"
     "\x9a",
     91},
    {"Google 'Argon2025h2' log", CTLogState::Admissible,
     1701000000000,  // 2023-11-26T12:00:00Z
     0,              // operated by Google
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xaf\xe4\xf3\x94\x2c\xdf\xa6\x27\xb5"
     "\xfe\xb2\x61\x83\x19\xc8\x21\x3a\x23\xa8\xa9\x3d\x54\xaf\xbc\x31\x9a\x1c"
     "\xd3\xc1\xe3\xb6\xc2\xf3\x0f\xc7\xb9\xca\x3b\x1d\x79\x65\x61\x22\x25\x82"
     "\x56\x4e\x98\xe8\xaa\x26\x29\x36\x1e\x28\x60\x6f\xeb\x15\x6e\xf7\x7c\xd0"
     "\xba",
     91},
    {"Google 'Argon2026h1' log", CTLogState::Admissible,
     1727734767000,  // 2024-09-30T22:19:27Z
     0,              // operated by Google
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x07\xfc\x1e\xe8\x63\x8e\xff\x1c\x31"
     "\x8a\xfc\xb8\x1e\x19\x2b\x60\x50\x00\x3e\x8e\x9e\xda\x77\x37\xe3\xa5\xa8"
     "\xda\x8d\x94\xf8\x6b\xe8\x3d\x64\x8f\x27\x3f\x75\xb3\xfc\x6b\x12\xf0\x37"
     "\x06\x4f\x64\x58\x75\x14\x5d\x56\x52\xe6\x6a\x2b\x14\x4c\xec\x81\xd1\xea"
     "\x3e",
     91},
    {"Google 'Argon2026h2' log", CTLogState::Admissible,
     1727734767000,  // 2024-09-30T22:19:27Z
     0,              // operated by Google
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x2a\x3a\x67\x8b\xfe\xba\x0c\x86\x2b"
     "\x4a\x51\x8a\xe9\x17\xfe\x7b\xa1\x76\x73\xfd\xbc\x65\x4b\xc3\x27\xbf\x4d"
     "\xf3\x5f\xa0\xca\x29\x80\x11\x20\x32\x78\xd6\x7e\xf9\x34\x60\x8c\x75\xa0"
     "\xf5\x35\x50\x9c\xa1\xd3\x49\x4d\x13\xd5\x3b\x6a\x0e\xea\x45\x9d\x24\x13"
     "\x22",
     91},
    {"Google 'Xenon2025h1' log", CTLogState::Admissible,
     1701000000000,  // 2023-11-26T12:00:00Z
     0,              // operated by Google
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x82\xe2\xce\x90\x40\x3f\x81\x0e\xdf"
     "\xea\xe1\x20\x2b\x5e\x2e\x30\x54\x46\x81\xb9\x58\xed\xaf\xbd\xff\x36\xa7"
     "\x9e\x0b\x5f\x6a\x6b\x91\xa5\xc1\x98\xe1\xf2\xcd\xeb\x17\x20\x70\xca\x2a"
     "\x12\xe6\x54\x78\x50\xdc\xff\x6d\xfd\x1c\xa7\xb6\x3a\x1f\xf9\x26\xa9\x1b"
     "\xbd",
     91},
    {"Google 'Xenon2025h2' log", CTLogState::Admissible,
     1701000000000,  // 2023-11-26T12:00:00Z
     0,              // operated by Google
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x6b\xe0\xaf\xed\x06\x7c\x3d\xef\xd9"
     "\x0e\xe4\x58\x4b\x04\xd8\x2a\x47\x99\x90\x89\x7a\xb9\x36\xa5\x75\xc8\x04"
     "\xb8\xcb\xe2\xaa\x2b\xb5\x68\x9d\x88\x29\xa2\xa5\xcf\xce\x2b\x9a\x15\x9b"
     "\xa0\x3e\x9d\x94\x1c\xb2\xb7\x4a\xf2\x51\xec\x40\xed\x62\x47\xa4\x03\x49"
     "\x86",
     91},
    {"Google 'Xenon2026h1' log", CTLogState::Admissible,
     1727734767000,  // 2024-09-30T22:19:27Z
     0,              // operated by Google
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x3a\x1f\xc8\xbb\xce\xd5\x90\x47\x34"
     "\xca\xca\x01\x04\x27\x21\x1c\xe2\x29\x3d\x92\xbb\x91\x45\xc7\x5a\x3e\xa5"
     "\xd4\xf2\x12\xe6\xe8\xe6\x43\xba\xf3\x7b\xc2\x38\xaf\xfc\x23\x8a\x05\x56"
     "\xeb\x03\x0a\x30\xcc\x63\x6c\xd9\x3c\xbe\xf5\x7b\x94\xba\x94\xd3\xbf\x88"
     "\x4c",
     91},
    {"Google 'Xenon2026h2' log", CTLogState::Admissible,
     1727734767000,  // 2024-09-30T22:19:27Z
     0,              // operated by Google
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xe5\x77\x78\x95\x71\x28\xb3\x95\xc9"
     "\xa5\xcc\x7a\x4c\xe8\x32\x03\x96\x7b\xfc\x2e\x1d\xb9\xa4\xdb\x43\xa0\xbd"
     "\x69\x72\xf9\x45\xba\x9a\xc3\xe9\x96\xd5\x70\xe7\x0d\x7e\xc9\x95\x15\x27"
     "\x8a\x72\x30\x65\x86\x43\x53\xdc\x11\x44\x18\x49\x98\x25\x68\xa7\x3c\x05"
     "\xbf",
     91},
    {"Cloudflare 'Nimbus2025'", CTLogState::Admissible,
     1702969200000,  // 2023-12-19T07:00:00Z
     1,              // operated by Cloudflare
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x1a\x80\x1a\x15\x19\x19\x23\x79\xb4"
     "\xfa\xa0\x79\x8e\x8d\xd5\xc1\xdc\xc2\xb5\x96\x92\x7e\x94\xe0\xc3\x7e\x14"
     "\x7c\x0a\x0d\x2d\x46\xa8\x9d\x1b\xb1\x41\x65\x0c\x5f\x98\xc4\x5a\x17\x79"
     "\x81\x5b\x4a\x14\x41\xec\xaf\xa9\x5d\x0e\xab\x12\x19\x71\xcd\x43\xef\xbb"
     "\x97",
     91},
    {"Cloudflare 'Nimbus2026'", CTLogState::Admissible,
     1731088800000,  // 2024-11-08T18:00:00Z
     1,              // operated by Cloudflare
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xd8\x5c\x61\x4f\xac\x6a\xd2\x20\x80"
     "\x4e\x8a\x42\xf6\x04\xad\x4b\xd4\xb1\x1c\x79\x8e\x29\x32\xde\x69\x53\x59"
     "\xeb\xad\x78\xf3\xc0\x2a\xf2\xd0\x11\x5d\x05\x7e\xeb\xe8\xc1\xd3\xdf\x37"
     "\xbf\x91\x64\x46\x6e\x0e\x27\x13\xea\xbb\x6f\x46\x27\x58\x86\xef\x40\x21"
     "\xa3",
     91},
    {"DigiCert Yeti2025 Log", CTLogState::Admissible,
     1667328840000,  // 2022-11-01T18:54:00Z
     2,              // operated by DigiCert
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xdf\x95\x00\x5e\x10\xc1\x01\xf7\x37"
     "\xe3\x10\x74\xd1\xff\xb2\xca\x90\xed\x32\x99\x5f\x0c\x39\xfe\xa1\xd1\x13"
     "\x11\xac\xd1\xb3\x73\x93\x20\xc2\x13\x3c\x4c\xb5\x7a\x52\x86\x86\x3d\xe3"
     "\x95\x24\x7c\xd8\x91\x98\x48\x3b\xf0\xf0\xdf\x21\xf1\xb0\x81\x5a\x59\x25"
     "\x43",
     91},
    {"DigiCert Nessie2025 Log", CTLogState::Retired,
     1744758000000,  // 2025-04-15T23:00:00Z
     2,              // operated by DigiCert
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xf2\xf0\xf0\xa7\x8b\x81\x2e\x09\x39"
     "\x3b\x9f\x42\xda\x38\x44\x5f\xb4\xcc\xed\x36\xbb\xd8\x43\x7f\x16\x49\x57"
     "\x87\x04\x7f\xa5\x01\x34\xf7\xe8\x68\x3f\xb7\x78\x1f\x60\x66\x2d\x67\x9a"
     "\x75\x80\xb7\x53\xa7\x85\xd5\xbc\xab\x47\x06\x55\xdb\xb5\xdf\x88\xa1\x6f"
     "\x38",
     91},
    {"DigiCert 'Wyvern2025h1' Log", CTLogState::Retired,
     1744670000000,  // 2025-04-14T22:33:20Z
     2,              // operated by DigiCert
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xa7\xcb\x80\x61\x86\x1b\x1f\xb5\xab"
     "\x2b\x20\x76\x59\x83\x66\x0e\xce\xae\xb8\x6f\x3b\x88\x02\xeb\x43\xf4\x87"
     "\x90\xcb\x8b\xda\xac\x0e\x19\x50\xe0\xf9\x24\x0e\xab\x26\x93\x8c\x3f\x9e"
     "\x0d\x96\x58\x44\x9d\x3b\x8a\x80\xc5\xc8\xbe\xe1\x89\x46\x6b\x48\x4c\xd6"
     "\x09",
     91},
    {"DigiCert 'Wyvern2025h2' Log", CTLogState::Admissible,
     1724900983000,  // 2024-08-29T03:09:43Z
     2,              // operated by DigiCert
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xe0\xdb\x41\xef\xe4\x04\xbd\xcb\x6b"
     "\x2e\x4c\xcc\xf1\x6c\xde\x41\x58\x7f\xfe\x94\xf6\x7a\xf6\x60\xed\x8b\x76"
     "\x72\xa3\xa2\x1c\x31\x13\x32\x35\xa1\xf2\x08\xd2\x68\xc5\x34\xa7\x56\x08"
     "\x1c\x63\xde\x95\xe2\x81\x69\x97\x8d\x1e\xa8\xb7\x66\x51\x25\x75\x4d\x78"
     "\x2e",
     91},
    {"DigiCert 'Wyvern2026h1'", CTLogState::Admissible,
     1731024000000,  // 2024-11-08T00:00:00Z
     2,              // operated by DigiCert
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xec\xbc\x34\x39\xe2\x9a\x8d\xb7\x99"
     "\x7a\x91\xf1\x05\x72\x52\xda\x93\x89\x5d\x3a\x07\x8b\x99\xed\x80\xa5\x16"
     "\xda\x73\x21\x20\xeb\x86\x96\x87\xc5\xc6\xd9\x17\xba\x6e\xb9\x4c\x13\x58"
     "\xd5\xd1\x83\xf8\x7a\xdf\x1e\x07\xbc\x15\xcd\xc0\x4a\xcd\x2a\x31\x71\x07"
     "\x55",
     91},
    {"DigiCert 'Wyvern2026h2'", CTLogState::Admissible,
     1731024000000,  // 2024-11-08T00:00:00Z
     2,              // operated by DigiCert
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x7a\x73\xdb\x4a\xf2\xde\x4f\xec\xe1"
     "\x14\x1b\xbe\xa6\xa9\x3c\x21\xb8\x45\x12\xcd\x7a\x88\x26\x91\x20\x56\xf5"
     "\x49\x32\xc3\x75\x6c\xcb\xe9\x7c\x13\x75\x35\x9c\x6c\xec\xf1\x31\x3c\xc1"
     "\xde\x9b\x8c\x13\x92\xb7\xad\x3d\x0f\xa1\x9c\x8f\x48\xce\x74\x27\x18\x23"
     "\x99",
     91},
    {"DigiCert 'Sphinx2025h1' Log", CTLogState::Retired,
     1744670000000,  // 2025-04-14T22:33:20Z
     2,              // operated by DigiCert
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xe3\x2f\x1f\x4d\x89\x05\x75\x29\x78"
     "\xbb\x22\x3d\x07\x62\x51\x14\x70\x94\xe7\x3c\xea\xf5\xee\xae\xa6\x48\x9a"
     "\x86\x52\x4e\x9e\x5c\xe3\x95\x97\x28\xbb\x52\x4b\x2a\xfd\xc8\xc9\x89\x4e"
     "\x45\x31\x17\xd3\x8d\xf2\xe7\xce\x18\x11\x58\x98\x2c\x60\x6f\x58\x20\x36"
     "\x6e",
     91},
    {"DigiCert 'Sphinx2025h2' Log", CTLogState::Admissible,
     1724900983000,  // 2024-08-29T03:09:43Z
     2,              // operated by DigiCert
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x41\x8c\x50\x13\x54\xb1\x19\x05\xb7"
     "\x7f\x4a\x20\x6e\xa3\x75\x63\xca\x34\xf4\xcc\x74\xea\x32\x3b\xb6\x8b\x03"
     "\x14\xa8\x52\x7f\x32\x87\x5e\x59\x9e\x0f\xab\x18\x9e\x29\x6c\xb5\x72\x77"
     "\x1a\x27\x54\x85\x5d\xc1\x7b\x24\xa8\x34\xe3\xcd\x88\xce\xd4\x50\x1b\xbe"
     "\x69",
     91},
    {"DigiCert 'Sphinx2026h1'", CTLogState::Admissible,
     1731024000000,  // 2024-11-08T00:00:00Z
     2,              // operated by DigiCert
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xab\x84\xbe\xf8\x3c\x87\xa2\x42\x25"
     "\x9a\x66\x9c\xae\x2b\x52\xe7\x5a\xf9\x21\x1b\x19\x03\xa5\x07\xe2\x46\x0b"
     "\x1f\x8a\x5e\x7c\x6c\xae\xff\x19\x77\x86\xe8\x7b\xfc\xee\x6b\x36\x4f\xf2"
     "\xbc\xc3\x9e\x05\x02\x9a\x08\x01\xb5\x49\x23\x35\xc4\xd3\x50\x2b\x51\xe9"
     "\xf4",
     91},
    {"DigiCert 'Sphinx2026h2'", CTLogState::Admissible,
     1731024000000,  // 2024-11-08T00:00:00Z
     2,              // operated by DigiCert
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xaa\xe0\xf4\x26\x44\x50\x4f\xfd\xa2"
     "\x9e\xe6\x80\xe0\x70\xb5\xb1\xce\x94\xa5\xf8\x97\x81\x44\x55\x42\x64\x1c"
     "\x22\x79\xa7\x64\x59\xd3\x89\x93\x21\x66\xfb\x09\x81\x60\x1f\x62\x55\x34"
     "\x38\x8c\xa4\x38\x2e\xac\x95\x0c\xeb\xed\x4f\x64\xbc\x45\x42\xf7\x06\x7a"
     "\xcd",
     91},
    {"Sectigo 'Sabre2025h1'", CTLogState::Admissible,
     1701000000000,  // 2023-11-26T12:00:00Z
     3,              // operated by Sectigo
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x7e\x2f\x39\xf1\xe8\x23\x8e\xb3\x32"
     "\x04\xaf\x4d\x57\xf6\xdb\xc5\x74\xa4\x7a\x6d\x3b\x07\x51\x0c\x5a\xfb\x80"
     "\x30\x05\xc6\x5a\x0c\xc4\x76\xd6\x06\xa8\x57\x4d\xfb\xdf\xe4\x82\x90\xc2"
     "\x41\xae\x70\xb3\x31\xa2\xe3\xfa\x3d\x5f\x2c\x5d\x04\xcd\xb4\x9d\x55\xab"
     "\x41",
     91},
    {"Sectigo 'Sabre2025h2'", CTLogState::Admissible,
     1701000000000,  // 2023-11-26T12:00:00Z
     3,              // operated by Sectigo
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x85\x13\x11\x2d\x7b\xf3\x93\x81\xe4"
     "\xb9\x7c\xd9\x64\x3b\xe7\xb5\x83\x99\x66\x79\x59\x47\x6a\x42\x5e\xd6\xbd"
     "\x63\x2e\xb7\x91\x4b\xae\xbc\x56\xc4\xc5\x6e\x09\xa0\xd7\x64\x1a\xc8\xc1"
     "\xaf\x89\x8b\xf5\x58\xd8\xba\xeb\x7b\x83\x52\xe9\xf4\xe0\xa5\xcd\xcd\x92"
     "\xcc",
     91},
    {"Sectigo 'Mammoth2025h1'", CTLogState::Admissible,
     1701000000000,  // 2023-11-26T12:00:00Z
     3,              // operated by Sectigo
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x13\x3c\x41\xb5\x30\x7d\x2e\x4a\xa1"
     "\xa8\x6b\xd2\xc5\x57\x6b\x98\xfe\x7e\xef\xd5\x21\xe2\xba\x5d\xb0\xba\x85"
     "\x11\x6e\x94\xe0\x3d\xa8\x8e\x6d\x56\x8d\x44\x02\x9e\xb0\x83\xcc\x54\xdf"
     "\x9b\x4e\x72\x62\x4b\x3c\x0c\x32\xdd\x86\xfb\xeb\x3e\x66\xcd\x77\x58\x5b"
     "\xe5",
     91},
    {"Sectigo 'Mammoth2025h2'", CTLogState::Admissible,
     1701000000000,  // 2023-11-26T12:00:00Z
     3,              // operated by Sectigo
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x88\xe2\xc7\xb3\xd7\x37\xa3\x91\xd7"
     "\xb3\xc5\xda\x07\x51\x04\x2b\x81\xed\xc2\x44\x3b\x75\xa0\xe6\x65\xe1\x4a"
     "\xba\x1b\xb1\x9c\xa9\x2a\x84\x31\x29\xae\x1d\x8b\xf1\x33\x9f\x12\x2e\x90"
     "\xb1\x15\x67\x66\xa0\x7c\x0b\x5b\x62\x7f\x6c\x9a\x6a\x30\x9b\x68\x02\x16"
     "\x6f",
     91},
    {"Sectigo 'Mammoth2026h1'", CTLogState::Admissible,
     1728925200000,  // 2024-10-14T17:00:00Z
     3,              // operated by Sectigo
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x9e\xcb\x0c\x8a\x51\xcc\x8a\xe2\x0b"
     "\xce\x85\xe6\xaf\x4d\x31\xdb\x1b\x6a\x4c\xfd\xb0\x79\x6b\x99\x97\xc0\x5d"
     "\xfb\x6e\x45\x50\x1d\x62\xaa\xc6\x9f\x9b\x6b\x05\x3d\xa2\xab\x2b\x5d\x88"
     "\x9b\x50\x28\xe2\x9e\x58\xa5\xa5\xfa\xf9\xe3\xfa\x15\x25\xe3\x14\x13\x32"
     "\xc4",
     91},
    {"Sectigo 'Mammoth2026h2'", CTLogState::Admissible,
     1728925200000,  // 2024-10-14T17:00:00Z
     3,              // operated by Sectigo
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xec\x83\x61\xf2\xd7\xb4\xbb\xe4\xe4"
     "\x3b\xeb\xc8\x63\x75\x98\xcf\x61\x90\x63\x14\x3d\x5f\x22\xdf\x74\xba\x50"
     "\xa7\x58\x9b\x69\x7d\xe6\x63\x89\x6d\xd9\xd7\x51\x84\x3f\xf8\x02\xd8\xc8"
     "\xff\xc2\x97\x71\xe5\x7e\x27\xf5\x72\xb1\x8f\x24\x27\x57\x0a\x0d\x74\xc0"
     "\xb6",
     91},
    {"Sectigo 'Sabre2026h1'", CTLogState::Admissible,
     1728925200000,  // 2024-10-14T17:00:00Z
     3,              // operated by Sectigo
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x84\x26\xbc\x36\xbd\xd8\x8d\x3c\x87"
     "\x9e\xe0\x10\xaf\xcd\x94\xd9\xd7\xb9\x51\x80\x34\x7e\xf7\x58\x5c\x73\xea"
     "\xeb\x09\x93\xb8\x10\x7b\x90\x9c\x7d\xc7\xcd\x96\x43\xed\x53\x6e\x95\x21"
     "\x46\x67\x51\xf0\xde\xb6\xc9\x9e\xaa\xe2\x80\x6d\xce\x25\x81\x34\xd7\x6a"
     "\x60",
     91},
    {"Sectigo 'Sabre2026h2'", CTLogState::Admissible,
     1728925200000,  // 2024-10-14T17:00:00Z
     3,              // operated by Sectigo
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xce\x35\xca\xec\x39\x07\x82\xda\x77"
     "\x27\x86\xe4\xf2\x7e\xc5\xdc\x38\xf2\x9b\xa9\xab\x8c\xa7\xc0\xed\x83\x1e"
     "\x3e\x6a\x1b\xc0\xf0\x95\x56\xba\x32\x33\x4c\x75\x7c\x09\x07\xe9\xe1\x3e"
     "\x65\x35\x63\xf0\x49\xbe\x72\xd1\xaa\x9d\xaf\x7d\x08\xc4\xb4\x8d\x59\x3d"
     "\x73",
     91},
    {"Sectigo 'Elephant2025h2'", CTLogState::Admissible,
     1747100000000,  // 2025-05-13T01:33:20Z
     3,              // operated by Sectigo
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xd0\xe9\x4b\x78\x65\xb6\xa9\x46\x46"
     "\x52\x84\x04\x47\x27\x70\xdc\x69\x5a\xc8\x43\xb7\x64\xad\xf8\xd7\xcc\xd3"
     "\x85\x8d\x6d\x0d\x8a\xfc\xe4\x04\xa6\x7b\xa6\x4e\x2f\xfd\x83\x5f\x23\x97"
     "\xc3\xc4\x42\xc1\x5b\x0a\x85\x16\xce\xa8\xc1\x0e\xc5\x6e\x10\xda\x9e\x0a"
     "\x42",
     91},
    {"Sectigo 'Elephant2026h1'", CTLogState::Admissible,
     1747100000000,  // 2025-05-13T01:33:20Z
     3,              // operated by Sectigo
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x53\x49\x6a\x9c\xf1\xe8\x5e\xe5\x3d"
     "\x15\xcf\x5d\x26\xfd\x47\x41\x90\xaf\xb2\xc2\x5f\xbf\x12\xec\x8a\xbc\x15"
     "\x43\xf7\xe4\x17\x25\x2a\x7a\xee\x22\x9f\x03\xca\x8a\x47\x93\xe0\x31\xb2"
     "\xc9\x65\x87\xe0\xd4\x7f\x0c\x22\x5a\xd9\xb0\x2e\x98\x7a\xd7\x25\xd0\x1c"
     "\x69",
     91},
    {"Sectigo 'Elephant2026h2'", CTLogState::Admissible,
     1747100000000,  // 2025-05-13T01:33:20Z
     3,              // operated by Sectigo
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x3b\xfb\x78\x53\x09\x28\xa2\xee\xfc"
     "\xce\x40\x9c\x86\x1f\x6d\x7c\x02\x9b\x21\x42\x66\x6c\xea\x14\x01\xbf\x2c"
     "\xcc\x3f\x12\xb6\x79\xc7\x14\xa0\x15\x63\x99\x2a\xd4\xb8\xec\xf1\x80\xfb"
     "\x09\xfc\xdd\x0f\xbc\x5c\x56\x39\x90\x62\x96\xed\x35\x48\x71\x44\xc4\x6d"
     "\x98",
     91},
    {"Sectigo 'Elephant2027h1'", CTLogState::Admissible,
     1747100000000,  // 2025-05-13T01:33:20Z
     3,              // operated by Sectigo
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xe1\xfb\xb7\xe8\x9c\xa0\x53\x06\x9a"
     "\x54\xef\x9d\x75\x62\x7d\xec\x52\x59\x94\x0e\x52\x8c\xf2\xe6\x4f\xe4\x47"
     "\xc2\x0d\x29\x6a\xf9\x08\xad\xb4\xf5\x6f\x92\xcd\x42\xbb\x1a\x13\x0d\x02"
     "\xa0\x6a\xda\x7f\xb0\x64\xcc\xa6\x5f\xec\xf0\xbc\x81\x80\x12\x73\x0d\xb0"
     "\xa0",
     91},
    {"Sectigo 'Elephant2027h2'", CTLogState::Admissible,
     1747100000000,  // 2025-05-13T01:33:20Z
     3,              // operated by Sectigo
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x09\x33\xe1\xa4\x99\xd1\x16\xba\x11"
     "\x46\x93\xff\xd4\x37\x40\x9e\xcf\x8f\xae\x79\x94\xcb\x0b\x6a\x21\x5f\x84"
     "\x78\xbe\x09\x83\xcc\xca\xa2\xea\x16\xee\x4b\x80\x91\x8a\x3e\x91\x97\xa8"
     "\x1e\xdc\x8a\xec\x20\x61\x7e\x52\x25\x32\x4e\xd3\xd9\x0a\xe7\xe3\x0f\xed"
     "\xf2",
     91},
    {"Let's Encrypt 'Oak2025h1'", CTLogState::Admissible,
     1701000000000,  // 2023-11-26T12:00:00Z
     4,              // operated by Let's Encrypt
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x29\xe0\x69\x53\xd7\xa3\x9c\x26\x88"
     "\x65\xe5\xf7\xf4\x4b\x1d\x17\x9b\xc3\xbd\xff\x04\x2d\x31\xdd\x2c\xfc\x62"
     "\x92\x5e\x32\xe0\x48\x91\x38\x84\x1f\x4b\x87\xab\x72\x99\xcc\x1d\xf8\x7c"
     "\xf9\x3c\x58\x54\x5b\x37\x10\xb1\xab\xd8\x83\xfb\x84\xf1\x95\x3f\x2e\x2f"
     "\x1c",
     91},
    {"Let's Encrypt 'Oak2025h2'", CTLogState::Admissible,
     1701000000000,  // 2023-11-26T12:00:00Z
     4,              // operated by Let's Encrypt
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xb5\x76\x30\x07\xad\xc6\xc8\xd2\xe4"
     "\x4b\xd2\xf5\xbe\xa2\x8d\x9c\xfd\x74\xfa\x3a\xd6\xfa\x59\x5d\xb6\x1c\x60"
     "\xd3\xdd\x1f\x63\x87\x86\xe3\x45\xe0\xd5\x1b\xc0\x35\x6a\xab\x27\x91\x95"
     "\xc9\xd7\x3d\xbb\xc1\xf7\x71\x86\x69\xf4\xb3\x5f\x90\x09\xaa\xae\xbd\x8d"
     "\xa9",
     91},
    {"Let's Encrypt 'Oak2026h1'", CTLogState::Admissible,
     1730678400000,  // 2024-11-04T00:00:00Z
     4,              // operated by Let's Encrypt
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x99\xd4\x61\x70\x22\xfa\x77\x93\x0d"
     "\xb3\xc7\x80\x96\x22\x51\xbf\x25\x79\xb1\x01\x42\xe9\x41\x7b\x8b\x0c\xc7"
     "\xb2\x65\x5a\x89\xf4\xfa\xe2\x02\x46\xd4\x8a\xc7\xcc\x10\x07\x11\x27\x45"
     "\x48\x90\x23\x40\xde\x7a\x4d\x89\x32\xfb\xd7\x0a\xeb\x5e\x8c\xa2\xf1\xf6"
     "\x49",
     91},
    {"Let's Encrypt 'Oak2026h2'", CTLogState::Admissible,
     1730678400000,  // 2024-11-04T00:00:00Z
     4,              // operated by Let's Encrypt
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x6a\x70\x9d\xb3\x96\xe3\xec\x85\x36"
     "\x95\xc3\x4f\x9c\x8b\xd9\x7c\xc9\xd5\x91\x29\xae\xeb\xd6\x87\xdc\x04\xbc"
     "\x3b\xf6\x34\x0f\xf6\xdb\x08\xf7\x52\xa9\x88\xef\xbb\x3f\x59\xd6\xd4\xf6"
     "\xf4\xfc\x5c\xa9\x8c\x5f\xfb\x0d\x60\xe4\x2c\x0f\x16\xec\x2a\xb2\x6d\xeb"
     "\x15",
     91},
    {"TrustAsia Log2025a", CTLogState::Admissible,
     1701000000000,  // 2023-11-26T12:00:00Z
     5,              // operated by TrustAsia
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x70\xe5\xb1\xa4\x09\x79\x2b\x9d\xf8"
     "\xa3\xa0\xdf\x18\xef\x95\x5d\x03\x6c\x7b\xa1\x91\xa9\xb8\x80\x7d\xec\x5c"
     "\x02\x08\xe2\x6e\x2f\x7c\x32\x70\xbd\x96\x84\x5f\xa6\x62\xe9\x65\xb5\x7c"
     "\x90\x58\xba\x22\xd5\xf9\xf5\x69\x54\xb7\xa8\x94\x4e\x32\x09\xae\x26\x11"
     "\x4d",
     91},
    {"TrustAsia Log2025b", CTLogState::Admissible,
     1701000000000,  // 2023-11-26T12:00:00Z
     5,              // operated by TrustAsia
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xaa\xa0\x8b\xdb\x67\x14\x5d\x97\x89"
     "\x1d\x08\x8d\x06\xd7\xc1\x94\x8e\xb0\xfa\x4c\x46\xd5\x53\x08\x78\x2b\x04"
     "\x53\x6c\xf3\xde\xb1\xd1\x53\x40\xda\x90\x57\xe6\x1a\x9e\x3c\xc7\x03\xb8"
     "\xbd\x2f\xa9\xcf\xe8\x7b\x5e\xe1\x4b\x60\xe5\x38\x43\x60\x97\xc1\x5b\x2f"
     "\x65",
     91},
    {"TrustAsia 'log2026a'", CTLogState::Admissible,
     1726790400000,  // 2024-09-20T00:00:00Z
     5,              // operated by TrustAsia
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xa7\x4e\x7a\xc9\xa6\x07\xf9\xff\x74"
     "\xec\x98\xcb\x49\xe1\x00\x24\xb3\x59\x2e\x83\xfd\xc0\x70\x35\x33\x4c\x63"
     "\xca\x74\x83\xc0\x3c\x5b\x53\x40\x7c\x31\x1f\x35\xa4\x5f\x0f\xe4\xee\x4f"
     "\x89\x17\xe8\x5b\x2e\xc5\xac\x00\x05\xc9\x76\x37\x45\x97\x03\x15\xff\x60"
     "\x59",
     91},
    {"TrustAsia 'log2026b'", CTLogState::Admissible,
     1726790400000,  // 2024-09-20T00:00:00Z
     5,              // operated by TrustAsia
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x0f\x12\x8c\xa9\xe6\xe3\xec\x62\xee"
     "\xdf\x58\xc8\x50\xe6\x26\x70\x76\x10\xb7\x04\x39\xb3\xa7\xf8\x4c\x73\x3b"
     "\xc3\x38\x5a\x12\x00\x4c\xe0\xda\x0e\x16\x8a\x45\x32\x0a\x31\xaa\x22\xc7"
     "\x9d\x7d\x05\x53\xc7\x9e\x94\xea\x9b\x57\x46\xbf\x4f\xa4\x7e\xfb\xdf\xfa"
     "\x85",
     91},
#ifdef DEBUG
    {"Mozilla Test RSA Log 1", CTLogState::Admissible,
     1721666666000,  // 2024-07-22T16:44:26Z
     6,              // operated by Mozilla Test Org 1
     "\x30\x82\x01\x22\x30\x0d\x06\x09\x2a\x86\x48\x86\xf7\x0d\x01\x01\x01\x05"
     "\x00\x03\x82\x01\x0f\x00\x30\x82\x01\x0a\x02\x82\x01\x01\x00\xba\x88\x51"
     "\xa8\x44\x8e\x16\xd6\x41\xfd\x6e\xb6\x88\x06\x36\x10\x3d\x3c\x13\xd9\xea"
     "\xe4\x35\x4a\xb4\xec\xf5\x68\x57\x6c\x24\x7b\xc1\xc7\x25\xa8\xe0\xd8\x1f"
     "\xbd\xb1\x9c\x06\x9b\x6e\x1a\x86\xf2\x6b\xe2\xaf\x5a\x75\x6b\x6a\x64\x71"
     "\x08\x7a\xa5\x5a\xa7\x45\x87\xf7\x1c\xd5\x24\x9c\x02\x7e\xcd\x43\xfc\x1e"
     "\x69\xd0\x38\x20\x29\x93\xab\x20\xc3\x49\xe4\xdb\xb9\x4c\xc2\x6b\x6c\x0e"
     "\xed\x15\x82\x0f\xf1\x7e\xad\x69\x1a\xb1\xd3\x02\x3a\x8b\x2a\x41\xee\xa7"
     "\x70\xe0\x0f\x0d\x8d\xfd\x66\x0b\x2b\xb0\x24\x92\xa4\x7d\xb9\x88\x61\x79"
     "\x90\xb1\x57\x90\x3d\xd2\x3b\xc5\xe0\xb8\x48\x1f\xa8\x37\xd3\x88\x43\xef"
     "\x27\x16\xd8\x55\xb7\x66\x5a\xaa\x7e\x02\x90\x2f\x3a\x7b\x10\x80\x06\x24"
     "\xcc\x1c\x6c\x97\xad\x96\x61\x5b\xb7\xe2\x96\x12\xc0\x75\x31\xa3\x0c\x91"
     "\xdd\xb4\xca\xf7\xfc\xad\x1d\x25\xd3\x09\xef\xb9\x17\x0e\xa7\x68\xe1\xb3"
     "\x7b\x2f\x22\x6f\x69\xe3\xb4\x8a\x95\x61\x1d\xee\x26\xd6\x25\x9d\xab\x91"
     "\x08\x4e\x36\xcb\x1c\x24\x04\x2c\xbf\x16\x8b\x2f\xe5\xf1\x8f\x99\x17\x31"
     "\xb8\xb3\xfe\x49\x23\xfa\x72\x51\xc4\x31\xd5\x03\xac\xda\x18\x0a\x35\xed"
     "\x8d\x02\x03\x01\x00\x01",
     294},
#endif  // DEBUG
#ifdef DEBUG
    {"Mozilla Test EC Log", CTLogState::Admissible,
     1721666666000,  // 2024-07-22T16:44:26Z
     6,              // operated by Mozilla Test Org 1
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x4f\xbf\xbb\xbb\x61\xe0\xf8\xf9\xb1"
     "\xa6\x0a\x59\xac\x87\x04\xe2\xec\x05\x0b\x42\x3e\x3c\xf7\x2e\x92\x3f\x2c"
     "\x4f\x79\x4b\x45\x5c\x2a\x69\xd2\x33\x45\x6c\x36\xc4\x11\x9d\x07\x06\xe0"
     "\x0e\xed\xc8\xd1\x93\x90\xd7\x99\x1b\x7b\x2d\x07\xa3\x04\xea\xa0\x4a\xa6"
     "\xc0",
     91},
#endif  // DEBUG
#ifdef DEBUG
    {"Mozilla Test RSA Log 2", CTLogState::Admissible,
     1721666666000,  // 2024-07-22T16:44:26Z
     7,              // operated by Mozilla Test Org 2
     "\x30\x82\x01\x22\x30\x0d\x06\x09\x2a\x86\x48\x86\xf7\x0d\x01\x01\x01\x05"
     "\x00\x03\x82\x01\x0f\x00\x30\x82\x01\x0a\x02\x82\x01\x01\x00\xc1\x75\xc6"
     "\x52\x66\x09\x9f\x77\x08\x2a\x67\x91\xf1\xb8\x76\xc3\x7f\x5c\xe5\x38\xb0"
     "\x6c\x4a\xcd\x22\xb1\xcb\xd4\x6f\xa6\x5a\xda\x2a\xdd\x41\xc8\xc2\x49\x8a"
     "\xc4\xa3\xb3\xc1\xf6\x14\x87\xf4\x1b\x69\x89\x41\xbd\x80\xa5\x1c\x3c\x12"
     "\x02\x44\xc5\x84\xa4\xc4\x48\x33\x05\xe5\x13\x8c\x01\x06\xcf\x08\xbe\x9a"
     "\x86\x27\x60\xba\xe6\xa2\xe8\xf3\x6f\x23\xc5\xd9\x83\x13\xb9\xdf\xaf\x37"
     "\x83\x45\xda\xce\x51\xd4\xd6\xdc\xd2\xa6\xcb\x3c\xc7\x06\xeb\xcd\x30\x70"
     "\xec\x98\xcc\xe4\x0a\xa5\x91\xd7\x29\x5a\x7f\x71\xc5\xbe\x66\x69\x1d\x2b"
     "\x2d\xfe\xc8\x49\x44\x59\x0b\xc5\xa3\xea\x49\xfd\x93\xb1\xd7\x53\x40\x5f"
     "\x17\x73\x76\x99\x95\x86\x66\x25\x47\x97\xed\x42\x69\x08\x88\x08\x11\x42"
     "\x20\x69\x98\x8a\x43\xfe\xe4\x8c\xe6\x87\x81\xdd\x22\xb6\xa6\x9c\xd2\x83"
     "\x75\x13\x1f\x93\x2b\x12\x8c\xe2\x86\xfa\x7d\x25\x1c\x06\x2a\xd2\x7e\xf0"
     "\x16\xf1\x87\xcd\xd5\x4e\x83\x2b\x35\xb8\x93\x0f\x74\xba\x90\xaa\x8b\xc7"
     "\x61\x67\x24\x2a\xb1\xfd\x6d\x62\x14\x0d\x18\xc4\xc0\xb8\xc6\x8f\xc3\x74"
     "\x84\x57\x32\x4a\xd7\xde\x86\xe6\x55\x2f\x1d\x1e\x19\x1d\x71\x21\x68\xd3"
     "\xbb\x02\x03\x01\x00\x01",
     294},
#endif  // DEBUG
};

const CTLogOperatorInfo kCTLogOperatorList[] = {
    {"Google", 0},
    {"Cloudflare", 1},
    {"DigiCert", 2},
    {"Sectigo", 3},
    {"Let's Encrypt", 4},
    {"TrustAsia", 5},
#ifdef DEBUG
    {"Mozilla Test Org 1", 6},
#endif  // DEBUG
#ifdef DEBUG
    {"Mozilla Test Org 2", 7},
#endif  // DEBUG
};

}  // namespace mozilla::ct

#endif  // CTKnownLogs_h
