# generated by datamodel-codegen:
#   filename:  rekord_schema.json
#   version:   0.26.3

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import BaseModel, ConfigDict, Field, RootModel, StrictStr


class Format(str, Enum):
    """Specifies the format of the signature"""

    PGP = "pgp"
    MINISIGN = "minisign"
    X509 = "x509"
    SSH = "ssh"


class PublicKey(BaseModel):
    """The public key that can verify the signature"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: str = Field(
        ...,
        description="Specifies the content of the public key inline within the document",
    )


class Signature(BaseModel):
    """Information about the detached signature associated with the entry"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    format: Format = Field(..., description="Specifies the format of the signature")
    content: str = Field(
        ...,
        description="Specifies the content of the signature inline within the document",
    )
    public_key: PublicKey = Field(
        ...,
        alias="publicKey",
        description="The public key that can verify the signature",
    )


class Algorithm(str, Enum):
    """The hashing function used to compute the hash value"""

    SHA256 = "sha256"


class Hash(BaseModel):
    """Specifies the hash algorithm and value for the content"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    algorithm: Algorithm = Field(
        ...,
        description="The hashing function used to compute the hash value",
    )
    value: StrictStr = Field(..., description="The hash value for the content")


class Data(BaseModel):
    """Information about the content associated with the entry"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    hash: Hash = Field(..., description="Specifies the hash algorithm and value for the content")
    content: Optional[str] = Field(
        default=None,
        description="Specifies the content inline within the document",
    )


class Hash1(Hash):
    """Specifies the hash algorithm and value for the content"""


class Data1(BaseModel):
    """Information about the content associated with the entry"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    hash: Optional[Hash1] = Field(
        default=None,
        description="Specifies the hash algorithm and value for the content",
    )
    content: str = Field(..., description="Specifies the content inline within the document")


class RekordV001Schema(BaseModel):
    """Schema for Rekord object"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    signature: Signature = Field(
        ...,
        description="Information about the detached signature associated with the entry",
    )
    data: Union[Data, Data1] = Field(
        ...,
        description="Information about the content associated with the entry",
    )


class RekorSchema(RootModel[RekordV001Schema]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: RekordV001Schema = Field(
        ...,
        description="Schema for Rekord objects",
        title="Rekor Schema",
    )
