# generated by datamodel-codegen:
#   filename:  hashedrekord_schema.json
#   version:   0.26.3

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, ConfigDict, Field, RootModel, StrictStr


class PublicKey(BaseModel):
    """The public key that can verify the signature; this can also be an X509 code signing certificate that contains the raw public key information"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: Optional[str] = Field(
        default=None,
        description="Specifies the content of the public key or code signing certificate inline within the document",
    )


class Signature(BaseModel):
    """Information about the detached signature associated with the entry"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: Optional[str] = Field(
        default=None,
        description="Specifies the content of the signature inline within the document",
    )
    public_key: Optional[PublicKey] = Field(
        default=None,
        alias="publicKey",
        description="The public key that can verify the signature; this can also be an X509 code signing certificate that contains the raw public key information",
    )


class Algorithm(str, Enum):
    """The hashing function used to compute the hash value"""

    SHA256 = "sha256"
    SHA384 = "sha384"
    SHA512 = "sha512"


class Hash(BaseModel):
    """Specifies the hash algorithm and value for the content"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    algorithm: Algorithm = Field(
        ...,
        description="The hashing function used to compute the hash value",
    )
    value: StrictStr = Field(
        ...,
        description="The hash value for the content, as represented by a lower case hexadecimal string",
    )


class Data(BaseModel):
    """Information about the content associated with the entry"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    hash: Optional[Hash] = Field(
        default=None,
        description="Specifies the hash algorithm and value for the content",
    )


class HashedrekordV001Schema(BaseModel):
    """Schema for Hashed Rekord object"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    signature: Signature = Field(
        ...,
        description="Information about the detached signature associated with the entry",
    )
    data: Data = Field(..., description="Information about the content associated with the entry")


class HashedrekordSchema(RootModel[HashedrekordV001Schema]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: HashedrekordV001Schema = Field(
        ...,
        description="Schema for Hashedrekord objects",
        title="Hashedrekord Schema",
    )
