// Copyright 2020-2025 Consensys Software Inc.
// Licensed under the Apache License, Version 2.0. See the LICENSE file for details.

// Code generated by consensys/gnark-crypto DO NOT EDIT

package ecc

import (
	"errors"
	"math/big"
	"strings"
)

var mID = map[string]ID{
	"bls12_377":   BLS12_377,
	"bls12_381":   BLS12_381,
	"bls24_315":   BLS24_315,
	"bls24_317":   BLS24_317,
	"bn254":       BN254,
	"bw6_633":     BW6_633,
	"bw6_761":     BW6_761,
	"grumpkin":    GRUMPKIN,
	"secp256k1":   SECP256K1,
	"stark_curve": STARK_CURVE,
}

// ScalarField returns the scalar field of the curve
func (id ID) ScalarField() *big.Int {
	f := new(big.Int)
	switch id {
	case BLS12_377:
		f.SetString("8444461749428370424248824938781546531375899335154063827935233455917409239041", 10)
	case BLS12_381:
		f.SetString("52435875175126190479447740508185965837690552500527637822603658699938581184513", 10)
	case BLS24_315:
		f.SetString("11502027791375260645628074404575422495959608200132055716665986169834464870401", 10)
	case BLS24_317:
		f.SetString("30869589236456844204538189757527902584594726589286811523515204428962673459201", 10)
	case BN254:
		f.SetString("21888242871839275222246405745257275088548364400416034343698204186575808495617", 10)
	case BW6_633:
		f.SetString("39705142709513438335025689890408969744933502416914749335064285505637884093126342347073617133569", 10)
	case BW6_761:
		f.SetString("258664426012969094010652733694893533536393512754914660539884262666720468348340822774968888139573360124440321458177", 10)
	case GRUMPKIN:
		f.SetString("21888242871839275222246405745257275088696311157297823662689037894645226208583", 10)
	case SECP256K1:
		f.SetString("115792089237316195423570985008687907852837564279074904382605163141518161494337", 10)
	case STARK_CURVE:
		f.SetString("3618502788666131213697322783095070105526743751716087489154079457884512865583", 10)
	default:
		panic("unimplemented ecc ID")
	}
	return f
}

// BaseField returns the base field of the curve
func (id ID) BaseField() *big.Int {
	f := new(big.Int)
	switch id {
	case BLS12_377:
		f.SetString("258664426012969094010652733694893533536393512754914660539884262666720468348340822774968888139573360124440321458177", 10)
	case BLS12_381:
		f.SetString("4002409555221667393417789825735904156556882819939007885332058136124031650490837864442687629129015664037894272559787", 10)
	case BLS24_315:
		f.SetString("39705142709513438335025689890408969744933502416914749335064285505637884093126342347073617133569", 10)
	case BLS24_317:
		f.SetString("136393071104295911515099765908274057061945112121419593977210139303905973197232025618026156731051", 10)
	case BN254:
		f.SetString("21888242871839275222246405745257275088696311157297823662689037894645226208583", 10)
	case BW6_633:
		f.SetString("20494478644167774678813387386538961497669590920908778075528754551012016751717791778743535050360001387419576570244406805463255765034468441182772056330021723098661967429339971741066259394985997", 10)
	case BW6_761:
		f.SetString("6891450384315732539396789682275657542479668912536150109513790160209623422243491736087683183289411687640864567753786613451161759120554247759349511699125301598951605099378508850372543631423596795951899700429969112842764913119068299", 10)
	case GRUMPKIN:
		f.SetString("21888242871839275222246405745257275088548364400416034343698204186575808495617", 10)
	case SECP256K1:
		f.SetString("115792089237316195423570985008687907853269984665640564039457584007908834671663", 10)
	case STARK_CURVE:
		f.SetString("3618502788666131213697322783095070105623107215331596699973092056135872020481", 10)
	default:
		panic("unimplemented ecc ID")
	}
	return f
}

// String returns the string representation of the ID
func (id ID) String() string {
	switch id {
	case BLS12_377:
		return "bls12_377"
	case BLS12_381:
		return "bls12_381"
	case BLS24_315:
		return "bls24_315"
	case BLS24_317:
		return "bls24_317"
	case BN254:
		return "bn254"
	case BW6_633:
		return "bw6_633"
	case BW6_761:
		return "bw6_761"
	case GRUMPKIN:
		return "grumpkin"
	case SECP256K1:
		return "secp256k1"
	case STARK_CURVE:
		return "stark_curve"
	default:
		panic("unimplemented ecc ID")
	}
}

// IDFromString returns the ID corresponding to the string representation of the curve ID.
// It returns UNKNOWN if the string does not match any known curve ID.
func IDFromString(s string) (ID, error) {
	s = strings.ToLower(s)
	if id, ok := mID[s]; ok {
		return id, nil
	}
	return UNKNOWN, errors.New("unknown curve ID")
}
