package avatars

import (
	"github.com/keybase/client/go/protocol/keybase1"
)

var userPlaceholders = map[keybase1.AvatarFormat]string{
	"square_192": "iVBORw0KGgoAAAANSUhEUgAAAMAAAADACAAAAAB3tzPbAAADwElEQVR4Ae3bB5ayWBDF8dn/mi6CqNgNnYzntYFGMAs8ljAnT57PUFQ9z6n/Dn4djHV/a548BZCkAAUoQAEKUIACFKAABShAAQpQgAIUoAAFKEABClCAAhSgAAUoQAEKOG2+R+/xcDAYxu+j783pqQB7k/j4W35i9s8BOEy7+I+604PrALuK8L9FK+swoF6E+GXhonYVkHZxVd3UScAxxtXFR/cAxsMNecYxQJXgxpLKJcA+xM2Fe3cAuY878nNXAKmHu/JSNwBr3N3aBcDGw915G3nAroMH6uykAecADxWchQEveLAXWcAUDzeVBBQgqJAD2AEIGlgxgAFJRgpw7oCkzlkIMAZRYxlA2QFRnVIEMANZMwlA7YMsvxYApCAsFQDEICzmB1xA2oUdsARpS3bAB0j7YAcEIC3gBhxA3IEZsAJxK2bADMTNmAFvIO6NGdAHcX1mgA/ifGYAyOMFVCCvYgVcQN6FFXACeSdWQAnySlaABXmWFdB4IM5reAEBiAuYAUMQN2QGfIG4L2aAAXGGGZCBuIwZUIG4ihnQRCAtargBE5A2YQfkIC1nB9gAhAWWHdBM6P+CeAF7ELYXADQR/esIXkAKsn5EAE2f/iMVXsAaRK1JAfz/BVEjBdiDpL0YoBmBoFEjByhDPFxYCgKanYcH83ayF1sGD2akj/7e8VDvjTSgfsUDvdbigKYc4O4GpQuXu5c+7qx/ceN2uhriroaVK9frdYI7Smp39gN2ipubWqcmKHmAmwpy1zY05wQ3lJwdnGFlPVxZL3NzR1bPA1xRMK+dnSJW5peEwFROj0Hr1Sv+p9dV7f4c92xePPxL3os5P8sgus5nSQ9/qpfM8vrZJun2UGTpcplmxcHqpl4BCng2QHna5lmarpbLVZpm+fZUPgfAnjbf4zjqevhHXjeKx9+bk3UVUBXmo4cr6n2YonIMUP6M+rip/uindAWQz+59TzzL5QHFKMADBaNCEnCcdPFw3clRBmDTGETFqWUHVKYLwrqmYgXUhv7kzNRsAGsCtFBgLA+g6KOl+gUD4PKJFvu8tA3IfLSan7UKsBO03sS2BzhHYCg6twU4hGApPLQD2AVgKti1Acg7YKuT0wMOPhjzD9SASwjWwgstwA7B3NCSAmZgb0YJ2Htgz9sTAiIIFNEBUoj0QwaIIFJEBSggVEEEGEGoEREghFAhDeAIsY4kgCXEWpIA5hBrTgIYQawRCeAdYr2TABKIlShAAf+WAhSgAAUoQAEKUIACFKAABShAAQpQgAIUoIDfAUJ3U+9hO4+uAAAAAElFTkSuQmCC",
	"square_256": "iVBORw0KGgoAAAANSUhEUgAAAQAAAAEACAAAAAB5Gfe6AAAFKElEQVR4AezQgQAAAAACoP1pRxjkQig9J0CAAAECBAgQIECAAAECBAgQIECAAAECBAgQIECAAAECBAgQIECAAAECBAgQIECAAAECBAgQIECAAAECxt59ICbKRVEc3/+eDkWxEsIEpMQhShswGOCxg6/3msK73Ef8LeGfajt3NKK7XjvxCQNci8S3LVPHT3TTsv2kuH6SAE3iLvCPFm7SzD1A6S3xn5ZeOd8ATWThFayomWWAYo9X2xezC5Bt8CabbFYB8jXebJ3PJkDj4F2cZhYBRKzjnfRYqB+gXuEDVrXqARIdH6InSgfoXHyY26kboLEwAqtRNUBlYhRmpWaAwsBIjELFAKmG0WipegFSjCpVLUCpY1R6qVaA2sDIjFqlAM0Co1s06gQQW0iwFcoE8CGFr0qAFJKkagS4GpDEuCoRYA9p9ioEOEGiE/8ArQmJzJZ9AA9SedwD1JCsZh7gHpLd8w5wgXQX1gFcSOdyDtCAQMM4gAcCHt8AwgQBU7ANkIJEyjaAAxIO1wCtBhJayzRAAiIJ0wAuiLhMAxggYvAMUINMzTLAEWSOLAM4IOOwDGCBjMUxQA9CPcMAFxC6MAxwBqEzwwAxCMUMA3gg5DEM4IKQyzCAA0IOwwA2CNkMA2xAaMMwwAqEVvwC3L4DdiC0Yxfg9kvw9n/AAwg9MAwQgFDAMEACQgnDACUIlQwDtCDUMgwwmCBjDhwDbEFmyzLAAWQOLAPkIJOzDNBpIKJ1LAMMW7pfATwDBCASMA1QgUjFNMCwAonVwDVADBIx2wANSDRsAwx7ENgPfAOkIHBmHGBYUfwK5BzgBOlOrAMIC5JZgnWAIYFkycA7gFhDqrVgHmAoIVXJ/5OjXyDRl4F/gNaENGarQIDhCdI8qbEf4EISd1AjQGdBCqtTJMBQ65BAr9VZkUkgQaLSjlCI0YVqLUl5GJmn2pbYPetPzRME6G2MyBbKBRjEPUZzL5RclPQxEl/VTdEYo4jVXZVNDXyYcVZ5V7jZ4oO2jdrDysLHh/hC+W3x3MK7Wfkc1uX7UMO7aGE/k/sCjY13sJsZXZgo3pzALmZ2Y6S6wxvcVTO8MlP7Jl7F9OuZ3hkSmavhf2huJuZ8aapL/TX+1dpPu09wa6xNA2el4U+0lROk7We6Niea/JwcoyCIjsk5b8Tt3uBEbgFuAW4BbgFuAah1z2V6SpLjYxQcDkH0eEySU1o+d3MP0Fan0LU3Cw3/QltsbDc8Ve3sArxkkbs18GrG1o2yl3kEaPPIWeBdFk6Ut0oHaFPPwgdZXtoqGUCU4RYj2YalUCuAKB5MjMp8KIQqAUThGZDA8AqhQIDmYEIa89AwD5DZkMzO+AZo4yUILOOWZYA20EFED1p2AdpQByE9bFkF6AIDxIyg4xPgycQEzCcmAS47TGR3YRCgDzRMRgv6qQNUFiZlVdMGOGqYmHacMEB3BwbuuqkCVEuwsKymCVDoYEIvpghw1sCGdqYP8BWsfKUO8AhmHmkDnMHOmTJAqYEdraQL8GyAIeOZKkBngSWrJwrggymfJkAJtkqKAL0FtqyeIEAIxkL5ATodjOmd9AAxWItlB+hNsGb2kgMkYC6RHGAH5nZyA3Rgr5MaIAV7qdQAHtjzpAZYgb2V1AA62NNlBuihgF5igCsUcJUY4BsU8E1igAIKKCQGyKGA/BbgFuBX37dDBwIAAAAAQP6vjZBgwIABAwYMGDBgwIABAwYMGDBgwIABAwYMGDBgwIABAwYMGDBgwIABABKdzdcYiV44AAAAAElFTkSuQmCC",
	"square_960": "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",
}

var userPlaceholdersDark = map[keybase1.AvatarFormat]string{
	"square_192": "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",
	"square_256": "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",
	"square_960": "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",
}

var teamPlaceholders = map[keybase1.AvatarFormat]string{
	"square_192": "iVBORw0KGgoAAAANSUhEUgAAAMAAAADACAAAAAB3tzPbAAADw0lEQVR4AezPgQwAAAACsPxpQ4ij7Td4ek5AQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBg1NbXjqtADMbx93+nD4ZoJFJ3JLZNmhSlgYgy4Ec4t4YlezbETvndU/43tlvO55cMKHfLbJLaJAaAOLHpJFvuytcICNvPNEanOP3chucOOH6NIvwqGn0dnzWg9BZ/Yn35fAHVaowrjFfVUwUEP8CVBj48TUD4NujBfIenCKi9QU/G148P2FncwO4eHHB6w43eTo8MWBvczKwfFhAcRLjwmIDcQojNHxGwinCZSZ3fHIoy1HUoi8PGu9Tgsnh1/4APXGKmi5w65Ivp5YiPOwfUDt1Mtqdf7DODbq6+Z0A1QafppqL/qDZTdJpU9wsIQ3RxBf1J4dBlGO4VUA3RISvpz8qss6C6T0A9wU+jnK6Sj/DTpL5LgEMbkjVdbZ2gDU49oHt+zgL1EGbd01Q5YIW2aEE9LSK0rbQD8hgt9ki9HS1a4lw3IFi0pGe6wTlFiw2qAQ4tk0A3CRO0OM2A9e8HgMxRstYLOBk0ORLQLjAntQDXY/H0WIxOK2CHpjSQiJCiaacTUFs02DMJObffXKsEeDRERxJzjNDgNQKCQcOCBC3QYIJCwDcaZiRqhoZv+YBgwCWBRIUEnAniAb7Ptum/I710QDUANyJxI3CDSjhghYacxOVoWAkHjMFlpCADN5YNKNFQkoL2N0QDPDhHKhw4LxpgwRWkogBnJQOO4KakZAruKBjwBW5DSjbgvgQDRmBMRUoqA2YkFxAi9RnaMUmjIBawBbcnNXtwW7GATzCGFBkwn2IBQ/0Z1DWHUrGAGMyCFC3AxFIBJbicFOXgSqGAHRhDqgyYnVDAEkxKqlIwS6GADIwjVQ5MJhQwAeNJlQczEQpI9Q+h7nMoFQqwYA6k6gDGCgUkYApSVYBJhAJiMCWpKsHEMgE1uECqArhaJODcfqemGty/du7gjGAoioJw/01Z2j0NqACgA1jagmTy/a+DgSS595w5Apj4J+RPHLiMBm5kHiUmfJjzOB14oQm8UvZf6o1VruvAYCswWgwOd43XAwuOwIrJki+wZg0sukUNYmGPQNwmEHgSOeuE/gKxS8HXQPQ4EP4Wv79ex38KEEMFJVACCtSwFOECVcRAGVQdN1CIDlTSSQH+pmUgxsioSchhnme7+qaehyApqKgiCXue/ebjj39PlBdXFZJFfq7rJEylrP2iNJi2mTj79VyOxwt5/LIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA7oureYlakdcsAAAAAElFTkSuQmCC",
	"square_256": "iVBORw0KGgoAAAANSUhEUgAAAQAAAAEACAMAAABrrFhUAAAAflBMVEXw8PC8vLy/v7+9vb3Hx8fk5OTLy8vb29vR0dHj4+PDw8Pm5ubJycnAwMDKysrX19fY2NjW1tbe3t7GxsbU1NTV1dXCwsLr6+vIyMi+vr7T09PMzMzPz8/u7u7s7OzOzs7Nzc3p6enn5+fc3Nzi4uLv7+/l5eXt7e3a2trf399nvuwAAAAE8UlEQVR42uzdWVbrOhAF0FPum9jpIfTXQbLR/Cf4Fh/vJzYJBFuSw9kDSLwCVkklqQpERERERERERERERERERERERERERERERKPRXXNslXn/+Hg3qj02ncZfcZ+nu6SQniLZpfk9btqL2h8COSs47NULbpGOl4tQviVcLGONm6LN04P8yMOT0bgVcVbJFaosxg1o1oVcrVg3mLfyTX7prcR8tYmMIGkxT6qWkdQK89NGMqKoxbx0mYws6zAjaSCjC1LMRRnJJKISc6AfZTKPGt5rIplQ1MBzJpBJBQY+05lMLtPwVrOV76mi56VR8Wci6DM1FCuzfI4q+Z5tA0+pQC4LklX+ikGv+Sr51kcoeGkTygVhvWw1ztLtsr78ORt4KJULorTDt3RpJBek8M5azir2DX6g2Rdy1hqeyeScrcGPma2ck8Er/+SMhcJV1ELO+DeXv3+d42p5LV/LZvH+323wK5s7+dLa//E/3HX4pW4X+h4LNvKVxREjOC7kKxt4QIUyLFxhJKsvv0LBuSaQYXcxRhPfybCggWN6K8OSDiPqEhm21Z4GwCVGtvQzGBoZFBqMzoQyyHg4AAQ5JpAH3g0DOpIhVYlJlJUMiTRceZQhRYOJNIUMeYQjpQypGkymqWRICTciGRCUmFAZyIDIoyVAmGNSeejNoqALZIBxEniDzpcp0BKTW3oyHWplQAILEhnQejEC3nWwoLvzYRxU0hfGsCIOpU/Brlr6VrBkJX21+xFgAWsWzkeBRHrCI6w5htKTuJ4E72DRzvGE+O1cBHAVCd5gTSN9xn0qunG5EVLDstrlRkkhPTksy6WngCXxmRDoNBTG7pZBCtYpZ0siXfWz83BgK6cqDRuM2xDg/jmeLow+DsfiJ1igH+TUHk7s5dSDdhMDGjjRSE/sZBYUwZu09NpJ/E3hSOpiPvISyomwgyNd/1leHMw/ajhTyynlYOhdwpmlg4B0cJmLuhyRDphaICcCDWd0/2kwsfuLuTjHucl768vwFRxaWU9MpOe/0X1aJLWejn2FQ69yamf7pavgVGV7SCr6CwGnIstLcy2nnuHUs5zSmFJ3KQi4DwOd5SW4gVPGcnLieGn14T43fLQ8+W7hVCunYp9/8Pn/S24GXjmnGsvXaN6vGHQth6V3TOnjirBreWLywR+Ar8CEjP+DoGEYtDsRiuHO8MyMU2Euhlwuh91vjXRMiDAlxqQo0+LcGOHWGDdHuT3u4oCE+5TogUdkeEiKx+R4UPIPH5Vd8rA0j8vzwgSvzPDSFK/N8eIkr87y8rT16/MbD67Ps4ACS2iwiArL6LCQEktpsZgay+mxoCJLarKoKsvqsrAyS2uzuDrL67PBAltssMkK2+yw0RJbbbHZmtt2ewa/Ys6122PDRbbcZNNVtt1l42W23mbz9Xm2318Z1f7ffr9VZnUL7fcBncnkMg2fmUAmFRh4rolkQlED7+lHmcyjxhyUkUwiKjEXaSCjC1LMSJfJyLIO89JGMqKoxfyoWkZSK8xTm8gIkhbzVb7JL72VmLdmXcjVinWDGxBnlVyhymLcCm2eHuRHHp6Mxk3R8XoRyreEi3WscYte1P4QyFnBYa9ecNPu83SXFNJTJLs0v8df8ZkIitXm/ePjfaPiz9QQiIiIiIiIiIiIiIiIiIjov/bgkAAAAABA0P/XnjACAAAAAFwC/pJqY0iLrG8AAAAASUVORK5CYII=",
	"square_960": "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",
}

var teamPlaceholdersDark = map[keybase1.AvatarFormat]string{
	"square_192": "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",
	"square_256": "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",
	"square_960": "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",
}
