package apitest

const reportTemplate = `<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.2/css/bootstrap.min.css">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/highlight.js/9.12.0/styles/github.min.css" />
	<script src="https://cdnjs.cloudflare.com/ajax/libs/underscore.js/1.8.3/underscore-min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/raphael/2.2.7/raphael.min.js"></script>
    <script src="https://bramp.github.io/js-sequence-diagrams/js/sequence-diagram-min.js"></script>
    <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.3/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.2/js/bootstrap.min.js"></script>
</head>
<body>
<!-- THIS CODE IS AUTOGENERATED. DO NOT EDIT -->
<div class="container-fluid">
    <h2>{{printf "%.100s" .Title }}</h2>
    <span class="{{ .BadgeClass }}">{{ .StatusCode }}</span>
    <p class="lead">{{ .SubTitle }}</p>
    <div class="card text-center">
        <div class="card-body">
            <div id="d" class="justify-content-center"></div>
        </div>
    </div>
    <br><br>
    <p class="lead">Event Log</p>
    <table class="table">
        <thead>
        <tr>
            <th scope="col">#</th>
            <th scope="col">Payload</th>
        </tr>
        </thead>
        <tbody>
        {{ range $i, $e := .LogEntries }}
        <tr>
            <th scope="row">{{ inc $i }}</th>
            <td>
<pre>{{ $e.Header }}</pre>
{{if $e.Body }}<pre style="max-height: 1000px;"><code>{{ $e.Body }}</code></pre>{{end}}
            </td>
        </tr>
        {{ end }}
        </tbody>
    </table>
</div>
<script>
    Diagram.parse("{{ .WebSequenceDSL }}").drawSVG("d", {theme: 'simple', 'font-size': 14});
</script>
<style>
    body {
        padding-top: 2rem;
        padding-bottom: 2rem;
    }
</style>
{{if $.MetaJSON }}<script type="application/json" id="metaJson">{{ $.MetaJSON }}</script>{{end}}
<script src="https://cdn.jsdelivr.net/gh/highlightjs/cdn-release@9.13.1/build/highlight.min.js"></script>
<script>hljs.initHighlightingOnLoad();</script>
</body>
</html>`
