// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) TypeSpec Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

#pragma once

#include "dll_import_export.hpp"

#include <azure/core/context.hpp>
#include <azure/core/internal/extendable_enumeration.hpp>
#include <azure/core/nullable.hpp>
#include <azure/core/url.hpp>
#include <azure/core/uuid.hpp>

#include <cstdint>
#include <map>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace Azure { namespace Data { namespace AppConfiguration {

  class GetKeysResponseContentType final
      : public Core::_internal::ExtendableEnumeration<GetKeysResponseContentType> {
  public:
    GetKeysResponseContentType() = default;

    explicit GetKeysResponseContentType(std::string getKeysResponseContentType)
        : ExtendableEnumeration(std::move(getKeysResponseContentType))
    {
    }

    static GetKeysResponseContentType const ApplicationVndMicrosoftAppconfigKeysetJson;
    static GetKeysResponseContentType const ApplicationProblemJson;
  };

  class GetKeyValuesResponseContentType final
      : public Core::_internal::ExtendableEnumeration<GetKeyValuesResponseContentType> {
  public:
    GetKeyValuesResponseContentType() = default;

    explicit GetKeyValuesResponseContentType(std::string getKeyValuesResponseContentType)
        : ExtendableEnumeration(std::move(getKeyValuesResponseContentType))
    {
    }

    static GetKeyValuesResponseContentType const ApplicationVndMicrosoftAppconfigKvsetJson;
    static GetKeyValuesResponseContentType const ApplicationProblemJson;
  };

  class KeyValueFields final : public Core::_internal::ExtendableEnumeration<KeyValueFields> {
  public:
    KeyValueFields() = default;

    explicit KeyValueFields(std::string keyValueFields)
        : ExtendableEnumeration(std::move(keyValueFields))
    {
    }

    static KeyValueFields const Key;
    static KeyValueFields const Label;
    static KeyValueFields const ContentType;
    static KeyValueFields const Value;
    static KeyValueFields const LastModified;
    static KeyValueFields const Tags;
    static KeyValueFields const Locked;
    static KeyValueFields const Etag;
  };

  class PutKeyValueRequestContentType final
      : public Core::_internal::ExtendableEnumeration<PutKeyValueRequestContentType> {
  public:
    PutKeyValueRequestContentType() = default;

    explicit PutKeyValueRequestContentType(std::string putKeyValueRequestContentType)
        : ExtendableEnumeration(std::move(putKeyValueRequestContentType))
    {
    }

    static PutKeyValueRequestContentType const ApplicationVndMicrosoftAppconfigKvJson;
    static PutKeyValueRequestContentType const ApplicationVndMicrosoftAppconfigKvsetJson;
    static PutKeyValueRequestContentType const ApplicationJson;
    static PutKeyValueRequestContentType const TextJson;
    static PutKeyValueRequestContentType const ApplicationZeroZeroJson;
    static PutKeyValueRequestContentType const ApplicationJsonPatchJson;
  };

  class SnapshotStatus final : public Core::_internal::ExtendableEnumeration<SnapshotStatus> {
  public:
    SnapshotStatus() = default;

    explicit SnapshotStatus(std::string snapshotStatus)
        : ExtendableEnumeration(std::move(snapshotStatus))
    {
    }

    static SnapshotStatus const Provisioning;
    static SnapshotStatus const Ready;
    static SnapshotStatus const Archived;
    static SnapshotStatus const Failed;
  };

  class CompositionType final : public Core::_internal::ExtendableEnumeration<CompositionType> {
  public:
    CompositionType() = default;

    explicit CompositionType(std::string compositionType)
        : ExtendableEnumeration(std::move(compositionType))
    {
    }

    static CompositionType const Key;
    static CompositionType const KeyLabel;
  };

  class GetSnapshotsResponseContentType final
      : public Core::_internal::ExtendableEnumeration<GetSnapshotsResponseContentType> {
  public:
    GetSnapshotsResponseContentType() = default;

    explicit GetSnapshotsResponseContentType(std::string getSnapshotsResponseContentType)
        : ExtendableEnumeration(std::move(getSnapshotsResponseContentType))
    {
    }

    static GetSnapshotsResponseContentType const ApplicationVndMicrosoftAppconfigSnapshotsetJson;
    static GetSnapshotsResponseContentType const ApplicationProblemJson;
  };

  class SnapshotFields final : public Core::_internal::ExtendableEnumeration<SnapshotFields> {
  public:
    SnapshotFields() = default;

    explicit SnapshotFields(std::string snapshotFields)
        : ExtendableEnumeration(std::move(snapshotFields))
    {
    }

    static SnapshotFields const Name;
    static SnapshotFields const Status;
    static SnapshotFields const Filters;
    static SnapshotFields const CompositionType;
    static SnapshotFields const Created;
    static SnapshotFields const Expires;
    static SnapshotFields const RetentionPeriod;
    static SnapshotFields const Size;
    static SnapshotFields const ItemsCount;
    static SnapshotFields const Tags;
    static SnapshotFields const Etag;
  };

  class GetSnapshotResponseContentType final
      : public Core::_internal::ExtendableEnumeration<GetSnapshotResponseContentType> {
  public:
    GetSnapshotResponseContentType() = default;

    explicit GetSnapshotResponseContentType(std::string getSnapshotResponseContentType)
        : ExtendableEnumeration(std::move(getSnapshotResponseContentType))
    {
    }

    static GetSnapshotResponseContentType const ApplicationVndMicrosoftAppconfigSnapshotJson;
    static GetSnapshotResponseContentType const ApplicationProblemJson;
  };

  class OperationState final : public Core::_internal::ExtendableEnumeration<OperationState> {
  public:
    OperationState() = default;

    explicit OperationState(std::string operationState)
        : ExtendableEnumeration(std::move(operationState))
    {
    }

    static OperationState const NotStarted;
    static OperationState const Running;
    static OperationState const Succeeded;
    static OperationState const Failed;
    static OperationState const Canceled;
  };

  class CreateSnapshotResponseContentType final
      : public Core::_internal::ExtendableEnumeration<CreateSnapshotResponseContentType> {
  public:
    CreateSnapshotResponseContentType() = default;

    explicit CreateSnapshotResponseContentType(std::string createSnapshotResponseContentType)
        : ExtendableEnumeration(std::move(createSnapshotResponseContentType))
    {
    }

    static CreateSnapshotResponseContentType const ApplicationVndMicrosoftAppconfigSnapshotJson;
    static CreateSnapshotResponseContentType const ApplicationProblemJson;
  };

  class CreateSnapshotRequestContentType final
      : public Core::_internal::ExtendableEnumeration<CreateSnapshotRequestContentType> {
  public:
    CreateSnapshotRequestContentType() = default;

    explicit CreateSnapshotRequestContentType(std::string createSnapshotRequestContentType)
        : ExtendableEnumeration(std::move(createSnapshotRequestContentType))
    {
    }

    static CreateSnapshotRequestContentType const ApplicationVndMicrosoftAppconfigSnapshotJson;
    static CreateSnapshotRequestContentType const ApplicationJson;
  };

  class UpdateSnapshotResponseContentType final
      : public Core::_internal::ExtendableEnumeration<UpdateSnapshotResponseContentType> {
  public:
    UpdateSnapshotResponseContentType() = default;

    explicit UpdateSnapshotResponseContentType(std::string updateSnapshotResponseContentType)
        : ExtendableEnumeration(std::move(updateSnapshotResponseContentType))
    {
    }

    static UpdateSnapshotResponseContentType const ApplicationVndMicrosoftAppconfigSnapshotJson;
    static UpdateSnapshotResponseContentType const ApplicationProblemJson;
  };

  class UpdateSnapshotRequestContentType final
      : public Core::_internal::ExtendableEnumeration<UpdateSnapshotRequestContentType> {
  public:
    UpdateSnapshotRequestContentType() = default;

    explicit UpdateSnapshotRequestContentType(std::string updateSnapshotRequestContentType)
        : ExtendableEnumeration(std::move(updateSnapshotRequestContentType))
    {
    }

    static UpdateSnapshotRequestContentType const ApplicationMergePatchJson;
    static UpdateSnapshotRequestContentType const ApplicationJson;
  };

  class GetLabelsResponseContentType final
      : public Core::_internal::ExtendableEnumeration<GetLabelsResponseContentType> {
  public:
    GetLabelsResponseContentType() = default;

    explicit GetLabelsResponseContentType(std::string getLabelsResponseContentType)
        : ExtendableEnumeration(std::move(getLabelsResponseContentType))
    {
    }

    static GetLabelsResponseContentType const ApplicationVndMicrosoftAppconfigLabelsetJson;
    static GetLabelsResponseContentType const ApplicationProblemJson;
  };

  class LabelFields final : public Core::_internal::ExtendableEnumeration<LabelFields> {
  public:
    LabelFields() = default;

    explicit LabelFields(std::string labelFields) : ExtendableEnumeration(std::move(labelFields)) {}

    static LabelFields const Name;
  };

  class GetRevisionsResponseContentType final
      : public Core::_internal::ExtendableEnumeration<GetRevisionsResponseContentType> {
  public:
    GetRevisionsResponseContentType() = default;

    explicit GetRevisionsResponseContentType(std::string getRevisionsResponseContentType)
        : ExtendableEnumeration(std::move(getRevisionsResponseContentType))
    {
    }

    static GetRevisionsResponseContentType const ApplicationVndMicrosoftAppconfigKvsetJson;
    static GetRevisionsResponseContentType const ApplicationProblemJson;
  };

  struct Key final
  {
    std::string Name;
  };

  struct CheckKeysResult final
  {
    std::string SyncToken;
  };

  struct KeyValue final
  {
    std::string Key;
    Nullable<std::string> Label;
    Nullable<std::string> ContentType;
    Nullable<std::string> Value;
    Nullable<std::string> LastModified;
    Nullable<std::map<std::string, std::string>> Tags;
    Nullable<bool> Locked;
    Nullable<std::string> Etag;
  };

  struct CheckKeyValuesResult final
  {
    std::string SyncToken;
    std::string ETag;
  };

  struct GetKeyValueResult final
  {
    std::string Key;
    Nullable<std::string> Label;
    Nullable<std::string> ContentType;
    Nullable<std::string> Value;
    Nullable<std::string> LastModified;
    Nullable<std::map<std::string, std::string>> Tags;
    Nullable<bool> Locked;
    Nullable<std::string> Etag;
    Core::Uuid XMsClientRequestId{};
    std::string SyncToken;
    std::string ETag;
  };

  struct PutKeyValueResult final
  {
    std::string Key;
    Nullable<std::string> Label;
    Nullable<std::string> ContentType;
    Nullable<std::string> Value;
    Nullable<std::string> LastModified;
    Nullable<std::map<std::string, std::string>> Tags;
    Nullable<bool> Locked;
    Nullable<std::string> Etag;
    std::string SyncToken;
    std::string ETag;
  };

  struct DeleteKeyValueResult final
  {
    std::string Key;
    Nullable<std::string> Label;
    Nullable<std::string> ContentType;
    Nullable<std::string> Value;
    Nullable<std::string> LastModified;
    Nullable<std::map<std::string, std::string>> Tags;
    Nullable<bool> Locked;
    Nullable<std::string> Etag;
    std::string SyncToken;
    std::string ETag;
  };

  struct CheckKeyValueResult final
  {
    std::string SyncToken;
    std::string ETag;
  };

  struct KeyValueFilter final
  {
    std::string Key;
    Nullable<std::string> Label;
    Nullable<std::vector<std::string>> Tags;
  };

  struct Snapshot final
  {
    std::string Name;
    Nullable<SnapshotStatus> Status;
    std::vector<KeyValueFilter> Filters;
    Nullable<AppConfiguration::CompositionType> CompositionType;
    Nullable<std::string> Created;
    Nullable<std::string> Expires;
    Nullable<std::int64_t> RetentionPeriod;
    Nullable<std::int64_t> Size;
    Nullable<std::int64_t> ItemsCount;
    Nullable<std::map<std::string, std::string>> Tags;
    Nullable<std::string> Etag;
  };

  struct CheckSnapshotsResult final
  {
    std::string SyncToken;
  };

  struct GetSnapshotResult final
  {
    std::string Name;
    Nullable<SnapshotStatus> Status;
    std::vector<KeyValueFilter> Filters;
    Nullable<AppConfiguration::CompositionType> CompositionType;
    Nullable<std::string> Created;
    Nullable<std::string> Expires;
    Nullable<std::int64_t> RetentionPeriod;
    Nullable<std::int64_t> Size;
    Nullable<std::int64_t> ItemsCount;
    Nullable<std::map<std::string, std::string>> Tags;
    Nullable<std::string> Etag;
    std::string SyncToken;
    std::string ETag;
    std::string Link;
    Core::Uuid XMsClientRequestId{};
    GetSnapshotResponseContentType ContentType;
  };

  struct InnerError final
  {
    Nullable<std::string> Code;
    std::unique_ptr<InnerError> Innererror;
  };

  struct Error final
  {
    std::string Code;
    std::string Message;
    Nullable<std::string> Target;
    Nullable<std::vector<Error>> Details;
    InnerError Innererror;
  };

  struct OperationDetails final
  {
    std::string Id;
    OperationState Status;
    AppConfiguration::Error Error;
  };

  struct CreateSnapshotResult final
  {
    std::string Name;
    Nullable<SnapshotStatus> Status;
    std::vector<KeyValueFilter> Filters;
    Nullable<AppConfiguration::CompositionType> CompositionType;
    Nullable<std::string> Created;
    Nullable<std::string> Expires;
    Nullable<std::int64_t> RetentionPeriod;
    Nullable<std::int64_t> Size;
    Nullable<std::int64_t> ItemsCount;
    Nullable<std::map<std::string, std::string>> Tags;
    Nullable<std::string> Etag;
    std::string SyncToken;
    std::string ETag;
    std::string Link;
    Core::Url OperationLocation;
    CreateSnapshotResponseContentType ContentType;
  };

  struct UpdateSnapshotResult final
  {
    std::string Name;
    Nullable<SnapshotStatus> Status;
    std::vector<KeyValueFilter> Filters;
    Nullable<AppConfiguration::CompositionType> CompositionType;
    Nullable<std::string> Created;
    Nullable<std::string> Expires;
    Nullable<std::int64_t> RetentionPeriod;
    Nullable<std::int64_t> Size;
    Nullable<std::int64_t> ItemsCount;
    Nullable<std::map<std::string, std::string>> Tags;
    Nullable<std::string> Etag;
    std::string SyncToken;
    std::string ETag;
    std::string Link;
    UpdateSnapshotResponseContentType ContentType;
  };

  struct SnapshotUpdateParameters final
  {
    Nullable<SnapshotStatus> Status;
  };

  struct CheckSnapshotResult final
  {
    std::string SyncToken;
    std::string ETag;
    std::string Link;
  };

  struct Label final
  {
    Nullable<std::string> Name;
  };

  struct CheckLabelsResult final
  {
    std::string SyncToken;
  };

  struct PutLockResult final
  {
    std::string Key;
    Nullable<std::string> Label;
    Nullable<std::string> ContentType;
    Nullable<std::string> Value;
    Nullable<std::string> LastModified;
    Nullable<std::map<std::string, std::string>> Tags;
    Nullable<bool> Locked;
    Nullable<std::string> Etag;
    std::string SyncToken;
    std::string ETag;
  };

  struct DeleteLockResult final
  {
    std::string Key;
    Nullable<std::string> Label;
    Nullable<std::string> ContentType;
    Nullable<std::string> Value;
    Nullable<std::string> LastModified;
    Nullable<std::map<std::string, std::string>> Tags;
    Nullable<bool> Locked;
    Nullable<std::string> Etag;
    std::string SyncToken;
    std::string ETag;
  };

  struct CheckRevisionsResult final
  {
    std::string SyncToken;
    std::string ETag;
  };
}}} // namespace Azure::Data::AppConfiguration
