/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.knowm.xchart.internal.chartpart.BoxPlotData;
import org.knowm.xchart.internal.series.AxesChartSeries;
import org.knowm.xchart.internal.series.AxesChartSeriesCategory;
import org.knowm.xchart.style.AxesChartStyler;
import org.knowm.xchart.style.BoxStyler;

public class BoxPlotDataCalculator<ST extends AxesChartStyler, S extends AxesChartSeries> {
    public List<BoxPlotData> calculate(Map<String, S> seriesMap, ST boxPlotStyler) {
        ArrayList<BoxPlotData> boxPlotDataList = new ArrayList<BoxPlotData>();
        BoxPlotData boxPlotData = null;
        ArrayList<Double> data = null;
        Collection<? extends Number> yData = null;
        Iterator<? extends Number> yDataIterator = null;
        Number next = null;
        for (AxesChartSeries series : seriesMap.values()) {
            if (!series.isEnabled()) continue;
            yData = ((AxesChartSeriesCategory)series).getYData();
            yDataIterator = yData.iterator();
            data = new ArrayList<Double>();
            while (yDataIterator.hasNext()) {
                next = yDataIterator.next();
                if (next == null) continue;
                data.add(next.doubleValue());
            }
            Collections.sort(data);
            boxPlotData = this.calculate(data, boxPlotStyler);
            boxPlotDataList.add(boxPlotData);
        }
        return boxPlotDataList;
    }

    private BoxPlotData calculate(List<Double> data, ST boxPlotStyler) {
        BoxPlotData boxPlotData = new BoxPlotData();
        int n = data.size();
        BoxStyler.BoxplotCalCulationMethod boxplotCalCulationMethod = ((BoxStyler)boxPlotStyler).getBoxplotCalCulationMethod();
        double q1P = 0.0;
        double q2P = 0.0;
        double q3P = 0.0;
        double four = 4.0;
        if (BoxStyler.BoxplotCalCulationMethod.N_PLUS_1.equals((Object)boxplotCalCulationMethod)) {
            q1P = (double)(n + 1) / four;
            q2P = (double)(2 * (n + 1)) / four;
            q3P = (double)(3 * (n + 1)) / four;
        } else if (BoxStyler.BoxplotCalCulationMethod.N_LESS_1.equals((Object)boxplotCalCulationMethod)) {
            q1P = (double)(n - 1) / four;
            q2P = (double)(2 * (n - 1)) / four;
            q3P = (double)(3 * (n - 1)) / four;
        } else if (BoxStyler.BoxplotCalCulationMethod.NP.equals((Object)boxplotCalCulationMethod)) {
            q1P = (double)n / four;
            q2P = (double)(2 * n) / four;
            q3P = (double)(3 * n) / four;
        } else if (BoxStyler.BoxplotCalCulationMethod.N_LESS_1_PLUS_1.equals((Object)boxplotCalCulationMethod)) {
            q1P = (double)(n - 1) / four + 1.0;
            q2P = (double)(2 * (n - 1)) / four + 1.0;
            q3P = (double)(3 * (n - 1)) / four + 1.0;
        }
        boxPlotData.q1 = BoxPlotDataCalculator.getQuartile(data, q1P, boxplotCalCulationMethod);
        boxPlotData.median = BoxPlotDataCalculator.getQuartile(data, q2P, boxplotCalCulationMethod);
        boxPlotData.q3 = BoxPlotDataCalculator.getQuartile(data, q3P, boxplotCalCulationMethod);
        double irq = boxPlotData.q3 - boxPlotData.q1;
        boxPlotData.lower = boxPlotData.q1 - 1.5 * irq;
        if (boxPlotData.lower < data.get(0)) {
            boxPlotData.lower = data.get(0);
        }
        boxPlotData.upper = boxPlotData.q3 + 1.5 * irq;
        if (boxPlotData.upper > data.get(data.size() - 1)) {
            boxPlotData.upper = data.get(data.size() - 1);
        }
        return boxPlotData;
    }

    private static double getQuartile(List<Double> data, double qiP, BoxStyler.BoxplotCalCulationMethod boxplotCalCulationMethod) {
        int nextItem_index;
        int previousItem = (int)Math.floor(qiP);
        int previousItem_index = previousItem == 0 ? 0 : previousItem - 1;
        int nextItem = (int)Math.ceil(qiP);
        int n = nextItem_index = data.size() == 1 ? 0 : nextItem - 1;
        double qi = BoxStyler.BoxplotCalCulationMethod.NP == boxplotCalCulationMethod ? (previousItem == nextItem ? (data.get(previousItem_index) + data.get(nextItem_index)) / 2.0 : data.get(nextItem_index)) : (previousItem == nextItem ? data.get(previousItem_index) : data.get(previousItem_index) * ((double)nextItem - qiP) + data.get(nextItem_index) * (qiP - (double)previousItem));
        return qi;
    }
}

