/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.net;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.TooManyListenersException;
import net.wimpi.modbus.io.ModbusASCIITransport;
import net.wimpi.modbus.io.ModbusBINTransport;
import net.wimpi.modbus.io.ModbusRTUTransport;
import net.wimpi.modbus.io.ModbusSerialTransport;
import net.wimpi.modbus.io.ModbusTransport;
import net.wimpi.modbus.net.ModbusSlaveConnection;
import net.wimpi.modbus.util.SerialParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialConnection
implements SerialPortEventListener,
ModbusSlaveConnection {
    private static final Logger logger = LoggerFactory.getLogger(SerialConnection.class);
    private SerialParameters m_Parameters;
    private ModbusSerialTransport m_Transport;
    private CommPortIdentifier m_PortIdentifyer;
    private SerialPort m_SerialPort;
    private boolean m_Open;
    private InputStream m_SerialIn;

    public SerialConnection(SerialParameters parameters) {
        this.m_Parameters = parameters;
        this.m_Open = false;
    }

    public SerialPort getSerialPort() {
        return this.m_SerialPort;
    }

    public ModbusTransport getModbusTransport() {
        return this.m_Transport;
    }

    public void open() throws Exception {
        File portDevFile;
        if (this.isOpen()) {
            return;
        }
        String osName = System.getProperty("os.name");
        if (osName != null && osName.toLowerCase().startsWith("linux") && !(portDevFile = new File(this.m_Parameters.getPortName())).exists()) {
            throw new Exception("Modbus serial device " + this.m_Parameters.getPortName() + " doesn't exist!");
        }
        try {
            this.m_PortIdentifyer = CommPortIdentifier.getPortIdentifier((String)this.m_Parameters.getPortName());
        }
        catch (NoSuchPortException e) {
            String errMsg = "Could not get port identifier, maybe insufficient permissions. " + e.getMessage();
            logger.debug("Could not get port identifier, maybe insufficient permissions. {}: {}", (Object)((Object)((Object)e)).getClass().getName(), (Object)e.getMessage());
            throw new Exception(errMsg);
        }
        logger.trace("Got Port Identifier");
        try {
            this.m_SerialPort = this.m_PortIdentifyer.open("Modbus Serial Master", 30000);
        }
        catch (PortInUseException e) {
            String msg = "open port failed: " + e.getMessage();
            logger.debug("open port failed: {}: {}", (Object)((Object)((Object)e)).getClass().getName(), (Object)e.getMessage());
            throw new Exception(msg);
        }
        logger.trace("Got Serial Port");
        try {
            this.setConnectionParameters();
        }
        catch (Exception e) {
            this.m_SerialPort.close();
            logger.debug("parameter setup failed. {}: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            throw e;
        }
        this.setReceiveTimeout(this.m_Parameters.getReceiveTimeoutMillis());
        if ("ascii".equals(this.m_Parameters.getEncoding())) {
            this.m_Transport = new ModbusASCIITransport();
        } else if ("rtu".equals(this.m_Parameters.getEncoding())) {
            this.m_Transport = new ModbusRTUTransport();
        } else if ("bin".equals(this.m_Parameters.getEncoding())) {
            this.m_Transport = new ModbusBINTransport();
        }
        this.m_Transport.setEcho(this.m_Parameters.isEcho());
        try {
            this.m_SerialIn = this.m_SerialPort.getInputStream();
            this.m_Transport.setCommPort((CommPort)this.m_SerialPort);
        }
        catch (IOException e) {
            this.m_SerialPort.close();
            String msg = "Error opening i/o streams: " + e.getMessage();
            logger.debug("Error opening i/o streams. {}: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            throw new Exception(msg);
        }
        logger.trace("i/o Streams prepared");
        try {
            this.m_SerialPort.addEventListener((SerialPortEventListener)this);
        }
        catch (TooManyListenersException e) {
            this.m_SerialPort.close();
            String errMsg = "too many listeners added:" + e.getMessage();
            logger.debug("too many listeners added. {}: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            throw new Exception(errMsg);
        }
        this.m_SerialPort.notifyOnBreakInterrupt(true);
        this.m_Open = true;
    }

    public void setReceiveTimeout(int ms) {
        try {
            this.m_SerialPort.enableReceiveTimeout(ms);
        }
        catch (UnsupportedCommOperationException e) {
            logger.warn("Failed to set receive timeout: {}", (Object)e.getMessage());
        }
    }

    public SerialParameters getParameters() {
        return this.m_Parameters;
    }

    protected void setConnectionParameters() throws Exception {
        int oldBaudRate = this.m_SerialPort.getBaudRate();
        int oldDatabits = this.m_SerialPort.getDataBits();
        int oldStopbits = this.m_SerialPort.getStopBits();
        int oldParity = this.m_SerialPort.getParity();
        int oldFlowControl = this.m_SerialPort.getFlowControlMode();
        try {
            this.m_SerialPort.setSerialPortParams(this.m_Parameters.getBaudRate(), this.m_Parameters.getDatabits(), this.m_Parameters.getStopbits(), this.m_Parameters.getParity());
        }
        catch (UnsupportedCommOperationException e) {
            this.m_Parameters.setBaudRate(oldBaudRate);
            this.m_Parameters.setDatabits(oldDatabits);
            this.m_Parameters.setStopbits(oldStopbits);
            this.m_Parameters.setParity(oldParity);
            String errMsg = "Unsupported parameter";
            logger.debug("{} failed to set up one of [baudRate, dataBits, stopBits, parity]: {}", (Object)"Unsupported parameter", (Object)e.getMessage());
            throw new Exception("Unsupported parameter");
        }
        try {
            this.m_SerialPort.setFlowControlMode(this.m_Parameters.getFlowControlIn() | this.m_Parameters.getFlowControlOut());
        }
        catch (UnsupportedCommOperationException e) {
            String errMsg = "Unsupported flow control";
            logger.debug("{}: {}", (Object)"Unsupported flow control", (Object)e.getMessage());
            throw new Exception("Unsupported flow control");
        }
    }

    public void close() {
        if (!this.m_Open) {
            return;
        }
        try {
            this.m_Transport.close();
        }
        catch (IOException e) {
            logger.warn("Error occurred when closing transport. {}: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
        }
        try {
            this.m_SerialIn.close();
        }
        catch (IOException e) {
            logger.warn("Error occurred when closing serial input stream. {}: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
        }
        this.m_Open = false;
    }

    public boolean isOpen() {
        return this.m_Open;
    }

    public void serialEvent(SerialPortEvent e) {
        switch (e.getEventType()) {
            case 1: {
                break;
            }
            case 10: {
                logger.debug("Serial port break detected");
                break;
            }
            default: {
                logger.debug("Serial port event: {}", (Object)e.getEventType());
            }
        }
    }

    @Override
    public boolean connect() throws Exception {
        this.open();
        return this.isOpen();
    }

    @Override
    public void resetConnection() {
        this.close();
    }

    @Override
    public boolean isConnected() {
        return this.isOpen();
    }

    public String toString() {
        return "SerialConnection [m_SerialPort=" + this.m_SerialPort + (this.m_Parameters != null ? ", m_Parameters.getPortName()=" + this.m_Parameters.getPortName() : "") + "]";
    }
}

