package logz

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// SubAccountClient is the client for the SubAccount methods of the Logz service.
type SubAccountClient struct {
	BaseClient
}

// NewSubAccountClient creates an instance of the SubAccountClient client.
func NewSubAccountClient(subscriptionID string) SubAccountClient {
	return NewSubAccountClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewSubAccountClientWithBaseURI creates an instance of the SubAccountClient client using a custom endpoint.  Use this
// when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewSubAccountClientWithBaseURI(baseURI string, subscriptionID string) SubAccountClient {
	return SubAccountClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Create sends the create request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// monitorName - monitor resource name
// subAccountName - sub Account resource name
func (client SubAccountClient) Create(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, body *MonitorResource) (result SubAccountCreateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubAccountClient.Create")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: body,
			Constraints: []validation.Constraint{{Target: "body", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "body.Properties", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "body.Properties.UserInfo", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "body.Properties.UserInfo.FirstName", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "body.Properties.UserInfo.FirstName", Name: validation.MaxLength, Rule: 50, Chain: nil}}},
							{Target: "body.Properties.UserInfo.LastName", Name: validation.Null, Rule: false,
								Chain: []validation.Constraint{{Target: "body.Properties.UserInfo.LastName", Name: validation.MaxLength, Rule: 50, Chain: nil}}},
							{Target: "body.Properties.UserInfo.EmailAddress", Name: validation.Null, Rule: false,
								Chain: []validation.Constraint{{Target: "body.Properties.UserInfo.EmailAddress", Name: validation.Pattern, Rule: `^[A-Za-z0-9._%+-]+@(?:[A-Za-z0-9-]+\.)+[A-Za-z]{2,}$`, Chain: nil}}},
							{Target: "body.Properties.UserInfo.PhoneNumber", Name: validation.Null, Rule: false,
								Chain: []validation.Constraint{{Target: "body.Properties.UserInfo.PhoneNumber", Name: validation.MaxLength, Rule: 40, Chain: nil}}},
						}},
						{Target: "body.Properties.PlanData", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "body.Properties.PlanData.UsageType", Name: validation.Null, Rule: false,
								Chain: []validation.Constraint{{Target: "body.Properties.PlanData.UsageType", Name: validation.MaxLength, Rule: 50, Chain: nil}}},
								{Target: "body.Properties.PlanData.BillingCycle", Name: validation.Null, Rule: false,
									Chain: []validation.Constraint{{Target: "body.Properties.PlanData.BillingCycle", Name: validation.MaxLength, Rule: 50, Chain: nil}}},
								{Target: "body.Properties.PlanData.PlanDetails", Name: validation.Null, Rule: false,
									Chain: []validation.Constraint{{Target: "body.Properties.PlanData.PlanDetails", Name: validation.MaxLength, Rule: 50, Chain: nil}}},
							}},
					}},
					{Target: "body.Location", Name: validation.Null, Rule: true, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("logz.SubAccountClient", "Create", err.Error())
	}

	req, err := client.CreatePreparer(ctx, resourceGroupName, monitorName, subAccountName, body)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.SubAccountClient", "Create", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.SubAccountClient", "Create", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreatePreparer prepares the Create request.
func (client SubAccountClient) CreatePreparer(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, body *MonitorResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"monitorName":       autorest.Encode("path", monitorName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subAccountName":    autorest.Encode("path", subAccountName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	body.ID = nil
	body.SystemData = nil
	body.Name = nil
	body.Type = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/accounts/{subAccountName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if body != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithJSON(body))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateSender sends the Create request. The method will close the
// http.Response Body if it receives an error.
func (client SubAccountClient) CreateSender(req *http.Request) (future SubAccountCreateFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreateResponder handles the response to the Create request. The method always
// closes the http.Response Body.
func (client SubAccountClient) CreateResponder(resp *http.Response) (result MonitorResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete sends the delete request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// monitorName - monitor resource name
// subAccountName - sub Account resource name
func (client SubAccountClient) Delete(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string) (result SubAccountDeleteFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubAccountClient.Delete")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("logz.SubAccountClient", "Delete", err.Error())
	}

	req, err := client.DeletePreparer(ctx, resourceGroupName, monitorName, subAccountName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.SubAccountClient", "Delete", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.SubAccountClient", "Delete", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client SubAccountClient) DeletePreparer(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"monitorName":       autorest.Encode("path", monitorName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subAccountName":    autorest.Encode("path", subAccountName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/accounts/{subAccountName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client SubAccountClient) DeleteSender(req *http.Request) (future SubAccountDeleteFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client SubAccountClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get sends the get request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// monitorName - monitor resource name
// subAccountName - sub Account resource name
func (client SubAccountClient) Get(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string) (result MonitorResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubAccountClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("logz.SubAccountClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, resourceGroupName, monitorName, subAccountName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.SubAccountClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "logz.SubAccountClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.SubAccountClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client SubAccountClient) GetPreparer(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"monitorName":       autorest.Encode("path", monitorName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subAccountName":    autorest.Encode("path", subAccountName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/accounts/{subAccountName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client SubAccountClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client SubAccountClient) GetResponder(resp *http.Response) (result MonitorResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List sends the list request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// monitorName - monitor resource name
func (client SubAccountClient) List(ctx context.Context, resourceGroupName string, monitorName string) (result MonitorResourceListResponsePage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubAccountClient.List")
		defer func() {
			sc := -1
			if result.mrlr.Response.Response != nil {
				sc = result.mrlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("logz.SubAccountClient", "List", err.Error())
	}

	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, resourceGroupName, monitorName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.SubAccountClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.mrlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "logz.SubAccountClient", "List", resp, "Failure sending request")
		return
	}

	result.mrlr, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.SubAccountClient", "List", resp, "Failure responding to request")
		return
	}
	if result.mrlr.hasNextLink() && result.mrlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client SubAccountClient) ListPreparer(ctx context.Context, resourceGroupName string, monitorName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"monitorName":       autorest.Encode("path", monitorName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/accounts", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client SubAccountClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client SubAccountClient) ListResponder(resp *http.Response) (result MonitorResourceListResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client SubAccountClient) listNextResults(ctx context.Context, lastResults MonitorResourceListResponse) (result MonitorResourceListResponse, err error) {
	req, err := lastResults.monitorResourceListResponsePreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "logz.SubAccountClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "logz.SubAccountClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.SubAccountClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client SubAccountClient) ListComplete(ctx context.Context, resourceGroupName string, monitorName string) (result MonitorResourceListResponseIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubAccountClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx, resourceGroupName, monitorName)
	return
}

// ListMonitoredResources sends the list monitored resources request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// monitorName - monitor resource name
// subAccountName - sub Account resource name
func (client SubAccountClient) ListMonitoredResources(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string) (result MonitoredResourceListResponsePage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubAccountClient.ListMonitoredResources")
		defer func() {
			sc := -1
			if result.mrlr.Response.Response != nil {
				sc = result.mrlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("logz.SubAccountClient", "ListMonitoredResources", err.Error())
	}

	result.fn = client.listMonitoredResourcesNextResults
	req, err := client.ListMonitoredResourcesPreparer(ctx, resourceGroupName, monitorName, subAccountName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.SubAccountClient", "ListMonitoredResources", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMonitoredResourcesSender(req)
	if err != nil {
		result.mrlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "logz.SubAccountClient", "ListMonitoredResources", resp, "Failure sending request")
		return
	}

	result.mrlr, err = client.ListMonitoredResourcesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.SubAccountClient", "ListMonitoredResources", resp, "Failure responding to request")
		return
	}
	if result.mrlr.hasNextLink() && result.mrlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListMonitoredResourcesPreparer prepares the ListMonitoredResources request.
func (client SubAccountClient) ListMonitoredResourcesPreparer(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"monitorName":       autorest.Encode("path", monitorName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subAccountName":    autorest.Encode("path", subAccountName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/accounts/{subAccountName}/listMonitoredResources", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListMonitoredResourcesSender sends the ListMonitoredResources request. The method will close the
// http.Response Body if it receives an error.
func (client SubAccountClient) ListMonitoredResourcesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListMonitoredResourcesResponder handles the response to the ListMonitoredResources request. The method always
// closes the http.Response Body.
func (client SubAccountClient) ListMonitoredResourcesResponder(resp *http.Response) (result MonitoredResourceListResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listMonitoredResourcesNextResults retrieves the next set of results, if any.
func (client SubAccountClient) listMonitoredResourcesNextResults(ctx context.Context, lastResults MonitoredResourceListResponse) (result MonitoredResourceListResponse, err error) {
	req, err := lastResults.monitoredResourceListResponsePreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "logz.SubAccountClient", "listMonitoredResourcesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListMonitoredResourcesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "logz.SubAccountClient", "listMonitoredResourcesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListMonitoredResourcesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.SubAccountClient", "listMonitoredResourcesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListMonitoredResourcesComplete enumerates all values, automatically crossing page boundaries as required.
func (client SubAccountClient) ListMonitoredResourcesComplete(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string) (result MonitoredResourceListResponseIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubAccountClient.ListMonitoredResources")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListMonitoredResources(ctx, resourceGroupName, monitorName, subAccountName)
	return
}

// ListVMHosts sends the list vm hosts request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// monitorName - monitor resource name
// subAccountName - sub Account resource name
func (client SubAccountClient) ListVMHosts(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string) (result VMResourcesListResponsePage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubAccountClient.ListVMHosts")
		defer func() {
			sc := -1
			if result.vrlr.Response.Response != nil {
				sc = result.vrlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("logz.SubAccountClient", "ListVMHosts", err.Error())
	}

	result.fn = client.listVMHostsNextResults
	req, err := client.ListVMHostsPreparer(ctx, resourceGroupName, monitorName, subAccountName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.SubAccountClient", "ListVMHosts", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListVMHostsSender(req)
	if err != nil {
		result.vrlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "logz.SubAccountClient", "ListVMHosts", resp, "Failure sending request")
		return
	}

	result.vrlr, err = client.ListVMHostsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.SubAccountClient", "ListVMHosts", resp, "Failure responding to request")
		return
	}
	if result.vrlr.hasNextLink() && result.vrlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListVMHostsPreparer prepares the ListVMHosts request.
func (client SubAccountClient) ListVMHostsPreparer(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"monitorName":       autorest.Encode("path", monitorName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subAccountName":    autorest.Encode("path", subAccountName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/accounts/{subAccountName}/listVMHosts", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListVMHostsSender sends the ListVMHosts request. The method will close the
// http.Response Body if it receives an error.
func (client SubAccountClient) ListVMHostsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListVMHostsResponder handles the response to the ListVMHosts request. The method always
// closes the http.Response Body.
func (client SubAccountClient) ListVMHostsResponder(resp *http.Response) (result VMResourcesListResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listVMHostsNextResults retrieves the next set of results, if any.
func (client SubAccountClient) listVMHostsNextResults(ctx context.Context, lastResults VMResourcesListResponse) (result VMResourcesListResponse, err error) {
	req, err := lastResults.vMResourcesListResponsePreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "logz.SubAccountClient", "listVMHostsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListVMHostsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "logz.SubAccountClient", "listVMHostsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListVMHostsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.SubAccountClient", "listVMHostsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListVMHostsComplete enumerates all values, automatically crossing page boundaries as required.
func (client SubAccountClient) ListVMHostsComplete(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string) (result VMResourcesListResponseIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubAccountClient.ListVMHosts")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListVMHosts(ctx, resourceGroupName, monitorName, subAccountName)
	return
}

// ListVMHostUpdate sends the list vm host update request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// monitorName - monitor resource name
// subAccountName - sub Account resource name
// body - request body to update the collection for agent installed in the given monitor.
func (client SubAccountClient) ListVMHostUpdate(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, body *VMHostUpdateRequest) (result VMResourcesListResponsePage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubAccountClient.ListVMHostUpdate")
		defer func() {
			sc := -1
			if result.vrlr.Response.Response != nil {
				sc = result.vrlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("logz.SubAccountClient", "ListVMHostUpdate", err.Error())
	}

	result.fn = client.listVMHostUpdateNextResults
	req, err := client.ListVMHostUpdatePreparer(ctx, resourceGroupName, monitorName, subAccountName, body)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.SubAccountClient", "ListVMHostUpdate", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListVMHostUpdateSender(req)
	if err != nil {
		result.vrlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "logz.SubAccountClient", "ListVMHostUpdate", resp, "Failure sending request")
		return
	}

	result.vrlr, err = client.ListVMHostUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.SubAccountClient", "ListVMHostUpdate", resp, "Failure responding to request")
		return
	}
	if result.vrlr.hasNextLink() && result.vrlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListVMHostUpdatePreparer prepares the ListVMHostUpdate request.
func (client SubAccountClient) ListVMHostUpdatePreparer(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, body *VMHostUpdateRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"monitorName":       autorest.Encode("path", monitorName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subAccountName":    autorest.Encode("path", subAccountName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/accounts/{subAccountName}/vmHostUpdate", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if body != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithJSON(body))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListVMHostUpdateSender sends the ListVMHostUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client SubAccountClient) ListVMHostUpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListVMHostUpdateResponder handles the response to the ListVMHostUpdate request. The method always
// closes the http.Response Body.
func (client SubAccountClient) ListVMHostUpdateResponder(resp *http.Response) (result VMResourcesListResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listVMHostUpdateNextResults retrieves the next set of results, if any.
func (client SubAccountClient) listVMHostUpdateNextResults(ctx context.Context, lastResults VMResourcesListResponse) (result VMResourcesListResponse, err error) {
	req, err := lastResults.vMResourcesListResponsePreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "logz.SubAccountClient", "listVMHostUpdateNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListVMHostUpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "logz.SubAccountClient", "listVMHostUpdateNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListVMHostUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.SubAccountClient", "listVMHostUpdateNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListVMHostUpdateComplete enumerates all values, automatically crossing page boundaries as required.
func (client SubAccountClient) ListVMHostUpdateComplete(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, body *VMHostUpdateRequest) (result VMResourcesListResponseIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubAccountClient.ListVMHostUpdate")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListVMHostUpdate(ctx, resourceGroupName, monitorName, subAccountName, body)
	return
}

// Update sends the update request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// monitorName - monitor resource name
// subAccountName - sub Account resource name
func (client SubAccountClient) Update(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, body *MonitorResourceUpdateParameters) (result MonitorResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubAccountClient.Update")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("logz.SubAccountClient", "Update", err.Error())
	}

	req, err := client.UpdatePreparer(ctx, resourceGroupName, monitorName, subAccountName, body)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.SubAccountClient", "Update", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "logz.SubAccountClient", "Update", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.SubAccountClient", "Update", resp, "Failure responding to request")
		return
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client SubAccountClient) UpdatePreparer(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, body *MonitorResourceUpdateParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"monitorName":       autorest.Encode("path", monitorName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subAccountName":    autorest.Encode("path", subAccountName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/accounts/{subAccountName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if body != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithJSON(body))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client SubAccountClient) UpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client SubAccountClient) UpdateResponder(resp *http.Response) (result MonitorResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// VMHostPayload sends the vm host payload request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// monitorName - monitor resource name
// subAccountName - sub Account resource name
func (client SubAccountClient) VMHostPayload(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string) (result VMExtensionPayload, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubAccountClient.VMHostPayload")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("logz.SubAccountClient", "VMHostPayload", err.Error())
	}

	req, err := client.VMHostPayloadPreparer(ctx, resourceGroupName, monitorName, subAccountName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.SubAccountClient", "VMHostPayload", nil, "Failure preparing request")
		return
	}

	resp, err := client.VMHostPayloadSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "logz.SubAccountClient", "VMHostPayload", resp, "Failure sending request")
		return
	}

	result, err = client.VMHostPayloadResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.SubAccountClient", "VMHostPayload", resp, "Failure responding to request")
		return
	}

	return
}

// VMHostPayloadPreparer prepares the VMHostPayload request.
func (client SubAccountClient) VMHostPayloadPreparer(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"monitorName":       autorest.Encode("path", monitorName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subAccountName":    autorest.Encode("path", subAccountName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/accounts/{subAccountName}/vmHostPayload", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// VMHostPayloadSender sends the VMHostPayload request. The method will close the
// http.Response Body if it receives an error.
func (client SubAccountClient) VMHostPayloadSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// VMHostPayloadResponder handles the response to the VMHostPayload request. The method always
// closes the http.Response Body.
func (client SubAccountClient) VMHostPayloadResponder(resp *http.Response) (result VMExtensionPayload, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
