// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// AgentRunnerSession agent runner session
//
// swagger:model agentRunnerSession
type AgentRunnerSession struct {

	// agent config
	AgentConfig *AgentRunnerSessionConfig `json:"agent_config,omitempty"`

	// agent runner id
	AgentRunnerID string `json:"agent_runner_id,omitempty"`

	// attached file keys
	AttachedFileKeys []string `json:"attached_file_keys"`

	// commit sha
	CommitSha string `json:"commit_sha,omitempty"`

	// created at
	CreatedAt string `json:"created_at,omitempty"`

	// deploy id
	DeployID string `json:"deploy_id,omitempty"`

	// deploy url
	DeployURL string `json:"deploy_url,omitempty"`

	// dev server id
	DevServerID string `json:"dev_server_id,omitempty"`

	// done at
	DoneAt string `json:"done_at,omitempty"`

	// duration
	Duration int64 `json:"duration,omitempty"`

	// id
	ID string `json:"id,omitempty"`

	// is published
	IsPublished bool `json:"is_published,omitempty"`

	// prompt
	Prompt string `json:"prompt,omitempty"`

	// result
	Result string `json:"result,omitempty"`

	// result diff
	ResultDiff string `json:"result_diff,omitempty"`

	// result zip file name
	ResultZipFileName string `json:"result_zip_file_name,omitempty"`

	// state
	State string `json:"state,omitempty"`

	// steps
	Steps []*AgentRunnerSessionStep `json:"steps"`

	// title
	Title string `json:"title,omitempty"`

	// updated at
	UpdatedAt string `json:"updated_at,omitempty"`

	// user
	User *AgentRunnerUser `json:"user,omitempty"`
}

// Validate validates this agent runner session
func (m *AgentRunnerSession) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAgentConfig(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSteps(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUser(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AgentRunnerSession) validateAgentConfig(formats strfmt.Registry) error {

	if swag.IsZero(m.AgentConfig) { // not required
		return nil
	}

	if m.AgentConfig != nil {
		if err := m.AgentConfig.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("agent_config")
			}
			return err
		}
	}

	return nil
}

func (m *AgentRunnerSession) validateSteps(formats strfmt.Registry) error {

	if swag.IsZero(m.Steps) { // not required
		return nil
	}

	for i := 0; i < len(m.Steps); i++ {
		if swag.IsZero(m.Steps[i]) { // not required
			continue
		}

		if m.Steps[i] != nil {
			if err := m.Steps[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("steps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *AgentRunnerSession) validateUser(formats strfmt.Registry) error {

	if swag.IsZero(m.User) { // not required
		return nil
	}

	if m.User != nil {
		if err := m.User.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("user")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AgentRunnerSession) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AgentRunnerSession) UnmarshalBinary(b []byte) error {
	var res AgentRunnerSession
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
