
:- document_export inClass/3.

:- document_import tp_subclass/2 from cdftp_cdfsc.
:- document_import abduced/2 from cdftp_meta.

:- import length/2 from basics.

inClass(','(C1,C2),Elt,Abd):- !,
	inClass(C1,Elt,Abd),
	inClass(C2,Elt,Abd).
inClass(';'(C1,C2),Elt,Abd):- !,
	(inClass(C1,Elt,Abd)
	 ; 
	 inClass(C2,Elt,Abd)).
inClass(exists(inv(Rel),C),Elt,Abd):- !, 
	abduced(rel(E1,R1,Elt),Abd),
	tp_subclass(R1,Rel),
	inClass( C,E1,Abd).
inClass(exists(Rel,C),Elt,Abd):- !, 
	abduced(rel(Elt,R1,E1),Abd),
	tp_subclass(R1,Rel),
	inClass( C,E1,Abd).
inClass(all(Rel,C),Elt,Abd):- !,
	\+ (abduced(rel(Elt,R1,E1),Abd),
	    tp_subclass(R1,Rel)) 
	; 
	\+ (abduced(rel(Elt,R1,E1),Abd),
	    tp_subclass(R1,Rel),
	    \+ inClass(C,E1,_)).
inClass(all(inv(Rel),C),Elt,Abd):- !,
	\+ (abduced(rel(E1,R1,Elt),Abd),
	    tp_subclass(R1,Rel)) 
	; 
	\+ (abduced(rel(E1,R1,Elt),Abd),
	    tp_subclass(R1,Rel),
	    \+ inClass(C,E1,_)).
inClass(not(Class),Elt,Abd):- !,
	inClassNot(Class,Elt,Abd).
inClass(atMost(N,inv(Rel),C),Elt,Abd):- !, 
	findall(E1,(abduced_subrel(rel(E1,Rel,Elt),Abd),
	                inClass(C,E1,Abd)),EltList),
            length(EltList,M),
	M =< N.
inClass(atMost(N,Rel,C),Elt,Abd):- !, 
	findall(E1,(abduced_subrel(rel(Elt,Rel,E1),Abd),
	                inClass(C,E1,Abd)),EltList),
            length(EltList,M),
	M =< N.
inClass(atLeast(N,inv(Rel),C),Elt,Abd):- !, 
	findall(E1,(abduced_subrel(rel(E1,Rel,Elt),Abd),
	                inClass(C,E1,Abd)),EltList),
            length(EltList,M),
	M >= N.
inClass(atLeast(N,Rel,C),Elt,Abd):- !, 
	findall(E1,(abduced_subrel(rel(Elt,Rel,E1),Abd),
	                inClass(C,E1,Abd)),EltList),
            length(EltList,M),
	M >= N.
inClass(sameAs(R1,C1,R2,C2),Elt,Abd):- !, 
	findall(E1,(abduced_subrel(rel(Elt,R1,E1),Abd),
	                inClass(C1,E1,Abd)),El1),
	sort(El1,El1s),
	findall(E2,(abduced_subrel(rel(Elt,R2,E2),Abd),
	                inClass(C2,E2,Abd)),El2),
	sort(El2,El2s),
	El1s = El2s.
inClass(differentFrom(R1,C1,R2,C2),Elt,Abd):- !, 
	findall(E1,(abduced_subrel(rel(Elt,R1,E1),Abd),
	                inClass(C1,E1,Abd)),El1),
	sort(El1,El1s),
	findall(E2,(abduced_subrel(rel(Elt,R2,E2),Abd),
	                inClass(C2,E2,Abd)),El2),
	sort(El2,El2s),
	El1s \== El2s.
inClass(cid('CDF Classes',cdf),_Elt,_Abd):- !.
inClass(cid(emptyset,cdf),_Elt,_Abd):- !,fail.
inClass(Class,Elt,Abd):-
	abduced(elt(Elt,C1),Abd),
	tp_subclass(C1,Class).

inClassNot(','(C1,C2),Elt,Abd):- !,
	inClassNot(C1,Elt,Abd),
	inClassNot(C2,Elt,Abd).
inClassNot(';'(C1,C2),Elt,Abd):- !,
	(inClassNot(C1,Elt,Abd)
	 ; 
	 inClassNot(C2,Elt,Abd)).
inClassNot(exists(Rel,C),Elt,Abd):- !, 
	inClass(all(Rel,not(C)),Elt,Abd).
inClassNot(all(Rel,C),Elt,Abd):- !, 
	inClass(exists(Rel,not(C)),Elt,Abd).
inClassNot(sameAs(R1,C1,R2,C2),Elt,Abd):-
	inClass(differentFrom(R1,C1,R2,C2),Elt,Abd).
inClassNot(not(Class),Elt,Abd):-
	inClass(Class,Elt,Abd).
inClassNot(cid('CDF Classes',cdf),_Elt,_Abd):- !,fail.
inClassNot(cid(emptyset,cdf),_Elt,_Abd):- !.
inClassNot(Class,Elt,Abd):-
	\+ inClass(Class,Elt,Abd).

