:- compiler_options([xpp_on]).

:- export cdf_message/1, cdf_warning/2.  
             
:- import  message/2,messageln/2 from standard.

#include "flag_defs_xsb.h"
#include "standard.h"

:- import using_xj/0 from usermod.

:- comment(module,"This module was originally designed to handle
different kinds of ""exceptions"" that arise in execution of CDF.  In
CDF, a distinction is made between errors that are thrown to the
nearest catcher, and warnings in which an action is taken (usually
writing a message out to the console or a log along with possibly
failing.

Errors per se in cdf are best handled using the mechanisms for
throwing errors as described in the XSB manual.  @module{cdf_config}
contains a rule for @pred{default_user_error_handler/2}, which checks
to see if the dynamic preicate @tt{using_xj/0} has been defined.  If
not, a message rris written to XSB's standard warning stream.  If so,
a message is displayed via a GUI window.").

:- comment(cdf_message/1,"The predicate @tt{cdf_message(List)} writes
a message either to the CDF log or to the XSBs standard message
stream.").

cdf_message(List):- 
	(using_xj -> 
	    cdf_message_xj(List)
	  ;
	    cdf_message_noxj(List)).

cdf_message_noxj(Message):- 
	messageln(Message, STDWARN).

% Shd probably use logger.
cdf_message_xj(Message):- 
	messageln(Message, STDWARN).

:- comment(cdf_warning/2,"cdf_arning can be used to handle warnings of
different types -- currently @tt{consistency_warning} and
@tt{update_warning}.  Actions taken depend on whether
@pred{using_xj/0} is defined or not.").

cdf_warning(Type,List):- 
	(using_xj -> 
	    cdf_warning_xj(Type,List)
	  ;
	    cdf_warning_noxj(Type,List)).

cdf_warning_noxj(Type,Message):- 
	message('++Warning[CDF]: ', STDWARN),
	message((' '(Type),' '), STDWARN),
	messageln(Message, STDWARN).

cdf_warning_xj(Type,Message):- 
	message('++Warning[CDF(XJ)]: ', STDWARN),
	message((' '(Type),' '), STDWARN),
	messageln(Message, STDWARN).
