#ifndef ATL_ztGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,103,182,221,261,300,340,379,419,458,498,577,656,972,1288,1327,1367,1406,1446,1525,1604,1762,1920,2236,2552,3816,5080
 * N : 25,103,182,221,261,300,340,379,419,458,498,577,656,972,1288,1327,1367,1406,1446,1525,1604,1762,1920,2236,2552,3816,5080
 * NB : 1,1,6,18,22,26,27,29,30,38,39,41,43,43,67,68,69,69,75,75,87,87,91,95,112,120,280
 */
#define ATL_ztGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 142) (nb_) = 1; \
   else if ((n_) < 201) (nb_) = 6; \
   else if ((n_) < 241) (nb_) = 18; \
   else if ((n_) < 280) (nb_) = 22; \
   else if ((n_) < 320) (nb_) = 26; \
   else if ((n_) < 359) (nb_) = 27; \
   else if ((n_) < 399) (nb_) = 29; \
   else if ((n_) < 438) (nb_) = 30; \
   else if ((n_) < 478) (nb_) = 38; \
   else if ((n_) < 537) (nb_) = 39; \
   else if ((n_) < 616) (nb_) = 41; \
   else if ((n_) < 1130) (nb_) = 43; \
   else if ((n_) < 1307) (nb_) = 67; \
   else if ((n_) < 1347) (nb_) = 68; \
   else if ((n_) < 1426) (nb_) = 69; \
   else if ((n_) < 1564) (nb_) = 75; \
   else if ((n_) < 1841) (nb_) = 87; \
   else if ((n_) < 2078) (nb_) = 91; \
   else if ((n_) < 2394) (nb_) = 95; \
   else if ((n_) < 3184) (nb_) = 112; \
   else if ((n_) < 4448) (nb_) = 120; \
   else (nb_) = 280; \
}


#endif    /* end ifndef ATL_ztGetNB_geqrf */
