#ifndef ATL_dtGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,102,180,219,258,297,336,375,414,453,492,570,609,648,803,881,959,1037,1115,1193,1271,1348,1426,1504,1582,1621,1660,1699,1738,1816,1894,2050,2206,2362,2518,2829,2985,3141,3453,3765,4388,5012,5323,5635,5791,5947,6103,6259,6882,7506,8753,10000
 * N : 25,102,180,219,258,297,336,375,414,453,492,570,609,648,803,881,959,1037,1115,1193,1271,1348,1426,1504,1582,1621,1660,1699,1738,1816,1894,2050,2206,2362,2518,2829,2985,3141,3453,3765,4388,5012,5323,5635,5791,5947,6103,6259,6882,7506,8753,10000
 * NB : 1,1,7,6,15,16,19,59,75,79,83,78,98,99,96,96,111,111,112,112,115,115,116,116,118,122,124,124,126,126,127,127,128,128,131,128,140,146,142,211,211,216,216,272,273,274,274,280,284,296,340,425
 */
#define ATL_dtGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 141) (nb_) = 1; \
   else if ((n_) < 199) (nb_) = 7; \
   else if ((n_) < 238) (nb_) = 6; \
   else if ((n_) < 277) (nb_) = 15; \
   else if ((n_) < 316) (nb_) = 16; \
   else if ((n_) < 355) (nb_) = 19; \
   else if ((n_) < 394) (nb_) = 59; \
   else if ((n_) < 433) (nb_) = 75; \
   else if ((n_) < 472) (nb_) = 79; \
   else if ((n_) < 531) (nb_) = 83; \
   else if ((n_) < 589) (nb_) = 78; \
   else if ((n_) < 628) (nb_) = 98; \
   else if ((n_) < 725) (nb_) = 99; \
   else if ((n_) < 920) (nb_) = 96; \
   else if ((n_) < 1076) (nb_) = 111; \
   else if ((n_) < 1232) (nb_) = 112; \
   else if ((n_) < 1387) (nb_) = 115; \
   else if ((n_) < 1543) (nb_) = 116; \
   else if ((n_) < 1601) (nb_) = 118; \
   else if ((n_) < 1640) (nb_) = 122; \
   else if ((n_) < 1718) (nb_) = 124; \
   else if ((n_) < 1855) (nb_) = 126; \
   else if ((n_) < 2128) (nb_) = 127; \
   else if ((n_) < 2440) (nb_) = 128; \
   else if ((n_) < 2673) (nb_) = 131; \
   else if ((n_) < 2907) (nb_) = 128; \
   else if ((n_) < 3063) (nb_) = 140; \
   else if ((n_) < 3297) (nb_) = 146; \
   else if ((n_) < 3609) (nb_) = 142; \
   else if ((n_) < 4700) (nb_) = 211; \
   else if ((n_) < 5479) (nb_) = 216; \
   else if ((n_) < 5713) (nb_) = 272; \
   else if ((n_) < 5869) (nb_) = 273; \
   else if ((n_) < 6181) (nb_) = 274; \
   else if ((n_) < 6570) (nb_) = 280; \
   else if ((n_) < 7194) (nb_) = 284; \
   else if ((n_) < 8129) (nb_) = 296; \
   else if ((n_) < 9376) (nb_) = 340; \
   else (nb_) = 425; \
}


#endif    /* end ifndef ATL_dtGetNB_geqrf */
