#ifndef ATL_stGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,180,336,375,414,453,492,570,648,725,803,842,881,920,959,1037,1115,1154,1193,1232,1271,1582,1894,2206,2518,3765,5012,7506,10000
 * N : 25,180,336,375,414,453,492,570,648,725,803,842,881,920,959,1037,1115,1154,1193,1232,1271,1582,1894,2206,2518,3765,5012,7506,10000
 * NB : 1,1,18,50,58,60,82,82,83,84,85,86,89,90,91,91,92,92,93,95,99,99,115,109,163,179,195,243,291
 */
#define ATL_stGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 258) (nb_) = 1; \
   else if ((n_) < 355) (nb_) = 18; \
   else if ((n_) < 394) (nb_) = 50; \
   else if ((n_) < 433) (nb_) = 58; \
   else if ((n_) < 472) (nb_) = 60; \
   else if ((n_) < 609) (nb_) = 82; \
   else if ((n_) < 686) (nb_) = 83; \
   else if ((n_) < 764) (nb_) = 84; \
   else if ((n_) < 822) (nb_) = 85; \
   else if ((n_) < 861) (nb_) = 86; \
   else if ((n_) < 900) (nb_) = 89; \
   else if ((n_) < 939) (nb_) = 90; \
   else if ((n_) < 1076) (nb_) = 91; \
   else if ((n_) < 1173) (nb_) = 92; \
   else if ((n_) < 1212) (nb_) = 93; \
   else if ((n_) < 1251) (nb_) = 95; \
   else if ((n_) < 1738) (nb_) = 99; \
   else if ((n_) < 2050) (nb_) = 115; \
   else if ((n_) < 2362) (nb_) = 109; \
   else if ((n_) < 3141) (nb_) = 163; \
   else if ((n_) < 4388) (nb_) = 179; \
   else if ((n_) < 6259) (nb_) = 195; \
   else if ((n_) < 8753) (nb_) = 243; \
   else (nb_) = 291; \
}


#endif    /* end ifndef ATL_stGetNB_geqrf */
