// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Specifies an inventory filter. The inventory only includes objects that meet the filter's criteria.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct InventoryFilter {
    /// <p>The prefix that an object must have to be included in the inventory results.</p>
    pub prefix: ::std::string::String,
}
impl InventoryFilter {
    /// <p>The prefix that an object must have to be included in the inventory results.</p>
    pub fn prefix(&self) -> &str {
        use std::ops::Deref;
        self.prefix.deref()
    }
}
impl InventoryFilter {
    /// Creates a new builder-style object to manufacture [`InventoryFilter`](crate::types::InventoryFilter).
    pub fn builder() -> crate::types::builders::InventoryFilterBuilder {
        crate::types::builders::InventoryFilterBuilder::default()
    }
}

/// A builder for [`InventoryFilter`](crate::types::InventoryFilter).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct InventoryFilterBuilder {
    pub(crate) prefix: ::std::option::Option<::std::string::String>,
}
impl InventoryFilterBuilder {
    /// <p>The prefix that an object must have to be included in the inventory results.</p>
    /// This field is required.
    pub fn prefix(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.prefix = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The prefix that an object must have to be included in the inventory results.</p>
    pub fn set_prefix(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.prefix = input;
        self
    }
    /// <p>The prefix that an object must have to be included in the inventory results.</p>
    pub fn get_prefix(&self) -> &::std::option::Option<::std::string::String> {
        &self.prefix
    }
    /// Consumes the builder and constructs a [`InventoryFilter`](crate::types::InventoryFilter).
    /// This method will fail if any of the following fields are not set:
    /// - [`prefix`](crate::types::builders::InventoryFilterBuilder::prefix)
    pub fn build(self) -> ::std::result::Result<crate::types::InventoryFilter, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::InventoryFilter {
            prefix: self.prefix.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "prefix",
                    "prefix was not specified but it is required when building InventoryFilter",
                )
            })?,
        })
    }
}
