// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The metadata table configuration for a general purpose bucket.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct GetBucketMetadataTableConfigurationResult {
    /// <p>The metadata table configuration for a general purpose bucket.</p>
    pub metadata_table_configuration_result: ::std::option::Option<crate::types::MetadataTableConfigurationResult>,
    /// <p>The status of the metadata table. The status values are:</p>
    /// <ul>
    /// <li>
    /// <p><code>CREATING</code> - The metadata table is in the process of being created in the specified table bucket.</p></li>
    /// <li>
    /// <p><code>ACTIVE</code> - The metadata table has been created successfully and records are being delivered to the table.</p></li>
    /// <li>
    /// <p><code>FAILED</code> - Amazon S3 is unable to create the metadata table, or Amazon S3 is unable to deliver records. See <code>ErrorDetails</code> for details.</p></li>
    /// </ul>
    pub status: ::std::string::String,
    /// <p>If the <code>CreateBucketMetadataTableConfiguration</code> request succeeds, but S3 Metadata was unable to create the table, this structure contains the error code and error message.</p>
    pub error: ::std::option::Option<crate::types::ErrorDetails>,
}
impl GetBucketMetadataTableConfigurationResult {
    /// <p>The metadata table configuration for a general purpose bucket.</p>
    pub fn metadata_table_configuration_result(&self) -> ::std::option::Option<&crate::types::MetadataTableConfigurationResult> {
        self.metadata_table_configuration_result.as_ref()
    }
    /// <p>The status of the metadata table. The status values are:</p>
    /// <ul>
    /// <li>
    /// <p><code>CREATING</code> - The metadata table is in the process of being created in the specified table bucket.</p></li>
    /// <li>
    /// <p><code>ACTIVE</code> - The metadata table has been created successfully and records are being delivered to the table.</p></li>
    /// <li>
    /// <p><code>FAILED</code> - Amazon S3 is unable to create the metadata table, or Amazon S3 is unable to deliver records. See <code>ErrorDetails</code> for details.</p></li>
    /// </ul>
    pub fn status(&self) -> &str {
        use std::ops::Deref;
        self.status.deref()
    }
    /// <p>If the <code>CreateBucketMetadataTableConfiguration</code> request succeeds, but S3 Metadata was unable to create the table, this structure contains the error code and error message.</p>
    pub fn error(&self) -> ::std::option::Option<&crate::types::ErrorDetails> {
        self.error.as_ref()
    }
}
impl GetBucketMetadataTableConfigurationResult {
    /// Creates a new builder-style object to manufacture [`GetBucketMetadataTableConfigurationResult`](crate::types::GetBucketMetadataTableConfigurationResult).
    pub fn builder() -> crate::types::builders::GetBucketMetadataTableConfigurationResultBuilder {
        crate::types::builders::GetBucketMetadataTableConfigurationResultBuilder::default()
    }
}

/// A builder for [`GetBucketMetadataTableConfigurationResult`](crate::types::GetBucketMetadataTableConfigurationResult).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct GetBucketMetadataTableConfigurationResultBuilder {
    pub(crate) metadata_table_configuration_result: ::std::option::Option<crate::types::MetadataTableConfigurationResult>,
    pub(crate) status: ::std::option::Option<::std::string::String>,
    pub(crate) error: ::std::option::Option<crate::types::ErrorDetails>,
}
impl GetBucketMetadataTableConfigurationResultBuilder {
    /// <p>The metadata table configuration for a general purpose bucket.</p>
    /// This field is required.
    pub fn metadata_table_configuration_result(mut self, input: crate::types::MetadataTableConfigurationResult) -> Self {
        self.metadata_table_configuration_result = ::std::option::Option::Some(input);
        self
    }
    /// <p>The metadata table configuration for a general purpose bucket.</p>
    pub fn set_metadata_table_configuration_result(mut self, input: ::std::option::Option<crate::types::MetadataTableConfigurationResult>) -> Self {
        self.metadata_table_configuration_result = input;
        self
    }
    /// <p>The metadata table configuration for a general purpose bucket.</p>
    pub fn get_metadata_table_configuration_result(&self) -> &::std::option::Option<crate::types::MetadataTableConfigurationResult> {
        &self.metadata_table_configuration_result
    }
    /// <p>The status of the metadata table. The status values are:</p>
    /// <ul>
    /// <li>
    /// <p><code>CREATING</code> - The metadata table is in the process of being created in the specified table bucket.</p></li>
    /// <li>
    /// <p><code>ACTIVE</code> - The metadata table has been created successfully and records are being delivered to the table.</p></li>
    /// <li>
    /// <p><code>FAILED</code> - Amazon S3 is unable to create the metadata table, or Amazon S3 is unable to deliver records. See <code>ErrorDetails</code> for details.</p></li>
    /// </ul>
    /// This field is required.
    pub fn status(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.status = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The status of the metadata table. The status values are:</p>
    /// <ul>
    /// <li>
    /// <p><code>CREATING</code> - The metadata table is in the process of being created in the specified table bucket.</p></li>
    /// <li>
    /// <p><code>ACTIVE</code> - The metadata table has been created successfully and records are being delivered to the table.</p></li>
    /// <li>
    /// <p><code>FAILED</code> - Amazon S3 is unable to create the metadata table, or Amazon S3 is unable to deliver records. See <code>ErrorDetails</code> for details.</p></li>
    /// </ul>
    pub fn set_status(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.status = input;
        self
    }
    /// <p>The status of the metadata table. The status values are:</p>
    /// <ul>
    /// <li>
    /// <p><code>CREATING</code> - The metadata table is in the process of being created in the specified table bucket.</p></li>
    /// <li>
    /// <p><code>ACTIVE</code> - The metadata table has been created successfully and records are being delivered to the table.</p></li>
    /// <li>
    /// <p><code>FAILED</code> - Amazon S3 is unable to create the metadata table, or Amazon S3 is unable to deliver records. See <code>ErrorDetails</code> for details.</p></li>
    /// </ul>
    pub fn get_status(&self) -> &::std::option::Option<::std::string::String> {
        &self.status
    }
    /// <p>If the <code>CreateBucketMetadataTableConfiguration</code> request succeeds, but S3 Metadata was unable to create the table, this structure contains the error code and error message.</p>
    pub fn error(mut self, input: crate::types::ErrorDetails) -> Self {
        self.error = ::std::option::Option::Some(input);
        self
    }
    /// <p>If the <code>CreateBucketMetadataTableConfiguration</code> request succeeds, but S3 Metadata was unable to create the table, this structure contains the error code and error message.</p>
    pub fn set_error(mut self, input: ::std::option::Option<crate::types::ErrorDetails>) -> Self {
        self.error = input;
        self
    }
    /// <p>If the <code>CreateBucketMetadataTableConfiguration</code> request succeeds, but S3 Metadata was unable to create the table, this structure contains the error code and error message.</p>
    pub fn get_error(&self) -> &::std::option::Option<crate::types::ErrorDetails> {
        &self.error
    }
    /// Consumes the builder and constructs a [`GetBucketMetadataTableConfigurationResult`](crate::types::GetBucketMetadataTableConfigurationResult).
    /// This method will fail if any of the following fields are not set:
    /// - [`status`](crate::types::builders::GetBucketMetadataTableConfigurationResultBuilder::status)
    pub fn build(
        self,
    ) -> ::std::result::Result<crate::types::GetBucketMetadataTableConfigurationResult, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::GetBucketMetadataTableConfigurationResult {
            metadata_table_configuration_result: self.metadata_table_configuration_result,
            status: self.status.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "status",
                    "status was not specified but it is required when building GetBucketMetadataTableConfigurationResult",
                )
            })?,
            error: self.error,
        })
    }
}
