// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[non_exhaustive]
#[derive(Debug)]
pub struct SelectObjectContentEventStreamUnmarshaller;

impl SelectObjectContentEventStreamUnmarshaller {
    pub fn new() -> Self {
        SelectObjectContentEventStreamUnmarshaller
    }
}
impl ::aws_smithy_eventstream::frame::UnmarshallMessage for SelectObjectContentEventStreamUnmarshaller {
    type Output = crate::types::SelectObjectContentEventStream;
    type Error = crate::types::error::SelectObjectContentEventStreamError;
    fn unmarshall(
        &self,
        message: &::aws_smithy_types::event_stream::Message,
    ) -> std::result::Result<::aws_smithy_eventstream::frame::UnmarshalledMessage<Self::Output, Self::Error>, ::aws_smithy_eventstream::error::Error>
    {
        let response_headers = ::aws_smithy_eventstream::smithy::parse_response_headers(message)?;
        match response_headers.message_type.as_str() {
            "event" => match response_headers.smithy_type.as_str() {
                "Records" => {
                    let mut builder = crate::types::builders::RecordsEventBuilder::default();
                    let content_type = response_headers.content_type().unwrap_or_default();
                    if content_type != "application/octet-stream" {
                        return Err(::aws_smithy_eventstream::error::Error::unmarshalling(format!(
                            "expected :content-type to be 'application/octet-stream', but was '{}'",
                            content_type
                        )));
                    }
                    builder = builder.set_payload(Some(::aws_smithy_types::Blob::new(message.payload().as_ref())));
                    Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Event(
                        crate::types::SelectObjectContentEventStream::Records(builder.build()),
                    ))
                }
                "Stats" => {
                    let mut builder = crate::types::builders::StatsEventBuilder::default();
                    builder = builder.set_details(Some(
                        crate::protocol_serde::shape_stats_event::de_details(&message.payload()[..])
                            .map_err(|err| ::aws_smithy_eventstream::error::Error::unmarshalling(format!("failed to unmarshall details: {}", err)))?,
                    ));
                    Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Event(
                        crate::types::SelectObjectContentEventStream::Stats(builder.build()),
                    ))
                }
                "Progress" => {
                    let mut builder = crate::types::builders::ProgressEventBuilder::default();
                    builder = builder.set_details(Some(
                        crate::protocol_serde::shape_progress_event::de_details(&message.payload()[..])
                            .map_err(|err| ::aws_smithy_eventstream::error::Error::unmarshalling(format!("failed to unmarshall details: {}", err)))?,
                    ));
                    Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Event(
                        crate::types::SelectObjectContentEventStream::Progress(builder.build()),
                    ))
                }
                "Cont" => Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Event(
                    crate::types::SelectObjectContentEventStream::Cont(crate::types::ContinuationEvent::builder().build()),
                )),
                "End" => Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Event(
                    crate::types::SelectObjectContentEventStream::End(crate::types::EndEvent::builder().build()),
                )),
                _unknown_variant => Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Event(
                    crate::types::SelectObjectContentEventStream::Unknown,
                )),
            },
            "exception" => {
                let generic = match crate::protocol_serde::parse_event_stream_error_metadata(message.payload()) {
                    Ok(builder) => builder.build(),
                    Err(err) => {
                        return Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Error(
                            crate::types::error::SelectObjectContentEventStreamError::unhandled(err),
                        ))
                    }
                };
                Ok(::aws_smithy_eventstream::frame::UnmarshalledMessage::Error(
                    crate::types::error::SelectObjectContentEventStreamError::generic(generic),
                ))
            }
            value => {
                return Err(::aws_smithy_eventstream::error::Error::unmarshalling(format!(
                    "unrecognized :message-type: {}",
                    value
                )));
            }
        }
    }
}
