<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
	xmlns:xsd="http://www.w3.org/2001/XMLSchema"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns="http://lincity-ng.berlios.de/gui"
	version="1.0">

	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>

	<xsl:template match="/YesNoDialog">
		<xsl:call-template name="Dialog">
			<xsl:with-param name="image">warning.png</xsl:with-param>
			<xsl:with-param name="buttonbar">
				<xsl:call-template name="yesnobuttonbar"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

	<xsl:template match="/Invention">
		<xsl:call-template name="Dialog">
			<xsl:with-param name="title">New Invention</xsl:with-param>
			<xsl:with-param name="image">invention.png</xsl:with-param>
			<xsl:with-param name="buttonbar">
				<xsl:call-template name="okbuttonbar"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

	<xsl:template match="/OkDialog">
		<xsl:call-template name="Dialog">
			<xsl:with-param name="buttonbar">
				<xsl:call-template name="okbuttonbar"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

	<xsl:template match="/Dialog" name="Dialog">
		<xsl:param name="image"/>
		<xsl:param name="buttonbar"/>
		<xsl:param name="title"/>
		<xsl:comment>
WARNING: This file is automatically generated. Do not edit!
</xsl:comment>
		<xsl:element name="Window">
			<xsl:attribute name="border">
				<xsl:text>5</xsl:text>
			</xsl:attribute>
			<xsl:attribute name="titlesize">
				<xsl:text>25</xsl:text>
			</xsl:attribute>
			<xsl:choose>
				<xsl:when test="@width">
					<xsl:attribute name="width">
						<xsl:value-of select="@width"/>
					</xsl:attribute>
					<xsl:attribute name="height">
						<xsl:value-of select="@height"/>
					</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="width">
						<xsl:text>700</xsl:text>
					</xsl:attribute>
					<xsl:attribute name="height">
						<xsl:text>200</xsl:text>
					</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:attribute name="resizable">
				<xsl:choose>
					<xsl:when test="@resizable">
						<xsl:value-of select="@resizable"/>
					</xsl:when>
					<xsl:otherwise>no</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:if test="@name">
		        <xsl:attribute name="name">
				    <xsl:value-of select="@name"/>
				</xsl:attribute>
			</xsl:if>
			<title>
				<Document>
					<Paragraph style="title" translatable="yes" halign="center" name="DialogTitle">
						<xsl:choose>
							<xsl:when test="title/text()">
								<xsl:value-of select="title/text()"/>
							</xsl:when>
							<xsl:when test="$title">
								<xsl:copy-of select="$title"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:message>
									Dialog Title missing
								</xsl:message>
							</xsl:otherwise>
						</xsl:choose>
					</Paragraph>
				</Document>
			</title>
			<title-background>
				<Gradient from="#ff0000ff" to="#88776655" direction="left-right"/>
			</title-background>
			<background>
				<FilledRectangle color="#ffffffbb"/>
			</background>
			<contents>
				<TableLayout rows="2" cols="1">
					<rowsize row="2" fixed="50"/>
					<cell row="1" col="1">
						<xsl:choose>
							<xsl:when test="contents">
								<xsl:copy-of select="contents/*"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="MessageContents">
									<xsl:with-param name="image" select="$image"/>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</cell>
					<cell row="2" col="1">
						<xsl:choose>
							<xsl:when test="buttonbar">
								<xsl:copy-of select="buttonbar/*"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:copy-of select="$buttonbar"/>
							</xsl:otherwise>
						</xsl:choose>
					</cell>
				</TableLayout>
			</contents>
		</xsl:element>
	</xsl:template>

	<xsl:template name="MessageContents">
		<xsl:param name="image"/>
		<TableLayout rows="1" cols="2">
			<colsize col="1" fixed="95"/>
			<cell row="1" col="1">
				<xsl:element name="Image">
					<xsl:attribute name="src">
						<xsl:text>images/gui/dialogs/</xsl:text>
						<xsl:choose>
							<xsl:when test="image/text()">
								<xsl:value-of select="image/text()"/>
							</xsl:when>
							<xsl:when test="$image">
								<xsl:copy-of select="$image"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:message terminate="yes">
									Image missing
								</xsl:message>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</xsl:element>
			</cell>
			<cell row="1" col="2">
				<Document style="message">
					<xsl:if test="bold/text()">
						<p style="messagebold" translatable="yes">
							<xsl:value-of select="bold/text()"/>
						</p>
					</xsl:if>
					<xsl:for-each select="p">
						<xsl:copy>
							<xsl:attribute name="translatable">
								<xsl:text>yes</xsl:text>
							</xsl:attribute>
							<xsl:for-each select="@*">
								<xsl:copy/>
							</xsl:for-each>
							<xsl:value-of select="text()"/>
						</xsl:copy>
					</xsl:for-each>
					<p name="ExtraText"/>
				</Document>
			</cell>
		</TableLayout>
	</xsl:template>

	<xsl:template name="okbuttonbar">
		<TableLayout rows="1" cols="1">
			<cell row="1" col="1">
				<Button name="Ok">
					<text-caption style="dialogbutton" translatable="yes">Ok</text-caption>
					<image src="images/gui/dialogs/yesbutton.png"/>
					<image-hover src="images/gui/dialogs/yesbutton-hover.png"/>
					<image-clicked src="images/gui/dialogs/yesbutton-clicked.png"/>
				</Button>
			</cell>
		</TableLayout>
	</xsl:template>

	<xsl:template name="yesnobuttonbar">
		<TableLayout rows="1" cols="2">
			<cell row="1" col="1">
				<Button name="No">
					<text-caption style="dialogbutton" translatable="yes">No</text-caption>
					<image src="images/gui/dialogs/nobutton.png"/>
					<image-hover src="images/gui/dialogs/nobutton-hover.png"/>
					<image-clicked src="images/gui/dialogs/nobutton-clicked.png"/>
				</Button>
			</cell>
			<cell row="1" col="2">
				<Button name="Yes">
					<text-caption style="dialogbutton" translatable="yes">Yes</text-caption>
					<image src="images/gui/dialogs/yesbutton.png"/>
					<image-hover src="images/gui/dialogs/yesbutton-hover.png"/>
					<image-clicked src="images/gui/dialogs/yesbutton-clicked.png"/>
				</Button>
			</cell>
		</TableLayout>
	</xsl:template>
</xsl:stylesheet>
