// Copyright (c) 2023-2024 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

#ifndef ROCRAND_RNG_CONFIG_CONFIG_DEFAULTS_HPP_
#define ROCRAND_RNG_CONFIG_CONFIG_DEFAULTS_HPP_

#include "../config_types.hpp"

/* DO NOT EDIT THIS FILE
 * This file is automatically generated by `/scripts/config-tuning/generate_config_defaults.py`.
 */

namespace rocrand_impl::host
{

template<class T>
struct generator_config_defaults<ROCRAND_RNG_PSEUDO_XORWOW, T>
{
    static constexpr inline unsigned int threads = 256;
    static constexpr inline unsigned int blocks  = 512;
};

template<class T>
struct generator_config_defaults<ROCRAND_RNG_PSEUDO_MRG32K3A, T>
{
    static constexpr inline unsigned int threads = 256;
    static constexpr inline unsigned int blocks  = 512;
};

template<class T>
struct generator_config_defaults<ROCRAND_RNG_PSEUDO_MTGP32, T>
{
    static constexpr inline unsigned int threads = 256;
    static constexpr inline unsigned int blocks  = 512;
};

template<class T>
struct generator_config_defaults<ROCRAND_RNG_PSEUDO_PHILOX4_32_10, T>
{
    static constexpr inline unsigned int threads = 256;
    static constexpr inline unsigned int blocks  = 1024;
};

template<class T>
struct generator_config_defaults<ROCRAND_RNG_PSEUDO_MRG31K3P, T>
{
    static constexpr inline unsigned int threads = 256;
    static constexpr inline unsigned int blocks  = 512;
};

template<class T>
struct generator_config_defaults<ROCRAND_RNG_PSEUDO_LFSR113, T>
{
    static constexpr inline unsigned int threads = 256;
    static constexpr inline unsigned int blocks  = 512;
};

template<class T>
struct generator_config_defaults<ROCRAND_RNG_PSEUDO_MT19937, T>
{
    static constexpr inline unsigned int threads = 256;
    static constexpr inline unsigned int blocks  = 256;
};

template<class T>
struct generator_config_defaults<ROCRAND_RNG_PSEUDO_THREEFRY2_32_20, T>
{
    static constexpr inline unsigned int threads = 256;
    static constexpr inline unsigned int blocks  = 1024;
};

template<class T>
struct generator_config_defaults<ROCRAND_RNG_PSEUDO_THREEFRY2_64_20, T>
{
    static constexpr inline unsigned int threads = 256;
    static constexpr inline unsigned int blocks  = 1024;
};

template<class T>
struct generator_config_defaults<ROCRAND_RNG_PSEUDO_THREEFRY4_32_20, T>
{
    static constexpr inline unsigned int threads = 256;
    static constexpr inline unsigned int blocks  = 1024;
};

template<class T>
struct generator_config_defaults<ROCRAND_RNG_PSEUDO_THREEFRY4_64_20, T>
{
    static constexpr inline unsigned int threads = 256;
    static constexpr inline unsigned int blocks  = 1024;
};

} // end namespace rocrand_impl::host

#endif // ROCRAND_RNG_CONFIG_CONFIG_DEFAULTS_HPP_
