// Code generated by sdkgen. DO NOT EDIT.

// nolint
package iam

import (
	"context"

	"google.golang.org/grpc"

	iam "github.com/yandex-cloud/go-genproto/yandex/cloud/iam/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// ServiceControlServiceClient is a iam.ServiceControlServiceClient with
// lazy GRPC connection initialization.
type ServiceControlServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Disable implements iam.ServiceControlServiceClient
func (c *ServiceControlServiceClient) Disable(ctx context.Context, in *iam.DisableServiceRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return iam.NewServiceControlServiceClient(conn).Disable(ctx, in, opts...)
}

// Enable implements iam.ServiceControlServiceClient
func (c *ServiceControlServiceClient) Enable(ctx context.Context, in *iam.EnableServiceRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return iam.NewServiceControlServiceClient(conn).Enable(ctx, in, opts...)
}

// Get implements iam.ServiceControlServiceClient
func (c *ServiceControlServiceClient) Get(ctx context.Context, in *iam.GetServiceRequest, opts ...grpc.CallOption) (*iam.Service, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return iam.NewServiceControlServiceClient(conn).Get(ctx, in, opts...)
}

// List implements iam.ServiceControlServiceClient
func (c *ServiceControlServiceClient) List(ctx context.Context, in *iam.ListServicesRequest, opts ...grpc.CallOption) (*iam.ListServicesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return iam.NewServiceControlServiceClient(conn).List(ctx, in, opts...)
}

type ServiceControlIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *ServiceControlServiceClient
	request *iam.ListServicesRequest

	items []*iam.Service
}

func (c *ServiceControlServiceClient) ServiceControlIterator(ctx context.Context, req *iam.ListServicesRequest, opts ...grpc.CallOption) *ServiceControlIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &ServiceControlIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *ServiceControlIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Services
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *ServiceControlIterator) Take(size int64) ([]*iam.Service, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*iam.Service

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *ServiceControlIterator) TakeAll() ([]*iam.Service, error) {
	return it.Take(0)
}

func (it *ServiceControlIterator) Value() *iam.Service {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *ServiceControlIterator) Error() error {
	return it.err
}

// ResolveAgent implements iam.ServiceControlServiceClient
func (c *ServiceControlServiceClient) ResolveAgent(ctx context.Context, in *iam.ResolveServiceAgentRequest, opts ...grpc.CallOption) (*iam.ServiceAgent, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return iam.NewServiceControlServiceClient(conn).ResolveAgent(ctx, in, opts...)
}
