// Code generated by sdkgen. DO NOT EDIT.

// nolint
package containerregistry

import (
	"context"

	"google.golang.org/grpc"

	containerregistry "github.com/yandex-cloud/go-genproto/yandex/cloud/containerregistry/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// LifecyclePolicyServiceClient is a containerregistry.LifecyclePolicyServiceClient with
// lazy GRPC connection initialization.
type LifecyclePolicyServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements containerregistry.LifecyclePolicyServiceClient
func (c *LifecyclePolicyServiceClient) Create(ctx context.Context, in *containerregistry.CreateLifecyclePolicyRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewLifecyclePolicyServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements containerregistry.LifecyclePolicyServiceClient
func (c *LifecyclePolicyServiceClient) Delete(ctx context.Context, in *containerregistry.DeleteLifecyclePolicyRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewLifecyclePolicyServiceClient(conn).Delete(ctx, in, opts...)
}

// DryRun implements containerregistry.LifecyclePolicyServiceClient
func (c *LifecyclePolicyServiceClient) DryRun(ctx context.Context, in *containerregistry.DryRunLifecyclePolicyRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewLifecyclePolicyServiceClient(conn).DryRun(ctx, in, opts...)
}

// Get implements containerregistry.LifecyclePolicyServiceClient
func (c *LifecyclePolicyServiceClient) Get(ctx context.Context, in *containerregistry.GetLifecyclePolicyRequest, opts ...grpc.CallOption) (*containerregistry.LifecyclePolicy, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewLifecyclePolicyServiceClient(conn).Get(ctx, in, opts...)
}

// GetDryRunResult implements containerregistry.LifecyclePolicyServiceClient
func (c *LifecyclePolicyServiceClient) GetDryRunResult(ctx context.Context, in *containerregistry.GetDryRunLifecyclePolicyResultRequest, opts ...grpc.CallOption) (*containerregistry.DryRunLifecyclePolicyResult, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewLifecyclePolicyServiceClient(conn).GetDryRunResult(ctx, in, opts...)
}

// List implements containerregistry.LifecyclePolicyServiceClient
func (c *LifecyclePolicyServiceClient) List(ctx context.Context, in *containerregistry.ListLifecyclePoliciesRequest, opts ...grpc.CallOption) (*containerregistry.ListLifecyclePoliciesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewLifecyclePolicyServiceClient(conn).List(ctx, in, opts...)
}

type LifecyclePolicyIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *LifecyclePolicyServiceClient
	request *containerregistry.ListLifecyclePoliciesRequest

	items []*containerregistry.LifecyclePolicy
}

func (c *LifecyclePolicyServiceClient) LifecyclePolicyIterator(ctx context.Context, req *containerregistry.ListLifecyclePoliciesRequest, opts ...grpc.CallOption) *LifecyclePolicyIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &LifecyclePolicyIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *LifecyclePolicyIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.LifecyclePolicies
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *LifecyclePolicyIterator) Take(size int64) ([]*containerregistry.LifecyclePolicy, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*containerregistry.LifecyclePolicy

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *LifecyclePolicyIterator) TakeAll() ([]*containerregistry.LifecyclePolicy, error) {
	return it.Take(0)
}

func (it *LifecyclePolicyIterator) Value() *containerregistry.LifecyclePolicy {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *LifecyclePolicyIterator) Error() error {
	return it.err
}

// ListDryRunResultAffectedImages implements containerregistry.LifecyclePolicyServiceClient
func (c *LifecyclePolicyServiceClient) ListDryRunResultAffectedImages(ctx context.Context, in *containerregistry.ListDryRunLifecyclePolicyResultAffectedImagesRequest, opts ...grpc.CallOption) (*containerregistry.ListDryRunLifecyclePolicyResultAffectedImagesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewLifecyclePolicyServiceClient(conn).ListDryRunResultAffectedImages(ctx, in, opts...)
}

type LifecyclePolicyDryRunResultAffectedImagesIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *LifecyclePolicyServiceClient
	request *containerregistry.ListDryRunLifecyclePolicyResultAffectedImagesRequest

	items []*containerregistry.Image
}

func (c *LifecyclePolicyServiceClient) LifecyclePolicyDryRunResultAffectedImagesIterator(ctx context.Context, req *containerregistry.ListDryRunLifecyclePolicyResultAffectedImagesRequest, opts ...grpc.CallOption) *LifecyclePolicyDryRunResultAffectedImagesIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &LifecyclePolicyDryRunResultAffectedImagesIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *LifecyclePolicyDryRunResultAffectedImagesIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListDryRunResultAffectedImages(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.AffectedImages
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *LifecyclePolicyDryRunResultAffectedImagesIterator) Take(size int64) ([]*containerregistry.Image, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*containerregistry.Image

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *LifecyclePolicyDryRunResultAffectedImagesIterator) TakeAll() ([]*containerregistry.Image, error) {
	return it.Take(0)
}

func (it *LifecyclePolicyDryRunResultAffectedImagesIterator) Value() *containerregistry.Image {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *LifecyclePolicyDryRunResultAffectedImagesIterator) Error() error {
	return it.err
}

// ListDryRunResults implements containerregistry.LifecyclePolicyServiceClient
func (c *LifecyclePolicyServiceClient) ListDryRunResults(ctx context.Context, in *containerregistry.ListDryRunLifecyclePolicyResultsRequest, opts ...grpc.CallOption) (*containerregistry.ListDryRunLifecyclePolicyResultsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewLifecyclePolicyServiceClient(conn).ListDryRunResults(ctx, in, opts...)
}

type LifecyclePolicyDryRunResultsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *LifecyclePolicyServiceClient
	request *containerregistry.ListDryRunLifecyclePolicyResultsRequest

	items []*containerregistry.DryRunLifecyclePolicyResult
}

func (c *LifecyclePolicyServiceClient) LifecyclePolicyDryRunResultsIterator(ctx context.Context, req *containerregistry.ListDryRunLifecyclePolicyResultsRequest, opts ...grpc.CallOption) *LifecyclePolicyDryRunResultsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &LifecyclePolicyDryRunResultsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *LifecyclePolicyDryRunResultsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListDryRunResults(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.DryRunLifecyclePolicyResults
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *LifecyclePolicyDryRunResultsIterator) Take(size int64) ([]*containerregistry.DryRunLifecyclePolicyResult, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*containerregistry.DryRunLifecyclePolicyResult

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *LifecyclePolicyDryRunResultsIterator) TakeAll() ([]*containerregistry.DryRunLifecyclePolicyResult, error) {
	return it.Take(0)
}

func (it *LifecyclePolicyDryRunResultsIterator) Value() *containerregistry.DryRunLifecyclePolicyResult {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *LifecyclePolicyDryRunResultsIterator) Error() error {
	return it.err
}

// Update implements containerregistry.LifecyclePolicyServiceClient
func (c *LifecyclePolicyServiceClient) Update(ctx context.Context, in *containerregistry.UpdateLifecyclePolicyRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return containerregistry.NewLifecyclePolicyServiceClient(conn).Update(ctx, in, opts...)
}
