// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package quic_initial_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetAllQUICInitialRuleDefaultsOKCode is the HTTP code returned for type GetAllQUICInitialRuleDefaultsOK
const GetAllQUICInitialRuleDefaultsOKCode int = 200

/*
GetAllQUICInitialRuleDefaultsOK Successful operation

swagger:response getAllQuicInitialRuleDefaultsOK
*/
type GetAllQUICInitialRuleDefaultsOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.QUICInitialRules `json:"body,omitempty"`
}

// NewGetAllQUICInitialRuleDefaultsOK creates GetAllQUICInitialRuleDefaultsOK with default headers values
func NewGetAllQUICInitialRuleDefaultsOK() *GetAllQUICInitialRuleDefaultsOK {

	return &GetAllQUICInitialRuleDefaultsOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get all Quic initial rule defaults o k response
func (o *GetAllQUICInitialRuleDefaultsOK) WithConfigurationVersion(configurationVersion string) *GetAllQUICInitialRuleDefaultsOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all Quic initial rule defaults o k response
func (o *GetAllQUICInitialRuleDefaultsOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all Quic initial rule defaults o k response
func (o *GetAllQUICInitialRuleDefaultsOK) WithPayload(payload models.QUICInitialRules) *GetAllQUICInitialRuleDefaultsOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all Quic initial rule defaults o k response
func (o *GetAllQUICInitialRuleDefaultsOK) SetPayload(payload models.QUICInitialRules) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllQUICInitialRuleDefaultsOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.QUICInitialRules{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetAllQUICInitialRuleDefaultsDefault General Error

swagger:response getAllQuicInitialRuleDefaultsDefault
*/
type GetAllQUICInitialRuleDefaultsDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllQUICInitialRuleDefaultsDefault creates GetAllQUICInitialRuleDefaultsDefault with default headers values
func NewGetAllQUICInitialRuleDefaultsDefault(code int) *GetAllQUICInitialRuleDefaultsDefault {
	if code <= 0 {
		code = 500
	}

	return &GetAllQUICInitialRuleDefaultsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get all QUIC initial rule defaults default response
func (o *GetAllQUICInitialRuleDefaultsDefault) WithStatusCode(code int) *GetAllQUICInitialRuleDefaultsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get all QUIC initial rule defaults default response
func (o *GetAllQUICInitialRuleDefaultsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get all QUIC initial rule defaults default response
func (o *GetAllQUICInitialRuleDefaultsDefault) WithConfigurationVersion(configurationVersion string) *GetAllQUICInitialRuleDefaultsDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all QUIC initial rule defaults default response
func (o *GetAllQUICInitialRuleDefaultsDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all QUIC initial rule defaults default response
func (o *GetAllQUICInitialRuleDefaultsDefault) WithPayload(payload *models.Error) *GetAllQUICInitialRuleDefaultsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all QUIC initial rule defaults default response
func (o *GetAllQUICInitialRuleDefaultsDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllQUICInitialRuleDefaultsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
