// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_target

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetAllLogTargetLogForwardOKCode is the HTTP code returned for type GetAllLogTargetLogForwardOK
const GetAllLogTargetLogForwardOKCode int = 200

/*
GetAllLogTargetLogForwardOK Successful operation

swagger:response getAllLogTargetLogForwardOK
*/
type GetAllLogTargetLogForwardOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.LogTargets `json:"body,omitempty"`
}

// NewGetAllLogTargetLogForwardOK creates GetAllLogTargetLogForwardOK with default headers values
func NewGetAllLogTargetLogForwardOK() *GetAllLogTargetLogForwardOK {

	return &GetAllLogTargetLogForwardOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get all log target log forward o k response
func (o *GetAllLogTargetLogForwardOK) WithConfigurationVersion(configurationVersion string) *GetAllLogTargetLogForwardOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all log target log forward o k response
func (o *GetAllLogTargetLogForwardOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all log target log forward o k response
func (o *GetAllLogTargetLogForwardOK) WithPayload(payload models.LogTargets) *GetAllLogTargetLogForwardOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all log target log forward o k response
func (o *GetAllLogTargetLogForwardOK) SetPayload(payload models.LogTargets) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllLogTargetLogForwardOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.LogTargets{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetAllLogTargetLogForwardDefault General Error

swagger:response getAllLogTargetLogForwardDefault
*/
type GetAllLogTargetLogForwardDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllLogTargetLogForwardDefault creates GetAllLogTargetLogForwardDefault with default headers values
func NewGetAllLogTargetLogForwardDefault(code int) *GetAllLogTargetLogForwardDefault {
	if code <= 0 {
		code = 500
	}

	return &GetAllLogTargetLogForwardDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get all log target log forward default response
func (o *GetAllLogTargetLogForwardDefault) WithStatusCode(code int) *GetAllLogTargetLogForwardDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get all log target log forward default response
func (o *GetAllLogTargetLogForwardDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get all log target log forward default response
func (o *GetAllLogTargetLogForwardDefault) WithConfigurationVersion(configurationVersion string) *GetAllLogTargetLogForwardDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all log target log forward default response
func (o *GetAllLogTargetLogForwardDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all log target log forward default response
func (o *GetAllLogTargetLogForwardDefault) WithPayload(payload *models.Error) *GetAllLogTargetLogForwardDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all log target log forward default response
func (o *GetAllLogTargetLogForwardDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllLogTargetLogForwardDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
