// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_request_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetHTTPRequestRuleBackendOKCode is the HTTP code returned for type GetHTTPRequestRuleBackendOK
const GetHTTPRequestRuleBackendOKCode int = 200

/*
GetHTTPRequestRuleBackendOK Successful operation

swagger:response getHttpRequestRuleBackendOK
*/
type GetHTTPRequestRuleBackendOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.HTTPRequestRule `json:"body,omitempty"`
}

// NewGetHTTPRequestRuleBackendOK creates GetHTTPRequestRuleBackendOK with default headers values
func NewGetHTTPRequestRuleBackendOK() *GetHTTPRequestRuleBackendOK {

	return &GetHTTPRequestRuleBackendOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get Http request rule backend o k response
func (o *GetHTTPRequestRuleBackendOK) WithConfigurationVersion(configurationVersion string) *GetHTTPRequestRuleBackendOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Http request rule backend o k response
func (o *GetHTTPRequestRuleBackendOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Http request rule backend o k response
func (o *GetHTTPRequestRuleBackendOK) WithPayload(payload *models.HTTPRequestRule) *GetHTTPRequestRuleBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Http request rule backend o k response
func (o *GetHTTPRequestRuleBackendOK) SetPayload(payload *models.HTTPRequestRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetHTTPRequestRuleBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetHTTPRequestRuleBackendNotFoundCode is the HTTP code returned for type GetHTTPRequestRuleBackendNotFound
const GetHTTPRequestRuleBackendNotFoundCode int = 404

/*
GetHTTPRequestRuleBackendNotFound The specified resource was not found

swagger:response getHttpRequestRuleBackendNotFound
*/
type GetHTTPRequestRuleBackendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetHTTPRequestRuleBackendNotFound creates GetHTTPRequestRuleBackendNotFound with default headers values
func NewGetHTTPRequestRuleBackendNotFound() *GetHTTPRequestRuleBackendNotFound {

	return &GetHTTPRequestRuleBackendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get Http request rule backend not found response
func (o *GetHTTPRequestRuleBackendNotFound) WithConfigurationVersion(configurationVersion string) *GetHTTPRequestRuleBackendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Http request rule backend not found response
func (o *GetHTTPRequestRuleBackendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Http request rule backend not found response
func (o *GetHTTPRequestRuleBackendNotFound) WithPayload(payload *models.Error) *GetHTTPRequestRuleBackendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Http request rule backend not found response
func (o *GetHTTPRequestRuleBackendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetHTTPRequestRuleBackendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetHTTPRequestRuleBackendDefault General Error

swagger:response getHttpRequestRuleBackendDefault
*/
type GetHTTPRequestRuleBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetHTTPRequestRuleBackendDefault creates GetHTTPRequestRuleBackendDefault with default headers values
func NewGetHTTPRequestRuleBackendDefault(code int) *GetHTTPRequestRuleBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &GetHTTPRequestRuleBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get HTTP request rule backend default response
func (o *GetHTTPRequestRuleBackendDefault) WithStatusCode(code int) *GetHTTPRequestRuleBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get HTTP request rule backend default response
func (o *GetHTTPRequestRuleBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get HTTP request rule backend default response
func (o *GetHTTPRequestRuleBackendDefault) WithConfigurationVersion(configurationVersion string) *GetHTTPRequestRuleBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get HTTP request rule backend default response
func (o *GetHTTPRequestRuleBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get HTTP request rule backend default response
func (o *GetHTTPRequestRuleBackendDefault) WithPayload(payload *models.Error) *GetHTTPRequestRuleBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get HTTP request rule backend default response
func (o *GetHTTPRequestRuleBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetHTTPRequestRuleBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
