// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_request_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteHTTPRequestRuleBackendAcceptedCode is the HTTP code returned for type DeleteHTTPRequestRuleBackendAccepted
const DeleteHTTPRequestRuleBackendAcceptedCode int = 202

/*
DeleteHTTPRequestRuleBackendAccepted Configuration change accepted and reload requested

swagger:response deleteHttpRequestRuleBackendAccepted
*/
type DeleteHTTPRequestRuleBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteHTTPRequestRuleBackendAccepted creates DeleteHTTPRequestRuleBackendAccepted with default headers values
func NewDeleteHTTPRequestRuleBackendAccepted() *DeleteHTTPRequestRuleBackendAccepted {

	return &DeleteHTTPRequestRuleBackendAccepted{}
}

// WithReloadID adds the reloadId to the delete Http request rule backend accepted response
func (o *DeleteHTTPRequestRuleBackendAccepted) WithReloadID(reloadID string) *DeleteHTTPRequestRuleBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete Http request rule backend accepted response
func (o *DeleteHTTPRequestRuleBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteHTTPRequestRuleBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteHTTPRequestRuleBackendNoContentCode is the HTTP code returned for type DeleteHTTPRequestRuleBackendNoContent
const DeleteHTTPRequestRuleBackendNoContentCode int = 204

/*
DeleteHTTPRequestRuleBackendNoContent HTTP Request Rule deleted

swagger:response deleteHttpRequestRuleBackendNoContent
*/
type DeleteHTTPRequestRuleBackendNoContent struct {
}

// NewDeleteHTTPRequestRuleBackendNoContent creates DeleteHTTPRequestRuleBackendNoContent with default headers values
func NewDeleteHTTPRequestRuleBackendNoContent() *DeleteHTTPRequestRuleBackendNoContent {

	return &DeleteHTTPRequestRuleBackendNoContent{}
}

// WriteResponse to the client
func (o *DeleteHTTPRequestRuleBackendNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteHTTPRequestRuleBackendNotFoundCode is the HTTP code returned for type DeleteHTTPRequestRuleBackendNotFound
const DeleteHTTPRequestRuleBackendNotFoundCode int = 404

/*
DeleteHTTPRequestRuleBackendNotFound The specified resource was not found

swagger:response deleteHttpRequestRuleBackendNotFound
*/
type DeleteHTTPRequestRuleBackendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteHTTPRequestRuleBackendNotFound creates DeleteHTTPRequestRuleBackendNotFound with default headers values
func NewDeleteHTTPRequestRuleBackendNotFound() *DeleteHTTPRequestRuleBackendNotFound {

	return &DeleteHTTPRequestRuleBackendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete Http request rule backend not found response
func (o *DeleteHTTPRequestRuleBackendNotFound) WithConfigurationVersion(configurationVersion string) *DeleteHTTPRequestRuleBackendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete Http request rule backend not found response
func (o *DeleteHTTPRequestRuleBackendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete Http request rule backend not found response
func (o *DeleteHTTPRequestRuleBackendNotFound) WithPayload(payload *models.Error) *DeleteHTTPRequestRuleBackendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete Http request rule backend not found response
func (o *DeleteHTTPRequestRuleBackendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteHTTPRequestRuleBackendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteHTTPRequestRuleBackendDefault General Error

swagger:response deleteHttpRequestRuleBackendDefault
*/
type DeleteHTTPRequestRuleBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteHTTPRequestRuleBackendDefault creates DeleteHTTPRequestRuleBackendDefault with default headers values
func NewDeleteHTTPRequestRuleBackendDefault(code int) *DeleteHTTPRequestRuleBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteHTTPRequestRuleBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete HTTP request rule backend default response
func (o *DeleteHTTPRequestRuleBackendDefault) WithStatusCode(code int) *DeleteHTTPRequestRuleBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete HTTP request rule backend default response
func (o *DeleteHTTPRequestRuleBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete HTTP request rule backend default response
func (o *DeleteHTTPRequestRuleBackendDefault) WithConfigurationVersion(configurationVersion string) *DeleteHTTPRequestRuleBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete HTTP request rule backend default response
func (o *DeleteHTTPRequestRuleBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete HTTP request rule backend default response
func (o *DeleteHTTPRequestRuleBackendDefault) WithPayload(payload *models.Error) *DeleteHTTPRequestRuleBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete HTTP request rule backend default response
func (o *DeleteHTTPRequestRuleBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteHTTPRequestRuleBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
