// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package tcp_check

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteTCPCheckBackendAcceptedCode is the HTTP code returned for type DeleteTCPCheckBackendAccepted
const DeleteTCPCheckBackendAcceptedCode int = 202

/*
DeleteTCPCheckBackendAccepted Configuration change accepted and reload requested

swagger:response deleteTcpCheckBackendAccepted
*/
type DeleteTCPCheckBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteTCPCheckBackendAccepted creates DeleteTCPCheckBackendAccepted with default headers values
func NewDeleteTCPCheckBackendAccepted() *DeleteTCPCheckBackendAccepted {

	return &DeleteTCPCheckBackendAccepted{}
}

// WithReloadID adds the reloadId to the delete Tcp check backend accepted response
func (o *DeleteTCPCheckBackendAccepted) WithReloadID(reloadID string) *DeleteTCPCheckBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete Tcp check backend accepted response
func (o *DeleteTCPCheckBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteTCPCheckBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteTCPCheckBackendNoContentCode is the HTTP code returned for type DeleteTCPCheckBackendNoContent
const DeleteTCPCheckBackendNoContentCode int = 204

/*
DeleteTCPCheckBackendNoContent TCP check deleted

swagger:response deleteTcpCheckBackendNoContent
*/
type DeleteTCPCheckBackendNoContent struct {
}

// NewDeleteTCPCheckBackendNoContent creates DeleteTCPCheckBackendNoContent with default headers values
func NewDeleteTCPCheckBackendNoContent() *DeleteTCPCheckBackendNoContent {

	return &DeleteTCPCheckBackendNoContent{}
}

// WriteResponse to the client
func (o *DeleteTCPCheckBackendNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteTCPCheckBackendNotFoundCode is the HTTP code returned for type DeleteTCPCheckBackendNotFound
const DeleteTCPCheckBackendNotFoundCode int = 404

/*
DeleteTCPCheckBackendNotFound The specified resource was not found

swagger:response deleteTcpCheckBackendNotFound
*/
type DeleteTCPCheckBackendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteTCPCheckBackendNotFound creates DeleteTCPCheckBackendNotFound with default headers values
func NewDeleteTCPCheckBackendNotFound() *DeleteTCPCheckBackendNotFound {

	return &DeleteTCPCheckBackendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete Tcp check backend not found response
func (o *DeleteTCPCheckBackendNotFound) WithConfigurationVersion(configurationVersion string) *DeleteTCPCheckBackendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete Tcp check backend not found response
func (o *DeleteTCPCheckBackendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete Tcp check backend not found response
func (o *DeleteTCPCheckBackendNotFound) WithPayload(payload *models.Error) *DeleteTCPCheckBackendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete Tcp check backend not found response
func (o *DeleteTCPCheckBackendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteTCPCheckBackendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteTCPCheckBackendDefault General Error

swagger:response deleteTcpCheckBackendDefault
*/
type DeleteTCPCheckBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteTCPCheckBackendDefault creates DeleteTCPCheckBackendDefault with default headers values
func NewDeleteTCPCheckBackendDefault(code int) *DeleteTCPCheckBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteTCPCheckBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete TCP check backend default response
func (o *DeleteTCPCheckBackendDefault) WithStatusCode(code int) *DeleteTCPCheckBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete TCP check backend default response
func (o *DeleteTCPCheckBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete TCP check backend default response
func (o *DeleteTCPCheckBackendDefault) WithConfigurationVersion(configurationVersion string) *DeleteTCPCheckBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete TCP check backend default response
func (o *DeleteTCPCheckBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete TCP check backend default response
func (o *DeleteTCPCheckBackendDefault) WithPayload(payload *models.Error) *DeleteTCPCheckBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete TCP check backend default response
func (o *DeleteTCPCheckBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteTCPCheckBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
