// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetAllStorageGeneralFilesOKCode is the HTTP code returned for type GetAllStorageGeneralFilesOK
const GetAllStorageGeneralFilesOKCode int = 200

/*
GetAllStorageGeneralFilesOK Successful operation

swagger:response getAllStorageGeneralFilesOK
*/
type GetAllStorageGeneralFilesOK struct {

	/*
	  In: Body
	*/
	Payload models.GeneralFiles `json:"body,omitempty"`
}

// NewGetAllStorageGeneralFilesOK creates GetAllStorageGeneralFilesOK with default headers values
func NewGetAllStorageGeneralFilesOK() *GetAllStorageGeneralFilesOK {

	return &GetAllStorageGeneralFilesOK{}
}

// WithPayload adds the payload to the get all storage general files o k response
func (o *GetAllStorageGeneralFilesOK) WithPayload(payload models.GeneralFiles) *GetAllStorageGeneralFilesOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all storage general files o k response
func (o *GetAllStorageGeneralFilesOK) SetPayload(payload models.GeneralFiles) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllStorageGeneralFilesOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.GeneralFiles{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// GetAllStorageGeneralFilesNotFoundCode is the HTTP code returned for type GetAllStorageGeneralFilesNotFound
const GetAllStorageGeneralFilesNotFoundCode int = 404

/*
GetAllStorageGeneralFilesNotFound The specified resource was not found

swagger:response getAllStorageGeneralFilesNotFound
*/
type GetAllStorageGeneralFilesNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllStorageGeneralFilesNotFound creates GetAllStorageGeneralFilesNotFound with default headers values
func NewGetAllStorageGeneralFilesNotFound() *GetAllStorageGeneralFilesNotFound {

	return &GetAllStorageGeneralFilesNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get all storage general files not found response
func (o *GetAllStorageGeneralFilesNotFound) WithConfigurationVersion(configurationVersion string) *GetAllStorageGeneralFilesNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all storage general files not found response
func (o *GetAllStorageGeneralFilesNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all storage general files not found response
func (o *GetAllStorageGeneralFilesNotFound) WithPayload(payload *models.Error) *GetAllStorageGeneralFilesNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all storage general files not found response
func (o *GetAllStorageGeneralFilesNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllStorageGeneralFilesNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetAllStorageGeneralFilesDefault General Error

swagger:response getAllStorageGeneralFilesDefault
*/
type GetAllStorageGeneralFilesDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllStorageGeneralFilesDefault creates GetAllStorageGeneralFilesDefault with default headers values
func NewGetAllStorageGeneralFilesDefault(code int) *GetAllStorageGeneralFilesDefault {
	if code <= 0 {
		code = 500
	}

	return &GetAllStorageGeneralFilesDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get all storage general files default response
func (o *GetAllStorageGeneralFilesDefault) WithStatusCode(code int) *GetAllStorageGeneralFilesDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get all storage general files default response
func (o *GetAllStorageGeneralFilesDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get all storage general files default response
func (o *GetAllStorageGeneralFilesDefault) WithConfigurationVersion(configurationVersion string) *GetAllStorageGeneralFilesDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all storage general files default response
func (o *GetAllStorageGeneralFilesDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all storage general files default response
func (o *GetAllStorageGeneralFilesDefault) WithPayload(payload *models.Error) *GetAllStorageGeneralFilesDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all storage general files default response
func (o *GetAllStorageGeneralFilesDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllStorageGeneralFilesDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
