// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_target

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceLogTargetLogForwardOKCode is the HTTP code returned for type ReplaceLogTargetLogForwardOK
const ReplaceLogTargetLogForwardOKCode int = 200

/*
ReplaceLogTargetLogForwardOK Log Target replaced

swagger:response replaceLogTargetLogForwardOK
*/
type ReplaceLogTargetLogForwardOK struct {

	/*
	  In: Body
	*/
	Payload *models.LogTarget `json:"body,omitempty"`
}

// NewReplaceLogTargetLogForwardOK creates ReplaceLogTargetLogForwardOK with default headers values
func NewReplaceLogTargetLogForwardOK() *ReplaceLogTargetLogForwardOK {

	return &ReplaceLogTargetLogForwardOK{}
}

// WithPayload adds the payload to the replace log target log forward o k response
func (o *ReplaceLogTargetLogForwardOK) WithPayload(payload *models.LogTarget) *ReplaceLogTargetLogForwardOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log target log forward o k response
func (o *ReplaceLogTargetLogForwardOK) SetPayload(payload *models.LogTarget) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogTargetLogForwardOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceLogTargetLogForwardAcceptedCode is the HTTP code returned for type ReplaceLogTargetLogForwardAccepted
const ReplaceLogTargetLogForwardAcceptedCode int = 202

/*
ReplaceLogTargetLogForwardAccepted Configuration change accepted and reload requested

swagger:response replaceLogTargetLogForwardAccepted
*/
type ReplaceLogTargetLogForwardAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.LogTarget `json:"body,omitempty"`
}

// NewReplaceLogTargetLogForwardAccepted creates ReplaceLogTargetLogForwardAccepted with default headers values
func NewReplaceLogTargetLogForwardAccepted() *ReplaceLogTargetLogForwardAccepted {

	return &ReplaceLogTargetLogForwardAccepted{}
}

// WithReloadID adds the reloadId to the replace log target log forward accepted response
func (o *ReplaceLogTargetLogForwardAccepted) WithReloadID(reloadID string) *ReplaceLogTargetLogForwardAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace log target log forward accepted response
func (o *ReplaceLogTargetLogForwardAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace log target log forward accepted response
func (o *ReplaceLogTargetLogForwardAccepted) WithPayload(payload *models.LogTarget) *ReplaceLogTargetLogForwardAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log target log forward accepted response
func (o *ReplaceLogTargetLogForwardAccepted) SetPayload(payload *models.LogTarget) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogTargetLogForwardAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceLogTargetLogForwardBadRequestCode is the HTTP code returned for type ReplaceLogTargetLogForwardBadRequest
const ReplaceLogTargetLogForwardBadRequestCode int = 400

/*
ReplaceLogTargetLogForwardBadRequest Bad request

swagger:response replaceLogTargetLogForwardBadRequest
*/
type ReplaceLogTargetLogForwardBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceLogTargetLogForwardBadRequest creates ReplaceLogTargetLogForwardBadRequest with default headers values
func NewReplaceLogTargetLogForwardBadRequest() *ReplaceLogTargetLogForwardBadRequest {

	return &ReplaceLogTargetLogForwardBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace log target log forward bad request response
func (o *ReplaceLogTargetLogForwardBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceLogTargetLogForwardBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace log target log forward bad request response
func (o *ReplaceLogTargetLogForwardBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace log target log forward bad request response
func (o *ReplaceLogTargetLogForwardBadRequest) WithPayload(payload *models.Error) *ReplaceLogTargetLogForwardBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log target log forward bad request response
func (o *ReplaceLogTargetLogForwardBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogTargetLogForwardBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceLogTargetLogForwardNotFoundCode is the HTTP code returned for type ReplaceLogTargetLogForwardNotFound
const ReplaceLogTargetLogForwardNotFoundCode int = 404

/*
ReplaceLogTargetLogForwardNotFound The specified resource was not found

swagger:response replaceLogTargetLogForwardNotFound
*/
type ReplaceLogTargetLogForwardNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceLogTargetLogForwardNotFound creates ReplaceLogTargetLogForwardNotFound with default headers values
func NewReplaceLogTargetLogForwardNotFound() *ReplaceLogTargetLogForwardNotFound {

	return &ReplaceLogTargetLogForwardNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace log target log forward not found response
func (o *ReplaceLogTargetLogForwardNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceLogTargetLogForwardNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace log target log forward not found response
func (o *ReplaceLogTargetLogForwardNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace log target log forward not found response
func (o *ReplaceLogTargetLogForwardNotFound) WithPayload(payload *models.Error) *ReplaceLogTargetLogForwardNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log target log forward not found response
func (o *ReplaceLogTargetLogForwardNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogTargetLogForwardNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceLogTargetLogForwardDefault General Error

swagger:response replaceLogTargetLogForwardDefault
*/
type ReplaceLogTargetLogForwardDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceLogTargetLogForwardDefault creates ReplaceLogTargetLogForwardDefault with default headers values
func NewReplaceLogTargetLogForwardDefault(code int) *ReplaceLogTargetLogForwardDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceLogTargetLogForwardDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace log target log forward default response
func (o *ReplaceLogTargetLogForwardDefault) WithStatusCode(code int) *ReplaceLogTargetLogForwardDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace log target log forward default response
func (o *ReplaceLogTargetLogForwardDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace log target log forward default response
func (o *ReplaceLogTargetLogForwardDefault) WithConfigurationVersion(configurationVersion string) *ReplaceLogTargetLogForwardDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace log target log forward default response
func (o *ReplaceLogTargetLogForwardDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace log target log forward default response
func (o *ReplaceLogTargetLogForwardDefault) WithPayload(payload *models.Error) *ReplaceLogTargetLogForwardDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log target log forward default response
func (o *ReplaceLogTargetLogForwardDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogTargetLogForwardDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
