// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_target

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceAllLogTargetGlobalOKCode is the HTTP code returned for type ReplaceAllLogTargetGlobalOK
const ReplaceAllLogTargetGlobalOKCode int = 200

/*
ReplaceAllLogTargetGlobalOK All Log Target lines replaced

swagger:response replaceAllLogTargetGlobalOK
*/
type ReplaceAllLogTargetGlobalOK struct {

	/*
	  In: Body
	*/
	Payload models.LogTargets `json:"body,omitempty"`
}

// NewReplaceAllLogTargetGlobalOK creates ReplaceAllLogTargetGlobalOK with default headers values
func NewReplaceAllLogTargetGlobalOK() *ReplaceAllLogTargetGlobalOK {

	return &ReplaceAllLogTargetGlobalOK{}
}

// WithPayload adds the payload to the replace all log target global o k response
func (o *ReplaceAllLogTargetGlobalOK) WithPayload(payload models.LogTargets) *ReplaceAllLogTargetGlobalOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all log target global o k response
func (o *ReplaceAllLogTargetGlobalOK) SetPayload(payload models.LogTargets) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllLogTargetGlobalOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.LogTargets{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllLogTargetGlobalAcceptedCode is the HTTP code returned for type ReplaceAllLogTargetGlobalAccepted
const ReplaceAllLogTargetGlobalAcceptedCode int = 202

/*
ReplaceAllLogTargetGlobalAccepted Configuration change accepted and reload requested

swagger:response replaceAllLogTargetGlobalAccepted
*/
type ReplaceAllLogTargetGlobalAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload models.LogTargets `json:"body,omitempty"`
}

// NewReplaceAllLogTargetGlobalAccepted creates ReplaceAllLogTargetGlobalAccepted with default headers values
func NewReplaceAllLogTargetGlobalAccepted() *ReplaceAllLogTargetGlobalAccepted {

	return &ReplaceAllLogTargetGlobalAccepted{}
}

// WithReloadID adds the reloadId to the replace all log target global accepted response
func (o *ReplaceAllLogTargetGlobalAccepted) WithReloadID(reloadID string) *ReplaceAllLogTargetGlobalAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace all log target global accepted response
func (o *ReplaceAllLogTargetGlobalAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace all log target global accepted response
func (o *ReplaceAllLogTargetGlobalAccepted) WithPayload(payload models.LogTargets) *ReplaceAllLogTargetGlobalAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all log target global accepted response
func (o *ReplaceAllLogTargetGlobalAccepted) SetPayload(payload models.LogTargets) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllLogTargetGlobalAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.LogTargets{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllLogTargetGlobalBadRequestCode is the HTTP code returned for type ReplaceAllLogTargetGlobalBadRequest
const ReplaceAllLogTargetGlobalBadRequestCode int = 400

/*
ReplaceAllLogTargetGlobalBadRequest Bad request

swagger:response replaceAllLogTargetGlobalBadRequest
*/
type ReplaceAllLogTargetGlobalBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllLogTargetGlobalBadRequest creates ReplaceAllLogTargetGlobalBadRequest with default headers values
func NewReplaceAllLogTargetGlobalBadRequest() *ReplaceAllLogTargetGlobalBadRequest {

	return &ReplaceAllLogTargetGlobalBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace all log target global bad request response
func (o *ReplaceAllLogTargetGlobalBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceAllLogTargetGlobalBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all log target global bad request response
func (o *ReplaceAllLogTargetGlobalBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all log target global bad request response
func (o *ReplaceAllLogTargetGlobalBadRequest) WithPayload(payload *models.Error) *ReplaceAllLogTargetGlobalBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all log target global bad request response
func (o *ReplaceAllLogTargetGlobalBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllLogTargetGlobalBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceAllLogTargetGlobalDefault General Error

swagger:response replaceAllLogTargetGlobalDefault
*/
type ReplaceAllLogTargetGlobalDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllLogTargetGlobalDefault creates ReplaceAllLogTargetGlobalDefault with default headers values
func NewReplaceAllLogTargetGlobalDefault(code int) *ReplaceAllLogTargetGlobalDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceAllLogTargetGlobalDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace all log target global default response
func (o *ReplaceAllLogTargetGlobalDefault) WithStatusCode(code int) *ReplaceAllLogTargetGlobalDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace all log target global default response
func (o *ReplaceAllLogTargetGlobalDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace all log target global default response
func (o *ReplaceAllLogTargetGlobalDefault) WithConfigurationVersion(configurationVersion string) *ReplaceAllLogTargetGlobalDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all log target global default response
func (o *ReplaceAllLogTargetGlobalDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all log target global default response
func (o *ReplaceAllLogTargetGlobalDefault) WithPayload(payload *models.Error) *ReplaceAllLogTargetGlobalDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all log target global default response
func (o *ReplaceAllLogTargetGlobalDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllLogTargetGlobalDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
