// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_request_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteHTTPRequestRuleFrontendAcceptedCode is the HTTP code returned for type DeleteHTTPRequestRuleFrontendAccepted
const DeleteHTTPRequestRuleFrontendAcceptedCode int = 202

/*
DeleteHTTPRequestRuleFrontendAccepted Configuration change accepted and reload requested

swagger:response deleteHttpRequestRuleFrontendAccepted
*/
type DeleteHTTPRequestRuleFrontendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteHTTPRequestRuleFrontendAccepted creates DeleteHTTPRequestRuleFrontendAccepted with default headers values
func NewDeleteHTTPRequestRuleFrontendAccepted() *DeleteHTTPRequestRuleFrontendAccepted {

	return &DeleteHTTPRequestRuleFrontendAccepted{}
}

// WithReloadID adds the reloadId to the delete Http request rule frontend accepted response
func (o *DeleteHTTPRequestRuleFrontendAccepted) WithReloadID(reloadID string) *DeleteHTTPRequestRuleFrontendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete Http request rule frontend accepted response
func (o *DeleteHTTPRequestRuleFrontendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteHTTPRequestRuleFrontendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteHTTPRequestRuleFrontendNoContentCode is the HTTP code returned for type DeleteHTTPRequestRuleFrontendNoContent
const DeleteHTTPRequestRuleFrontendNoContentCode int = 204

/*
DeleteHTTPRequestRuleFrontendNoContent HTTP Request Rule deleted

swagger:response deleteHttpRequestRuleFrontendNoContent
*/
type DeleteHTTPRequestRuleFrontendNoContent struct {
}

// NewDeleteHTTPRequestRuleFrontendNoContent creates DeleteHTTPRequestRuleFrontendNoContent with default headers values
func NewDeleteHTTPRequestRuleFrontendNoContent() *DeleteHTTPRequestRuleFrontendNoContent {

	return &DeleteHTTPRequestRuleFrontendNoContent{}
}

// WriteResponse to the client
func (o *DeleteHTTPRequestRuleFrontendNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteHTTPRequestRuleFrontendNotFoundCode is the HTTP code returned for type DeleteHTTPRequestRuleFrontendNotFound
const DeleteHTTPRequestRuleFrontendNotFoundCode int = 404

/*
DeleteHTTPRequestRuleFrontendNotFound The specified resource was not found

swagger:response deleteHttpRequestRuleFrontendNotFound
*/
type DeleteHTTPRequestRuleFrontendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteHTTPRequestRuleFrontendNotFound creates DeleteHTTPRequestRuleFrontendNotFound with default headers values
func NewDeleteHTTPRequestRuleFrontendNotFound() *DeleteHTTPRequestRuleFrontendNotFound {

	return &DeleteHTTPRequestRuleFrontendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete Http request rule frontend not found response
func (o *DeleteHTTPRequestRuleFrontendNotFound) WithConfigurationVersion(configurationVersion string) *DeleteHTTPRequestRuleFrontendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete Http request rule frontend not found response
func (o *DeleteHTTPRequestRuleFrontendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete Http request rule frontend not found response
func (o *DeleteHTTPRequestRuleFrontendNotFound) WithPayload(payload *models.Error) *DeleteHTTPRequestRuleFrontendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete Http request rule frontend not found response
func (o *DeleteHTTPRequestRuleFrontendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteHTTPRequestRuleFrontendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteHTTPRequestRuleFrontendDefault General Error

swagger:response deleteHttpRequestRuleFrontendDefault
*/
type DeleteHTTPRequestRuleFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteHTTPRequestRuleFrontendDefault creates DeleteHTTPRequestRuleFrontendDefault with default headers values
func NewDeleteHTTPRequestRuleFrontendDefault(code int) *DeleteHTTPRequestRuleFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteHTTPRequestRuleFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete HTTP request rule frontend default response
func (o *DeleteHTTPRequestRuleFrontendDefault) WithStatusCode(code int) *DeleteHTTPRequestRuleFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete HTTP request rule frontend default response
func (o *DeleteHTTPRequestRuleFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete HTTP request rule frontend default response
func (o *DeleteHTTPRequestRuleFrontendDefault) WithConfigurationVersion(configurationVersion string) *DeleteHTTPRequestRuleFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete HTTP request rule frontend default response
func (o *DeleteHTTPRequestRuleFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete HTTP request rule frontend default response
func (o *DeleteHTTPRequestRuleFrontendDefault) WithPayload(payload *models.Error) *DeleteHTTPRequestRuleFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete HTTP request rule frontend default response
func (o *DeleteHTTPRequestRuleFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteHTTPRequestRuleFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
