// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_request_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateHTTPRequestRuleFrontendCreatedCode is the HTTP code returned for type CreateHTTPRequestRuleFrontendCreated
const CreateHTTPRequestRuleFrontendCreatedCode int = 201

/*
CreateHTTPRequestRuleFrontendCreated HTTP Request Rule created

swagger:response createHttpRequestRuleFrontendCreated
*/
type CreateHTTPRequestRuleFrontendCreated struct {

	/*
	  In: Body
	*/
	Payload *models.HTTPRequestRule `json:"body,omitempty"`
}

// NewCreateHTTPRequestRuleFrontendCreated creates CreateHTTPRequestRuleFrontendCreated with default headers values
func NewCreateHTTPRequestRuleFrontendCreated() *CreateHTTPRequestRuleFrontendCreated {

	return &CreateHTTPRequestRuleFrontendCreated{}
}

// WithPayload adds the payload to the create Http request rule frontend created response
func (o *CreateHTTPRequestRuleFrontendCreated) WithPayload(payload *models.HTTPRequestRule) *CreateHTTPRequestRuleFrontendCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http request rule frontend created response
func (o *CreateHTTPRequestRuleFrontendCreated) SetPayload(payload *models.HTTPRequestRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPRequestRuleFrontendCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateHTTPRequestRuleFrontendAcceptedCode is the HTTP code returned for type CreateHTTPRequestRuleFrontendAccepted
const CreateHTTPRequestRuleFrontendAcceptedCode int = 202

/*
CreateHTTPRequestRuleFrontendAccepted Configuration change accepted and reload requested

swagger:response createHttpRequestRuleFrontendAccepted
*/
type CreateHTTPRequestRuleFrontendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.HTTPRequestRule `json:"body,omitempty"`
}

// NewCreateHTTPRequestRuleFrontendAccepted creates CreateHTTPRequestRuleFrontendAccepted with default headers values
func NewCreateHTTPRequestRuleFrontendAccepted() *CreateHTTPRequestRuleFrontendAccepted {

	return &CreateHTTPRequestRuleFrontendAccepted{}
}

// WithReloadID adds the reloadId to the create Http request rule frontend accepted response
func (o *CreateHTTPRequestRuleFrontendAccepted) WithReloadID(reloadID string) *CreateHTTPRequestRuleFrontendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create Http request rule frontend accepted response
func (o *CreateHTTPRequestRuleFrontendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create Http request rule frontend accepted response
func (o *CreateHTTPRequestRuleFrontendAccepted) WithPayload(payload *models.HTTPRequestRule) *CreateHTTPRequestRuleFrontendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http request rule frontend accepted response
func (o *CreateHTTPRequestRuleFrontendAccepted) SetPayload(payload *models.HTTPRequestRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPRequestRuleFrontendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateHTTPRequestRuleFrontendBadRequestCode is the HTTP code returned for type CreateHTTPRequestRuleFrontendBadRequest
const CreateHTTPRequestRuleFrontendBadRequestCode int = 400

/*
CreateHTTPRequestRuleFrontendBadRequest Bad request

swagger:response createHttpRequestRuleFrontendBadRequest
*/
type CreateHTTPRequestRuleFrontendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateHTTPRequestRuleFrontendBadRequest creates CreateHTTPRequestRuleFrontendBadRequest with default headers values
func NewCreateHTTPRequestRuleFrontendBadRequest() *CreateHTTPRequestRuleFrontendBadRequest {

	return &CreateHTTPRequestRuleFrontendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create Http request rule frontend bad request response
func (o *CreateHTTPRequestRuleFrontendBadRequest) WithConfigurationVersion(configurationVersion string) *CreateHTTPRequestRuleFrontendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Http request rule frontend bad request response
func (o *CreateHTTPRequestRuleFrontendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Http request rule frontend bad request response
func (o *CreateHTTPRequestRuleFrontendBadRequest) WithPayload(payload *models.Error) *CreateHTTPRequestRuleFrontendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http request rule frontend bad request response
func (o *CreateHTTPRequestRuleFrontendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPRequestRuleFrontendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateHTTPRequestRuleFrontendConflictCode is the HTTP code returned for type CreateHTTPRequestRuleFrontendConflict
const CreateHTTPRequestRuleFrontendConflictCode int = 409

/*
CreateHTTPRequestRuleFrontendConflict The specified resource already exists

swagger:response createHttpRequestRuleFrontendConflict
*/
type CreateHTTPRequestRuleFrontendConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateHTTPRequestRuleFrontendConflict creates CreateHTTPRequestRuleFrontendConflict with default headers values
func NewCreateHTTPRequestRuleFrontendConflict() *CreateHTTPRequestRuleFrontendConflict {

	return &CreateHTTPRequestRuleFrontendConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create Http request rule frontend conflict response
func (o *CreateHTTPRequestRuleFrontendConflict) WithConfigurationVersion(configurationVersion string) *CreateHTTPRequestRuleFrontendConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Http request rule frontend conflict response
func (o *CreateHTTPRequestRuleFrontendConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Http request rule frontend conflict response
func (o *CreateHTTPRequestRuleFrontendConflict) WithPayload(payload *models.Error) *CreateHTTPRequestRuleFrontendConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http request rule frontend conflict response
func (o *CreateHTTPRequestRuleFrontendConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPRequestRuleFrontendConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateHTTPRequestRuleFrontendDefault General Error

swagger:response createHttpRequestRuleFrontendDefault
*/
type CreateHTTPRequestRuleFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateHTTPRequestRuleFrontendDefault creates CreateHTTPRequestRuleFrontendDefault with default headers values
func NewCreateHTTPRequestRuleFrontendDefault(code int) *CreateHTTPRequestRuleFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateHTTPRequestRuleFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create HTTP request rule frontend default response
func (o *CreateHTTPRequestRuleFrontendDefault) WithStatusCode(code int) *CreateHTTPRequestRuleFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create HTTP request rule frontend default response
func (o *CreateHTTPRequestRuleFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create HTTP request rule frontend default response
func (o *CreateHTTPRequestRuleFrontendDefault) WithConfigurationVersion(configurationVersion string) *CreateHTTPRequestRuleFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create HTTP request rule frontend default response
func (o *CreateHTTPRequestRuleFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create HTTP request rule frontend default response
func (o *CreateHTTPRequestRuleFrontendDefault) WithPayload(payload *models.Error) *CreateHTTPRequestRuleFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create HTTP request rule frontend default response
func (o *CreateHTTPRequestRuleFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPRequestRuleFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
