/* game.c generated by valac 0.46.3, the Vala compiler
 * generated from game.vala, do not modify */

/*  Pasang Emas. Enjoy a unique traditional game of Brunei.
    Copyright (C) 2010  Nor Jaidi Tuah

    This file is part of Pasang Emas.
      
    Pasang Emas is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>

typedef enum  {
	PASANG_DELTA_UP = -13,
	PASANG_DELTA_DOWN = 13,
	PASANG_DELTA_RIGHT = 1,
	PASANG_DELTA_LEFT = -1
} PasangDelta;

#define PASANG_TYPE_DELTA (pasang_delta_get_type ())
typedef enum  {
	PASANG_PIECE_NULL = -999,
	PASANG_PIECE_KAS_0 = 0,
	PASANG_PIECE_KAS_1 = 1,
	PASANG_PIECE_BLACK = 2,
	PASANG_PIECE_WHITE = 3,
	PASANG_PIECE_COUNT = 4,
	PASANG_PIECE_BOARD = 4,
	PASANG_PIECE_GUARD = 5,
	PASANG_PIECE_GUIDE = 6,
	PASANG_PIECE_EMPTY = 100
} PasangPiece;

#define PASANG_TYPE_PIECE (pasang_piece_get_type ())
typedef enum  {
	PASANG_STAGE_NULL = -999,
	PASANG_STAGE_OPENING = 0,
	PASANG_STAGE_SELECT = 1,
	PASANG_STAGE_SUB_SELECT = 2,
	PASANG_STAGE_MOVE = 3,
	PASANG_STAGE_SUB_MOVE = 4,
	PASANG_STAGE_GAME_OVER = 5
} PasangStage;

#define PASANG_TYPE_STAGE (pasang_stage_get_type ())

#define PASANG_TYPE_MOVE (pasang_move_get_type ())
#define PASANG_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_MOVE, PasangMove))
#define PASANG_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_MOVE, PasangMoveClass))
#define PASANG_IS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_MOVE))
#define PASANG_IS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_MOVE))
#define PASANG_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_MOVE, PasangMoveClass))

typedef struct _PasangMove PasangMove;
typedef struct _PasangMoveClass PasangMoveClass;
typedef struct _PasangMovePrivate PasangMovePrivate;
enum  {
	PASANG_MOVE_0_PROPERTY,
	PASANG_MOVE_POSITION_PROPERTY,
	PASANG_MOVE_NOTATION_PROPERTY,
	PASANG_MOVE_VALUE_PROPERTY,
	PASANG_MOVE_NUM_PROPERTIES
};
static GParamSpec* pasang_move_properties[PASANG_MOVE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define PASANG_TYPE_GAME (pasang_game_get_type ())
#define PASANG_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_GAME, PasangGame))
#define PASANG_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_GAME, PasangGameClass))
#define PASANG_IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_GAME))
#define PASANG_IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_GAME))
#define PASANG_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_GAME, PasangGameClass))

typedef struct _PasangGame PasangGame;
typedef struct _PasangGameClass PasangGameClass;
typedef struct _PasangGamePrivate PasangGamePrivate;
enum  {
	PASANG_GAME_0_PROPERTY,
	PASANG_GAME_STAGE_PROPERTY,
	PASANG_GAME_SEQ_PROPERTY,
	PASANG_GAME_PLAYER_PROPERTY,
	PASANG_GAME_KAS_PROPERTY,
	PASANG_GAME_VALUE_OF_UNCAPTURED_PIECES_PROPERTY,
	PASANG_GAME_NUM_PROPERTIES
};
static GParamSpec* pasang_game_properties[PASANG_GAME_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define PASANG_GAME_TYPE_ITERATOR (pasang_game_iterator_get_type ())
#define PASANG_GAME_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_GAME_TYPE_ITERATOR, PasangGameIterator))
#define PASANG_GAME_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_GAME_TYPE_ITERATOR, PasangGameIteratorClass))
#define PASANG_GAME_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_GAME_TYPE_ITERATOR))
#define PASANG_GAME_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_GAME_TYPE_ITERATOR))
#define PASANG_GAME_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_GAME_TYPE_ITERATOR, PasangGameIteratorClass))

typedef struct _PasangGameIterator PasangGameIterator;
typedef struct _PasangGameIteratorClass PasangGameIteratorClass;
typedef struct _PasangGameIteratorPrivate PasangGameIteratorPrivate;
typedef struct _PasangGameParamSpecIterator PasangGameParamSpecIterator;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PasangMove {
	GObject parent_instance;
	PasangMovePrivate * priv;
	gint* booties;
	gint booties_length1;
};

struct _PasangMoveClass {
	GObjectClass parent_class;
};

struct _PasangMovePrivate {
	gint _position;
	gchar* _notation;
	gint _value;
};

struct _PasangGame {
	GObject parent_instance;
	PasangGamePrivate * priv;
	PasangPiece* board;
	gint board_length1;
	gint* score;
	gint score_length1;
	gint* kas_position;
	gint kas_position_length1;
	gint* first_move;
	gint first_move_length1;
};

struct _PasangGameClass {
	GObjectClass parent_class;
};

struct _PasangGamePrivate {
	PasangStage _stage;
	gint _seq;
	gint _player;
	gint _value_of_uncaptured_pieces;
	PasangMove** moves;
	gint moves_length1;
	gint _moves_size_;
};

struct _PasangGameIterator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PasangGameIteratorPrivate * priv;
};

struct _PasangGameIteratorClass {
	GTypeClass parent_class;
	void (*finalize) (PasangGameIterator *self);
};

struct _PasangGameIteratorPrivate {
	PasangGame* game;
	gint index;
};

struct _PasangGameParamSpecIterator {
	GParamSpec parent_instance;
};

static gint PasangMove_private_offset;
static gpointer pasang_move_parent_class = NULL;
static gint PasangGame_private_offset;
static gpointer pasang_game_parent_class = NULL;
static gint PasangGameIterator_private_offset;
static gpointer pasang_game_iterator_parent_class = NULL;

#define PASANG_BOARD_WIDTH 13
#define PASANG_BOARD_SIZE (13 * 13)
#define PASANG_NUM_WHITES 60
#define PASANG_NUM_BLACKS 60
GType pasang_delta_get_type (void) G_GNUC_CONST;
GType pasang_piece_get_type (void) G_GNUC_CONST;
gboolean pasang_piece_is_real (PasangPiece self);
gboolean pasang_piece_is_kas (PasangPiece self);
GType pasang_stage_get_type (void) G_GNUC_CONST;
GType pasang_move_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangMove, g_object_unref)
GType pasang_game_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangGame, g_object_unref)
PasangMove* pasang_move_new (PasangGame* game,
                             gint position,
                             gint* booties,
                             gint booties_length1);
PasangMove* pasang_move_construct (GType object_type,
                                   PasangGame* game,
                                   gint position,
                                   gint* booties,
                                   gint booties_length1);
static void pasang_move_set_position (PasangMove* self,
                               gint value);
static gint* _vala_array_dup2 (gint* self,
                        int length);
PasangStage pasang_game_get_stage (PasangGame* self);
static void pasang_move_set_notation (PasangMove* self,
                               const gchar* value);
gint pasang_move_get_position (PasangMove* self);
const gchar* pasang_move_get_notation (PasangMove* self);
gint pasang_move_get_value (PasangMove* self);
void pasang_move_set_value (PasangMove* self,
                            gint value);
static void pasang_move_finalize (GObject * obj);
static void _vala_pasang_move_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_pasang_move_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
PasangGame* pasang_game_new_clone (PasangGame* source);
PasangGame* pasang_game_construct_clone (GType object_type,
                                         PasangGame* source);
static PasangPiece* _vala_array_dup3 (PasangPiece* self,
                               int length);
gint pasang_game_get_player (PasangGame* self);
static void pasang_game_set_player (PasangGame* self,
                             gint value);
gint pasang_game_get_value_of_uncaptured_pieces (PasangGame* self);
static void pasang_game_set_value_of_uncaptured_pieces (PasangGame* self,
                                                 gint value);
static void pasang_game_set_stage (PasangGame* self,
                            PasangStage value);
static gint* _vala_array_dup4 (gint* self,
                        int length);
static gint* _vala_array_dup5 (gint* self,
                        int length);
static gint* _vala_array_dup6 (gint* self,
                        int length);
gint pasang_game_get_seq (PasangGame* self);
static void pasang_game_set_seq (PasangGame* self,
                          gint value);
gboolean pasang_game_is_valid_pattern (const gchar* pattern);
void pasang_game_compile (const gchar* pattern,
                          PasangPiece** b,
                          gint* b_length1);
void pasang_game_start (PasangGame* self,
                        const gchar* starting_pattern);
void pasang_game_generate_moves (PasangGame* self);
void pasang_game_perform (PasangGame* self,
                          PasangMove* move,
                          gboolean full_move);
static void pasang_game_perform_capture (PasangGame* self,
                                  PasangMove* move);
static void pasang_game_next_player (PasangGame* self);
static void pasang_game_perform_move_kas (PasangGame* self,
                                   PasangMove* move);
gint pasang_game_count_submoves (PasangGame* self,
                                 PasangMove* move);
static void _vala_array_add1 (PasangMove** * array,
                       int* length,
                       int* size,
                       PasangMove* value);
static PasangMove** _vala_array_dup7 (PasangMove** self,
                               int length);
void pasang_game_perform_from_notation (PasangGame* self,
                                        const gchar* move_notation);
PasangMove* pasang_game_get_move (PasangGame* self,
                                  const gchar* move_notation);
void pasang_game_sort_moves (PasangGame* self);
static gint __lambda4_ (void* m1,
                 void* m2);
static gint ___lambda4____compar_fn_t (void* key1,
                                void* key2);
void pasang_game_leave_one_move (PasangGame* self,
                                 PasangMove* move);
static void pasang_game_generate_opening_moves (PasangGame* self);
static void pasang_game_generate_kas_selection_moves (PasangGame* self);
static void pasang_game_generate_kas_moving_moves (PasangGame* self);
static void _vala_array_add2 (gint* * array,
                       int* length,
                       int* size,
                       gint value);
static void _vala_array_add3 (PasangMove** * array,
                       int* length,
                       int* size,
                       PasangMove* value);
static void pasang_game_add_move (PasangGame* self,
                           gint position,
                           gint capture_position,
                           gint capture_direction);
static void _vala_array_add4 (gint* * array,
                       int* length,
                       int* size,
                       gint value);
static void _vala_array_add5 (gint* * array,
                       int* length,
                       int* size,
                       gint value);
static void _vala_array_add6 (gint* * array,
                       int* length,
                       int* size,
                       gint value);
static void _vala_array_add7 (PasangMove** * array,
                       int* length,
                       int* size,
                       PasangMove* value);
static void _vala_array_add8 (PasangMove** * array,
                       int* length,
                       int* size,
                       PasangMove* value);
gpointer pasang_game_iterator_ref (gpointer instance);
void pasang_game_iterator_unref (gpointer instance);
GParamSpec* pasang_game_param_spec_iterator (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
void pasang_game_value_set_iterator (GValue* value,
                                     gpointer v_object);
void pasang_game_value_take_iterator (GValue* value,
                                      gpointer v_object);
gpointer pasang_game_value_get_iterator (const GValue* value);
GType pasang_game_iterator_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangGameIterator, pasang_game_iterator_unref)
PasangGameIterator* pasang_game_iterator (PasangGame* self);
PasangGameIterator* pasang_game_iterator_new (PasangGame* game);
PasangGameIterator* pasang_game_iterator_construct (GType object_type,
                                                    PasangGame* game);
gint pasang_game_numMoves (PasangGame* self);
PasangMove* pasang_game_getMove (PasangGame* self,
                                 gint n);
PasangGame* pasang_game_new (void);
PasangGame* pasang_game_construct (GType object_type);
PasangPiece pasang_game_get_kas (PasangGame* self);
PasangMove* pasang_game_iterator_next_value (PasangGameIterator* self);
static void pasang_game_iterator_finalize (PasangGameIterator * obj);
static void pasang_game_finalize (GObject * obj);
static void _vala_pasang_game_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_pasang_game_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

/**
 * Relative directions
 */
GType
pasang_delta_get_type (void)
{
	static volatile gsize pasang_delta_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_delta_type_id__volatile)) {
		static const GEnumValue values[] = {{PASANG_DELTA_UP, "PASANG_DELTA_UP", "up"}, {PASANG_DELTA_DOWN, "PASANG_DELTA_DOWN", "down"}, {PASANG_DELTA_RIGHT, "PASANG_DELTA_RIGHT", "right"}, {PASANG_DELTA_LEFT, "PASANG_DELTA_LEFT", "left"}, {0, NULL, NULL}};
		GType pasang_delta_type_id;
		pasang_delta_type_id = g_enum_register_static ("PasangDelta", values);
		g_once_init_leave (&pasang_delta_type_id__volatile, pasang_delta_type_id);
	}
	return pasang_delta_type_id__volatile;
}

/**
 * Possible contents of a board.
 * When cast to int, the value is used to index to image portions.
 * WHITE and BLACK should actually correspond to visually 
 * black/dark and white/light pieces (like in chess).
 *
 * A int can also be cast into a Piece to convert player number 
 * (either 0 or 1) into either KAS_0 or KAS_1.
 */
gboolean
pasang_piece_is_real (PasangPiece self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
#line 68 "game.vala"
	if (self >= PASANG_PIECE_KAS_0) {
#line 68 "game.vala"
		_tmp0_ = self <= PASANG_PIECE_WHITE;
#line 404 "game.c"
	} else {
#line 68 "game.vala"
		_tmp0_ = FALSE;
#line 408 "game.c"
	}
#line 68 "game.vala"
	result = _tmp0_;
#line 68 "game.vala"
	return result;
#line 414 "game.c"
}

gboolean
pasang_piece_is_kas (PasangPiece self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
#line 72 "game.vala"
	if (self == PASANG_PIECE_KAS_0) {
#line 72 "game.vala"
		_tmp0_ = TRUE;
#line 426 "game.c"
	} else {
#line 72 "game.vala"
		_tmp0_ = self == PASANG_PIECE_KAS_1;
#line 430 "game.c"
	}
#line 72 "game.vala"
	result = _tmp0_;
#line 72 "game.vala"
	return result;
#line 436 "game.c"
}

GType
pasang_piece_get_type (void)
{
	static volatile gsize pasang_piece_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_piece_type_id__volatile)) {
		static const GEnumValue values[] = {{PASANG_PIECE_NULL, "PASANG_PIECE_NULL", "null"}, {PASANG_PIECE_KAS_0, "PASANG_PIECE_KAS_0", "kas-0"}, {PASANG_PIECE_KAS_1, "PASANG_PIECE_KAS_1", "kas-1"}, {PASANG_PIECE_BLACK, "PASANG_PIECE_BLACK", "black"}, {PASANG_PIECE_WHITE, "PASANG_PIECE_WHITE", "white"}, {PASANG_PIECE_COUNT, "PASANG_PIECE_COUNT", "count"}, {PASANG_PIECE_BOARD, "PASANG_PIECE_BOARD", "board"}, {PASANG_PIECE_GUARD, "PASANG_PIECE_GUARD", "guard"}, {PASANG_PIECE_GUIDE, "PASANG_PIECE_GUIDE", "guide"}, {PASANG_PIECE_EMPTY, "PASANG_PIECE_EMPTY", "empty"}, {0, NULL, NULL}};
		GType pasang_piece_type_id;
		pasang_piece_type_id = g_enum_register_static ("PasangPiece", values);
		g_once_init_leave (&pasang_piece_type_id__volatile, pasang_piece_type_id);
	}
	return pasang_piece_type_id__volatile;
}

GType
pasang_stage_get_type (void)
{
	static volatile gsize pasang_stage_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_stage_type_id__volatile)) {
		static const GEnumValue values[] = {{PASANG_STAGE_NULL, "PASANG_STAGE_NULL", "null"}, {PASANG_STAGE_OPENING, "PASANG_STAGE_OPENING", "opening"}, {PASANG_STAGE_SELECT, "PASANG_STAGE_SELECT", "select"}, {PASANG_STAGE_SUB_SELECT, "PASANG_STAGE_SUB_SELECT", "sub-select"}, {PASANG_STAGE_MOVE, "PASANG_STAGE_MOVE", "move"}, {PASANG_STAGE_SUB_MOVE, "PASANG_STAGE_SUB_MOVE", "sub-move"}, {PASANG_STAGE_GAME_OVER, "PASANG_STAGE_GAME_OVER", "game-over"}, {0, NULL, NULL}};
		GType pasang_stage_type_id;
		pasang_stage_type_id = g_enum_register_static ("PasangStage", values);
		g_once_init_leave (&pasang_stage_type_id__volatile, pasang_stage_type_id);
	}
	return pasang_stage_type_id__volatile;
}

static inline gpointer
pasang_move_get_instance_private (PasangMove* self)
{
	return G_STRUCT_MEMBER_P (self, PasangMove_private_offset);
}

static gint*
_vala_array_dup2 (gint* self,
                  int length)
{
#line 112 "game.vala"
	return g_memdup (self, length * sizeof (gint));
#line 477 "game.c"
}

PasangMove*
pasang_move_construct (GType object_type,
                       PasangGame* game,
                       gint position,
                       gint* booties,
                       gint booties_length1)
{
	PasangMove * self = NULL;
	gint* _tmp0_;
	gint _tmp0__length1;
	gint worth = 0;
	gchar col = '\0';
	gint row = 0;
	gboolean capture_vertical = FALSE;
	gint _tmp6_;
	PasangStage _tmp7_;
	PasangStage _tmp8_;
#line 109 "game.vala"
	g_return_val_if_fail (game != NULL, NULL);
#line 109 "game.vala"
	self = (PasangMove*) g_object_new (object_type, NULL);
#line 110 "game.vala"
	_vala_assert ((booties_length1 % 2) == 1, "booties.length % 2 == 1");
#line 111 "game.vala"
	pasang_move_set_position (self, position);
#line 112 "game.vala"
	_tmp0_ = (booties != NULL) ? _vala_array_dup2 (booties, booties_length1) : ((gpointer) booties);
#line 112 "game.vala"
	_tmp0__length1 = booties_length1;
#line 112 "game.vala"
	self->booties = (g_free (self->booties), NULL);
#line 112 "game.vala"
	self->booties = _tmp0_;
#line 112 "game.vala"
	self->booties_length1 = _tmp0__length1;
#line 113 "game.vala"
	worth = 0;
#line 517 "game.c"
	{
		gint* pos_collection = NULL;
		gint pos_collection_length1 = 0;
		gint _pos_collection_size_ = 0;
		gint pos_it = 0;
#line 114 "game.vala"
		pos_collection = booties;
#line 114 "game.vala"
		pos_collection_length1 = booties_length1;
#line 114 "game.vala"
		for (pos_it = 0; pos_it < pos_collection_length1; pos_it = pos_it + 1) {
#line 529 "game.c"
			gint pos = 0;
#line 114 "game.vala"
			pos = pos_collection[pos_it];
#line 533 "game.c"
			{
				gboolean _tmp1_ = FALSE;
				gint piece = 0;
				PasangPiece* _tmp2_;
				gint _tmp2__length1;
				PasangPiece _tmp3_;
				gboolean _tmp4_ = FALSE;
				gint _tmp5_ = 0;
#line 115 "game.vala"
				if (pos >= 0) {
#line 115 "game.vala"
					_tmp1_ = pos < PASANG_BOARD_SIZE;
#line 546 "game.c"
				} else {
#line 115 "game.vala"
					_tmp1_ = FALSE;
#line 550 "game.c"
				}
#line 115 "game.vala"
				_vala_assert (_tmp1_, "pos >= 0 && pos < BOARD_SIZE");
#line 116 "game.vala"
				_tmp2_ = game->board;
#line 116 "game.vala"
				_tmp2__length1 = game->board_length1;
#line 116 "game.vala"
				_tmp3_ = _tmp2_[pos];
#line 116 "game.vala"
				piece = (gint) _tmp3_;
#line 117 "game.vala"
				if (piece == ((gint) PASANG_PIECE_BLACK)) {
#line 117 "game.vala"
					_tmp4_ = TRUE;
#line 566 "game.c"
				} else {
#line 117 "game.vala"
					_tmp4_ = piece == ((gint) PASANG_PIECE_WHITE);
#line 570 "game.c"
				}
#line 117 "game.vala"
				_vala_assert (_tmp4_, "piece == Piece.BLACK || piece == Piece.WHITE");
#line 118 "game.vala"
				if (piece == ((gint) PASANG_PIECE_BLACK)) {
#line 118 "game.vala"
					_tmp5_ = 1;
#line 578 "game.c"
				} else {
#line 118 "game.vala"
					_tmp5_ = 2;
#line 582 "game.c"
				}
#line 118 "game.vala"
				worth += _tmp5_;
#line 586 "game.c"
			}
		}
	}
#line 120 "game.vala"
	col = (gchar) (('A' - 1) + (12 - (position % PASANG_BOARD_WIDTH)));
#line 121 "game.vala"
	row = position / PASANG_BOARD_WIDTH;
#line 122 "game.vala"
	_tmp6_ = booties[0];
#line 122 "game.vala"
	capture_vertical = (_tmp6_ / PASANG_BOARD_WIDTH) != row;
#line 123 "game.vala"
	_tmp7_ = pasang_game_get_stage (game);
#line 123 "game.vala"
	_tmp8_ = _tmp7_;
#line 123 "game.vala"
	if (_tmp8_ == PASANG_STAGE_OPENING) {
#line 604 "game.c"
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 124 "game.vala"
		_tmp9_ = g_strdup_printf ("%cx%d", (gint) col, worth);
#line 124 "game.vala"
		_tmp10_ = _tmp9_;
#line 124 "game.vala"
		pasang_move_set_notation (self, _tmp10_);
#line 124 "game.vala"
		_g_free0 (_tmp10_);
#line 615 "game.c"
	} else {
		gboolean _tmp11_ = FALSE;
		PasangStage _tmp12_;
		PasangStage _tmp13_;
#line 126 "game.vala"
		_tmp12_ = pasang_game_get_stage (game);
#line 126 "game.vala"
		_tmp13_ = _tmp12_;
#line 126 "game.vala"
		if (_tmp13_ == PASANG_STAGE_SELECT) {
#line 126 "game.vala"
			_tmp11_ = capture_vertical;
#line 628 "game.c"
		} else {
#line 126 "game.vala"
			_tmp11_ = FALSE;
#line 632 "game.c"
		}
#line 126 "game.vala"
		if (_tmp11_) {
#line 636 "game.c"
			gchar* _tmp14_;
			gchar* _tmp15_;
#line 127 "game.vala"
			_tmp14_ = g_strdup_printf ("%c%dx%d*", (gint) col, row, worth);
#line 127 "game.vala"
			_tmp15_ = _tmp14_;
#line 127 "game.vala"
			pasang_move_set_notation (self, _tmp15_);
#line 127 "game.vala"
			_g_free0 (_tmp15_);
#line 647 "game.c"
		} else {
			gchar* _tmp16_;
			gchar* _tmp17_;
#line 130 "game.vala"
			_tmp16_ = g_strdup_printf ("%c%dx%d", (gint) col, row, worth);
#line 130 "game.vala"
			_tmp17_ = _tmp16_;
#line 130 "game.vala"
			pasang_move_set_notation (self, _tmp17_);
#line 130 "game.vala"
			_g_free0 (_tmp17_);
#line 659 "game.c"
		}
	}
#line 109 "game.vala"
	return self;
#line 664 "game.c"
}

PasangMove*
pasang_move_new (PasangGame* game,
                 gint position,
                 gint* booties,
                 gint booties_length1)
{
#line 109 "game.vala"
	return pasang_move_construct (PASANG_TYPE_MOVE, game, position, booties, booties_length1);
#line 675 "game.c"
}

gint
pasang_move_get_position (PasangMove* self)
{
	gint result;
#line 92 "game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 92 "game.vala"
	result = self->priv->_position;
#line 92 "game.vala"
	return result;
#line 688 "game.c"
}

static void
pasang_move_set_position (PasangMove* self,
                          gint value)
{
#line 92 "game.vala"
	g_return_if_fail (self != NULL);
#line 92 "game.vala"
	if (pasang_move_get_position (self) != value) {
#line 92 "game.vala"
		self->priv->_position = value;
#line 92 "game.vala"
		g_object_notify_by_pspec ((GObject *) self, pasang_move_properties[PASANG_MOVE_POSITION_PROPERTY]);
#line 703 "game.c"
	}
}

const gchar*
pasang_move_get_notation (PasangMove* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 102 "game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 102 "game.vala"
	_tmp0_ = self->priv->_notation;
#line 102 "game.vala"
	result = _tmp0_;
#line 102 "game.vala"
	return result;
#line 720 "game.c"
}

static void
pasang_move_set_notation (PasangMove* self,
                          const gchar* value)
{
#line 102 "game.vala"
	g_return_if_fail (self != NULL);
#line 102 "game.vala"
	if (g_strcmp0 (value, pasang_move_get_notation (self)) != 0) {
#line 731 "game.c"
		gchar* _tmp0_;
#line 102 "game.vala"
		_tmp0_ = g_strdup (value);
#line 102 "game.vala"
		_g_free0 (self->priv->_notation);
#line 102 "game.vala"
		self->priv->_notation = _tmp0_;
#line 102 "game.vala"
		g_object_notify_by_pspec ((GObject *) self, pasang_move_properties[PASANG_MOVE_NOTATION_PROPERTY]);
#line 741 "game.c"
	}
}

gint
pasang_move_get_value (PasangMove* self)
{
	gint result;
#line 107 "game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 107 "game.vala"
	result = self->priv->_value;
#line 107 "game.vala"
	return result;
#line 755 "game.c"
}

void
pasang_move_set_value (PasangMove* self,
                       gint value)
{
#line 107 "game.vala"
	g_return_if_fail (self != NULL);
#line 107 "game.vala"
	if (pasang_move_get_value (self) != value) {
#line 107 "game.vala"
		self->priv->_value = value;
#line 107 "game.vala"
		g_object_notify_by_pspec ((GObject *) self, pasang_move_properties[PASANG_MOVE_VALUE_PROPERTY]);
#line 770 "game.c"
	}
}

static void
pasang_move_class_init (PasangMoveClass * klass,
                        gpointer klass_data)
{
#line 86 "game.vala"
	pasang_move_parent_class = g_type_class_peek_parent (klass);
#line 86 "game.vala"
	g_type_class_adjust_private_offset (klass, &PasangMove_private_offset);
#line 86 "game.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_pasang_move_get_property;
#line 86 "game.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_pasang_move_set_property;
#line 86 "game.vala"
	G_OBJECT_CLASS (klass)->finalize = pasang_move_finalize;
#line 788 "game.c"
	/**
	     * At Stage.OPEN, this is the column selected (1-11).
	     * At Stage.SELECT, this is the source position.
	     * At Stage.MOVE, this is the destination position.
	     */
#line 86 "game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), PASANG_MOVE_POSITION_PROPERTY, pasang_move_properties[PASANG_MOVE_POSITION_PROPERTY] = g_param_spec_int ("position", "position", "position", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 796 "game.c"
	/**
	     * Standard string representation for this move.
	     */
#line 86 "game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), PASANG_MOVE_NOTATION_PROPERTY, pasang_move_properties[PASANG_MOVE_NOTATION_PROPERTY] = g_param_spec_string ("notation", "notation", "notation", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 802 "game.c"
	/**
	     * Not used by this class. Provided here for the program's AI.
	     */
#line 86 "game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), PASANG_MOVE_VALUE_PROPERTY, pasang_move_properties[PASANG_MOVE_VALUE_PROPERTY] = g_param_spec_int ("value", "value", "value", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 808 "game.c"
}

static void
pasang_move_instance_init (PasangMove * self,
                           gpointer klass)
{
#line 86 "game.vala"
	self->priv = pasang_move_get_instance_private (self);
#line 817 "game.c"
}

static void
pasang_move_finalize (GObject * obj)
{
	PasangMove * self;
#line 86 "game.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PASANG_TYPE_MOVE, PasangMove);
#line 97 "game.vala"
	self->booties = (g_free (self->booties), NULL);
#line 102 "game.vala"
	_g_free0 (self->priv->_notation);
#line 86 "game.vala"
	G_OBJECT_CLASS (pasang_move_parent_class)->finalize (obj);
#line 832 "game.c"
}

GType
pasang_move_get_type (void)
{
	static volatile gsize pasang_move_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_move_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PasangMoveClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pasang_move_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PasangMove), 0, (GInstanceInitFunc) pasang_move_instance_init, NULL };
		GType pasang_move_type_id;
		pasang_move_type_id = g_type_register_static (G_TYPE_OBJECT, "PasangMove", &g_define_type_info, 0);
		PasangMove_private_offset = g_type_add_instance_private (pasang_move_type_id, sizeof (PasangMovePrivate));
		g_once_init_leave (&pasang_move_type_id__volatile, pasang_move_type_id);
	}
	return pasang_move_type_id__volatile;
}

static void
_vala_pasang_move_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	PasangMove * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PASANG_TYPE_MOVE, PasangMove);
#line 86 "game.vala"
	switch (property_id) {
#line 86 "game.vala"
		case PASANG_MOVE_POSITION_PROPERTY:
#line 86 "game.vala"
		g_value_set_int (value, pasang_move_get_position (self));
#line 86 "game.vala"
		break;
#line 86 "game.vala"
		case PASANG_MOVE_NOTATION_PROPERTY:
#line 86 "game.vala"
		g_value_set_string (value, pasang_move_get_notation (self));
#line 86 "game.vala"
		break;
#line 86 "game.vala"
		case PASANG_MOVE_VALUE_PROPERTY:
#line 86 "game.vala"
		g_value_set_int (value, pasang_move_get_value (self));
#line 86 "game.vala"
		break;
#line 877 "game.c"
		default:
#line 86 "game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 86 "game.vala"
		break;
#line 883 "game.c"
	}
}

static void
_vala_pasang_move_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	PasangMove * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PASANG_TYPE_MOVE, PasangMove);
#line 86 "game.vala"
	switch (property_id) {
#line 86 "game.vala"
		case PASANG_MOVE_POSITION_PROPERTY:
#line 86 "game.vala"
		pasang_move_set_position (self, g_value_get_int (value));
#line 86 "game.vala"
		break;
#line 86 "game.vala"
		case PASANG_MOVE_NOTATION_PROPERTY:
#line 86 "game.vala"
		pasang_move_set_notation (self, g_value_get_string (value));
#line 86 "game.vala"
		break;
#line 86 "game.vala"
		case PASANG_MOVE_VALUE_PROPERTY:
#line 86 "game.vala"
		pasang_move_set_value (self, g_value_get_int (value));
#line 86 "game.vala"
		break;
#line 915 "game.c"
		default:
#line 86 "game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 86 "game.vala"
		break;
#line 921 "game.c"
	}
}

static inline gpointer
pasang_game_get_instance_private (PasangGame* self)
{
	return G_STRUCT_MEMBER_P (self, PasangGame_private_offset);
}

/**
     * Clone a game, except for its list of moves.
     */
static PasangPiece*
_vala_array_dup3 (PasangPiece* self,
                  int length)
{
#line 182 "game.vala"
	return g_memdup (self, length * sizeof (PasangPiece));
#line 940 "game.c"
}

static gint*
_vala_array_dup4 (gint* self,
                  int length)
{
#line 186 "game.vala"
	return g_memdup (self, length * sizeof (gint));
#line 949 "game.c"
}

static gint*
_vala_array_dup5 (gint* self,
                  int length)
{
#line 187 "game.vala"
	return g_memdup (self, length * sizeof (gint));
#line 958 "game.c"
}

static gint*
_vala_array_dup6 (gint* self,
                  int length)
{
#line 188 "game.vala"
	return g_memdup (self, length * sizeof (gint));
#line 967 "game.c"
}

PasangGame*
pasang_game_construct_clone (GType object_type,
                             PasangGame* source)
{
	PasangGame * self = NULL;
	PasangPiece* _tmp0_;
	gint _tmp0__length1;
	PasangPiece* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	gint _tmp3_;
	PasangStage _tmp4_;
	gint* _tmp5_;
	gint _tmp5__length1;
	gint* _tmp6_;
	gint _tmp6__length1;
	gint* _tmp7_;
	gint _tmp7__length1;
	gint* _tmp8_;
	gint _tmp8__length1;
	gint* _tmp9_;
	gint _tmp9__length1;
	gint* _tmp10_;
	gint _tmp10__length1;
	gint _tmp11_;
#line 181 "game.vala"
	g_return_val_if_fail (source != NULL, NULL);
#line 181 "game.vala"
	self = (PasangGame*) g_object_new (object_type, NULL);
#line 182 "game.vala"
	_tmp0_ = source->board;
#line 182 "game.vala"
	_tmp0__length1 = source->board_length1;
#line 182 "game.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup3 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
#line 182 "game.vala"
	_tmp1__length1 = _tmp0__length1;
#line 182 "game.vala"
	self->board = (g_free (self->board), NULL);
#line 182 "game.vala"
	self->board = _tmp1_;
#line 182 "game.vala"
	self->board_length1 = _tmp1__length1;
#line 183 "game.vala"
	_tmp2_ = source->priv->_player;
#line 183 "game.vala"
	pasang_game_set_player (self, _tmp2_);
#line 184 "game.vala"
	_tmp3_ = source->priv->_value_of_uncaptured_pieces;
#line 184 "game.vala"
	pasang_game_set_value_of_uncaptured_pieces (self, _tmp3_);
#line 185 "game.vala"
	_tmp4_ = source->priv->_stage;
#line 185 "game.vala"
	pasang_game_set_stage (self, _tmp4_);
#line 186 "game.vala"
	_tmp5_ = source->score;
#line 186 "game.vala"
	_tmp5__length1 = source->score_length1;
#line 186 "game.vala"
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup4 (_tmp5_, _tmp5__length1) : ((gpointer) _tmp5_);
#line 186 "game.vala"
	_tmp6__length1 = _tmp5__length1;
#line 186 "game.vala"
	self->score = (g_free (self->score), NULL);
#line 186 "game.vala"
	self->score = _tmp6_;
#line 186 "game.vala"
	self->score_length1 = _tmp6__length1;
#line 187 "game.vala"
	_tmp7_ = source->kas_position;
#line 187 "game.vala"
	_tmp7__length1 = source->kas_position_length1;
#line 187 "game.vala"
	_tmp8_ = (_tmp7_ != NULL) ? _vala_array_dup5 (_tmp7_, _tmp7__length1) : ((gpointer) _tmp7_);
#line 187 "game.vala"
	_tmp8__length1 = _tmp7__length1;
#line 187 "game.vala"
	self->kas_position = (g_free (self->kas_position), NULL);
#line 187 "game.vala"
	self->kas_position = _tmp8_;
#line 187 "game.vala"
	self->kas_position_length1 = _tmp8__length1;
#line 188 "game.vala"
	_tmp9_ = source->first_move;
#line 188 "game.vala"
	_tmp9__length1 = source->first_move_length1;
#line 188 "game.vala"
	_tmp10_ = (_tmp9_ != NULL) ? _vala_array_dup6 (_tmp9_, _tmp9__length1) : ((gpointer) _tmp9_);
#line 188 "game.vala"
	_tmp10__length1 = _tmp9__length1;
#line 188 "game.vala"
	self->first_move = (g_free (self->first_move), NULL);
#line 188 "game.vala"
	self->first_move = _tmp10_;
#line 188 "game.vala"
	self->first_move_length1 = _tmp10__length1;
#line 189 "game.vala"
	_tmp11_ = source->priv->_seq;
#line 189 "game.vala"
	pasang_game_set_seq (self, _tmp11_);
#line 181 "game.vala"
	return self;
#line 1073 "game.c"
}

PasangGame*
pasang_game_new_clone (PasangGame* source)
{
#line 181 "game.vala"
	return pasang_game_construct_clone (PASANG_TYPE_GAME, source);
#line 1081 "game.c"
}

/**
     * Check that a pattern is valid.
     */
static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
#line 1180 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1181 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1181 "glib-2.0.vapi"
	result = _tmp0_;
#line 1181 "glib-2.0.vapi"
	return result;
#line 1101 "game.c"
}

gboolean
pasang_game_is_valid_pattern (const gchar* pattern)
{
	gint blacks = 0;
	gint whites = 0;
	gboolean _tmp6_ = FALSE;
	gboolean result = FALSE;
#line 196 "game.vala"
	g_return_val_if_fail (pattern != NULL, FALSE);
#line 197 "game.vala"
	blacks = 0;
#line 198 "game.vala"
	whites = 0;
#line 1117 "game.c"
	{
		gint i = 0;
#line 199 "game.vala"
		i = 0;
#line 1122 "game.c"
		{
			gboolean _tmp0_ = FALSE;
#line 199 "game.vala"
			_tmp0_ = TRUE;
#line 199 "game.vala"
			while (TRUE) {
#line 1129 "game.c"
				gint _tmp2_;
				gint _tmp3_;
#line 199 "game.vala"
				if (!_tmp0_) {
#line 1134 "game.c"
					gint _tmp1_;
#line 199 "game.vala"
					_tmp1_ = i;
#line 199 "game.vala"
					i = _tmp1_ + 1;
#line 1140 "game.c"
				}
#line 199 "game.vala"
				_tmp0_ = FALSE;
#line 199 "game.vala"
				_tmp2_ = strlen (pattern);
#line 199 "game.vala"
				_tmp3_ = _tmp2_;
#line 199 "game.vala"
				if (!(i < _tmp3_)) {
#line 199 "game.vala"
					break;
#line 1152 "game.c"
				}
#line 200 "game.vala"
				if (string_get (pattern, (glong) i) == 'P') {
#line 1156 "game.c"
					gint _tmp4_;
#line 200 "game.vala"
					_tmp4_ = whites;
#line 200 "game.vala"
					whites = _tmp4_ + 1;
#line 1162 "game.c"
				} else {
#line 201 "game.vala"
					if (string_get (pattern, (glong) i) == 'H') {
#line 1166 "game.c"
						gint _tmp5_;
#line 201 "game.vala"
						_tmp5_ = blacks;
#line 201 "game.vala"
						blacks = _tmp5_ + 1;
#line 1172 "game.c"
					} else {
#line 202 "game.vala"
						if (string_get (pattern, (glong) i) == ' ') {
#line 202 "game.vala"
							continue;
#line 1178 "game.c"
						} else {
#line 203 "game.vala"
							result = FALSE;
#line 203 "game.vala"
							return result;
#line 1184 "game.c"
						}
					}
				}
			}
		}
	}
#line 205 "game.vala"
	if (blacks == 30) {
#line 205 "game.vala"
		_tmp6_ = whites == 30;
#line 1195 "game.c"
	} else {
#line 205 "game.vala"
		_tmp6_ = FALSE;
#line 1199 "game.c"
	}
#line 205 "game.vala"
	result = _tmp6_;
#line 205 "game.vala"
	return result;
#line 1205 "game.c"
}

/**
     * Compile a string of H's and P's into an array of Pieces representing 
     * an intial board arrangment.
     */
void
pasang_game_compile (const gchar* pattern,
                     PasangPiece** b,
                     gint* b_length1)
{
	gint whites = 0;
	gint blacks = 0;
	gint n = 0;
	gboolean _tmp7_ = FALSE;
#line 212 "game.vala"
	g_return_if_fail (pattern != NULL);
#line 212 "game.vala"
	_vala_return_if_fail ((*b_length1) == PASANG_BOARD_SIZE, "b.length == BOARD_SIZE");
#line 1225 "game.c"
	{
		gint i = 0;
#line 214 "game.vala"
		i = 0;
#line 1230 "game.c"
		{
			gboolean _tmp0_ = FALSE;
#line 214 "game.vala"
			_tmp0_ = TRUE;
#line 214 "game.vala"
			while (TRUE) {
#line 214 "game.vala"
				if (!_tmp0_) {
#line 1239 "game.c"
					gint _tmp1_;
#line 214 "game.vala"
					_tmp1_ = i;
#line 214 "game.vala"
					i = _tmp1_ + 1;
#line 1245 "game.c"
				}
#line 214 "game.vala"
				_tmp0_ = FALSE;
#line 214 "game.vala"
				if (!(i < PASANG_BOARD_SIZE)) {
#line 214 "game.vala"
					break;
#line 1253 "game.c"
				}
#line 214 "game.vala"
				(*b)[i] = PASANG_PIECE_GUARD;
#line 1257 "game.c"
			}
		}
	}
#line 215 "game.vala"
	whites = 0;
#line 216 "game.vala"
	blacks = 0;
#line 217 "game.vala"
	n = 0;
#line 1267 "game.c"
	{
		gint i = 0;
#line 218 "game.vala"
		i = 0;
#line 1272 "game.c"
		{
			gboolean _tmp2_ = FALSE;
#line 218 "game.vala"
			_tmp2_ = TRUE;
#line 218 "game.vala"
			while (TRUE) {
#line 1279 "game.c"
				gint _tmp4_;
				gint _tmp5_;
				gchar code = '\0';
				gint row = 0;
				gint col = 0;
				gint pos = 0;
				gint _tmp6_;
#line 218 "game.vala"
				if (!_tmp2_) {
#line 1289 "game.c"
					gint _tmp3_;
#line 218 "game.vala"
					_tmp3_ = i;
#line 218 "game.vala"
					i = _tmp3_ + 1;
#line 1295 "game.c"
				}
#line 218 "game.vala"
				_tmp2_ = FALSE;
#line 218 "game.vala"
				_tmp4_ = strlen (pattern);
#line 218 "game.vala"
				_tmp5_ = _tmp4_;
#line 218 "game.vala"
				if (!(i < _tmp5_)) {
#line 218 "game.vala"
					break;
#line 1307 "game.c"
				}
#line 219 "game.vala"
				code = string_get (pattern, (glong) i);
#line 220 "game.vala"
				if (code == ' ') {
#line 220 "game.vala"
					continue;
#line 1315 "game.c"
				}
#line 222 "game.vala"
				row = (n / (PASANG_BOARD_WIDTH - 2)) + 1;
#line 223 "game.vala"
				col = (n % (PASANG_BOARD_WIDTH - 2)) + 1;
#line 224 "game.vala"
				pos = (row * PASANG_BOARD_WIDTH) + col;
#line 225 "game.vala"
				if (code == 'H') {
#line 226 "game.vala"
					(*b)[(PASANG_BOARD_SIZE - 1) - pos] = PASANG_PIECE_BLACK;
#line 226 "game.vala"
					(*b)[pos] = PASANG_PIECE_BLACK;
#line 227 "game.vala"
					blacks += 2;
#line 1331 "game.c"
				} else {
#line 230 "game.vala"
					_vala_assert (code == 'P', "code == 'P'");
#line 231 "game.vala"
					(*b)[(PASANG_BOARD_SIZE - 1) - pos] = PASANG_PIECE_WHITE;
#line 231 "game.vala"
					(*b)[pos] = PASANG_PIECE_WHITE;
#line 232 "game.vala"
					whites += 2;
#line 1341 "game.c"
				}
#line 234 "game.vala"
				_tmp6_ = n;
#line 234 "game.vala"
				n = _tmp6_ + 1;
#line 1347 "game.c"
			}
		}
	}
#line 236 "game.vala"
	if (whites == PASANG_NUM_WHITES) {
#line 236 "game.vala"
		_tmp7_ = blacks == PASANG_NUM_BLACKS;
#line 1355 "game.c"
	} else {
#line 236 "game.vala"
		_tmp7_ = FALSE;
#line 1359 "game.c"
	}
#line 236 "game.vala"
	_vala_assert (_tmp7_, "whites == NUM_WHITES && blacks == NUM_BLACKS");
#line 1363 "game.c"
}

/**
     * Start the game with the given starting board (in textual form).
     * Player 0 always plays first and the game always begins with Stage.OPEN. 
     */
void
pasang_game_start (PasangGame* self,
                   const gchar* starting_pattern)
{
	gint* _tmp0_;
	gint* _tmp1_;
#line 243 "game.vala"
	g_return_if_fail (self != NULL);
#line 243 "game.vala"
	g_return_if_fail (starting_pattern != NULL);
#line 244 "game.vala"
	pasang_game_compile (starting_pattern, &self->board, (gint*) (&self->board_length1));
#line 245 "game.vala"
	pasang_game_set_player (self, 0);
#line 246 "game.vala"
	_tmp0_ = g_new0 (gint, 2);
#line 246 "game.vala"
	_tmp0_[0] = 0;
#line 246 "game.vala"
	_tmp0_[1] = 0;
#line 246 "game.vala"
	self->score = (g_free (self->score), NULL);
#line 246 "game.vala"
	self->score = _tmp0_;
#line 246 "game.vala"
	self->score_length1 = 2;
#line 247 "game.vala"
	_tmp1_ = g_new0 (gint, 2);
#line 247 "game.vala"
	_tmp1_[0] = 0;
#line 247 "game.vala"
	_tmp1_[1] = 0;
#line 247 "game.vala"
	self->kas_position = (g_free (self->kas_position), NULL);
#line 247 "game.vala"
	self->kas_position = _tmp1_;
#line 247 "game.vala"
	self->kas_position_length1 = 2;
#line 248 "game.vala"
	pasang_game_set_value_of_uncaptured_pieces (self, (2 * PASANG_NUM_WHITES) + PASANG_NUM_BLACKS);
#line 249 "game.vala"
	pasang_game_set_stage (self, PASANG_STAGE_OPENING);
#line 250 "game.vala"
	pasang_game_set_seq (self, 0);
#line 251 "game.vala"
	pasang_game_generate_moves (self);
#line 1416 "game.c"
}

/**
     * Perform the given move. The move can be partial, e.g., the user has moved
     * her kas, but has yet to decide either to capture blacks or whites.
     *
     * full_move should be true for AI players, since AI players are not
     * constrained to use a sequential input device to make their moves.
     * full_move should also be true for remote players, since moves from remote players
     * are always marshalled.
     *
     * Unchecked precondition: if full_move==false, generate_moves should be called first.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
#line 283 "game.vala"
	return self ? g_object_ref (self) : NULL;
#line 1435 "game.c"
}

static void
_vala_array_add1 (PasangMove** * array,
                  int* length,
                  int* size,
                  PasangMove* value)
{
#line 284 "game.vala"
	if ((*length) == (*size)) {
#line 284 "game.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 284 "game.vala"
		*array = g_renew (PasangMove*, *array, (*size) + 1);
#line 1450 "game.c"
	}
#line 284 "game.vala"
	(*array)[(*length)++] = value;
#line 284 "game.vala"
	(*array)[*length] = NULL;
#line 1456 "game.c"
}

static PasangMove**
_vala_array_dup7 (PasangMove** self,
                  int length)
{
	PasangMove** result;
	int i;
#line 286 "game.vala"
	result = g_new0 (PasangMove*, length + 1);
#line 286 "game.vala"
	for (i = 0; i < length; i++) {
#line 1469 "game.c"
		PasangMove* _tmp0_;
#line 286 "game.vala"
		_tmp0_ = _g_object_ref0 (self[i]);
#line 286 "game.vala"
		result[i] = _tmp0_;
#line 1475 "game.c"
	}
#line 286 "game.vala"
	return result;
#line 1479 "game.c"
}

void
pasang_game_perform (PasangGame* self,
                     PasangMove* move,
                     gboolean full_move)
{
	PasangStage _tmp0_;
	PasangStage _tmp1_;
	PasangMove** _tmp26_;
	gint _tmp26__length1;
	gboolean _tmp35_ = FALSE;
	PasangStage _tmp36_;
#line 265 "game.vala"
	g_return_if_fail (self != NULL);
#line 265 "game.vala"
	g_return_if_fail (move != NULL);
#line 266 "game.vala"
	_tmp0_ = self->priv->_stage;
#line 266 "game.vala"
	_vala_assert (_tmp0_ != PASANG_STAGE_NULL, "stage != Stage.NULL");
#line 267 "game.vala"
	_tmp1_ = self->priv->_stage;
#line 267 "game.vala"
	switch (_tmp1_) {
#line 267 "game.vala"
		case PASANG_STAGE_OPENING:
#line 267 "game.vala"
		case PASANG_STAGE_SUB_SELECT:
#line 267 "game.vala"
		case PASANG_STAGE_SUB_MOVE:
#line 1511 "game.c"
		{
			PasangStage _tmp2_;
#line 271 "game.vala"
			_tmp2_ = self->priv->_stage;
#line 271 "game.vala"
			if (_tmp2_ == PASANG_STAGE_OPENING) {
#line 1518 "game.c"
				gint* _tmp3_;
				gint _tmp3__length1;
				gint _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
#line 271 "game.vala"
				_tmp3_ = self->first_move;
#line 271 "game.vala"
				_tmp3__length1 = self->first_move_length1;
#line 271 "game.vala"
				_tmp4_ = self->priv->_player;
#line 271 "game.vala"
				_tmp5_ = pasang_move_get_position (move);
#line 271 "game.vala"
				_tmp6_ = _tmp5_;
#line 271 "game.vala"
				_tmp3_[_tmp4_] = _tmp6_;
#line 1536 "game.c"
			}
#line 272 "game.vala"
			pasang_game_perform_capture (self, move);
#line 273 "game.vala"
			pasang_game_next_player (self);
#line 274 "game.vala"
			pasang_game_generate_moves (self);
#line 275 "game.vala"
			break;
#line 1546 "game.c"
		}
#line 267 "game.vala"
		case PASANG_STAGE_SELECT:
#line 267 "game.vala"
		case PASANG_STAGE_MOVE:
#line 1552 "game.c"
		{
			gboolean _tmp7_ = FALSE;
#line 278 "game.vala"
			pasang_game_perform_move_kas (self, move);
#line 279 "game.vala"
			if (!full_move) {
#line 279 "game.vala"
				_tmp7_ = pasang_game_count_submoves (self, move) > 1;
#line 1561 "game.c"
			} else {
#line 279 "game.vala"
				_tmp7_ = FALSE;
#line 1565 "game.c"
			}
#line 279 "game.vala"
			if (_tmp7_) {
#line 1569 "game.c"
				PasangStage _tmp8_ = 0;
				PasangStage _tmp9_;
				PasangMove** submoves = NULL;
				PasangMove** _tmp10_;
				gint submoves_length1;
				gint _submoves_size_;
				PasangMove** _tmp11_;
				gint _tmp11__length1;
				PasangMove** _tmp21_;
				gint _tmp21__length1;
				PasangMove** _tmp22_;
				gint _tmp22__length1;
				gboolean _tmp23_ = FALSE;
				PasangMove** _tmp24_;
				gint _tmp24__length1;
#line 281 "game.vala"
				_tmp9_ = self->priv->_stage;
#line 281 "game.vala"
				if (_tmp9_ == PASANG_STAGE_MOVE) {
#line 281 "game.vala"
					_tmp8_ = PASANG_STAGE_SUB_MOVE;
#line 1591 "game.c"
				} else {
#line 281 "game.vala"
					_tmp8_ = PASANG_STAGE_SUB_SELECT;
#line 1595 "game.c"
				}
#line 281 "game.vala"
				pasang_game_set_stage (self, _tmp8_);
#line 282 "game.vala"
				_tmp10_ = g_new0 (PasangMove*, 0 + 1);
#line 282 "game.vala"
				submoves = _tmp10_;
#line 282 "game.vala"
				submoves_length1 = 0;
#line 282 "game.vala"
				_submoves_size_ = submoves_length1;
#line 283 "game.vala"
				_tmp11_ = self->priv->moves;
#line 283 "game.vala"
				_tmp11__length1 = self->priv->moves_length1;
#line 1611 "game.c"
				{
					PasangMove** m_collection = NULL;
					gint m_collection_length1 = 0;
					gint _m_collection_size_ = 0;
					gint m_it = 0;
#line 283 "game.vala"
					m_collection = _tmp11_;
#line 283 "game.vala"
					m_collection_length1 = _tmp11__length1;
#line 283 "game.vala"
					for (m_it = 0; m_it < m_collection_length1; m_it = m_it + 1) {
#line 1623 "game.c"
						PasangMove* _tmp12_;
						PasangMove* m = NULL;
#line 283 "game.vala"
						_tmp12_ = _g_object_ref0 (m_collection[m_it]);
#line 283 "game.vala"
						m = _tmp12_;
#line 1630 "game.c"
						{
							PasangMove* _tmp13_;
							gint _tmp14_;
							gint _tmp15_;
							gint _tmp16_;
							gint _tmp17_;
#line 284 "game.vala"
							_tmp13_ = m;
#line 284 "game.vala"
							_tmp14_ = pasang_move_get_position (_tmp13_);
#line 284 "game.vala"
							_tmp15_ = _tmp14_;
#line 284 "game.vala"
							_tmp16_ = pasang_move_get_position (move);
#line 284 "game.vala"
							_tmp17_ = _tmp16_;
#line 284 "game.vala"
							if (_tmp15_ == _tmp17_) {
#line 1649 "game.c"
								PasangMove** _tmp18_;
								gint _tmp18__length1;
								PasangMove* _tmp19_;
								PasangMove* _tmp20_;
#line 284 "game.vala"
								_tmp18_ = submoves;
#line 284 "game.vala"
								_tmp18__length1 = submoves_length1;
#line 284 "game.vala"
								_tmp19_ = m;
#line 284 "game.vala"
								_tmp20_ = _g_object_ref0 (_tmp19_);
#line 284 "game.vala"
								_vala_array_add1 (&submoves, &submoves_length1, &_submoves_size_, _tmp20_);
#line 1664 "game.c"
							}
#line 283 "game.vala"
							_g_object_unref0 (m);
#line 1668 "game.c"
						}
					}
				}
#line 286 "game.vala"
				_tmp21_ = submoves;
#line 286 "game.vala"
				_tmp21__length1 = submoves_length1;
#line 286 "game.vala"
				_tmp22_ = (_tmp21_ != NULL) ? _vala_array_dup7 (_tmp21_, _tmp21__length1) : ((gpointer) _tmp21_);
#line 286 "game.vala"
				_tmp22__length1 = _tmp21__length1;
#line 286 "game.vala"
				self->priv->moves = (_vala_array_free (self->priv->moves, self->priv->moves_length1, (GDestroyNotify) g_object_unref), NULL);
#line 286 "game.vala"
				self->priv->moves = _tmp22_;
#line 286 "game.vala"
				self->priv->moves_length1 = _tmp22__length1;
#line 286 "game.vala"
				self->priv->_moves_size_ = self->priv->moves_length1;
#line 287 "game.vala"
				_tmp24_ = self->priv->moves;
#line 287 "game.vala"
				_tmp24__length1 = self->priv->moves_length1;
#line 287 "game.vala"
				if (_tmp24__length1 == 2) {
#line 287 "game.vala"
					_tmp23_ = TRUE;
#line 1696 "game.c"
				} else {
					PasangMove** _tmp25_;
					gint _tmp25__length1;
#line 287 "game.vala"
					_tmp25_ = self->priv->moves;
#line 287 "game.vala"
					_tmp25__length1 = self->priv->moves_length1;
#line 287 "game.vala"
					_tmp23_ = _tmp25__length1 == 3;
#line 1706 "game.c"
				}
#line 287 "game.vala"
				_vala_assert (_tmp23_, "moves.length == 2 || moves.length == 3");
#line 279 "game.vala"
				submoves = (_vala_array_free (submoves, submoves_length1, (GDestroyNotify) g_object_unref), NULL);
#line 1712 "game.c"
			} else {
#line 291 "game.vala"
				pasang_game_perform_capture (self, move);
#line 292 "game.vala"
				pasang_game_next_player (self);
#line 293 "game.vala"
				pasang_game_generate_moves (self);
#line 1720 "game.c"
			}
#line 295 "game.vala"
			break;
#line 1724 "game.c"
		}
		default:
#line 267 "game.vala"
		break;
#line 1729 "game.c"
	}
#line 298 "game.vala"
	_tmp26_ = self->priv->moves;
#line 298 "game.vala"
	_tmp26__length1 = self->priv->moves_length1;
#line 298 "game.vala"
	if (_tmp26__length1 == 0) {
#line 1737 "game.c"
		gint _tmp27_;
#line 299 "game.vala"
		pasang_game_set_stage (self, PASANG_STAGE_GAME_OVER);
#line 300 "game.vala"
		_tmp27_ = self->priv->_value_of_uncaptured_pieces;
#line 300 "game.vala"
		if (_tmp27_ > 0) {
#line 1745 "game.c"
			gint* _tmp28_;
			gint _tmp28__length1;
			gint _tmp29_;
			gint* _tmp30_;
			gint _tmp30__length1;
			gint _tmp31_;
			gint _tmp32_;
			gint* _tmp33_;
			gint _tmp33__length1;
			gint _tmp34_;
#line 301 "game.vala"
			_tmp28_ = self->score;
#line 301 "game.vala"
			_tmp28__length1 = self->score_length1;
#line 301 "game.vala"
			_tmp29_ = self->priv->_player;
#line 301 "game.vala"
			_tmp30_ = self->score;
#line 301 "game.vala"
			_tmp30__length1 = self->score_length1;
#line 301 "game.vala"
			_tmp31_ = self->priv->_player;
#line 301 "game.vala"
			_tmp32_ = _tmp30_[_tmp31_];
#line 301 "game.vala"
			_tmp28_[1 - _tmp29_] += _tmp32_;
#line 302 "game.vala"
			_tmp33_ = self->score;
#line 302 "game.vala"
			_tmp33__length1 = self->score_length1;
#line 302 "game.vala"
			_tmp34_ = self->priv->_player;
#line 302 "game.vala"
			_tmp33_[_tmp34_] = 0;
#line 1780 "game.c"
		}
	}
#line 305 "game.vala"
	_tmp36_ = self->priv->_stage;
#line 305 "game.vala"
	if (_tmp36_ != PASANG_STAGE_SUB_MOVE) {
#line 1787 "game.c"
		PasangStage _tmp37_;
#line 305 "game.vala"
		_tmp37_ = self->priv->_stage;
#line 305 "game.vala"
		_tmp35_ = _tmp37_ != PASANG_STAGE_SUB_SELECT;
#line 1793 "game.c"
	} else {
#line 305 "game.vala"
		_tmp35_ = FALSE;
#line 1797 "game.c"
	}
#line 305 "game.vala"
	if (_tmp35_) {
#line 1801 "game.c"
		gint _tmp38_;
#line 305 "game.vala"
		_tmp38_ = self->priv->_seq;
#line 305 "game.vala"
		pasang_game_set_seq (self, _tmp38_ + 1);
#line 1807 "game.c"
	}
}

/**
     * Perform the given text-encoded move (see Move.notation).
     * Unchecked precondition: generate_moves should be called first.
     */
void
pasang_game_perform_from_notation (PasangGame* self,
                                   const gchar* move_notation)
{
	PasangMove* _tmp0_;
	PasangMove* _tmp1_;
#line 312 "game.vala"
	g_return_if_fail (self != NULL);
#line 312 "game.vala"
	g_return_if_fail (move_notation != NULL);
#line 313 "game.vala"
	_tmp0_ = pasang_game_get_move (self, move_notation);
#line 313 "game.vala"
	_tmp1_ = _tmp0_;
#line 313 "game.vala"
	pasang_game_perform (self, _tmp1_, TRUE);
#line 313 "game.vala"
	_g_object_unref0 (_tmp1_);
#line 1833 "game.c"
}

/**
     * Get the move represented by the given notation (see Move.notation).
     */
PasangMove*
pasang_game_get_move (PasangGame* self,
                      const gchar* move_notation)
{
	PasangMove** _tmp0_;
	gint _tmp0__length1;
	PasangMove* result = NULL;
#line 319 "game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 319 "game.vala"
	g_return_val_if_fail (move_notation != NULL, NULL);
#line 320 "game.vala"
	_tmp0_ = self->priv->moves;
#line 320 "game.vala"
	_tmp0__length1 = self->priv->moves_length1;
#line 1854 "game.c"
	{
		PasangMove** m_collection = NULL;
		gint m_collection_length1 = 0;
		gint _m_collection_size_ = 0;
		gint m_it = 0;
#line 320 "game.vala"
		m_collection = _tmp0_;
#line 320 "game.vala"
		m_collection_length1 = _tmp0__length1;
#line 320 "game.vala"
		for (m_it = 0; m_it < m_collection_length1; m_it = m_it + 1) {
#line 1866 "game.c"
			PasangMove* _tmp1_;
			PasangMove* m = NULL;
#line 320 "game.vala"
			_tmp1_ = _g_object_ref0 (m_collection[m_it]);
#line 320 "game.vala"
			m = _tmp1_;
#line 1873 "game.c"
			{
				PasangMove* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
#line 321 "game.vala"
				_tmp2_ = m;
#line 321 "game.vala"
				_tmp3_ = pasang_move_get_notation (_tmp2_);
#line 321 "game.vala"
				_tmp4_ = _tmp3_;
#line 321 "game.vala"
				if (g_strcmp0 (_tmp4_, move_notation) == 0) {
#line 322 "game.vala"
					result = m;
#line 322 "game.vala"
					return result;
#line 1890 "game.c"
				}
#line 320 "game.vala"
				_g_object_unref0 (m);
#line 1894 "game.c"
			}
		}
	}
#line 325 "game.vala"
	result = NULL;
#line 325 "game.vala"
	return result;
#line 1902 "game.c"
}

/**
     * Move kas, but do not capture yet because a further submove may be required.
     */
static void
pasang_game_perform_move_kas (PasangGame* self,
                              PasangMove* move)
{
	gint position = 0;
	gint _tmp0_;
	gint _tmp1_;
	PasangStage _tmp2_;
#line 331 "game.vala"
	g_return_if_fail (self != NULL);
#line 331 "game.vala"
	g_return_if_fail (move != NULL);
#line 332 "game.vala"
	_tmp0_ = pasang_move_get_position (move);
#line 332 "game.vala"
	_tmp1_ = _tmp0_;
#line 332 "game.vala"
	position = _tmp1_;
#line 333 "game.vala"
	_tmp2_ = self->priv->_stage;
#line 333 "game.vala"
	if (_tmp2_ == PASANG_STAGE_SELECT) {
#line 1930 "game.c"
		gint col = 0;
		gint* _tmp3_;
		gint _tmp3__length1;
		gint _tmp4_;
		gint _tmp5_;
		gint row = 0;
		gint* _tmp6_;
		gint _tmp6__length1;
		gint _tmp7_;
		gint _tmp8_ = 0;
		PasangPiece* _tmp9_;
		gint _tmp9__length1;
		PasangPiece _tmp10_;
		gint _tmp11_;
		PasangPiece* _tmp12_;
		gint _tmp12__length1;
		PasangPiece* _tmp13_;
		gint _tmp13__length1;
		gint* _tmp14_;
		gint _tmp14__length1;
		gint _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
#line 336 "game.vala"
		_tmp3_ = self->first_move;
#line 336 "game.vala"
		_tmp3__length1 = self->first_move_length1;
#line 336 "game.vala"
		_tmp4_ = self->priv->_player;
#line 336 "game.vala"
		_tmp5_ = _tmp3_[_tmp4_];
#line 336 "game.vala"
		col = _tmp5_;
#line 337 "game.vala"
		row = position / PASANG_BOARD_WIDTH;
#line 338 "game.vala"
		_tmp6_ = self->kas_position;
#line 338 "game.vala"
		_tmp6__length1 = self->kas_position_length1;
#line 338 "game.vala"
		_tmp7_ = self->priv->_player;
#line 338 "game.vala"
		_tmp6_[_tmp7_] = col + (row * PASANG_BOARD_WIDTH);
#line 340 "game.vala"
		_tmp9_ = self->board;
#line 340 "game.vala"
		_tmp9__length1 = self->board_length1;
#line 340 "game.vala"
		_tmp10_ = _tmp9_[position];
#line 340 "game.vala"
		if (_tmp10_ == PASANG_PIECE_WHITE) {
#line 340 "game.vala"
			_tmp8_ = 2;
#line 1984 "game.c"
		} else {
#line 340 "game.vala"
			_tmp8_ = 1;
#line 1988 "game.c"
		}
#line 340 "game.vala"
		_tmp11_ = self->priv->_value_of_uncaptured_pieces;
#line 340 "game.vala"
		pasang_game_set_value_of_uncaptured_pieces (self, _tmp11_ - _tmp8_);
#line 342 "game.vala"
		_tmp12_ = self->board;
#line 342 "game.vala"
		_tmp12__length1 = self->board_length1;
#line 342 "game.vala"
		_tmp12_[position] = PASANG_PIECE_EMPTY;
#line 343 "game.vala"
		_tmp13_ = self->board;
#line 343 "game.vala"
		_tmp13__length1 = self->board_length1;
#line 343 "game.vala"
		_tmp14_ = self->kas_position;
#line 343 "game.vala"
		_tmp14__length1 = self->kas_position_length1;
#line 343 "game.vala"
		_tmp15_ = self->priv->_player;
#line 343 "game.vala"
		_tmp16_ = _tmp14_[_tmp15_];
#line 343 "game.vala"
		_tmp17_ = self->priv->_player;
#line 343 "game.vala"
		_tmp13_[_tmp16_] = (PasangPiece) _tmp17_;
#line 2016 "game.c"
	} else {
		PasangPiece* _tmp18_;
		gint _tmp18__length1;
		gint* _tmp19_;
		gint _tmp19__length1;
		gint _tmp20_;
		gint _tmp21_;
		PasangPiece* _tmp22_;
		gint _tmp22__length1;
		gint _tmp23_;
		gint* _tmp24_;
		gint _tmp24__length1;
		gint _tmp25_;
#line 347 "game.vala"
		_tmp18_ = self->board;
#line 347 "game.vala"
		_tmp18__length1 = self->board_length1;
#line 347 "game.vala"
		_tmp19_ = self->kas_position;
#line 347 "game.vala"
		_tmp19__length1 = self->kas_position_length1;
#line 347 "game.vala"
		_tmp20_ = self->priv->_player;
#line 347 "game.vala"
		_tmp21_ = _tmp19_[_tmp20_];
#line 347 "game.vala"
		_tmp18_[_tmp21_] = PASANG_PIECE_EMPTY;
#line 348 "game.vala"
		_tmp22_ = self->board;
#line 348 "game.vala"
		_tmp22__length1 = self->board_length1;
#line 348 "game.vala"
		_tmp23_ = self->priv->_player;
#line 348 "game.vala"
		_tmp22_[position] = (PasangPiece) _tmp23_;
#line 349 "game.vala"
		_tmp24_ = self->kas_position;
#line 349 "game.vala"
		_tmp24__length1 = self->kas_position_length1;
#line 349 "game.vala"
		_tmp25_ = self->priv->_player;
#line 349 "game.vala"
		_tmp24_[_tmp25_] = position;
#line 2060 "game.c"
	}
}

/**
     * Capture the pieces listed in the move's list of booties, making 
     * those positions empty. The player's score is updated.
     */
static void
pasang_game_perform_capture (PasangGame* self,
                             PasangMove* move)
{
	gint* _tmp0_;
	gint _tmp0__length1;
#line 357 "game.vala"
	g_return_if_fail (self != NULL);
#line 357 "game.vala"
	g_return_if_fail (move != NULL);
#line 358 "game.vala"
	_tmp0_ = move->booties;
#line 358 "game.vala"
	_tmp0__length1 = move->booties_length1;
#line 2082 "game.c"
	{
		gint* pos_collection = NULL;
		gint pos_collection_length1 = 0;
		gint _pos_collection_size_ = 0;
		gint pos_it = 0;
#line 358 "game.vala"
		pos_collection = _tmp0_;
#line 358 "game.vala"
		pos_collection_length1 = _tmp0__length1;
#line 358 "game.vala"
		for (pos_it = 0; pos_it < pos_collection_length1; pos_it = pos_it + 1) {
#line 2094 "game.c"
			gint pos = 0;
#line 358 "game.vala"
			pos = pos_collection[pos_it];
#line 2098 "game.c"
			{
				PasangPiece* _tmp1_;
				gint _tmp1__length1;
				PasangPiece _tmp2_;
				PasangPiece* _tmp26_;
				gint _tmp26__length1;
#line 359 "game.vala"
				_tmp1_ = self->board;
#line 359 "game.vala"
				_tmp1__length1 = self->board_length1;
#line 359 "game.vala"
				_tmp2_ = _tmp1_[pos];
#line 359 "game.vala"
				if (_tmp2_ == PASANG_PIECE_WHITE) {
#line 2113 "game.c"
					gint _tmp3_;
					gint* _tmp4_;
					gint _tmp4__length1;
					gint _tmp5_;
#line 360 "game.vala"
					_tmp3_ = self->priv->_value_of_uncaptured_pieces;
#line 360 "game.vala"
					pasang_game_set_value_of_uncaptured_pieces (self, _tmp3_ - 2);
#line 361 "game.vala"
					_tmp4_ = self->score;
#line 361 "game.vala"
					_tmp4__length1 = self->score_length1;
#line 361 "game.vala"
					_tmp5_ = self->priv->_player;
#line 361 "game.vala"
					_tmp4_[_tmp5_] += 2;
#line 2130 "game.c"
				} else {
					PasangPiece* _tmp6_;
					gint _tmp6__length1;
					PasangPiece _tmp7_;
#line 363 "game.vala"
					_tmp6_ = self->board;
#line 363 "game.vala"
					_tmp6__length1 = self->board_length1;
#line 363 "game.vala"
					_tmp7_ = _tmp6_[pos];
#line 363 "game.vala"
					if (_tmp7_ == PASANG_PIECE_BLACK) {
#line 2143 "game.c"
						gint _tmp8_;
						gint* _tmp9_;
						gint _tmp9__length1;
						gint _tmp10_;
						gint _tmp11_;
#line 364 "game.vala"
						_tmp8_ = self->priv->_value_of_uncaptured_pieces;
#line 364 "game.vala"
						pasang_game_set_value_of_uncaptured_pieces (self, _tmp8_ - 1);
#line 365 "game.vala"
						_tmp9_ = self->score;
#line 365 "game.vala"
						_tmp9__length1 = self->score_length1;
#line 365 "game.vala"
						_tmp10_ = self->priv->_player;
#line 365 "game.vala"
						_tmp11_ = _tmp9_[_tmp10_];
#line 365 "game.vala"
						_tmp9_[_tmp10_] = _tmp11_ + 1;
#line 2163 "game.c"
					} else {
						FILE* _tmp23_;
						const gchar* _tmp24_;
						const gchar* _tmp25_;
						{
							gint i = 0;
#line 368 "game.vala"
							i = 0;
#line 2172 "game.c"
							{
								gboolean _tmp12_ = FALSE;
#line 368 "game.vala"
								_tmp12_ = TRUE;
#line 368 "game.vala"
								while (TRUE) {
#line 2179 "game.c"
									PasangPiece* _tmp15_;
									gint _tmp15__length1;
									PasangPiece _tmp16_;
#line 368 "game.vala"
									if (!_tmp12_) {
#line 2185 "game.c"
										gint _tmp13_;
#line 368 "game.vala"
										_tmp13_ = i;
#line 368 "game.vala"
										i = _tmp13_ + 1;
#line 2191 "game.c"
									}
#line 368 "game.vala"
									_tmp12_ = FALSE;
#line 368 "game.vala"
									if (!(i < PASANG_BOARD_SIZE)) {
#line 368 "game.vala"
										break;
#line 2199 "game.c"
									}
#line 369 "game.vala"
									if ((i % PASANG_BOARD_WIDTH) == 0) {
#line 2203 "game.c"
										FILE* _tmp14_;
#line 369 "game.vala"
										_tmp14_ = stderr;
#line 369 "game.vala"
										fprintf (_tmp14_, "\n");
#line 2209 "game.c"
									}
#line 370 "game.vala"
									_tmp15_ = self->board;
#line 370 "game.vala"
									_tmp15__length1 = self->board_length1;
#line 370 "game.vala"
									_tmp16_ = _tmp15_[i];
#line 370 "game.vala"
									switch (_tmp16_) {
#line 370 "game.vala"
										case PASANG_PIECE_WHITE:
#line 2221 "game.c"
										{
											FILE* _tmp17_;
#line 372 "game.vala"
											_tmp17_ = stderr;
#line 372 "game.vala"
											fprintf (_tmp17_, "2");
#line 372 "game.vala"
											break;
#line 2230 "game.c"
										}
#line 370 "game.vala"
										case PASANG_PIECE_BLACK:
#line 2234 "game.c"
										{
											FILE* _tmp18_;
#line 374 "game.vala"
											_tmp18_ = stderr;
#line 374 "game.vala"
											fprintf (_tmp18_, "1");
#line 374 "game.vala"
											break;
#line 2243 "game.c"
										}
#line 370 "game.vala"
										case PASANG_PIECE_KAS_0:
#line 2247 "game.c"
										{
											FILE* _tmp19_;
#line 376 "game.vala"
											_tmp19_ = stderr;
#line 376 "game.vala"
											fprintf (_tmp19_, "R");
#line 376 "game.vala"
											break;
#line 2256 "game.c"
										}
#line 370 "game.vala"
										case PASANG_PIECE_KAS_1:
#line 2260 "game.c"
										{
											FILE* _tmp20_;
#line 378 "game.vala"
											_tmp20_ = stderr;
#line 378 "game.vala"
											fprintf (_tmp20_, "B");
#line 378 "game.vala"
											break;
#line 2269 "game.c"
										}
#line 370 "game.vala"
										case PASANG_PIECE_EMPTY:
#line 2273 "game.c"
										{
											FILE* _tmp21_;
#line 380 "game.vala"
											_tmp21_ = stderr;
#line 380 "game.vala"
											fprintf (_tmp21_, ".");
#line 380 "game.vala"
											break;
#line 2282 "game.c"
										}
										default:
										{
											FILE* _tmp22_;
#line 382 "game.vala"
											_tmp22_ = stderr;
#line 382 "game.vala"
											fprintf (_tmp22_, " ");
#line 382 "game.vala"
											break;
#line 2293 "game.c"
										}
									}
								}
							}
						}
#line 385 "game.vala"
						_tmp23_ = stderr;
#line 385 "game.vala"
						_tmp24_ = pasang_move_get_notation (move);
#line 385 "game.vala"
						_tmp25_ = _tmp24_;
#line 385 "game.vala"
						fprintf (_tmp23_, "\nError trying to perform %s\n", _tmp25_);
#line 386 "game.vala"
						g_assert_not_reached ();
#line 2309 "game.c"
					}
				}
#line 388 "game.vala"
				_tmp26_ = self->board;
#line 388 "game.vala"
				_tmp26__length1 = self->board_length1;
#line 388 "game.vala"
				_tmp26_[pos] = PASANG_PIECE_EMPTY;
#line 2318 "game.c"
			}
		}
	}
}

/**
     * Set up for the next player's turn, advancing the stage of the game.
     */
static void
pasang_game_next_player (PasangGame* self)
{
	PasangStage _tmp0_;
	gint _tmp2_;
	gint _tmp5_;
#line 395 "game.vala"
	g_return_if_fail (self != NULL);
#line 396 "game.vala"
	_tmp0_ = self->priv->_stage;
#line 396 "game.vala"
	if (_tmp0_ == PASANG_STAGE_SUB_SELECT) {
#line 397 "game.vala"
		pasang_game_set_stage (self, PASANG_STAGE_SELECT);
#line 2341 "game.c"
	} else {
		PasangStage _tmp1_;
#line 398 "game.vala"
		_tmp1_ = self->priv->_stage;
#line 398 "game.vala"
		if (_tmp1_ == PASANG_STAGE_SUB_MOVE) {
#line 399 "game.vala"
			pasang_game_set_stage (self, PASANG_STAGE_MOVE);
#line 2350 "game.c"
		}
	}
#line 401 "game.vala"
	_tmp2_ = self->priv->_player;
#line 401 "game.vala"
	if (_tmp2_ == 1) {
#line 2357 "game.c"
		PasangStage _tmp3_;
#line 402 "game.vala"
		_tmp3_ = self->priv->_stage;
#line 402 "game.vala"
		if (_tmp3_ == PASANG_STAGE_OPENING) {
#line 403 "game.vala"
			pasang_game_set_stage (self, PASANG_STAGE_SELECT);
#line 2365 "game.c"
		} else {
			PasangStage _tmp4_;
#line 404 "game.vala"
			_tmp4_ = self->priv->_stage;
#line 404 "game.vala"
			if (_tmp4_ == PASANG_STAGE_SELECT) {
#line 405 "game.vala"
				pasang_game_set_stage (self, PASANG_STAGE_MOVE);
#line 2374 "game.c"
			}
		}
	}
#line 407 "game.vala"
	_tmp5_ = self->priv->_player;
#line 407 "game.vala"
	pasang_game_set_player (self, 1 - _tmp5_);
#line 2382 "game.c"
}

/**
     * Count the number of moves having the same "position" (but different capture).
     * After the kas is moved to (or selected from) this position, the capture
     * must be resolved (i.e., a submove must be made).
     */
gint
pasang_game_count_submoves (PasangGame* self,
                            PasangMove* move)
{
	gint count = 0;
	PasangMove** _tmp0_;
	gint _tmp0__length1;
	gint result = 0;
#line 415 "game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 415 "game.vala"
	g_return_val_if_fail (move != NULL, 0);
#line 416 "game.vala"
	count = 0;
#line 417 "game.vala"
	_tmp0_ = self->priv->moves;
#line 417 "game.vala"
	_tmp0__length1 = self->priv->moves_length1;
#line 2408 "game.c"
	{
		PasangMove** m_collection = NULL;
		gint m_collection_length1 = 0;
		gint _m_collection_size_ = 0;
		gint m_it = 0;
#line 417 "game.vala"
		m_collection = _tmp0_;
#line 417 "game.vala"
		m_collection_length1 = _tmp0__length1;
#line 417 "game.vala"
		for (m_it = 0; m_it < m_collection_length1; m_it = m_it + 1) {
#line 2420 "game.c"
			PasangMove* _tmp1_;
			PasangMove* m = NULL;
#line 417 "game.vala"
			_tmp1_ = _g_object_ref0 (m_collection[m_it]);
#line 417 "game.vala"
			m = _tmp1_;
#line 2427 "game.c"
			{
				gint _tmp2_;
				gint _tmp3_;
				PasangMove* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
#line 418 "game.vala"
				_tmp2_ = pasang_move_get_position (move);
#line 418 "game.vala"
				_tmp3_ = _tmp2_;
#line 418 "game.vala"
				_tmp4_ = m;
#line 418 "game.vala"
				_tmp5_ = pasang_move_get_position (_tmp4_);
#line 418 "game.vala"
				_tmp6_ = _tmp5_;
#line 418 "game.vala"
				if (_tmp3_ == _tmp6_) {
#line 2446 "game.c"
					gint _tmp7_;
#line 418 "game.vala"
					_tmp7_ = count;
#line 418 "game.vala"
					count = _tmp7_ + 1;
#line 2452 "game.c"
				}
#line 417 "game.vala"
				_g_object_unref0 (m);
#line 2456 "game.c"
			}
		}
	}
#line 420 "game.vala"
	result = count;
#line 420 "game.vala"
	return result;
#line 2464 "game.c"
}

/** 
     * Sort moves in descending values.
     */
static gint
__lambda4_ (void* m1,
            void* m2)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint result = 0;
#line 428 "game.vala"
	_tmp0_ = pasang_move_get_value (*((PasangMove**) m2));
#line 428 "game.vala"
	_tmp1_ = _tmp0_;
#line 428 "game.vala"
	_tmp2_ = pasang_move_get_value (*((PasangMove**) m1));
#line 428 "game.vala"
	_tmp3_ = _tmp2_;
#line 428 "game.vala"
	result = _tmp1_ - _tmp3_;
#line 428 "game.vala"
	return result;
#line 2491 "game.c"
}

static gint
___lambda4____compar_fn_t (void* key1,
                           void* key2)
{
	gint result;
	result = __lambda4_ (key1, key2);
#line 427 "game.vala"
	return result;
#line 2502 "game.c"
}

void
pasang_game_sort_moves (PasangGame* self)
{
	PasangMove** _tmp0_;
	gint _tmp0__length1;
	PasangMove** _tmp1_;
	gint _tmp1__length1;
#line 426 "game.vala"
	g_return_if_fail (self != NULL);
#line 427 "game.vala"
	_tmp0_ = self->priv->moves;
#line 427 "game.vala"
	_tmp0__length1 = self->priv->moves_length1;
#line 427 "game.vala"
	_tmp1_ = self->priv->moves;
#line 427 "game.vala"
	_tmp1__length1 = self->priv->moves_length1;
#line 427 "game.vala"
	qsort (_tmp0_, (gsize) _tmp1__length1, (gsize) sizeof (PasangMove*), ___lambda4____compar_fn_t);
#line 2524 "game.c"
}

/**
     * Delete every move except the given one
     */
void
pasang_game_leave_one_move (PasangGame* self,
                            PasangMove* move)
{
	PasangMove* _tmp0_;
	PasangMove** _tmp1_;
#line 434 "game.vala"
	g_return_if_fail (self != NULL);
#line 434 "game.vala"
	g_return_if_fail (move != NULL);
#line 435 "game.vala"
	_tmp0_ = _g_object_ref0 (move);
#line 435 "game.vala"
	_tmp1_ = g_new0 (PasangMove*, 1 + 1);
#line 435 "game.vala"
	_tmp1_[0] = _tmp0_;
#line 435 "game.vala"
	self->priv->moves = (_vala_array_free (self->priv->moves, self->priv->moves_length1, (GDestroyNotify) g_object_unref), NULL);
#line 435 "game.vala"
	self->priv->moves = _tmp1_;
#line 435 "game.vala"
	self->priv->moves_length1 = 1;
#line 435 "game.vala"
	self->priv->_moves_size_ = self->priv->moves_length1;
#line 2554 "game.c"
}

/**
     * Generate a list of all possible moves.
     */
void
pasang_game_generate_moves (PasangGame* self)
{
	PasangMove** _tmp0_;
	PasangStage _tmp1_;
#line 441 "game.vala"
	g_return_if_fail (self != NULL);
#line 442 "game.vala"
	_tmp0_ = g_new0 (PasangMove*, 0 + 1);
#line 442 "game.vala"
	self->priv->moves = (_vala_array_free (self->priv->moves, self->priv->moves_length1, (GDestroyNotify) g_object_unref), NULL);
#line 442 "game.vala"
	self->priv->moves = _tmp0_;
#line 442 "game.vala"
	self->priv->moves_length1 = 0;
#line 442 "game.vala"
	self->priv->_moves_size_ = self->priv->moves_length1;
#line 443 "game.vala"
	_tmp1_ = self->priv->_stage;
#line 443 "game.vala"
	if (_tmp1_ == PASANG_STAGE_OPENING) {
#line 444 "game.vala"
		pasang_game_generate_opening_moves (self);
#line 2583 "game.c"
	} else {
		PasangStage _tmp2_;
#line 446 "game.vala"
		_tmp2_ = self->priv->_stage;
#line 446 "game.vala"
		if (_tmp2_ == PASANG_STAGE_SELECT) {
#line 447 "game.vala"
			pasang_game_generate_kas_selection_moves (self);
#line 2592 "game.c"
		} else {
			PasangStage _tmp3_;
#line 449 "game.vala"
			_tmp3_ = self->priv->_stage;
#line 449 "game.vala"
			if (_tmp3_ == PASANG_STAGE_MOVE) {
#line 450 "game.vala"
				pasang_game_generate_kas_moving_moves (self);
#line 2601 "game.c"
			} else {
				FILE* _tmp4_;
				PasangStage _tmp5_;
#line 453 "game.vala"
				_tmp4_ = stderr;
#line 453 "game.vala"
				_tmp5_ = self->priv->_stage;
#line 453 "game.vala"
				fprintf (_tmp4_, "Stage : %d\n", (gint) _tmp5_);
#line 454 "game.vala"
				g_assert_not_reached ();
#line 2613 "game.c"
			}
		}
	}
}

/**
     * Generate moves each of which captures either these 5 pieces
     *   (x,1), (x,2), (x,3), (x,4), (x,5)    -- for player 0
     * or these 5
     *   (x,7), (x,8), (x,9), (x,10), (x,11)  -- for player 1
     * where x is an element of [1,2,...,11]-[forbidden_column]
     */
static void
_vala_array_add2 (gint* * array,
                  int* length,
                  int* size,
                  gint value)
{
#line 474 "game.vala"
	if ((*length) == (*size)) {
#line 474 "game.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 474 "game.vala"
		*array = g_renew (gint, *array, *size);
#line 2638 "game.c"
	}
#line 474 "game.vala"
	(*array)[(*length)++] = value;
#line 2642 "game.c"
}

static void
_vala_array_add3 (PasangMove** * array,
                  int* length,
                  int* size,
                  PasangMove* value)
{
#line 477 "game.vala"
	if ((*length) == (*size)) {
#line 477 "game.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 477 "game.vala"
		*array = g_renew (PasangMove*, *array, (*size) + 1);
#line 2657 "game.c"
	}
#line 477 "game.vala"
	(*array)[(*length)++] = value;
#line 477 "game.vala"
	(*array)[*length] = NULL;
#line 2663 "game.c"
}

static void
pasang_game_generate_opening_moves (PasangGame* self)
{
	gint _tmp0_ = 0;
	gint _tmp1_;
	gint forbidden_column = 0;
	gint _tmp4_ = 0;
	gint _tmp5_;
	gint ref_pos = 0;
#line 465 "game.vala"
	g_return_if_fail (self != NULL);
#line 467 "game.vala"
	_tmp1_ = self->priv->_player;
#line 467 "game.vala"
	if (_tmp1_ == 1) {
#line 2681 "game.c"
		gint* _tmp2_;
		gint _tmp2__length1;
		gint _tmp3_;
#line 467 "game.vala"
		_tmp2_ = self->first_move;
#line 467 "game.vala"
		_tmp2__length1 = self->first_move_length1;
#line 467 "game.vala"
		_tmp3_ = _tmp2_[0];
#line 467 "game.vala"
		_tmp0_ = 12 - _tmp3_;
#line 2693 "game.c"
	} else {
#line 467 "game.vala"
		_tmp0_ = -1;
#line 2697 "game.c"
	}
#line 467 "game.vala"
	forbidden_column = _tmp0_;
#line 468 "game.vala"
	_tmp5_ = self->priv->_player;
#line 468 "game.vala"
	if (_tmp5_ == 0) {
#line 468 "game.vala"
		_tmp4_ = 1;
#line 2707 "game.c"
	} else {
#line 468 "game.vala"
		_tmp4_ = 7;
#line 2711 "game.c"
	}
#line 468 "game.vala"
	ref_pos = _tmp4_ * PASANG_BOARD_WIDTH;
#line 2715 "game.c"
	{
		gint col = 0;
#line 469 "game.vala"
		col = 1;
#line 2720 "game.c"
		{
			gboolean _tmp6_ = FALSE;
#line 469 "game.vala"
			_tmp6_ = TRUE;
#line 469 "game.vala"
			while (TRUE) {
#line 2727 "game.c"
				gint* booties = NULL;
				gint* _tmp8_;
				gint booties_length1;
				gint _booties_size_;
				gint capture_position = 0;
				PasangMove** _tmp12_;
				gint _tmp12__length1;
				gint* _tmp13_;
				gint _tmp13__length1;
				PasangMove* _tmp14_;
#line 469 "game.vala"
				if (!_tmp6_) {
#line 2740 "game.c"
					gint _tmp7_;
#line 469 "game.vala"
					_tmp7_ = col;
#line 469 "game.vala"
					col = _tmp7_ + 1;
#line 2746 "game.c"
				}
#line 469 "game.vala"
				_tmp6_ = FALSE;
#line 469 "game.vala"
				if (!(col <= 11)) {
#line 469 "game.vala"
					break;
#line 2754 "game.c"
				}
#line 470 "game.vala"
				if (col == forbidden_column) {
#line 470 "game.vala"
					continue;
#line 2760 "game.c"
				}
#line 471 "game.vala"
				_tmp8_ = g_new0 (gint, 0);
#line 471 "game.vala"
				booties = _tmp8_;
#line 471 "game.vala"
				booties_length1 = 0;
#line 471 "game.vala"
				_booties_size_ = booties_length1;
#line 472 "game.vala"
				capture_position = ref_pos + col;
#line 2772 "game.c"
				{
					gint n = 0;
#line 473 "game.vala"
					n = 0;
#line 2777 "game.c"
					{
						gboolean _tmp9_ = FALSE;
#line 473 "game.vala"
						_tmp9_ = TRUE;
#line 473 "game.vala"
						while (TRUE) {
#line 2784 "game.c"
							gint* _tmp11_;
							gint _tmp11__length1;
#line 473 "game.vala"
							if (!_tmp9_) {
#line 2789 "game.c"
								gint _tmp10_;
#line 473 "game.vala"
								_tmp10_ = n;
#line 473 "game.vala"
								n = _tmp10_ + 1;
#line 2795 "game.c"
							}
#line 473 "game.vala"
							_tmp9_ = FALSE;
#line 473 "game.vala"
							if (!(n < 5)) {
#line 473 "game.vala"
								break;
#line 2803 "game.c"
							}
#line 474 "game.vala"
							_tmp11_ = booties;
#line 474 "game.vala"
							_tmp11__length1 = booties_length1;
#line 474 "game.vala"
							_vala_array_add2 (&booties, &booties_length1, &_booties_size_, capture_position);
#line 475 "game.vala"
							capture_position += (gint) PASANG_DELTA_DOWN;
#line 2813 "game.c"
						}
					}
				}
#line 477 "game.vala"
				_tmp12_ = self->priv->moves;
#line 477 "game.vala"
				_tmp12__length1 = self->priv->moves_length1;
#line 477 "game.vala"
				_tmp13_ = booties;
#line 477 "game.vala"
				_tmp13__length1 = booties_length1;
#line 477 "game.vala"
				_tmp14_ = pasang_move_new (self, col, _tmp13_, _tmp13__length1);
#line 477 "game.vala"
				_vala_array_add3 (&self->priv->moves, &self->priv->moves_length1, &self->priv->_moves_size_, _tmp14_);
#line 469 "game.vala"
				booties = (g_free (booties), NULL);
#line 2831 "game.c"
			}
		}
	}
}

/**
     * The kas can be selected from a piece on the banks, each two-column wide, astriding 
     * the empty column that was captured during the opening move. Such a piece is either 
     * one grid or two grid away from the empty column (see figure below where O represent 
     * a candidate kas).
     *
     *                 OOeOO
     *                 OOmOO
     *                 OOpOO
     *                 OOtOO
     *                 OOyOO
     *
     * <diversion>
     *   Note that the test "candidate != Piece.EMPTY" was missing from the original
     *   Pasang Emas (non-free, and this bug will live forever in there). As a result, 
     *   a captured piece can still be used for the kas!. (e.g. Select "galap" pattern. 
     *   Player 0 capture column 3, Player 1 capture column 2. Now Player 0 can 
     *   capture the three black pieces, two of which are player 1's potential kas).
     * </diversion>
     */
static void
pasang_game_generate_kas_selection_moves (PasangGame* self)
{
	gint _tmp0_ = 0;
	gint _tmp1_;
	gint row = 0;
	gint col = 0;
	gint* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	gint _tmp4_;
	gint* distances = NULL;
	gint* _tmp5_;
	gint distances_length1;
	gint _distances_size_;
#line 501 "game.vala"
	g_return_if_fail (self != NULL);
#line 502 "game.vala"
	_tmp1_ = self->priv->_player;
#line 502 "game.vala"
	if (_tmp1_ == 0) {
#line 502 "game.vala"
		_tmp0_ = 1;
#line 2880 "game.c"
	} else {
#line 502 "game.vala"
		_tmp0_ = 7;
#line 2884 "game.c"
	}
#line 502 "game.vala"
	row = _tmp0_;
#line 503 "game.vala"
	_tmp2_ = self->first_move;
#line 503 "game.vala"
	_tmp2__length1 = self->first_move_length1;
#line 503 "game.vala"
	_tmp3_ = self->priv->_player;
#line 503 "game.vala"
	_tmp4_ = _tmp2_[_tmp3_];
#line 503 "game.vala"
	col = _tmp4_;
#line 504 "game.vala"
	_tmp5_ = g_new0 (gint, 4);
#line 504 "game.vala"
	_tmp5_[0] = -2;
#line 504 "game.vala"
	_tmp5_[1] = -1;
#line 504 "game.vala"
	_tmp5_[2] = 1;
#line 504 "game.vala"
	_tmp5_[3] = 2;
#line 504 "game.vala"
	distances = _tmp5_;
#line 504 "game.vala"
	distances_length1 = 4;
#line 504 "game.vala"
	_distances_size_ = distances_length1;
#line 2914 "game.c"
	{
		gint j = 0;
#line 505 "game.vala"
		j = 0;
#line 2919 "game.c"
		{
			gboolean _tmp6_ = FALSE;
#line 505 "game.vala"
			_tmp6_ = TRUE;
#line 505 "game.vala"
			while (TRUE) {
#line 2926 "game.c"
				gint empty_position = 0;
				gint* _tmp8_;
				gint _tmp8__length1;
#line 505 "game.vala"
				if (!_tmp6_) {
#line 2932 "game.c"
					gint _tmp7_;
#line 505 "game.vala"
					_tmp7_ = j;
#line 505 "game.vala"
					j = _tmp7_ + 1;
#line 2938 "game.c"
				}
#line 505 "game.vala"
				_tmp6_ = FALSE;
#line 505 "game.vala"
				if (!(j < 5)) {
#line 505 "game.vala"
					break;
#line 2946 "game.c"
				}
#line 506 "game.vala"
				empty_position = ((row + j) * PASANG_BOARD_WIDTH) + col;
#line 507 "game.vala"
				_tmp8_ = distances;
#line 507 "game.vala"
				_tmp8__length1 = distances_length1;
#line 2954 "game.c"
				{
					gint* distance_collection = NULL;
					gint distance_collection_length1 = 0;
					gint _distance_collection_size_ = 0;
					gint distance_it = 0;
#line 507 "game.vala"
					distance_collection = _tmp8_;
#line 507 "game.vala"
					distance_collection_length1 = _tmp8__length1;
#line 507 "game.vala"
					for (distance_it = 0; distance_it < distance_collection_length1; distance_it = distance_it + 1) {
#line 2966 "game.c"
						gint distance = 0;
#line 507 "game.vala"
						distance = distance_collection[distance_it];
#line 2970 "game.c"
						{
							gboolean _tmp9_ = FALSE;
							gint candidate_position = 0;
							PasangPiece piece = 0;
							PasangPiece* _tmp10_;
							gint _tmp10__length1;
							PasangPiece _tmp11_;
							PasangPiece _tmp12_;
							PasangPiece* _tmp13_;
							gint _tmp13__length1;
							PasangPiece* _tmp14_;
							gint _tmp14__length1;
							PasangPiece _tmp15_;
#line 508 "game.vala"
							if ((col + distance) < 1) {
#line 508 "game.vala"
								_tmp9_ = TRUE;
#line 2988 "game.c"
							} else {
#line 508 "game.vala"
								_tmp9_ = (col + distance) > 11;
#line 2992 "game.c"
							}
#line 508 "game.vala"
							if (_tmp9_) {
#line 508 "game.vala"
								continue;
#line 2998 "game.c"
							}
#line 509 "game.vala"
							candidate_position = empty_position + distance;
#line 510 "game.vala"
							_tmp10_ = self->board;
#line 510 "game.vala"
							_tmp10__length1 = self->board_length1;
#line 510 "game.vala"
							_tmp11_ = _tmp10_[candidate_position];
#line 510 "game.vala"
							piece = _tmp11_;
#line 511 "game.vala"
							_tmp12_ = piece;
#line 511 "game.vala"
							if (_tmp12_ == PASANG_PIECE_EMPTY) {
#line 511 "game.vala"
								continue;
#line 3016 "game.c"
							}
#line 512 "game.vala"
							_tmp13_ = self->board;
#line 512 "game.vala"
							_tmp13__length1 = self->board_length1;
#line 512 "game.vala"
							_tmp13_[candidate_position] = PASANG_PIECE_EMPTY;
#line 513 "game.vala"
							pasang_game_add_move (self, candidate_position, empty_position, (gint) PASANG_DELTA_RIGHT);
#line 514 "game.vala"
							pasang_game_add_move (self, candidate_position, empty_position, (gint) PASANG_DELTA_DOWN);
#line 515 "game.vala"
							_tmp14_ = self->board;
#line 515 "game.vala"
							_tmp14__length1 = self->board_length1;
#line 515 "game.vala"
							_tmp15_ = piece;
#line 515 "game.vala"
							_tmp14_[candidate_position] = _tmp15_;
#line 3036 "game.c"
						}
					}
				}
			}
		}
	}
#line 501 "game.vala"
	distances = (g_free (distances), NULL);
#line 3045 "game.c"
}

/**
     * Move the kas up and down, capturing horizontally,
     * or left and right, capturing vertically.
     */
static void
pasang_game_generate_kas_moving_moves (PasangGame* self)
{
	gint* kas_directions = NULL;
	gint* _tmp0_;
	gint kas_directions_length1;
	gint _kas_directions_size_;
	gint* capture_directions = NULL;
	gint* _tmp1_;
	gint capture_directions_length1;
	gint _capture_directions_size_;
#line 524 "game.vala"
	g_return_if_fail (self != NULL);
#line 525 "game.vala"
	_tmp0_ = g_new0 (gint, 4);
#line 525 "game.vala"
	_tmp0_[0] = (gint) PASANG_DELTA_UP;
#line 525 "game.vala"
	_tmp0_[1] = (gint) PASANG_DELTA_DOWN;
#line 525 "game.vala"
	_tmp0_[2] = (gint) PASANG_DELTA_LEFT;
#line 525 "game.vala"
	_tmp0_[3] = (gint) PASANG_DELTA_RIGHT;
#line 525 "game.vala"
	kas_directions = _tmp0_;
#line 525 "game.vala"
	kas_directions_length1 = 4;
#line 525 "game.vala"
	_kas_directions_size_ = kas_directions_length1;
#line 526 "game.vala"
	_tmp1_ = g_new0 (gint, 4);
#line 526 "game.vala"
	_tmp1_[0] = (gint) PASANG_DELTA_RIGHT;
#line 526 "game.vala"
	_tmp1_[1] = (gint) PASANG_DELTA_RIGHT;
#line 526 "game.vala"
	_tmp1_[2] = (gint) PASANG_DELTA_DOWN;
#line 526 "game.vala"
	_tmp1_[3] = (gint) PASANG_DELTA_DOWN;
#line 526 "game.vala"
	capture_directions = _tmp1_;
#line 526 "game.vala"
	capture_directions_length1 = 4;
#line 526 "game.vala"
	_capture_directions_size_ = capture_directions_length1;
#line 3097 "game.c"
	{
		gint i = 0;
#line 527 "game.vala"
		i = 0;
#line 3102 "game.c"
		{
			gboolean _tmp2_ = FALSE;
#line 527 "game.vala"
			_tmp2_ = TRUE;
#line 527 "game.vala"
			while (TRUE) {
#line 3109 "game.c"
				gint position = 0;
				gint* _tmp4_;
				gint _tmp4__length1;
				gint _tmp5_;
				gint _tmp6_;
				gint* _tmp7_;
				gint _tmp7__length1;
				gint _tmp8_;
#line 527 "game.vala"
				if (!_tmp2_) {
#line 3120 "game.c"
					gint _tmp3_;
#line 527 "game.vala"
					_tmp3_ = i;
#line 527 "game.vala"
					i = _tmp3_ + 1;
#line 3126 "game.c"
				}
#line 527 "game.vala"
				_tmp2_ = FALSE;
#line 527 "game.vala"
				if (!(i < 4)) {
#line 527 "game.vala"
					break;
#line 3134 "game.c"
				}
#line 528 "game.vala"
				_tmp4_ = self->kas_position;
#line 528 "game.vala"
				_tmp4__length1 = self->kas_position_length1;
#line 528 "game.vala"
				_tmp5_ = self->priv->_player;
#line 528 "game.vala"
				_tmp6_ = _tmp4_[_tmp5_];
#line 528 "game.vala"
				_tmp7_ = kas_directions;
#line 528 "game.vala"
				_tmp7__length1 = kas_directions_length1;
#line 528 "game.vala"
				_tmp8_ = _tmp7_[i];
#line 528 "game.vala"
				position = _tmp6_ + _tmp8_;
#line 529 "game.vala"
				while (TRUE) {
#line 3154 "game.c"
					PasangPiece* _tmp9_;
					gint _tmp9__length1;
					PasangPiece _tmp10_;
					gint* _tmp11_;
					gint _tmp11__length1;
					gint _tmp12_;
					gint* _tmp13_;
					gint _tmp13__length1;
					gint _tmp14_;
#line 529 "game.vala"
					_tmp9_ = self->board;
#line 529 "game.vala"
					_tmp9__length1 = self->board_length1;
#line 529 "game.vala"
					_tmp10_ = _tmp9_[position];
#line 529 "game.vala"
					if (!(_tmp10_ == PASANG_PIECE_EMPTY)) {
#line 529 "game.vala"
						break;
#line 3174 "game.c"
					}
#line 530 "game.vala"
					_tmp11_ = capture_directions;
#line 530 "game.vala"
					_tmp11__length1 = capture_directions_length1;
#line 530 "game.vala"
					_tmp12_ = _tmp11_[i];
#line 530 "game.vala"
					pasang_game_add_move (self, position, position, _tmp12_);
#line 531 "game.vala"
					_tmp13_ = kas_directions;
#line 531 "game.vala"
					_tmp13__length1 = kas_directions_length1;
#line 531 "game.vala"
					_tmp14_ = _tmp13_[i];
#line 531 "game.vala"
					position += _tmp14_;
#line 3192 "game.c"
				}
			}
		}
	}
#line 524 "game.vala"
	capture_directions = (g_free (capture_directions), NULL);
#line 524 "game.vala"
	kas_directions = (g_free (kas_directions), NULL);
#line 3201 "game.c"
}

/**
     * Construct a move for each possible capture in the given capture_direction
     * (Delta.RIGHT for horizontal capture, Delta.DOWN for vertical capture). Only an odd 
     * number of pieces of the same colour can be captured. These pieces must be
     * in line with capture_position.
     */
static void
_vala_array_add4 (gint* * array,
                  int* length,
                  int* size,
                  gint value)
{
#line 556 "game.vala"
	if ((*length) == (*size)) {
#line 556 "game.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 556 "game.vala"
		*array = g_renew (gint, *array, *size);
#line 3222 "game.c"
	}
#line 556 "game.vala"
	(*array)[(*length)++] = value;
#line 3226 "game.c"
}

static void
_vala_array_add5 (gint* * array,
                  int* length,
                  int* size,
                  gint value)
{
#line 557 "game.vala"
	if ((*length) == (*size)) {
#line 557 "game.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 557 "game.vala"
		*array = g_renew (gint, *array, *size);
#line 3241 "game.c"
	}
#line 557 "game.vala"
	(*array)[(*length)++] = value;
#line 3245 "game.c"
}

static void
_vala_array_add6 (gint* * array,
                  int* length,
                  int* size,
                  gint value)
{
#line 562 "game.vala"
	if ((*length) == (*size)) {
#line 562 "game.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 562 "game.vala"
		*array = g_renew (gint, *array, *size);
#line 3260 "game.c"
	}
#line 562 "game.vala"
	(*array)[(*length)++] = value;
#line 3264 "game.c"
}

static void
_vala_array_add7 (PasangMove** * array,
                  int* length,
                  int* size,
                  PasangMove* value)
{
#line 566 "game.vala"
	if ((*length) == (*size)) {
#line 566 "game.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 566 "game.vala"
		*array = g_renew (PasangMove*, *array, (*size) + 1);
#line 3279 "game.c"
	}
#line 566 "game.vala"
	(*array)[(*length)++] = value;
#line 566 "game.vala"
	(*array)[*length] = NULL;
#line 3285 "game.c"
}

static void
_vala_array_add8 (PasangMove** * array,
                  int* length,
                  int* size,
                  PasangMove* value)
{
#line 569 "game.vala"
	if ((*length) == (*size)) {
#line 569 "game.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 569 "game.vala"
		*array = g_renew (PasangMove*, *array, (*size) + 1);
#line 3300 "game.c"
	}
#line 569 "game.vala"
	(*array)[(*length)++] = value;
#line 569 "game.vala"
	(*array)[*length] = NULL;
#line 3306 "game.c"
}

static void
pasang_game_add_move (PasangGame* self,
                      gint position,
                      gint capture_position,
                      gint capture_direction)
{
	PasangPiece* booty_types = NULL;
	PasangPiece* _tmp0_;
	gint booty_types_length1;
	gint _booty_types_size_;
	gint* booties0 = NULL;
	gint* _tmp1_;
	gint booties0_length1;
	gint _booties0_size_;
	gint* booties1 = NULL;
	gint* _tmp2_;
	gint booties1_length1;
	gint _booties1_size_;
	PasangPiece* _tmp22_;
	gint _tmp22__length1;
	PasangPiece _tmp23_;
	PasangPiece* _tmp24_;
	gint _tmp24__length1;
	PasangPiece _tmp25_;
	gint* _tmp29_;
	gint _tmp29__length1;
	gint* _tmp33_;
	gint _tmp33__length1;
#line 542 "game.vala"
	g_return_if_fail (self != NULL);
#line 542 "game.vala"
	_vala_return_if_fail ((capture_direction == ((gint) PASANG_DELTA_RIGHT)) || (capture_direction == ((gint) PASANG_DELTA_DOWN)), "capture_direction == Delta.RIGHT || capture_direction == Delta.DOWN");
#line 544 "game.vala"
	_tmp0_ = g_new0 (PasangPiece, 2);
#line 544 "game.vala"
	_tmp0_[0] = PASANG_PIECE_NULL;
#line 544 "game.vala"
	_tmp0_[1] = PASANG_PIECE_NULL;
#line 544 "game.vala"
	booty_types = _tmp0_;
#line 544 "game.vala"
	booty_types_length1 = 2;
#line 544 "game.vala"
	_booty_types_size_ = booty_types_length1;
#line 545 "game.vala"
	_tmp1_ = g_new0 (gint, 0);
#line 545 "game.vala"
	booties0 = _tmp1_;
#line 545 "game.vala"
	booties0_length1 = 0;
#line 545 "game.vala"
	_booties0_size_ = booties0_length1;
#line 546 "game.vala"
	_tmp2_ = g_new0 (gint, 0);
#line 546 "game.vala"
	booties1 = _tmp2_;
#line 546 "game.vala"
	booties1_length1 = 0;
#line 546 "game.vala"
	_booties1_size_ = booties1_length1;
#line 3369 "game.c"
	{
		gint i = 0;
#line 547 "game.vala"
		i = 0;
#line 3374 "game.c"
		{
			gboolean _tmp3_ = FALSE;
#line 547 "game.vala"
			_tmp3_ = TRUE;
#line 547 "game.vala"
			while (TRUE) {
#line 3381 "game.c"
				gint _tmp5_ = 0;
				gint delta = 0;
				gint cursor = 0;
#line 547 "game.vala"
				if (!_tmp3_) {
#line 3387 "game.c"
					gint _tmp4_;
#line 547 "game.vala"
					_tmp4_ = i;
#line 547 "game.vala"
					i = _tmp4_ + 1;
#line 3393 "game.c"
				}
#line 547 "game.vala"
				_tmp3_ = FALSE;
#line 547 "game.vala"
				if (!(i < 2)) {
#line 547 "game.vala"
					break;
#line 3401 "game.c"
				}
#line 548 "game.vala"
				if (i == 0) {
#line 548 "game.vala"
					_tmp5_ = -capture_direction;
#line 3407 "game.c"
				} else {
#line 548 "game.vala"
					_tmp5_ = capture_direction;
#line 3411 "game.c"
				}
#line 548 "game.vala"
				delta = _tmp5_;
#line 549 "game.vala"
				cursor = capture_position;
#line 550 "game.vala"
				while (TRUE) {
#line 3419 "game.c"
					PasangPiece piece = 0;
					PasangPiece* _tmp6_;
					gint _tmp6__length1;
					PasangPiece _tmp7_;
					PasangPiece _tmp8_;
					gboolean _tmp9_ = FALSE;
					PasangPiece _tmp10_;
					gboolean _tmp12_ = FALSE;
					PasangPiece* _tmp13_;
					gint _tmp13__length1;
					PasangPiece _tmp14_;
					PasangPiece* _tmp20_;
					gint _tmp20__length1;
					PasangPiece _tmp21_;
#line 551 "game.vala"
					cursor += delta;
#line 552 "game.vala"
					_tmp6_ = self->board;
#line 552 "game.vala"
					_tmp6__length1 = self->board_length1;
#line 552 "game.vala"
					_tmp7_ = _tmp6_[cursor];
#line 552 "game.vala"
					piece = _tmp7_;
#line 553 "game.vala"
					_tmp8_ = piece;
#line 553 "game.vala"
					if (_tmp8_ == PASANG_PIECE_EMPTY) {
#line 553 "game.vala"
						continue;
#line 3450 "game.c"
					}
#line 554 "game.vala"
					_tmp10_ = piece;
#line 554 "game.vala"
					if (_tmp10_ != PASANG_PIECE_BLACK) {
#line 3456 "game.c"
						PasangPiece _tmp11_;
#line 554 "game.vala"
						_tmp11_ = piece;
#line 554 "game.vala"
						_tmp9_ = _tmp11_ != PASANG_PIECE_WHITE;
#line 3462 "game.c"
					} else {
#line 554 "game.vala"
						_tmp9_ = FALSE;
#line 3466 "game.c"
					}
#line 554 "game.vala"
					if (_tmp9_) {
#line 554 "game.vala"
						break;
#line 3472 "game.c"
					}
#line 555 "game.vala"
					_tmp13_ = booty_types;
#line 555 "game.vala"
					_tmp13__length1 = booty_types_length1;
#line 555 "game.vala"
					_tmp14_ = _tmp13_[i];
#line 555 "game.vala"
					if (_tmp14_ != PASANG_PIECE_NULL) {
#line 3482 "game.c"
						PasangPiece _tmp15_;
						PasangPiece* _tmp16_;
						gint _tmp16__length1;
						PasangPiece _tmp17_;
#line 555 "game.vala"
						_tmp15_ = piece;
#line 555 "game.vala"
						_tmp16_ = booty_types;
#line 555 "game.vala"
						_tmp16__length1 = booty_types_length1;
#line 555 "game.vala"
						_tmp17_ = _tmp16_[i];
#line 555 "game.vala"
						_tmp12_ = _tmp15_ != _tmp17_;
#line 3497 "game.c"
					} else {
#line 555 "game.vala"
						_tmp12_ = FALSE;
#line 3501 "game.c"
					}
#line 555 "game.vala"
					if (_tmp12_) {
#line 555 "game.vala"
						break;
#line 3507 "game.c"
					}
#line 556 "game.vala"
					if (i == 0) {
#line 3511 "game.c"
						gint* _tmp18_;
						gint _tmp18__length1;
#line 556 "game.vala"
						_tmp18_ = booties0;
#line 556 "game.vala"
						_tmp18__length1 = booties0_length1;
#line 556 "game.vala"
						_vala_array_add4 (&booties0, &booties0_length1, &_booties0_size_, cursor);
#line 3520 "game.c"
					} else {
						gint* _tmp19_;
						gint _tmp19__length1;
#line 557 "game.vala"
						_tmp19_ = booties1;
#line 557 "game.vala"
						_tmp19__length1 = booties1_length1;
#line 557 "game.vala"
						_vala_array_add5 (&booties1, &booties1_length1, &_booties1_size_, cursor);
#line 3530 "game.c"
					}
#line 558 "game.vala"
					_tmp20_ = booty_types;
#line 558 "game.vala"
					_tmp20__length1 = booty_types_length1;
#line 558 "game.vala"
					_tmp21_ = piece;
#line 558 "game.vala"
					_tmp20_[i] = _tmp21_;
#line 3540 "game.c"
				}
			}
		}
	}
#line 561 "game.vala"
	_tmp22_ = booty_types;
#line 561 "game.vala"
	_tmp22__length1 = booty_types_length1;
#line 561 "game.vala"
	_tmp23_ = _tmp22_[0];
#line 561 "game.vala"
	_tmp24_ = booty_types;
#line 561 "game.vala"
	_tmp24__length1 = booty_types_length1;
#line 561 "game.vala"
	_tmp25_ = _tmp24_[1];
#line 561 "game.vala"
	if (_tmp23_ == _tmp25_) {
#line 3559 "game.c"
		gint* _tmp26_;
		gint _tmp26__length1;
		gint* _tmp28_;
#line 562 "game.vala"
		_tmp26_ = booties1;
#line 562 "game.vala"
		_tmp26__length1 = booties1_length1;
#line 3567 "game.c"
		{
			gint* p_collection = NULL;
			gint p_collection_length1 = 0;
			gint _p_collection_size_ = 0;
			gint p_it = 0;
#line 562 "game.vala"
			p_collection = _tmp26_;
#line 562 "game.vala"
			p_collection_length1 = _tmp26__length1;
#line 562 "game.vala"
			for (p_it = 0; p_it < p_collection_length1; p_it = p_it + 1) {
#line 3579 "game.c"
				gint p = 0;
#line 562 "game.vala"
				p = p_collection[p_it];
#line 3583 "game.c"
				{
					gint* _tmp27_;
					gint _tmp27__length1;
#line 562 "game.vala"
					_tmp27_ = booties0;
#line 562 "game.vala"
					_tmp27__length1 = booties0_length1;
#line 562 "game.vala"
					_vala_array_add6 (&booties0, &booties0_length1, &_booties0_size_, p);
#line 3593 "game.c"
				}
			}
		}
#line 563 "game.vala"
		_tmp28_ = g_new0 (gint, 0);
#line 563 "game.vala"
		booties1 = (g_free (booties1), NULL);
#line 563 "game.vala"
		booties1 = _tmp28_;
#line 563 "game.vala"
		booties1_length1 = 0;
#line 563 "game.vala"
		_booties1_size_ = booties1_length1;
#line 3607 "game.c"
	}
#line 565 "game.vala"
	_tmp29_ = booties0;
#line 565 "game.vala"
	_tmp29__length1 = booties0_length1;
#line 565 "game.vala"
	if ((_tmp29__length1 % 2) == 1) {
#line 3615 "game.c"
		PasangMove** _tmp30_;
		gint _tmp30__length1;
		gint* _tmp31_;
		gint _tmp31__length1;
		PasangMove* _tmp32_;
#line 566 "game.vala"
		_tmp30_ = self->priv->moves;
#line 566 "game.vala"
		_tmp30__length1 = self->priv->moves_length1;
#line 566 "game.vala"
		_tmp31_ = booties0;
#line 566 "game.vala"
		_tmp31__length1 = booties0_length1;
#line 566 "game.vala"
		_tmp32_ = pasang_move_new (self, position, _tmp31_, _tmp31__length1);
#line 566 "game.vala"
		_vala_array_add7 (&self->priv->moves, &self->priv->moves_length1, &self->priv->_moves_size_, _tmp32_);
#line 3633 "game.c"
	}
#line 568 "game.vala"
	_tmp33_ = booties1;
#line 568 "game.vala"
	_tmp33__length1 = booties1_length1;
#line 568 "game.vala"
	if ((_tmp33__length1 % 2) == 1) {
#line 3641 "game.c"
		PasangMove** _tmp34_;
		gint _tmp34__length1;
		gint* _tmp35_;
		gint _tmp35__length1;
		PasangMove* _tmp36_;
#line 569 "game.vala"
		_tmp34_ = self->priv->moves;
#line 569 "game.vala"
		_tmp34__length1 = self->priv->moves_length1;
#line 569 "game.vala"
		_tmp35_ = booties1;
#line 569 "game.vala"
		_tmp35__length1 = booties1_length1;
#line 569 "game.vala"
		_tmp36_ = pasang_move_new (self, position, _tmp35_, _tmp35__length1);
#line 569 "game.vala"
		_vala_array_add8 (&self->priv->moves, &self->priv->moves_length1, &self->priv->_moves_size_, _tmp36_);
#line 3659 "game.c"
	}
#line 542 "game.vala"
	booties1 = (g_free (booties1), NULL);
#line 542 "game.vala"
	booties0 = (g_free (booties0), NULL);
#line 542 "game.vala"
	booty_types = (g_free (booty_types), NULL);
#line 3667 "game.c"
}

/**
     * Iterator to support foreach(Move m in game) {...}
     */
PasangGameIterator*
pasang_game_iterator (PasangGame* self)
{
	PasangGameIterator* _tmp0_;
	PasangGameIterator* result = NULL;
#line 576 "game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 577 "game.vala"
	_tmp0_ = pasang_game_iterator_new (self);
#line 577 "game.vala"
	result = _tmp0_;
#line 577 "game.vala"
	return result;
#line 3686 "game.c"
}

/**
     * Access to moves
     */
gint
pasang_game_numMoves (PasangGame* self)
{
	PasangMove** _tmp0_;
	gint _tmp0__length1;
	gint result = 0;
#line 596 "game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 597 "game.vala"
	_tmp0_ = self->priv->moves;
#line 597 "game.vala"
	_tmp0__length1 = self->priv->moves_length1;
#line 597 "game.vala"
	result = _tmp0__length1;
#line 597 "game.vala"
	return result;
#line 3708 "game.c"
}

PasangMove*
pasang_game_getMove (PasangGame* self,
                     gint n)
{
	PasangMove** _tmp0_;
	gint _tmp0__length1;
	PasangMove* _tmp1_;
	PasangMove* _tmp2_;
	PasangMove* result = NULL;
#line 600 "game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 601 "game.vala"
	_tmp0_ = self->priv->moves;
#line 601 "game.vala"
	_tmp0__length1 = self->priv->moves_length1;
#line 601 "game.vala"
	_tmp1_ = _tmp0_[n];
#line 601 "game.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 601 "game.vala"
	result = _tmp2_;
#line 601 "game.vala"
	return result;
#line 3734 "game.c"
}

PasangGame*
pasang_game_construct (GType object_type)
{
	PasangGame * self = NULL;
#line 135 "game.vala"
	self = (PasangGame*) g_object_new (object_type, NULL);
#line 135 "game.vala"
	return self;
#line 3745 "game.c"
}

PasangGame*
pasang_game_new (void)
{
#line 135 "game.vala"
	return pasang_game_construct (PASANG_TYPE_GAME);
#line 3753 "game.c"
}

PasangStage
pasang_game_get_stage (PasangGame* self)
{
	PasangStage result;
	PasangStage _tmp0_;
#line 136 "game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 136 "game.vala"
	_tmp0_ = self->priv->_stage;
#line 136 "game.vala"
	result = _tmp0_;
#line 136 "game.vala"
	return result;
#line 3769 "game.c"
}

static void
pasang_game_set_stage (PasangGame* self,
                       PasangStage value)
{
#line 136 "game.vala"
	g_return_if_fail (self != NULL);
#line 136 "game.vala"
	if (pasang_game_get_stage (self) != value) {
#line 136 "game.vala"
		self->priv->_stage = value;
#line 136 "game.vala"
		g_object_notify_by_pspec ((GObject *) self, pasang_game_properties[PASANG_GAME_STAGE_PROPERTY]);
#line 3784 "game.c"
	}
}

gint
pasang_game_get_seq (PasangGame* self)
{
	gint result;
#line 146 "game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 146 "game.vala"
	result = self->priv->_seq;
#line 146 "game.vala"
	return result;
#line 3798 "game.c"
}

static void
pasang_game_set_seq (PasangGame* self,
                     gint value)
{
#line 146 "game.vala"
	g_return_if_fail (self != NULL);
#line 146 "game.vala"
	if (pasang_game_get_seq (self) != value) {
#line 146 "game.vala"
		self->priv->_seq = value;
#line 146 "game.vala"
		g_object_notify_by_pspec ((GObject *) self, pasang_game_properties[PASANG_GAME_SEQ_PROPERTY]);
#line 3813 "game.c"
	}
}

gint
pasang_game_get_player (PasangGame* self)
{
	gint result;
#line 151 "game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 151 "game.vala"
	result = self->priv->_player;
#line 151 "game.vala"
	return result;
#line 3827 "game.c"
}

static void
pasang_game_set_player (PasangGame* self,
                        gint value)
{
#line 151 "game.vala"
	g_return_if_fail (self != NULL);
#line 151 "game.vala"
	if (pasang_game_get_player (self) != value) {
#line 151 "game.vala"
		self->priv->_player = value;
#line 151 "game.vala"
		g_object_notify_by_pspec ((GObject *) self, pasang_game_properties[PASANG_GAME_PLAYER_PROPERTY]);
#line 3842 "game.c"
	}
}

PasangPiece
pasang_game_get_kas (PasangGame* self)
{
	PasangPiece result;
	gint _tmp0_;
#line 156 "game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 156 "game.vala"
	_tmp0_ = self->priv->_player;
#line 156 "game.vala"
	result = (PasangPiece) _tmp0_;
#line 156 "game.vala"
	return result;
#line 3859 "game.c"
}

gint
pasang_game_get_value_of_uncaptured_pieces (PasangGame* self)
{
	gint result;
#line 158 "game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 158 "game.vala"
	result = self->priv->_value_of_uncaptured_pieces;
#line 158 "game.vala"
	return result;
#line 3872 "game.c"
}

static void
pasang_game_set_value_of_uncaptured_pieces (PasangGame* self,
                                            gint value)
{
#line 158 "game.vala"
	g_return_if_fail (self != NULL);
#line 158 "game.vala"
	if (pasang_game_get_value_of_uncaptured_pieces (self) != value) {
#line 158 "game.vala"
		self->priv->_value_of_uncaptured_pieces = value;
#line 158 "game.vala"
		g_object_notify_by_pspec ((GObject *) self, pasang_game_properties[PASANG_GAME_VALUE_OF_UNCAPTURED_PIECES_PROPERTY]);
#line 3887 "game.c"
	}
}

static inline gpointer
pasang_game_iterator_get_instance_private (PasangGameIterator* self)
{
	return G_STRUCT_MEMBER_P (self, PasangGameIterator_private_offset);
}

PasangGameIterator*
pasang_game_iterator_construct (GType object_type,
                                PasangGame* game)
{
	PasangGameIterator* self = NULL;
	PasangGame* _tmp0_;
#line 583 "game.vala"
	g_return_val_if_fail (game != NULL, NULL);
#line 583 "game.vala"
	self = (PasangGameIterator*) g_type_create_instance (object_type);
#line 584 "game.vala"
	_tmp0_ = _g_object_ref0 (game);
#line 584 "game.vala"
	_g_object_unref0 (self->priv->game);
#line 584 "game.vala"
	self->priv->game = _tmp0_;
#line 585 "game.vala"
	self->priv->index = 0;
#line 583 "game.vala"
	return self;
#line 3917 "game.c"
}

PasangGameIterator*
pasang_game_iterator_new (PasangGame* game)
{
#line 583 "game.vala"
	return pasang_game_iterator_construct (PASANG_GAME_TYPE_ITERATOR, game);
#line 3925 "game.c"
}

PasangMove*
pasang_game_iterator_next_value (PasangGameIterator* self)
{
	PasangMove* _tmp0_ = NULL;
	PasangGame* _tmp1_;
	PasangMove** _tmp2_;
	gint _tmp2__length1;
	PasangMove* _tmp7_;
	PasangMove* result = NULL;
#line 588 "game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 589 "game.vala"
	_tmp1_ = self->priv->game;
#line 589 "game.vala"
	_tmp2_ = _tmp1_->priv->moves;
#line 589 "game.vala"
	_tmp2__length1 = _tmp1_->priv->moves_length1;
#line 589 "game.vala"
	if (self->priv->index == _tmp2__length1) {
#line 589 "game.vala"
		_tmp0_ = NULL;
#line 3949 "game.c"
	} else {
		PasangGame* _tmp3_;
		PasangMove** _tmp4_;
		gint _tmp4__length1;
		gint _tmp5_;
		PasangMove* _tmp6_;
#line 589 "game.vala"
		_tmp3_ = self->priv->game;
#line 589 "game.vala"
		_tmp4_ = _tmp3_->priv->moves;
#line 589 "game.vala"
		_tmp4__length1 = _tmp3_->priv->moves_length1;
#line 589 "game.vala"
		_tmp5_ = self->priv->index;
#line 589 "game.vala"
		self->priv->index = _tmp5_ + 1;
#line 589 "game.vala"
		_tmp6_ = _tmp4_[_tmp5_];
#line 589 "game.vala"
		_tmp0_ = _tmp6_;
#line 3970 "game.c"
	}
#line 589 "game.vala"
	_tmp7_ = _g_object_ref0 (_tmp0_);
#line 589 "game.vala"
	result = _tmp7_;
#line 589 "game.vala"
	return result;
#line 3978 "game.c"
}

static void
pasang_game_value_iterator_init (GValue* value)
{
#line 580 "game.vala"
	value->data[0].v_pointer = NULL;
#line 3986 "game.c"
}

static void
pasang_game_value_iterator_free_value (GValue* value)
{
#line 580 "game.vala"
	if (value->data[0].v_pointer) {
#line 580 "game.vala"
		pasang_game_iterator_unref (value->data[0].v_pointer);
#line 3996 "game.c"
	}
}

static void
pasang_game_value_iterator_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
#line 580 "game.vala"
	if (src_value->data[0].v_pointer) {
#line 580 "game.vala"
		dest_value->data[0].v_pointer = pasang_game_iterator_ref (src_value->data[0].v_pointer);
#line 4008 "game.c"
	} else {
#line 580 "game.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4012 "game.c"
	}
}

static gpointer
pasang_game_value_iterator_peek_pointer (const GValue* value)
{
#line 580 "game.vala"
	return value->data[0].v_pointer;
#line 4021 "game.c"
}

static gchar*
pasang_game_value_iterator_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
#line 580 "game.vala"
	if (collect_values[0].v_pointer) {
#line 4032 "game.c"
		PasangGameIterator * object;
		object = collect_values[0].v_pointer;
#line 580 "game.vala"
		if (object->parent_instance.g_class == NULL) {
#line 580 "game.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4039 "game.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 580 "game.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4043 "game.c"
		}
#line 580 "game.vala"
		value->data[0].v_pointer = pasang_game_iterator_ref (object);
#line 4047 "game.c"
	} else {
#line 580 "game.vala"
		value->data[0].v_pointer = NULL;
#line 4051 "game.c"
	}
#line 580 "game.vala"
	return NULL;
#line 4055 "game.c"
}

static gchar*
pasang_game_value_iterator_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	PasangGameIterator ** object_p;
	object_p = collect_values[0].v_pointer;
#line 580 "game.vala"
	if (!object_p) {
#line 580 "game.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4070 "game.c"
	}
#line 580 "game.vala"
	if (!value->data[0].v_pointer) {
#line 580 "game.vala"
		*object_p = NULL;
#line 4076 "game.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 580 "game.vala"
		*object_p = value->data[0].v_pointer;
#line 4080 "game.c"
	} else {
#line 580 "game.vala"
		*object_p = pasang_game_iterator_ref (value->data[0].v_pointer);
#line 4084 "game.c"
	}
#line 580 "game.vala"
	return NULL;
#line 4088 "game.c"
}

GParamSpec*
pasang_game_param_spec_iterator (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	PasangGameParamSpecIterator* spec;
#line 580 "game.vala"
	g_return_val_if_fail (g_type_is_a (object_type, PASANG_GAME_TYPE_ITERATOR), NULL);
#line 580 "game.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 580 "game.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 580 "game.vala"
	return G_PARAM_SPEC (spec);
#line 4107 "game.c"
}

gpointer
pasang_game_value_get_iterator (const GValue* value)
{
#line 580 "game.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PASANG_GAME_TYPE_ITERATOR), NULL);
#line 580 "game.vala"
	return value->data[0].v_pointer;
#line 4117 "game.c"
}

void
pasang_game_value_set_iterator (GValue* value,
                                gpointer v_object)
{
	PasangGameIterator * old;
#line 580 "game.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PASANG_GAME_TYPE_ITERATOR));
#line 580 "game.vala"
	old = value->data[0].v_pointer;
#line 580 "game.vala"
	if (v_object) {
#line 580 "game.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PASANG_GAME_TYPE_ITERATOR));
#line 580 "game.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 580 "game.vala"
		value->data[0].v_pointer = v_object;
#line 580 "game.vala"
		pasang_game_iterator_ref (value->data[0].v_pointer);
#line 4139 "game.c"
	} else {
#line 580 "game.vala"
		value->data[0].v_pointer = NULL;
#line 4143 "game.c"
	}
#line 580 "game.vala"
	if (old) {
#line 580 "game.vala"
		pasang_game_iterator_unref (old);
#line 4149 "game.c"
	}
}

void
pasang_game_value_take_iterator (GValue* value,
                                 gpointer v_object)
{
	PasangGameIterator * old;
#line 580 "game.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PASANG_GAME_TYPE_ITERATOR));
#line 580 "game.vala"
	old = value->data[0].v_pointer;
#line 580 "game.vala"
	if (v_object) {
#line 580 "game.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PASANG_GAME_TYPE_ITERATOR));
#line 580 "game.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 580 "game.vala"
		value->data[0].v_pointer = v_object;
#line 4170 "game.c"
	} else {
#line 580 "game.vala"
		value->data[0].v_pointer = NULL;
#line 4174 "game.c"
	}
#line 580 "game.vala"
	if (old) {
#line 580 "game.vala"
		pasang_game_iterator_unref (old);
#line 4180 "game.c"
	}
}

static void
pasang_game_iterator_class_init (PasangGameIteratorClass * klass,
                                 gpointer klass_data)
{
#line 580 "game.vala"
	pasang_game_iterator_parent_class = g_type_class_peek_parent (klass);
#line 580 "game.vala"
	((PasangGameIteratorClass *) klass)->finalize = pasang_game_iterator_finalize;
#line 580 "game.vala"
	g_type_class_adjust_private_offset (klass, &PasangGameIterator_private_offset);
#line 4194 "game.c"
}

static void
pasang_game_iterator_instance_init (PasangGameIterator * self,
                                    gpointer klass)
{
#line 580 "game.vala"
	self->priv = pasang_game_iterator_get_instance_private (self);
#line 580 "game.vala"
	self->ref_count = 1;
#line 4205 "game.c"
}

static void
pasang_game_iterator_finalize (PasangGameIterator * obj)
{
	PasangGameIterator * self;
#line 580 "game.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PASANG_GAME_TYPE_ITERATOR, PasangGameIterator);
#line 580 "game.vala"
	g_signal_handlers_destroy (self);
#line 581 "game.vala"
	_g_object_unref0 (self->priv->game);
#line 4218 "game.c"
}

GType
pasang_game_iterator_get_type (void)
{
	static volatile gsize pasang_game_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_game_iterator_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { pasang_game_value_iterator_init, pasang_game_value_iterator_free_value, pasang_game_value_iterator_copy_value, pasang_game_value_iterator_peek_pointer, "p", pasang_game_value_iterator_collect_value, "p", pasang_game_value_iterator_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PasangGameIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pasang_game_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PasangGameIterator), 0, (GInstanceInitFunc) pasang_game_iterator_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType pasang_game_iterator_type_id;
		pasang_game_iterator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PasangGameIterator", &g_define_type_info, &g_define_type_fundamental_info, 0);
		PasangGameIterator_private_offset = g_type_add_instance_private (pasang_game_iterator_type_id, sizeof (PasangGameIteratorPrivate));
		g_once_init_leave (&pasang_game_iterator_type_id__volatile, pasang_game_iterator_type_id);
	}
	return pasang_game_iterator_type_id__volatile;
}

gpointer
pasang_game_iterator_ref (gpointer instance)
{
	PasangGameIterator * self;
	self = instance;
#line 580 "game.vala"
	g_atomic_int_inc (&self->ref_count);
#line 580 "game.vala"
	return instance;
#line 4246 "game.c"
}

void
pasang_game_iterator_unref (gpointer instance)
{
	PasangGameIterator * self;
	self = instance;
#line 580 "game.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 580 "game.vala"
		PASANG_GAME_ITERATOR_GET_CLASS (self)->finalize (self);
#line 580 "game.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4260 "game.c"
	}
}

static void
pasang_game_class_init (PasangGameClass * klass,
                        gpointer klass_data)
{
#line 135 "game.vala"
	pasang_game_parent_class = g_type_class_peek_parent (klass);
#line 135 "game.vala"
	g_type_class_adjust_private_offset (klass, &PasangGame_private_offset);
#line 135 "game.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_pasang_game_get_property;
#line 135 "game.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_pasang_game_set_property;
#line 135 "game.vala"
	G_OBJECT_CLASS (klass)->finalize = pasang_game_finalize;
#line 135 "game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), PASANG_GAME_STAGE_PROPERTY, pasang_game_properties[PASANG_GAME_STAGE_PROPERTY] = g_param_spec_enum ("stage", "stage", "stage", PASANG_TYPE_STAGE, PASANG_STAGE_NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 4280 "game.c"
	/**
	     * Move sequence number.
	     * Initially -1. 0 after start (). +1 after perform ().
	     * Used in NETWORK mode to verify that clients are synchronized.
	     * (Too paranoid?)
	     */
#line 135 "game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), PASANG_GAME_SEQ_PROPERTY, pasang_game_properties[PASANG_GAME_SEQ_PROPERTY] = g_param_spec_int ("seq", "seq", "seq", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 4289 "game.c"
	/**
	     * Player to move next. Player 0 always moves first.
	     */
#line 135 "game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), PASANG_GAME_PLAYER_PROPERTY, pasang_game_properties[PASANG_GAME_PLAYER_PROPERTY] = g_param_spec_int ("player", "player", "player", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 4295 "game.c"
	/**
	     * The kas owned by the player to move next.
	     */
#line 135 "game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), PASANG_GAME_KAS_PROPERTY, pasang_game_properties[PASANG_GAME_KAS_PROPERTY] = g_param_spec_enum ("kas", "kas", "kas", PASANG_TYPE_PIECE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 135 "game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), PASANG_GAME_VALUE_OF_UNCAPTURED_PIECES_PROPERTY, pasang_game_properties[PASANG_GAME_VALUE_OF_UNCAPTURED_PIECES_PROPERTY] = g_param_spec_int ("value-of-uncaptured-pieces", "value-of-uncaptured-pieces", "value-of-uncaptured-pieces", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 4303 "game.c"
}

static void
pasang_game_instance_init (PasangGame * self,
                           gpointer klass)
{
	PasangPiece* _tmp0_;
	PasangMove** _tmp1_;
	gint* _tmp2_;
	gint* _tmp3_;
	gint* _tmp4_;
#line 135 "game.vala"
	self->priv = pasang_game_get_instance_private (self);
#line 136 "game.vala"
	self->priv->_stage = PASANG_STAGE_NULL;
#line 138 "game.vala"
	_tmp0_ = g_new0 (PasangPiece, PASANG_BOARD_SIZE);
#line 138 "game.vala"
	self->board = _tmp0_;
#line 138 "game.vala"
	self->board_length1 = PASANG_BOARD_SIZE;
#line 146 "game.vala"
	self->priv->_seq = -1;
#line 163 "game.vala"
	_tmp1_ = g_new0 (PasangMove*, 0 + 1);
#line 163 "game.vala"
	self->priv->moves = _tmp1_;
#line 163 "game.vala"
	self->priv->moves_length1 = 0;
#line 163 "game.vala"
	self->priv->_moves_size_ = self->priv->moves_length1;
#line 165 "game.vala"
	_tmp2_ = g_new0 (gint, 2);
#line 165 "game.vala"
	_tmp2_[0] = 0;
#line 165 "game.vala"
	_tmp2_[1] = 0;
#line 165 "game.vala"
	self->score = _tmp2_;
#line 165 "game.vala"
	self->score_length1 = 2;
#line 167 "game.vala"
	_tmp3_ = g_new0 (gint, 2);
#line 167 "game.vala"
	_tmp3_[0] = 0;
#line 167 "game.vala"
	_tmp3_[1] = 0;
#line 167 "game.vala"
	self->kas_position = _tmp3_;
#line 167 "game.vala"
	self->kas_position_length1 = 2;
#line 176 "game.vala"
	_tmp4_ = g_new0 (gint, 2);
#line 176 "game.vala"
	_tmp4_[0] = 0;
#line 176 "game.vala"
	_tmp4_[1] = 0;
#line 176 "game.vala"
	self->first_move = _tmp4_;
#line 176 "game.vala"
	self->first_move_length1 = 2;
#line 4365 "game.c"
}

static void
pasang_game_finalize (GObject * obj)
{
	PasangGame * self;
#line 135 "game.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PASANG_TYPE_GAME, PasangGame);
#line 138 "game.vala"
	self->board = (g_free (self->board), NULL);
#line 163 "game.vala"
	self->priv->moves = (_vala_array_free (self->priv->moves, self->priv->moves_length1, (GDestroyNotify) g_object_unref), NULL);
#line 165 "game.vala"
	self->score = (g_free (self->score), NULL);
#line 167 "game.vala"
	self->kas_position = (g_free (self->kas_position), NULL);
#line 176 "game.vala"
	self->first_move = (g_free (self->first_move), NULL);
#line 135 "game.vala"
	G_OBJECT_CLASS (pasang_game_parent_class)->finalize (obj);
#line 4386 "game.c"
}

GType
pasang_game_get_type (void)
{
	static volatile gsize pasang_game_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_game_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PasangGameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pasang_game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PasangGame), 0, (GInstanceInitFunc) pasang_game_instance_init, NULL };
		GType pasang_game_type_id;
		pasang_game_type_id = g_type_register_static (G_TYPE_OBJECT, "PasangGame", &g_define_type_info, 0);
		PasangGame_private_offset = g_type_add_instance_private (pasang_game_type_id, sizeof (PasangGamePrivate));
		g_once_init_leave (&pasang_game_type_id__volatile, pasang_game_type_id);
	}
	return pasang_game_type_id__volatile;
}

static void
_vala_pasang_game_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	PasangGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PASANG_TYPE_GAME, PasangGame);
#line 135 "game.vala"
	switch (property_id) {
#line 135 "game.vala"
		case PASANG_GAME_STAGE_PROPERTY:
#line 135 "game.vala"
		g_value_set_enum (value, pasang_game_get_stage (self));
#line 135 "game.vala"
		break;
#line 135 "game.vala"
		case PASANG_GAME_SEQ_PROPERTY:
#line 135 "game.vala"
		g_value_set_int (value, pasang_game_get_seq (self));
#line 135 "game.vala"
		break;
#line 135 "game.vala"
		case PASANG_GAME_PLAYER_PROPERTY:
#line 135 "game.vala"
		g_value_set_int (value, pasang_game_get_player (self));
#line 135 "game.vala"
		break;
#line 135 "game.vala"
		case PASANG_GAME_KAS_PROPERTY:
#line 135 "game.vala"
		g_value_set_enum (value, pasang_game_get_kas (self));
#line 135 "game.vala"
		break;
#line 135 "game.vala"
		case PASANG_GAME_VALUE_OF_UNCAPTURED_PIECES_PROPERTY:
#line 135 "game.vala"
		g_value_set_int (value, pasang_game_get_value_of_uncaptured_pieces (self));
#line 135 "game.vala"
		break;
#line 4443 "game.c"
		default:
#line 135 "game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 135 "game.vala"
		break;
#line 4449 "game.c"
	}
}

static void
_vala_pasang_game_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	PasangGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PASANG_TYPE_GAME, PasangGame);
#line 135 "game.vala"
	switch (property_id) {
#line 135 "game.vala"
		case PASANG_GAME_STAGE_PROPERTY:
#line 135 "game.vala"
		pasang_game_set_stage (self, g_value_get_enum (value));
#line 135 "game.vala"
		break;
#line 135 "game.vala"
		case PASANG_GAME_SEQ_PROPERTY:
#line 135 "game.vala"
		pasang_game_set_seq (self, g_value_get_int (value));
#line 135 "game.vala"
		break;
#line 135 "game.vala"
		case PASANG_GAME_PLAYER_PROPERTY:
#line 135 "game.vala"
		pasang_game_set_player (self, g_value_get_int (value));
#line 135 "game.vala"
		break;
#line 135 "game.vala"
		case PASANG_GAME_VALUE_OF_UNCAPTURED_PIECES_PROPERTY:
#line 135 "game.vala"
		pasang_game_set_value_of_uncaptured_pieces (self, g_value_get_int (value));
#line 135 "game.vala"
		break;
#line 4487 "game.c"
		default:
#line 135 "game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 135 "game.vala"
		break;
#line 4493 "game.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

