/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.maven;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.execution.AbstractExecutionListener;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.builder.ArtifactBuilder;
import org.jfrog.build.api.builder.BuildInfoMavenBuilder;
import org.jfrog.build.api.builder.DependencyBuilder;
import org.jfrog.build.api.builder.ModuleBuilder;
import org.jfrog.build.api.builder.ModuleType;
import org.jfrog.build.api.util.CommonUtils;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.extractor.BuildInfoExtractor;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.jfrog.build.extractor.clientConfiguration.PatternMatcher;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.build.extractor.maven.BuildDeploymentHelper;
import org.jfrog.build.extractor.maven.BuildInfoModelPropertyResolver;
import org.jfrog.build.extractor.maven.resolver.ResolutionHelper;

@Component(role=BuildInfoRecorder.class)
public class BuildInfoRecorder
extends AbstractExecutionListener
implements BuildInfoExtractor<ExecutionEvent> {
    @Requirement
    private Logger logger;
    @Requirement
    private BuildInfoModelPropertyResolver buildInfoModelPropertyResolver;
    @Requirement
    private BuildDeploymentHelper buildDeploymentHelper;
    @Requirement
    private ResolutionHelper resolutionHelper;
    private ExecutionListener wrappedListener;
    private BuildInfoMavenBuilder buildInfoBuilder;
    private ThreadLocal<ModuleBuilder> currentModule = new ThreadLocal();
    private ThreadLocal<Set<Artifact>> currentModuleArtifacts = new ThreadLocal();
    private ThreadLocal<Set<Artifact>> currentModuleDependencies = new ThreadLocal();
    private volatile boolean projectHasTestFailures;
    private Map<String, DeployDetails> deployableArtifactBuilderMap;
    private ArtifactoryClientConfiguration conf;
    private Map<String, String> matrixParams;
    private Set<Artifact> resolvedArtifacts = Collections.synchronizedSet(new HashSet());
    private DocumentBuilder documentBuilder = null;
    private final ThreadLocal<XPathExpression> xPathExpression = new ThreadLocal<XPathExpression>(){

        @Override
        protected XPathExpression initialValue() {
            XPathExpression result = null;
            try {
                result = XPathFactory.newInstance().newXPath().compile("/testsuite/@failures>0 or /testsuite/@errors>0");
            }
            catch (XPathExpressionException ex) {
                BuildInfoRecorder.this.logger.error("Fail to create XPathExpression", (Throwable)ex);
            }
            return result;
        }
    };

    public void setListenerToWrap(ExecutionListener executionListener) {
        this.wrappedListener = executionListener;
    }

    public void setConfiguration(ArtifactoryClientConfiguration conf) {
        this.conf = conf;
    }

    public void artifactResolved(Artifact artifact) {
        if (artifact != null) {
            this.resolvedArtifacts.add(artifact);
        }
    }

    public void projectDiscoveryStarted(ExecutionEvent event) {
        if (this.wrappedListener != null) {
            this.wrappedListener.projectDiscoveryStarted(event);
        }
    }

    public void sessionStarted(ExecutionEvent event) {
        try {
            this.logger.info("Initializing Artifactory Build-Info Recording");
            this.buildInfoBuilder = this.buildInfoModelPropertyResolver.resolveProperties(event, this.conf);
            this.deployableArtifactBuilderMap = new ConcurrentHashMap<String, DeployDetails>();
            this.matrixParams = new ConcurrentHashMap<String, String>();
            ImmutableMap<String, String> matrixParamProps = this.conf.publisher.getMatrixParams();
            for (Map.Entry matrixParamProp : matrixParamProps.entrySet()) {
                String key = (String)matrixParamProp.getKey();
                key = StringUtils.removeStartIgnoreCase(key, "artifactory.deploy.");
                this.matrixParams.put(key, (String)matrixParamProp.getValue());
            }
            if (this.wrappedListener != null) {
                this.wrappedListener.sessionStarted(event);
            }
        }
        catch (Throwable t) {
            String message = this.getClass().getName() + ".sessionStarted() listener has failed: ";
            this.logger.error(message, t);
            throw new RuntimeException(message, t);
        }
    }

    public void sessionEnded(ExecutionEvent event) {
        File file;
        String propertyFilePath;
        block11: {
            try {
                Build build = this.extract(event);
                if (build != null) {
                    File basedir = event.getSession().getTopLevelProject().getBasedir();
                    this.buildDeploymentHelper.deploy(build, this.conf, this.deployableArtifactBuilderMap, this.projectHasTestFailures, basedir);
                }
                this.deployableArtifactBuilderMap.clear();
                if (this.wrappedListener == null) break block11;
                this.wrappedListener.sessionEnded(event);
            }
            catch (Throwable t) {
                try {
                    String message = this.getClass().getName() + ".sessionEnded() listener has failed: ";
                    this.logger.error(message, t);
                    throw new RuntimeException(message, t);
                }
                catch (Throwable throwable) {
                    File file2;
                    String propertyFilePath2 = System.getenv("buildInfoConfig.propertiesFile");
                    if (StringUtils.isBlank(propertyFilePath2)) {
                        propertyFilePath2 = this.conf.getPropertiesFile();
                    }
                    if (StringUtils.isNotBlank(propertyFilePath2) && (file2 = new File(propertyFilePath2)).exists()) {
                        boolean deleteFailed;
                        boolean bl = deleteFailed = !file2.delete();
                        if (deleteFailed) {
                            this.logger.warn("Failed to delete properties file with sensitive data: " + propertyFilePath2);
                        }
                    }
                    throw throwable;
                }
            }
        }
        if (StringUtils.isBlank(propertyFilePath = System.getenv("buildInfoConfig.propertiesFile"))) {
            propertyFilePath = this.conf.getPropertiesFile();
        }
        if (StringUtils.isNotBlank(propertyFilePath) && (file = new File(propertyFilePath)).exists()) {
            boolean deleteFailed;
            boolean bl = deleteFailed = !file.delete();
            if (deleteFailed) {
                this.logger.warn("Failed to delete properties file with sensitive data: " + propertyFilePath);
            }
        }
    }

    public void projectSkipped(ExecutionEvent event) {
        if (this.wrappedListener != null) {
            this.wrappedListener.projectSkipped(event);
        }
    }

    public void projectStarted(ExecutionEvent event) {
        MavenProject project = event.getProject();
        this.initModule(project);
        if (this.wrappedListener != null) {
            this.wrappedListener.projectStarted(event);
        }
    }

    public void projectSucceeded(ExecutionEvent event) {
        this.finalizeModule(event.getProject());
        if (this.wrappedListener != null) {
            this.wrappedListener.projectSucceeded(event);
        }
    }

    public void projectFailed(ExecutionEvent event) {
        if (this.wrappedListener != null) {
            this.wrappedListener.projectFailed(event);
        }
    }

    public void forkStarted(ExecutionEvent event) {
        if (this.wrappedListener != null) {
            this.wrappedListener.forkStarted(event);
        }
    }

    public void forkSucceeded(ExecutionEvent event) {
        if (this.wrappedListener != null) {
            this.wrappedListener.forkSucceeded(event);
        }
    }

    public void forkFailed(ExecutionEvent event) {
        if (this.wrappedListener != null) {
            this.wrappedListener.forkFailed(event);
        }
    }

    public void forkedProjectStarted(ExecutionEvent event) {
        if (this.wrappedListener != null) {
            this.wrappedListener.forkedProjectStarted(event);
        }
    }

    public void forkedProjectSucceeded(ExecutionEvent event) {
        if (this.wrappedListener != null) {
            this.wrappedListener.forkedProjectSucceeded(event);
        }
    }

    public void forkedProjectFailed(ExecutionEvent event) {
        if (this.wrappedListener != null) {
            this.wrappedListener.forkedProjectFailed(event);
        }
    }

    public void mojoSkipped(ExecutionEvent event) {
        if (this.wrappedListener != null) {
            this.wrappedListener.mojoSkipped(event);
        }
    }

    public void mojoStarted(ExecutionEvent event) {
        if (this.wrappedListener != null) {
            this.wrappedListener.mojoStarted(event);
        }
    }

    public void mojoSucceeded(ExecutionEvent event) {
        List<File> resultsFile;
        MavenProject project = event.getProject();
        if (project == null) {
            this.logger.warn("Skipping Artifactory Build-Info dependency extraction: Null project.");
            return;
        }
        if (!this.projectHasTestFailures && "maven-surefire-plugin".equals(event.getMojoExecution().getPlugin().getArtifactId()) && this.isTestsFailed(resultsFile = this.getSurefireResultsFile(project))) {
            this.projectHasTestFailures = true;
        }
        this.extractModuleDependencies(project);
        if (this.wrappedListener != null) {
            this.wrappedListener.mojoSucceeded(event);
        }
    }

    private List<File> getSurefireResultsFile(MavenProject project) {
        String[] xmls;
        ArrayList<File> surefireReports = new ArrayList<File>();
        File surefireDirectory = new File(new File(project.getFile().getParentFile(), "target"), "surefire-reports");
        try {
            xmls = surefireDirectory.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith("xml");
                }
            });
        }
        catch (Exception e) {
            this.logger.error("Error occurred: " + e.getMessage() + " while retrieving surefire descriptors at: " + surefireDirectory.getAbsolutePath(), (Throwable)e);
            return new ArrayList<File>();
        }
        if (xmls != null) {
            for (String xml : xmls) {
                surefireReports.add(new File(surefireDirectory, xml));
            }
        }
        return surefireReports;
    }

    /*
     * Exception decompiling
     */
    private boolean isTestsFailed(List<File> surefireReports) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void mojoFailed(ExecutionEvent event) {
        MavenProject project = event.getProject();
        if (project == null) {
            this.logger.warn("Skipping Artifactory Build-Info dependency extraction: Null project.");
            return;
        }
        this.extractModuleDependencies(project);
        if (this.wrappedListener != null) {
            this.wrappedListener.mojoFailed(event);
        }
    }

    private void initModule(MavenProject project) {
        if (project == null) {
            this.logger.warn("Skipping Artifactory Build-Info module initialization: Null project.");
            return;
        }
        ModuleBuilder module = new ModuleBuilder().type(ModuleType.MAVEN);
        module.id(BuildInfoExtractorUtils.getModuleIdString(project.getGroupId(), project.getArtifactId(), project.getVersion()));
        module.properties(project.getProperties());
        this.currentModule.set(module);
        this.currentModuleArtifacts.set(Collections.synchronizedSet(new HashSet()));
        this.currentModuleDependencies.set(Collections.synchronizedSet(new HashSet()));
    }

    private void extractArtifactsAndDependencies(MavenProject project) {
        if (project == null) {
            this.logger.warn("Skipping Artifactory Build-Info artifact and dependency extraction: Null project.");
            return;
        }
        Set<Artifact> artifacts = this.currentModuleArtifacts.get();
        if (artifacts == null) {
            this.logger.warn("Skipping Artifactory Build-Info project artifact extraction: Null current module artifacts.");
        } else {
            this.extractModuleArtifact(project, artifacts);
            this.extractModuleAttachedArtifacts(project, artifacts);
        }
        this.extractModuleDependencies(project);
    }

    private void finalizeModule(MavenProject project) {
        try {
            this.extractArtifactsAndDependencies(project);
            ModuleBuilder module = this.currentModule.get();
            if (module == null) {
                this.logger.warn("Skipping Artifactory Build-Info module finalization: Null current module.");
                return;
            }
            this.addModuleToBuild(project, module);
        }
        finally {
            this.cleanUpModule();
        }
    }

    private void extractModuleArtifact(MavenProject project, Set<Artifact> artifacts) {
        Artifact artifact = project.getArtifact();
        if (artifact == null) {
            this.logger.warn("Skipping Artifactory Build-Info project artifact extraction: Null artifact.");
            return;
        }
        artifacts.add(artifact);
    }

    private void extractModuleAttachedArtifacts(MavenProject project, Set<Artifact> artifacts) {
        List attachedArtifacts = project.getAttachedArtifacts();
        if (attachedArtifacts != null) {
            for (Artifact attachedArtifact : attachedArtifacts) {
                artifacts.add(attachedArtifact);
            }
        }
    }

    private void extractModuleDependencies(MavenProject project) {
        Set<Artifact> moduleDependencies = this.currentModuleDependencies.get();
        if (moduleDependencies == null) {
            this.logger.warn("Skipping Artifactory Build-Info project dependency extraction: Null current module dependencies.");
            return;
        }
        this.mergeProjectDependencies(project.getArtifacts());
    }

    private void mergeProjectDependencies(Set<Artifact> projectDependencies) {
        HashSet<DefaultArtifact> dependecies = new HashSet<DefaultArtifact>();
        for (Artifact artifact : projectDependencies) {
            String classifier = artifact.getClassifier();
            classifier = classifier == null ? "" : classifier;
            String scope = artifact.getScope();
            scope = StringUtils.isBlank(scope) ? "compile" : scope;
            DefaultArtifact art = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), scope, artifact.getType(), classifier, artifact.getArtifactHandler());
            art.setFile(artifact.getFile());
            dependecies.add(art);
        }
        Set<Artifact> moduleDependencies = this.currentModuleDependencies.get();
        HashSet<Artifact> tempSet = new HashSet<Artifact>(moduleDependencies);
        moduleDependencies.clear();
        moduleDependencies.addAll(dependecies);
        moduleDependencies.addAll(tempSet);
        if (this.conf.publisher.isRecordAllDependencies()) {
            moduleDependencies.addAll(this.resolvedArtifacts);
        }
    }

    private void addModuleToBuild(MavenProject project, ModuleBuilder module) {
        this.addArtifactsToCurrentModule(project, module);
        this.addDependenciesToCurrentModule(module);
        this.setModuleRepo(module);
        this.buildInfoBuilder.addModule(module.build());
    }

    private void addArtifactsToCurrentModule(MavenProject project, ModuleBuilder module) {
        Set<Artifact> moduleArtifacts = this.currentModuleArtifacts.get();
        if (moduleArtifacts == null) {
            this.logger.warn("Skipping Artifactory Build-Info module artifact addition: Null current module artifact list.");
            return;
        }
        ArtifactoryClientConfiguration.PublisherHandler publisher = this.conf.publisher;
        IncludeExcludePatterns patterns = new IncludeExcludePatterns(publisher.getIncludePatterns(), publisher.getExcludePatterns());
        boolean excludeArtifactsFromBuild = publisher.isFilterExcludedArtifactsFromBuild();
        boolean pomFileAdded = false;
        Artifact nonPomArtifact = null;
        String pomFileName = null;
        for (Artifact moduleArtifact : moduleArtifacts) {
            String groupId = moduleArtifact.getGroupId();
            String artifactId = moduleArtifact.getArtifactId();
            String artifactVersion = moduleArtifact.getVersion();
            String artifactClassifier = moduleArtifact.getClassifier();
            String artifactExtension = moduleArtifact.getArtifactHandler().getExtension();
            String type = BuildInfoExtractorUtils.getTypeString(moduleArtifact.getType(), artifactClassifier, artifactExtension);
            String artifactName = this.getArtifactName(artifactId, artifactVersion, artifactClassifier, artifactExtension);
            ArtifactBuilder artifactBuilder = new ArtifactBuilder(artifactName).remotePath(this.getRemotePath(groupId, artifactId, artifactVersion)).type(type);
            File artifactFile = moduleArtifact.getFile();
            if ("pom".equals(type)) {
                pomFileAdded = true;
                if (moduleArtifact.equals(project.getArtifact())) {
                    artifactFile = project.getFile();
                }
            } else {
                for (ArtifactMetadata metadata : moduleArtifact.getMetadataList()) {
                    if (!(metadata instanceof ProjectArtifactMetadata)) continue;
                    nonPomArtifact = moduleArtifact;
                    pomFileName = StringUtils.removeEnd(artifactName, artifactExtension) + "pom";
                }
            }
            org.jfrog.build.api.Artifact artifact = artifactBuilder.build();
            String deploymentPath = this.getDeploymentPath(groupId, artifactId, artifactVersion, artifactClassifier, artifactExtension);
            if (artifactFile == null || !artifactFile.isFile()) continue;
            boolean pathConflicts = PatternMatcher.pathConflicts(deploymentPath, patterns);
            this.addArtifactToBuildInfo(artifact, pathConflicts, excludeArtifactsFromBuild, module);
            this.addDeployableArtifact(artifact, artifactFile, pathConflicts, groupId, artifactId, artifactVersion, artifactClassifier, artifactExtension);
        }
        if (!pomFileAdded && nonPomArtifact != null) {
            String deploymentPath = this.getDeploymentPath(nonPomArtifact.getGroupId(), nonPomArtifact.getArtifactId(), nonPomArtifact.getVersion(), nonPomArtifact.getClassifier(), "pom");
            this.addPomArtifact(nonPomArtifact, module, patterns, deploymentPath, pomFileName, excludeArtifactsFromBuild);
        }
    }

    private void addPomArtifact(Artifact nonPomArtifact, ModuleBuilder module, IncludeExcludePatterns patterns, String deploymentPath, String pomFileName, boolean excludeArtifactsFromBuild) {
        for (ArtifactMetadata metadata : nonPomArtifact.getMetadataList()) {
            if (!(metadata instanceof ProjectArtifactMetadata)) continue;
            ArtifactBuilder artifactBuilder = new ArtifactBuilder(pomFileName).remotePath(this.getRemotePath(metadata.getGroupId(), metadata.getArtifactId(), metadata.getBaseVersion())).type("pom");
            File pomFile = ((ProjectArtifactMetadata)metadata).getFile();
            org.jfrog.build.api.Artifact pomArtifact = artifactBuilder.build();
            if (pomFile == null || !pomFile.isFile()) break;
            boolean pathConflicts = PatternMatcher.pathConflicts(deploymentPath, patterns);
            this.addArtifactToBuildInfo(pomArtifact, pathConflicts, excludeArtifactsFromBuild, module);
            this.addDeployableArtifact(pomArtifact, pomFile, pathConflicts, nonPomArtifact.getGroupId(), nonPomArtifact.getArtifactId(), nonPomArtifact.getVersion(), nonPomArtifact.getClassifier(), "pom");
            break;
        }
    }

    private void addArtifactToBuildInfo(org.jfrog.build.api.Artifact artifact, boolean pathConflicts, boolean isFilterExcludedArtifactsFromBuild, ModuleBuilder module) {
        if (isFilterExcludedArtifactsFromBuild && pathConflicts) {
            module.addExcludedArtifact(artifact);
        } else {
            module.addArtifact(artifact);
        }
    }

    private String getArtifactName(String artifactId, String version, String classifier, String fileExtension) {
        StringBuilder nameBuilder = new StringBuilder(artifactId).append("-").append(version);
        if (StringUtils.isNotBlank(classifier)) {
            nameBuilder.append("-").append(classifier);
        }
        return nameBuilder.append(".").append(fileExtension).toString();
    }

    private void addDeployableArtifact(org.jfrog.build.api.Artifact artifact, File artifactFile, boolean pathConflicts, String groupId, String artifactId, String version, String classifier, String fileExtension) {
        if (pathConflicts) {
            this.logger.info("'" + artifact.getName() + "' will not be deployed due to the defined include-exclude patterns.");
            return;
        }
        String deploymentPath = this.getDeploymentPath(groupId, artifactId, version, classifier, fileExtension);
        String targetRepository = this.getTargetRepository(deploymentPath);
        DeployDetails deployable = new DeployDetails.Builder().artifactPath(deploymentPath).file(artifactFile).targetRepository(targetRepository).addProperties(this.conf.publisher.getMatrixParams()).packageType(DeployDetails.PackageType.MAVEN).build();
        String myArtifactId = BuildInfoExtractorUtils.getArtifactId(this.currentModule.get().build().getId(), artifact.getName());
        this.deployableArtifactBuilderMap.put(myArtifactId, deployable);
    }

    public String getTargetRepository(String deployPath) {
        String snapshotsRepository = this.conf.publisher.getSnapshotRepoKey();
        if (snapshotsRepository != null && deployPath.contains("-SNAPSHOT")) {
            return snapshotsRepository;
        }
        return this.conf.publisher.getRepoKey();
    }

    private String getRemotePath(String groupId, String artifactId, String version) {
        return groupId.replace(".", "/") + "/" + artifactId + "/" + version;
    }

    private String getDeploymentPath(String groupId, String artifactId, String version, String classifier, String fileExtension) {
        return this.getRemotePath(groupId, artifactId, version) + "/" + this.getArtifactName(artifactId, version, classifier, fileExtension);
    }

    private void addDependenciesToCurrentModule(ModuleBuilder module) {
        Set<Artifact> moduleDependencies = this.currentModuleDependencies.get();
        if (moduleDependencies == null) {
            this.logger.warn("Skipping Artifactory Build-Info module dependency addition: Null current module dependency list.");
            return;
        }
        for (Artifact dependency : moduleDependencies) {
            File depFile = dependency.getFile();
            DependencyBuilder dependencyBuilder = new DependencyBuilder().id(BuildInfoExtractorUtils.getModuleIdString(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion())).type(BuildInfoExtractorUtils.getTypeString(dependency.getType(), dependency.getClassifier(), this.getExtension(depFile)));
            String scopes = dependency.getScope();
            if (StringUtils.isNotBlank(scopes)) {
                dependencyBuilder.scopes(CommonUtils.newHashSet(scopes));
            }
            this.setDependencyChecksums(depFile, dependencyBuilder);
            module.addDependency(dependencyBuilder.build());
        }
    }

    private String getExtension(File depFile) {
        int lastDot;
        String fileName;
        String extension = "";
        if (depFile != null && (fileName = depFile.getName()) != null && (lastDot = fileName.lastIndexOf(46)) > 0 && lastDot + 1 < fileName.length()) {
            extension = fileName.substring(lastDot + 1);
        }
        return extension;
    }

    private boolean isPomProject(Artifact moduleArtifact) {
        return "pom".equals(moduleArtifact.getType());
    }

    private void setDependencyChecksums(File dependencyFile, DependencyBuilder dependencyBuilder) {
        if (dependencyFile != null && dependencyFile.isFile()) {
            try {
                Map<String, String> checksumsMap = FileChecksumCalculator.calculateChecksums(dependencyFile, "md5", "sha1");
                dependencyBuilder.md5(checksumsMap.get("md5"));
                dependencyBuilder.sha1(checksumsMap.get("sha1"));
            }
            catch (NoSuchAlgorithmException e) {
                this.logger.error("Could not set checksum values on '" + dependencyBuilder.build().getId() + "': " + e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                this.logger.error("Could not set checksum values on '" + dependencyBuilder.build().getId() + "': " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setModuleRepo(ModuleBuilder module) {
        String repo = this.deployableArtifactBuilderMap.values().stream().map(DeployDetails::getTargetRepository).filter(StringUtils::isNotBlank).findAny().orElse("");
        module.repository(repo);
    }

    @Override
    public Build extract(ExecutionEvent event) {
        MavenSession session = event.getSession();
        if (!session.getResult().hasExceptions()) {
            if (this.conf.isIncludeEnvVars().booleanValue()) {
                Properties envProperties = new Properties();
                envProperties.putAll(this.conf.getAllProperties());
                envProperties = BuildInfoExtractorUtils.getEnvProperties(envProperties, this.conf.getLog());
                for (Map.Entry<Object, Object> envProp : envProperties.entrySet()) {
                    this.buildInfoBuilder.addProperty(envProp.getKey(), envProp.getValue());
                }
            }
            Date finish = new Date();
            long time = finish.getTime() - session.getRequest().getStartTime().getTime();
            return this.buildInfoBuilder.durationMillis(time).build();
        }
        return null;
    }

    public ResolutionHelper getResolutionHelper() {
        return this.resolutionHelper;
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (this.documentBuilder == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            this.documentBuilder = factory.newDocumentBuilder();
        }
        return this.documentBuilder;
    }

    private void cleanUpModule() {
        this.currentModule.remove();
        this.currentModuleArtifacts.remove();
        this.currentModuleDependencies.remove();
        this.resolvedArtifacts.clear();
    }
}

